/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.image.request;

import com.qcloud.image.ClientConfig;
import com.qcloud.image.common_utils.CommonParamCheckUtils;
import com.qcloud.image.exception.ParamException;
import com.qcloud.image.request.AbstractBaseRequest;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class FaceAddFaceRequest
extends AbstractBaseRequest {
    private boolean isUrl = true;
    private ArrayList<String> urlList = new ArrayList();
    private HashMap<String, File> imageList = new HashMap();
    private String personId = "";
    private String personTag = "";
    private HashMap<String, String> keyList = new HashMap();

    public FaceAddFaceRequest(String bucketName, String[] urlList, String personId, String personTag) {
        super(bucketName);
        this.isUrl = true;
        this.personTag = personTag;
        this.personId = personId;
        for (int i = 0; i < urlList.length; ++i) {
            this.urlList.add(urlList[i]);
        }
    }

    public FaceAddFaceRequest(String bucketName, File[] image, String personId, String personTag) {
        super(bucketName);
        this.isUrl = false;
        this.personTag = personTag;
        this.personId = personId;
        for (int i = 0; i < image.length; ++i) {
            this.imageList.put(i + "", image[i]);
            this.keyList.put(i + "", String.format("images[%d]", i));
        }
    }

    public boolean isUrl() {
        return this.isUrl;
    }

    public ArrayList<String> getUrlList() {
        return this.urlList;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getPersonTag() {
        return this.personTag;
    }

    public void setUrlList(ArrayList<String> urlList) {
        this.urlList = urlList;
    }

    public HashMap<String, File> getImageList() {
        return this.imageList;
    }

    public HashMap<String, String> getKeyList() {
        return this.keyList;
    }

    public void setImageList(HashMap<String, File> imageList) {
        this.imageList = imageList;
    }

    @Override
    public void check_param() throws ParamException {
        super.check_param();
        if (this.isUrl) {
            CommonParamCheckUtils.AssertNotZero("url list", this.urlList.size());
            CommonParamCheckUtils.AssertExceed("url list", this.urlList.size(), ClientConfig.getMaxListNum());
        } else {
            CommonParamCheckUtils.AssertNotZero("image list", this.imageList.size());
            CommonParamCheckUtils.AssertExceed("image list", this.imageList.size(), ClientConfig.getMaxListNum());
        }
    }
}

