/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.image.request;

import com.qcloud.image.ClientConfig;
import com.qcloud.image.common_utils.CommonParamCheckUtils;
import com.qcloud.image.exception.ParamException;
import com.qcloud.image.request.AbstractBaseRequest;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class FaceCompareRequest
extends AbstractBaseRequest {
    private boolean isUrl;
    private String urlA = "";
    private String urlB = "";
    private ArrayList<String> urlList = new ArrayList();
    private HashMap<String, String> keyList = new HashMap();
    private HashMap<String, File> imageList = new HashMap();

    public FaceCompareRequest(String bucketName, String urlA, String urlB) {
        super(bucketName);
        this.isUrl = true;
        this.urlA = urlA;
        this.urlB = urlB;
    }

    public FaceCompareRequest(String bucketName, File imageA, File imageB) {
        super(bucketName);
        this.isUrl = false;
        this.keyList.put("key1", "imageA");
        this.keyList.put("key2", "imageB");
        this.imageList.put("key1", imageA);
        this.imageList.put("key2", imageB);
    }

    public boolean isUrl() {
        return this.isUrl;
    }

    public String getUrlA() {
        return this.urlA;
    }

    public String getUrlB() {
        return this.urlB;
    }

    public ArrayList<String> getUrlList() {
        return this.urlList;
    }

    public HashMap<String, String> getKeyList() {
        return this.keyList;
    }

    public void setUrlList(ArrayList<String> urlList) {
        this.urlList = urlList;
    }

    public HashMap<String, File> getImageList() {
        return this.imageList;
    }

    public void setImageList(HashMap<String, File> imageList) {
        this.imageList = imageList;
    }

    @Override
    public void check_param() throws ParamException {
        super.check_param();
        if (this.isUrl) {
            CommonParamCheckUtils.AssertNotNull("urlA", this.urlA);
            CommonParamCheckUtils.AssertNotNull("urlB", this.urlB);
        } else {
            CommonParamCheckUtils.AssertNotZero("image list", this.imageList.size());
            CommonParamCheckUtils.AssertExceed("image list", this.imageList.size(), ClientConfig.getMaxListNum());
        }
    }
}

