# 1.1 升级指南

1.1 版新增了很多的功能，但一些改动也涉及到了对 Skeleton 骨架的调整，以及配置项的结构调整，如果您已经投入了业务使用的项目且是基于官方提供的 Skeleton 项目创建的 1.0 应用项目，那么可以根据下面的内容点来调整您的骨架项目，如果您是一个新的项目，按照文档通过 `composer create-project hyperf/hyperf-skeleton` 命令创建新的项目即可使用新的 skeleton 结构。

## 升级 Swoole 到 4.4+

1.1 版将最低的 Swoole 版本要求从 4.3+ 提升到了 4.4+，这两个版本之间有一些使用上的细节问题，Hyperf 已经在较早的版本便已适配了，对于 Hyperf 的用户而言无需理会这之间的差异，我们提升最低 Swoole 版本要求主要是为了减少我们的历史负担，而 Swoole 4.4 作为 Swoole 的 LTS(长期支持版本) 也意味着更加的稳定可靠。   

Hyperf 在启动时会进行 Swoole 版本检测，但为了更好的统一各处对 Swoole 版本的依赖约束，我们建议您将 `composer.json` 内对 Swoole 的依赖条件改为 `"ext-swoole": ">=4.4"`。

## 增加 SWOOLE_HOOK_FLAGS 常量

在应用的入口文件 `bin/hyperf.php` 以及单测的入口文件 `test/bootstrap.php` 里增加一行常量定义如下：

```php
! defined('SWOOLE_HOOK_FLAGS') && define('SWOOLE_HOOK_FLAGS', SWOOLE_HOOK_ALL);
```

参考：[入口文件参考](https://github.com/hyperf/hyperf-skeleton/blob/70062b7bbf29e23cda2f30680e02aa3b26ebd6f7/bin/hyperf.php#L11) [单测入口文件参考](https://github.com/hyperf/hyperf-skeleton/blob/70062b7bbf29e23cda2f30680e02aa3b26ebd6f7/test/bootstrap.php#L20)

## 移动 config/dependencies.php 文件并调整文件结构

移动 `config/dependencies.php` → `config/autoload/dependencies.php`，并去除配置文件中的第一层 `dependencies`，如下：

1.0 的文件结构：
```php
<?php
// config/dependencies.php 文件

return [
    'dependencies' => [
        FooInterface::class => Foo::class
    ],
];
```

1.1 的文件结构：
```php
<?php
// config/autoload/dependencies.php 文件

return [
    FooInterface::class => Foo::class
];
```

## 调整 config/container.php 文件的内容

由于 1.1 版本调整了 `dependencies.php` 文件的位置和结构，所处我们还需要调整一下 `config/container.php` 文件，以便依赖注入容器能够正确的运行，与此同时，我们也为 `config/container.php` 提供了更加简便的写法，`DefinitionSourceFactory` 将很多默认的行为聚合了起来，您只需将 `config/container.php` 文件的内容更换成下面的内容即可：

> 默认开启注解扫描缓存功能，可修改 `DefinitionSourceFactory` 入参的第一个参数来关闭此功能

```php
<?php
/**
 * Initial a dependency injection container that implemented PSR-11 and return the container.
 */
declare(strict_types=1);

use Hyperf\Di\Container;
use Hyperf\Di\Definition\DefinitionSourceFactory;
use Hyperf\Utils\ApplicationContext;
use Psr\Container\ContainerInterface;

$container = new Container((new DefinitionSourceFactory(true))());
if (! $container instanceof ContainerInterface) {
    throw new RuntimeException('The dependency injection container is invalid.');
}
return ApplicationContext::setContainer($container);
```

## 调整 WebSocket 控制器

由于 1.1 版本调整了 `onMessage` 和 `onOpen` 的入参约束，所以需要手动修改其为 `Swoole\WebSocket\Server`，具体代码如下

```php
<?php
declare(strict_types=1);

namespace App\Controller;

use Hyperf\Contract\OnMessageInterface;
use Hyperf\Contract\OnOpenInterface;
use Swoole\Http\Request;
use Swoole\Websocket\Frame;
use Swoole\WebSocket\Server as WebSocketServer;

class WebSocketController implements OnMessageInterface, OnOpenInterface
{
    public function onMessage(WebSocketServer $server, Frame $frame): void
    {
    }

    public function onOpen(WebSocketServer $server, Request $request): void
    {
    }
}
```

## 调整自定义组件的 ConfigProvider

1.0 版本中 `scan.path` 在 1.1 版本中调整为 `annotations.scan.path`，您需要修改所有自定义组件的 ConfigProvider 类来适配此变更，如您的自定义组件不涉及到注解扫描的功能配置，则可忽略此调整，如下所示：

1.0 的 ConfigProvider 文件结构：
```php
class ConfigProvider
{

    public function __invoke(): array
    {
        return [
            'scan' => [
                'paths' => [
                    __DIR__,
                ],
            ],
        ];
    }
}
```

1.1 的 ConfigProvider 文件结构：
```php
class ConfigProvider
{

    public function __invoke(): array
    {
        return [
            'annotations' => [
                'scan' => [
                    'paths' => [
                        __DIR__,
                    ],
                ],
            ],
        ];
    }
}
```

## 调整默认的本地化语言

如果您在之前有使用 [hyperf/translation](https://github.com/hyperf/translation) 组件，那么您需要检查一下 `config/autoload/translation.php` 文件内的 `locale` 配置项，如为 `zh-CN`，则需要改为 `zh_CN`，在 1.1 版本，我们统一了这个配置的值。

## 调整 composer.json 的依赖

由于要升级到 1.1 版本的组件，而原来 skeleton 项目默认情况下是依赖 1.0.x 版本的组件的，所以我们需要对依赖的约束条件进行一些调整，将原来所有 Hyperf 组件的依赖 `~1.0.0` 修改为 `~1.1.0`，修改完后需运行 `composer update` 来将依赖项升级到 1.1 版本。   

必须将所有 Hyperf 依赖都升级到 1.1 版本才可用，因为 1.1 调整了组件适配的 ConfigProvider 机制。

## 完成升级

至此，1.1 升级即已完成，但由于 Hyperf 的各个底层文件都是可以通过 DI 来实现重写的，如您重写了某些本次升级调整到了的框架内部文件，您仍需再根据您的实际情况进行一定的调整。   

如您在升级上或升级后遇到任何的问题，请前往 [Github Issue](https://github.com/hyperf/hyperf/issues) 提交您的 issue，说明您遇到的问题，我们会尽快帮助您解决。
