<?php
/*
 +----------------------------------------------------------------------
 | TEMMOKUMVC [ NO BEST, ONLY BETTER ]
 +----------------------------------------------------------------------
 | Copyright (c) 2018~2019 https://www.temmoku.cn All rights reserved.
 +----------------------------------------------------------------------
 | Author: 张宗强 Email:webmaster@temmoku.cn QQ:158726877 516669373 TEL:17895221001 微信:temmokumvc
 +---------------------------------------------------------------------- 
*/
namespace news\public_class;
use \temmoku\db;
use \temmoku\controller;
use \news\init;
class cache extends controller{
	
/*	是来自全局更新缓存，或者只是独立更新
 * 	模块必须存在此控制器
 */

	public static function run($data=''){
		//模型缓存
		self::Module_Cache();
		//核心缓存
		self::setting();
		//主分类缓存
		$categorydb=db::select('*')->from(init::$table."category")->query();
		self::category_setting($categorydb);
		
		//以下是专题缓存
		$special_list_setting=db::select('*')->from(init::$table.'special_list')->where("1")->query();
		self::special_list_setting($special_list_setting);
		
		$special_category_setting=db::select('*')->from(init::$table."special_category")->where('1')->query();
		self::special_category_setting($special_category_setting);
		self::import_hook_sql();
	}
	
	//模型缓存
	public static function Module_Cache(){
		//兼容全局缓存
		
		$data=db::select('*')->from(init::$table."module")->orderByDESC(['reorder'])->query();
		$datadb=[];
		foreach((array)$data AS $row){
			$field=db::select('*')->from(init::$table."field")->where("mid=$row[id]")->orderByDESC(['reorder'])->query();
			
			$datadb[$row['id']]=['name'=>$row['name'],'field'=>$field];
		}
		$array=['WN_ModelDB'=>$datadb];
		createconf($array,'custom_model_cache',init::$dir);
	}

	
	
	
	
	
	//核心缓存
	public static function setting(){
		$settingDB=db::select('*')->from(init::$table."setting")->query();
		$datadb=[];
		foreach((array)$settingDB AS $key=>$row){
			$datadb[$row['s_key']]=$row['s_name'];
		}
		$array=['setting'=>$datadb];
		createconf($array,'setting',init::$dir);
	}
	
	public static function category_setting($data){
    	//兼容全局缓存

		self::home_route($data);
		$datadb=[];
		foreach($data AS $key=>$row){
			$son= self::get_son($row['cid']);
			$datadb[$row['cid']]=[
				'name'=>$row['name'],
				'seo_name'=>$row['seo_name'],
				'seo_keywords'=>$row['seo_keywords'],
				'dir_name'=>$row['dir_name'],
				'seo_description'=>$row['seo_description'],
				'setting'=>$row['setting'],
				'son'=>trim($son,','),
				'upcid'=>$row['upcid']
			];
		}
		$array=['category_setting'=>$datadb];
		createconf($array,'category_setting',init::$dir);
		self::Crumbs_Cache($data);
	}
	 //获取子孙
	private static function get_son($cid){
		$data=db::select('*')->from(init::$table."category")->where("upcid=$cid")->query();
		$echo='';
		foreach($data AS $key=>$row){
		    $echo.=$row['cid'].",";
		    if($row['type']==1){
		    	$echo.=self::get_son($row['cid']);
		    }
		}
	    return $echo;
	}
	//ROUTE
	private static function home_route($data){
		$datadb=[];
		foreach((array)$data AS $key=>$row){
			if(!$row['dir_name']){
				continue;
			}
			$datadb[strtolower($row['dir_name'])]=$row['cid'];
		}
		$array=['home_route'=>$datadb];
		createconf($array,'route',init::$dir);
	}
	//面包屑缓存
	private static function Crumbs_Cache($data){
		$domain=HTTP.init::$domain;
		$datadb=[];
		foreach($data AS $key=>$row){
    		$echo=self::get_father($row['cid']);
			$datadb[$row['cid']]="<a href='/'>首页</a>-> <a href='$domain'>".init::$name."</a>".$echo;
		}
		$array=['wn_crumbs'=>$datadb];
		createconf($array,'crumbs',init::$dir);
	}
	private static function get_father($cid){
		//兼容全局缓存
	    $Crumbs_DB=db::select('*')->from(init::$table."category")->where("cid=$cid")->query();
		foreach($Crumbs_DB AS $key=>$row){
		   	$echo.=" -> <a href=\"cid=$cid\">$row[name]</a>";
		   	if($row['upcid']){
		   		$echo=self::get_father($row['upcid']).$echo;
		    }
		}
	    return $echo;
    }
    
	//以下是专题
	public static function special_list_setting($data){
    	$datadb=[];
		foreach($data AS $key=>$row){
			$datadb[$row['id']]=[
				'name'=>$row['name'],
				'seo_name'=>$row['seo_name'],
				'seo_keywords'=>$row['seo_keywords'],
				'dir_name'=>$row['dir_name'],
				'seo_description'=>$row['seo_description'],
				'setting'=>$row['setting'],
				'sid'=>$row['sid'],
				'thumb'=>$row['thumb'],
				'is_comment'=>$row['is_comment']
			];
		}
		$array=['Special_list_setting'=>$datadb];
		createconf($array,'special_list_setting',init::$dir);
		self::special_list_route($data);
	}
	//分类ROUTE
	private static function special_list_route($data){
		$datadb=[];
		foreach($data AS $key=>$row){
			if(!$row['dir_name']){
				continue;
			}
			$datadb[strtolower($row['dir_name'])]=$row[id];
		}
		$array=['special_list_route'=>$datadb];
		createconf($array,'special_list_route',init::$dir);
	}
	
	
    
    public static function special_category_setting($data){
    	$datadb=[];
		foreach($data AS $key=>$row){
			$datadb[$row['sid']]=[
				'name'=>$row['name'],
				'seo_name'=>$row['seo_name'],
				'seo_keywords'=>$row['seo_keywords'],
				'dir_name'=>$row['dir_name'],
				'seo_description'=>$row['seo_description'],
				'setting'=>$row['setting'],
				'upsid'=>$row['upsid']
			];
		}
		$array=['special_category_setting'=>$datadb];
		createconf($array,'special_category_setting',init::$dir);
		self::special_category_crumbs_cache($data);
		self::special_category_route($data);
	}
	//分类ROUTE
	private static function special_category_route($data){
		$datadb=[];
		foreach($data AS $key=>$row){
			if(!$row['dir_name']){
				continue;
			}
			$datadb[strtolower($row['dir_name'])]=$row['sid'];
		}
		$array=['Special_Route'=>$datadb];
		createconf($array,'special_route',init::$dir);
	}
	//面包屑缓存
	private static function special_category_crumbs_cache($data){
		$datadb=[];
		foreach($data AS $key=>$row){
    		$echo=self::get_up($row['sid']);
			$datadb[$row['sid']]="<a href='/'>首页</a>".$echo;
		}
		$array=['Special_Crumbs'=>$datadb];
		createconf($array,'special_crumbs',init::$dir);
	}
	private static function get_up($sid){
		//兼容全局缓存
	    $Crumbs_DB=db::select('*')->from(init::$table."special_category")->where("sid=$sid")->query();
		foreach($Crumbs_DB AS $key=>$row){
		    $echo.=" -> <a href=\"sid=$sid\">$row[name]</a>";
		    if($row['upsid']){
		    	$echo=self::get_up($row['upsid']).$echo;
		    }
		}
	    return $echo;
   	}
	
	private static function import_hook_sql(){
		$array=[
			'news_post_begin'=>'文章模块发布信息之前',
			'news_post_end'=>'文章模块发布信息之后',
			'news_article_state'=>'文章模块审核或取消文章审核',
			'news_article_recommend'=>'文章模块置顶或取消文章置顶',
			'news_article_del_begin'=>'文章模块删除文章前',
			'news_article_del_end'=>'文章模块删除文章后',
			'news_comment_del_begin'=>'文章模块删除评论前',
			'news_comment_del_end'=>'文章模块删除评论后',
		];
		foreach($array AS $name=>$content){
			$row=db::select('id')->from(jab."hook")->where("name like '$name'")->row();
			if(!$row){
				db::insert(jab."hook")->cols(['name'=>$name,'content'=>$content,'state'=>1])->query();
			}
		}
	}
}
?>
