-- ----------------------------
-- Table structure for temmoku_plugin_advertisement_buy_list
-- ----------------------------
DROP TABLE IF EXISTS `temmoku_plugin_advertisement_buy_list`;
CREATE TABLE `temmoku_plugin_advertisement_buy_list` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `bid` mediumint(9) NOT NULL DEFAULT '0',
  `ad_type` varchar(255) DEFAULT NULL,
  `btime` smallint(7) NOT NULL DEFAULT '0',
  `uid` mediumint(9) NOT NULL DEFAULT '0',
  `content` text,
  `endtime` int(10) NOT NULL,
  `posttime` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `bid` (`bid`),
  KEY `bid_2` (`bid`,`ad_type`),
  KEY `uid` (`uid`) USING BTREE,
  KEY `bid_3` (`bid`,`endtime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for temmoku_plugin_advertisement_click_list
-- ----------------------------
DROP TABLE IF EXISTS `temmoku_plugin_advertisement_click_list`;
CREATE TABLE `temmoku_plugin_advertisement_click_list` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `lid` mediumint(9) DEFAULT '0',
  `ip` varchar(255) NOT NULL DEFAULT '',
  `time` int(11) DEFAULT NULL,
  `setting` text,
  PRIMARY KEY (`id`),
  KEY `lid` (`lid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for temmoku_plugin_advertisement_list
-- ----------------------------
DROP TABLE IF EXISTS `temmoku_plugin_advertisement_list`;
CREATE TABLE `temmoku_plugin_advertisement_list` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `tag` varchar(32) NOT NULL DEFAULT '',
  `ad_type` varchar(255) NOT NULL DEFAULT '0',
  `is_sell` tinyint(1) NOT NULL DEFAULT '0',
  `price` text NOT NULL,
  `integral` mediumint(9) DEFAULT '0',
  `sellnum` smallint(7) NOT NULL DEFAULT '0' COMMENT '出售数量',
  `setting` text,
  `tpl` text,
  `msg` text,
  `posttime` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `tag` (`tag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for temmoku_plugin_advertisement_pay_log
-- ----------------------------
DROP TABLE IF EXISTS `temmoku_plugin_advertisement_pay_log`;
CREATE TABLE `temmoku_plugin_advertisement_pay_log` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `uid` mediumint(9) DEFAULT NULL,
  `username` varchar(255) DEFAULT NULL,
  `bid` mediumint(9) NOT NULL DEFAULT '0',
  `tag` varchar(255) NOT NULL,
  `integral` int(11) NOT NULL DEFAULT '0',
  `buytime` tinyint(3) NOT NULL DEFAULT '0',
  `rmb` decimal(10,2) DEFAULT '0.00',
  `state` tinyint(3) DEFAULT '0' COMMENT '为1充值成功',
  `transaction_code` bigint(20) DEFAULT NULL,
  `posttime` int(10) DEFAULT NULL,
  `payment` varchar(255) DEFAULT NULL,
  `trade_no` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `transaction_code` (`transaction_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 CHECKSUM=1 DELAY_KEY_WRITE=1 COMMENT='广告充值管理';

-- ----------------------------
-- Table structure for temmoku_plugin_advertisement_set
-- ----------------------------
DROP TABLE IF EXISTS `temmoku_plugin_advertisement_set`;
CREATE TABLE `temmoku_plugin_advertisement_set` (
  `u_key` varchar(255) NOT NULL DEFAULT '',
  `u_value` text,
  UNIQUE KEY `u_key` (`u_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
