{{include file=Main_View('head')}}
<div class="main_content">
	<fieldset class="layui-elem-field layui-field-title">
		<legend>会员注册</legend>
	</fieldset>
	<form class="layui-form" method="post">
		<table class="layui-table" >
			<tr>
				<td>用户名</td>
				<td>
					<input id="username" type="text" class="layui-input my-input" name="username" />
				</td>
			</tr>
			<tr>
				<td>密码</td>
				<td>
					<input id="password" type="password" class="layui-input my-input" name="password"  />
				</td>
			</tr>
			<tr>
				<td>重复密码</td>
				<td>
					<input id="password1" type="password" class="layui-input my-input" name="password1"  />
				</td>
			</tr>
			<if condition="C('login|login.reg_is_code')==1">
			<tr>
				<td>Email</td>
				<td>
					<input type="email" id="email" class="layui-input w120 left" name="email" lay-verify='email' required/>
					<span class="left ml10 reg_code">验证码：</span>
					<input type="text" id="code" class="layui-input w100 left ml10" name="code" />
					<button id="reg_code_post" class="layui-btn layui-btn-normal left ml10" lay-submit lay-filter="reg_code_post">获取验证码</button>
					<script>
						layui.use(['form'], function(){
							var form = layui.form;
							form.on('submit(reg_code_post)', function(data){
						    	var email=$('#email').val();
						    	var reg = new RegExp("^[a-z0-9]+([._\\-]*[a-z0-9])*@([a-z0-9]+[-a-z0-9]*[a-z0-9]+.){1,63}[a-z0-9]+$");
						    	if(!reg.test(email)){ //正则验证不通过，格式不对
								　　　　layer.tips('Email不正确', '#email');
								　　　　return false;
								　}
						    	$.ajax({
									url: "/login/index/reg_email_code/",
									type: 'POST',
									data: {
										'email': email,
										'json':true
									},
									dataType: 'json',
									success: function(data) {
										if(data.code=='0'){
											layer.tips('请将打开邮箱接收邮件，然后将验证码填入此处', '#code');
										}else if(data.code=='33'){
											layer.tips(data.text, '#reg_code_post');
										}else{
											layer.tips(data.text, '#email');
										}
										　
									}
								});
								return false;
						  	});
						})
					</script>
				</td>
			</tr>
			<else>
			<tr>
				<td>Email</td>
				<td>
					<input type="email" id="email" class="layui-input my-input left" name="email" lay-verify='email' required/>
					<span class="left reg_code ml10">找回密码使用</span>
				</td>
			</tr>
			</if>
			
			<if condition="C('login|login.reg_is_code')==2">
			<tr>
				<td>手机号码</td>
				<td>
					<input type="number" id="mobile" class="layui-input w120 left" name="mobile" lay-verify='mobile' required/>
					<span class="left ml10 reg_code">验证码：</span>
					<input type="text" class="layui-input w100 left ml10" name="code" id="code" />
					<button id="reg_code_post" class="layui-btn layui-btn-normal left ml10" lay-submit lay-filter="reg_code_post">获取验证码</button>
					
					<script>
						layui.use(['layer','form'], function(){
							var form = layui.form;
							var layer = layui.layer;
							form.on('submit(reg_code_post)', function(data){
						    	var mobile=$('#mobile').val();
						    	var reg = new RegExp('^1[3|4|5|7|8][0-9]{9}$');
						    	if(!reg.test(mobile)){ //正则验证不通过，格式不对
								　　layer.tips('手机号码不正确', '#mobile');
								　　return false;
								}
						    	layer.open({
									type: 1,
									title:"验证码输入",
									content: $('#table_mobile'), //这里content是一个DOM，注意：最好该元素要存放在body最外层，否则可能被其它的相对元素所影响
									success:function(){
										$('#mobile_yzm_img').click();
									}
						    	});
						    	return false;
						  	});
						  	
						  	var mobile_yzm_post=form.on('submit(mobile_yzm_post)', function(data){
						  		var mobile=$('#mobile').val();
						  		var mobile_yzm=$('#mobile_yzm').val();
						  		$.ajax({
									url: "/login/index/reg_mobile_code/",
									type: 'POST',
									data: {
										'mobile': mobile,
										'yzm':mobile_yzm
									},
									dataType: 'json',
									success: function(res) {
										if(res.code=='0'){
											if($('#yzmimg')){
												$('#yzmimg').click();
											}
											layer.closeAll();
											setIntervals();
											layer.tips('请打开手机查看验证码', '#code');
										}else if(res.code=='9'){
											$('#mobile_yzm_img').click();
											layer.tips(res.text, '#mobile_yzm');
										}else{
											layer.closeAll();
											layer.alert(res.text);
										}
										$('#mobile_yzm').val('');
									}
								});
						    	
						  	})
						})
						var timer='';
						function setIntervals(){
							$('#reg_code_post').html('剩余<span id="timer">{{C('login|LOGIN.mobile_put_time') ? C('login|LOGIN.mobile_put_time') : 60}}</span>秒');
							$('#reg_code_post').attr('disabled','disabled');
							$('#reg_code_post').attr('class','layui-btn layui-btn-primary left ml10');
							timer=window.setInterval(function(){runtimer();},1000);
						}
						function runtimer() {
					        var s = document.getElementById("timer");
					        if(s.innerHTML==1){
					        	$('#reg_code_post').html('获取验证码');
					        	$('#reg_code_post').attr('class','layui-btn layui-btn-normal left ml10');
					        	$('#reg_code_post').removeAttr('disabled');
					        	window.clearInterval(timer); 
					        }else{
					        	 s.innerHTML = s.innerHTML * 1 - 1;
					        }
					       
						}
					</script>
				</td>
			</tr>
			<else>
			<tr>
				<td>手机号码</td>
				<td>
					<input type="number" id="mobile" class="layui-input my-input" name="mobile" lay-verify='mobile' required/>
				</td>
			</tr>
			</if>
			<if condition="C('login|login.reg_is_yzm')">
			<tr>
				<td>验证码</td>
				<td>
					<input type="text" id="yzm" class="layui-input w100 left" name="yzm" />
					<img id="yzmimg" src="/Verification_Code{{C('HTML')}}" alt="点击图片更换验证码" title="点击图片更换验证码" class="left ml10"  onclick="this.src='/Verification_Code?'+Math.random();"/>
				</td>
			</tr>
			</if>
			<tr>
				<td colspan="2" align="center" class="login_input">
					<input type="hidden" name="step" value="post" />
					<button class="layui-btn layui-btn-normal" lay-submit lay-filter="post">已经填好，立即注册</button>
				</td>
			</tr>
		</table>
	</form>
</div>
<if condition="C('login|login.reg_is_code')==2">
	<table class="layui-table" id="table_mobile" style="display: none;">
		<tr>
			<td>请输入验证码</td>
			<td> 
				<input type="mobile_yzm" class="layui-input w100 left" name="mobile_yzm" id="mobile_yzm" value="" />
				<img id="mobile_yzm_img" src="/Verification_Code{{C('HTML')}}" alt="点击图片更换验证码" title="点击图片更换验证码" class="left ml10"  onclick="this.src='/Verification_Code?'+Math.random();"/>
			</td>
		</tr>
		<tr>
			<td colspan="2" align="center">
				<button class="layui-btn layui-btn-normal" lay-submit lay-filter="mobile_yzm_post">确定</button>
			</td>
		</tr>
	</table>
</if>
<script>
	layui.use(['form'], function() {
		var form = layui.form;
		form.on('submit(post)', function(data) {
			
			if(!data.field.username){
				$("#username").focus();
				layer.tips('用户名必须填写', '#username');
				return false;
			}
			if(!data.field.password){
				$("#password").focus();
				layer.tips('必须填写密码', '#password');
				return false;
			}
			if(data.field.password != data.field.password1){
				$("#password1").focus();
				layer.tips('重复密码不对', '#password1');
				return false;
			}
			if(!data.field.email){
				$("#email").focus();
				layer.tips('email必须填写', '#email');
				return false;
			}else{
				var reg = new RegExp("^[a-z0-9]+([._\\-]*[a-z0-9])*@([a-z0-9]+[-a-z0-9]*[a-z0-9]+.){1,63}[a-z0-9]+$");
				if(!reg.test(data.field.email)){ //正则验证不通过，格式不对
					$("#email").focus();
					layer.tips('Email格式不正确', '#email');
					return false;
				}
			}
			if(!data.field.mobile){
				$("#mobile").focus();
				layer.tips('手机号码必须填写', '#mobile');
				return false;
			}else{
				var pattern = /^1[3|4|5|7|8][0-9]{9}$/;
				if(!pattern.test(data.field.mobile)){ //正则验证不通过，格式不对
					$("#mobile").focus();
					layer.tips('手机号码格式不对', '#mobile');
					return false;
				}
			}
		});
	})
</script>
{{include file=Main_View('foot')}}