<?php
/*
 +----------------------------------------------------------------------
 | TEMMOKUMVC [ NO BEST, ONLY BETTER ]
 +----------------------------------------------------------------------
 | Copyright (c) 2018~2019 https://www.temmoku.cn All rights reserved.
 +----------------------------------------------------------------------
 | Author: 张宗强 Email:webmaster@temmoku.cn QQ:158726877 516669373 TEL:17895221001 微信:temmokumvc
 +---------------------------------------------------------------------- 
*/
namespace temmoku;
use temmoku\route;
class app 
{
    // 运行程序
    public static function run(){
		spl_autoload_register('self::Load_Class');
    	self::setReporting();
    	self::default_config();
    	new route();
    	self::log();
    	self::Load_Controller();
    }
    
    private static function log(){
    	if(C('is_log')){
    		$_SERVER['HTTP_REFERER'] ?$HTTP_REFERER= $_SERVER['HTTP_REFERER'] :$HTTP_REFERER='';
    		$DIR=RUNTIME_PATH.'access_Logs/'.date('ymd');
    		$DIR=$DIR.'/'.date('H').md5(C('md5')).'.txt';
			$content='HTTP_RAW_POST_DATA:'.file_get_contents('php://input')."\n";
    		$content.='GET->'.json_encode($_GET)."\n";
    		$content.='_POST->'.json_encode($_POST)."\n";
    		$content.='HTTP_REFERER->'.$HTTP_REFERER."\n";
    		$content.='onlineip->'.onlineip."\n";
    		$content.='_COOKIE->'.json_encode($_COOKIE)."\n";
			$content.='time->'.date('Y-m-d H:i:s');
    		$content.="\r\n";
    		write_file($DIR,$content,'a+');
    	}
    }
    // 检测开发环境
    private static function setReporting()
    {
        if (APP_DEBUG === true) {
			if(ERROR_REPORTING_LEVEL==0){
				error_reporting(E_ALL);
			}elseif(ERROR_REPORTING_LEVEL==1){
				error_reporting(E_ALL ^ E_NOTICE);
			}elseif(ERROR_REPORTING_LEVEL==2){
				error_reporting(E_ALL ^ E_NOTICE ^ E_WARNING);
			}
            
            ini_set('display_errors','On');
        } else {
            error_reporting(E_ALL ^ E_NOTICE ^ E_WARNING);
            ini_set('display_errors','Off');
            ini_set('log_errors', 'On');
            ini_set('error_log', RUNTIME_PATH. 'error/'.date('Ymd').'.log');
        }
    }
    
    
    //加载控制器
    private static function Load_Controller(){
    	//如果是模块
    	$home= MODULE=='admin' ||  MODULE=='user' ||  MODULE=='install' ||  MODULE=='home' ? '' : '\home';
    	//如果是插件is_plugin
    	$plugin=defined('is_plugin') ? 'plugin\\' : '';
    	$controller = $plugin.MODULE.$home.'\controller\\'.strtolower(CONTROLLER);
    	if (class_exists($controller)) {
		   $dispatch = new $controller();
		   Load_Method($dispatch,METHOD,$controller);
		}else{
			E($controller.'控制器不存在');
		}
    }
    
    // 自动加载控制器
    private static function Load_Class($class)
    {
    	$class=str_caps_look(str_replace('\\','/',$class),'1');
    	$_class=[
    		Temmoku_PATH . $class . '.php',
    		APP_PATH . $class . '.php'
    	];

    	$E=false;
    	foreach ($_class AS $__CLASS){
    		 if (is_file($__CLASS)) {
	            // 加载框架核心类
	            $E=true;
	            include_once $__CLASS;
	            break;
	      	}
    	}
    	if(false===$E){
    		E("无法加载模块:".$class);
    	}
    }
    //加载必须的默认设置
    private static function default_config(){
		//查询并设置高速缓存状态
		$caching_state=false;
		if(is_file($caching_file=APP_PATH."/caching.php")){
			$setting=include $caching_file;
			if($setting['caching']){
				$caching=unserialize(stripslashes($setting['caching']));//反序列化
				C('caching',$caching);
				if($caching['state']){//判断是否启用了高速缓存
					$caching_state=true;
					$type=$caching['type']== 'memcached'? 'memcache' : $caching['type'];
					$default = $caching[$type];
					$default['type']=$type;
					\temmoku\vendor\think\cache::init($default);
				}
			}
		}
		define('CACHING', $caching_state);
    	$dir=APP_PATH.'/conf';
		$route_dir=$dir.'/route';
    	Load_conf($dir);
		//加载路由文件
		Load_conf($route_dir);
	    define('jab', C('JAB'));
	    C('SSL') ? define('HTTP', "https://") : define('HTTP', "http://");
	    define('program_development', "张宗强");
	    define('Copyright', "邳州天目网络科技有限公司");
		$version=Temmoku.'version.php';
	    Load_conf($version,false);
	    C('onlineip',getRealIp());
	    define('onlineip', getRealIp());
	    if(C('WEBURL')){
	    	define('WEBURL', HTTP.C('WEBURL'));
	    }else{
	    	$http=is_https() ? 'http' : 'https';
	    	define('WEBURL', $http."://".$_SERVER['HTTP_HOST']);
	    }
		//静态文件所在目录，如 img js css 
		defined('_STATIC_') or define('_STATIC_', WEBURL.'/public/');
		$device=Is_Weixin() ? 'wechat' : (Is_Mobile() ? 'wap' : 'pc');
		define('DEVICE', $device);
        define('Upgrade_URL', 'https://www.temmokumvc.com/');
    }
}
?>