<?php
include KX_ROOT . '/env.php';
return [
    'app'  => [
        'debug'               => APP_ENV !== 'production',
        'mode'                => PHP_SAPI == 'cli' ? 'cli' : 'web',
        'env'                 => APP_ENV,
        'fastcgi_buffer_fill' => true,
        'fastcgi_buffer_size' => 124,
        'phpbin'              => defined('PHPPATH') ? PHPPATH : 'php',
    ],
    'auth' => [
        'crypto_key'       => 'www.kxcms.com',
        'active_effective' => 24 * 60 * 60,
        'max_age'          => 7 * 24 * 60 * 60,
    ],
    'url'  => [
        'ignore_param' => [
            'key',
            'novelid',
            'pinyin',
            'chapterid',
            'categoryid',
            'subcategoryid',
            'pageid',
            'authorid',
            'name',
            'subnovelid',
            'subnovelidplus',
        ],
        'default_data' => [
            'page'   => '1',
            'siteid' => '0',
        ],
        'auto_calc'    => [
            'novelid' => [
                [ 'name' => 'subnovelid', 'func' => 'subid' ],
                [ 'name' => 'subnovelidplus', 'func' => 'subidplus' ],
            ],
        ],
    ],

    'rewrite' => [
        'power' => true,
    ],


    'view' => [
        'driver' => 'mc',
    ],

    'plugin' => [
        'app_init'         => [],
        'app_start'        => [
            \App\Plugin\ConfigCache\ConfigCache::class,
        ],
        'controller_start' => [],
        'controller_end'   => [],
        'view_start'       => [],
        'view_end'         => [],
    ],

    'apiurl' => API_BASE_URL,


    'database' => [
        'debug'  => true,
        'prefix' => '',
        'engine' => 'MyISAM',
        'common' => [
            'driver' => 'mysql',
            'option' => [
                'host' => KX_DB_HOST,
                'port' => KX_DB_PORT,
                'user' => KX_DB_USER,
                'pwd'  => KX_DB_PWD,
                'name' => KX_DB_NAME,
            ],
        ],
    ],

    //
    'storage'  => [
        'runtime'  => [
            'driver' => 'file',
            'option' => [
                'path' => KX_ROOT . '/storage/runtime',
            ],
        ],
        'log'      => [
            'driver' => 'file',
            'option' => [
                'path' => KX_ROOT . '/storage/log',
            ],
        ],
        'template' => [
            'driver' => 'file',
            'option' => [
                'path' => KX_ROOT . '/storage/template',
            ],
        ],
        'upload'   => [
            'driver' => 'file',
            'option' => [
                'path' => KX_ROOT . '/public/upload',
                'url'  => '/upload',
            ],
        ],
        'cover'    => [
            'driver' => 'file',
            'option' => [
                'path' => KX_ROOT . '/public/cover',
                'url'  => '/cover',
            ],
        ],
        'txt'      => [
            'driver' => 'file',
            'option' => [
                'path' => defined('TXT_PATH') ? TXT_PATH : (KX_ROOT . '/storage/txt'),
            ],
        ],
    ],

    //缓存设置
    'cache'    => [
        'prefix'  => 'kx_',
        'time'    => 600,
        'time_s'  => 600,
        'time_m'  => 600,
        'time_l'  => 86200,
        'common'  => [
            'driver' => KX_CACHE_COMMON_DRIVER,
            'option' => [
                'prefix'   => defined('KX_CACHE_COMMON_PREFIX') ? KX_CACHE_COMMON_PREFIX : 'kx_',
                'host'     => defined('KX_CACHE_COMMON_HOST') ? KX_CACHE_COMMON_HOST : '127.0.0.1',
                'port'     => defined('KX_CACHE_COMMON_PORT') ? KX_CACHE_COMMON_PORT : '11211',
                'password' => defined('KX_CACHE_COMMON_PASSWORD') ? KX_CACHE_COMMON_PASSWORD : null,
            ],
        ],
        'chapter' => [
            'driver' => defined('KX_CACHE_CHAPTER_DRIVER') ? KX_CACHE_CHAPTER_DRIVER : 'memcache',
            'option' => [
                'prefix'   => defined('KX_CACHE_CHAPTER_PREFIX') ? KX_CACHE_CHAPTER_PREFIX : 'kx_',
                'host'     => defined('KX_CACHE_CHAPTER_HOST') ? KX_CACHE_CHAPTER_HOST : '127.0.0.1',
                'port'     => defined('KX_CACHE_CHAPTER_PORT') ? KX_CACHE_CHAPTER_PORT : '11211',
                'password' => defined('KX_CACHE_CHAPTER_PASSWORD') ? KX_CACHE_CHAPTER_PASSWORD : null,
            ],
        ],
    ],


    //日志设置
    'log'      => [
        'power'     => true,
        'buildtype' => [ 'kx', 'debug', 'console' ],
    ],

    // cookie设置
    'coookie'  => [
        'prefix'   => 'PTCMS_',
        // cookie 保存时间
        'expire'   => 2592000,
        // cookie 保存路径
        'path'     => '/',
        // cookie 有效域名
        'domain'   => '',
        //  cookie 启用安全传输
        'secure'   => false,
        // httponly设置
        'httponly' => '',
    ],

    //session
    'session'  => [
        'handler' => '',
        'path'    => '',
        'host'    => '',
        'port'    => '',
    ],

    'chapter' => [
        'cache_power' => defined('CHAPTER_CACHE_POWER') ? true : false,
    ],
    'novel'   => [
        'intro_min_length' => defined('NOVEL_INTRO_MIN_LENGTH') ? NOVEL_INTRO_MIN_LENGTH : '50',
        'intro_max_length' => defined('NOVEL_INTRO_MAX_LENGTH') ? NOVEL_INTRO_MAX_LENGTH : '500',
    ],
];
// TXT_PATH txt保存路径
// COLLECT_MODE 采集模式