<?php

namespace Kuxin\Alipay;

use Kuxin\Config;
use Kuxin\Helper\Http;
use Kuxin\Helper\Xml;

class Pay extends Alipay
{

    const GATEWAY_URL = 'https://mapi.alipay.com/gateway.do';

    public function getPcUrl($data)
    {
        $data         = array_merge([
            'service'        => 'create_direct_pay_by_user',
            '_input_charset' => 'utf-8',
            'partner'        => $this->appId,
            'format'         => 'xml',
            'v'              => '2.0',
            'sign_type'      => 'MD5',
            'notify_url'     => '',
            'return_url'     => '',
            'out_trade_no'   => '',
            'subject'        => '',
            'body'           => '',
            'payment_type'   => '1',
            'total_fee'      => '',
            'seller_id'      => $this->appId,
            'seller_email'   => Config::get('alipay.email'),
            'show_url'       => '',
        ], $data);
        $data['sign'] = $this->sign($data);
        return self::GATEWAY_URL . '?' . http_build_query($data);
    }

    public function getWapUrl($data)
    {
        $data         = array_merge([
            'service'        => 'alipay.wap.create.direct.pay.by.user',
            '_input_charset' => 'utf-8',
            'partner'        => $this->appId,
            'format'         => 'xml',
            'v'              => '2.0',
            'sign_type'      => 'MD5',
            'notify_url'     => '',
            'return_url'     => '',
            'out_trade_no'   => '',
            'subject'        => '',
            'body'           => '',
            'payment_type'   => '1',
            'total_fee'      => '',
            'seller_id'      => $this->appId,
            'seller_email'   => Config::get('alipay.email'),
            'show_url'       => '',
        ], $data);
        $data['sign'] = $this->sign($data);
        return self::GATEWAY_URL . '?' . http_build_query($data);
    }
}