<?php

namespace Kuxin\Helper;

class OpenCC
{

    protected static $data = null;

    protected static function getData($key = '')
    {
        if (self::$data === null) {
            $data = file_get_contents(__DIR__ . "/data/opencc.dat", 'r') or exit('读取字典失败');
            if (empty(self::$data = Json::decode($data)))
                exit('解析字典失败');
        }
        return $key ? Arr::get(self::$data, $key) : self::$data;
    }

    public static function change(string $content, $type = 'from')
    {
        if ($type == 'from') {
            return self::fromutf8($content);
        } else {
            return self::toutf8($content);
        }
    }

    public static function fromutf8(string $content)
    {
        static $_word;
        if (empty($_word)) {
            $tcData = self::getData('character.tc');
            $scData = self::getData('character.sc');
            $length = mb_strlen($tcData);
            for ($i = 0; $i < $length; $i++) {
                $_word[mb_substr($scData, $i, 1)] = mb_substr($tcData, $i, 1);
            }
        }
        //基础单字替换
        $resStr = $content;
        //地区用词替换
        $resStr = strtr($resStr, self::getData('phrases.base'));
        $resStr = strtr($resStr, self::getData('phrases.tw_it'));
        $resStr = strtr($resStr, self::getData('phrases.tw_other'));
        $resStr = strtr($resStr, $_word);
        return $resStr;
    }


    public static function toutf8(string $content)
    {
        static $_word;
        if (empty($_word)) {
            $tcData = self::getData('character.tc');
            $scData = self::getData('character.sc');
            $length = mb_strlen($tcData);
            for ($i = 0; $i < $length; $i++) {
                $_word[mb_substr($tcData, $i, 1)] = mb_substr($scData, $i, 1);
            }
        }
        //基础单字替换
        $resStr = $content;
        //地区用词替换
        $resStr = strtr($resStr, array_flip(self::getData('phrases.base')));
        $resStr = strtr($resStr, array_flip(self::getData('phrases.tw_it')));
        $resStr = strtr($resStr, array_flip(self::getData('phrases.tw_other')));
        $resStr = strtr($resStr, $_word);
        return $resStr;
    }
}