<?php

namespace SMProxy\MysqlPacket\Util;

/**
 * Author: Louis Livi <574747417@qq.com>
 * Date: 2018/10/31
 * Time: 上午10:39.
 */
interface Capabilities
{
    /**
     * server capabilities
     * <p/>
     * <pre>
     * server:        11110111 11111111
     * client_cmd: 11 10100110 10000101
     * client_jdbc:10 10100010 10001111.
     *
     * </pre>
     */
    // new more secure passwords
    const CLIENT_LONG_PASSWORD = 1;

    // Found instead of affected rows
    // 返回找到（匹配）的行数，而不是改变了的行数。
    const CLIENT_FOUND_ROWS = 2;

    // Get all column flags
    const CLIENT_LONG_FLAG = 4;

    // One can specify db on connect
    const CLIENT_CONNECT_WITH_DB = 8;

    // Don't allow database.table.column
    // 不允许“数据库名.表名.列名”这样的语法。这是对于ODBC的设置。
    // 当使用这样的语法时解析器会产生一个错误，这对于一些ODBC的程序限制bug来说是有用的。
    const CLIENT_NO_SCHEMA = 16;

    // Can use compression protocol
    // 使用压缩协议
    const CLIENT_COMPRESS = 32;

    // Odbc client
    const CLIENT_ODBC = 64;

    // Can use LOAD DATA LOCAL
    const CLIENT_LOCAL_FILES = 128;

    // Ignore spaces before '('
    // 允许在函数名后使用空格。所有函数名可以预留字。
    const CLIENT_IGNORE_SPACE = 256;

    // New 4.1 protocol This is an interactive client
    const CLIENT_PROTOCOL_41 = 512;

    // This is an interactive client
    // 允许使用关闭连接之前的不活动交互超时的描述，而不是等待超时秒数。
    // 客户端的会话等待超时变量变为交互超时变量。
    const CLIENT_INTERACTIVE = 1024;

    // Switch to SSL after handshake
    // 使用SSL。这个设置不应该被应用程序设置，他应该是在客户端库内部是设置的。
    // 可以在调用mysql_real_connect()之前调用mysql_ssl_set()来代替设置。
    const CLIENT_SSL = 2048;

    // IGNORE sigpipes
    // 阻止客户端库安装一个SIGPIPE信号处理器。
    // 这个可以用于当应用程序已经安装该处理器的时候避免与其发生冲突。
    const CLIENT_IGNORE_SIGPIPE = 4096;

    // Client knows about transactions
    const CLIENT_TRANSACTIONS = 8192;

    // Old flag for 4.1 protocol
    const CLIENT_RESERVED = 16384;

    // New 4.1 authentication
    const CLIENT_SECURE_CONNECTION = 32768;

    // Enable/disable multi-stmt support
    // 通知服务器客户端可以发送多条语句（由分号分隔）。如果该标志为没有被设置，多条语句执行。
    const CLIENT_MULTI_STATEMENTS = 65536;

    // Enable/disable multi-results
    // 通知服务器客户端可以处理由多语句或者存储过程执行生成的多结果集。
    // 当打开CLIENT_MULTI_STATEMENTS时，这个标志自动的被打开。
    const CLIENT_MULTI_RESULTS = 131072;

    const CLIENT_PLUGIN_AUTH = 524288;

    const CLIENT_CONNECT_ATTRS = 1048576;

    const CLIENT_PLUGIN_AUTH_LENENC_CLIENT_DATA = 2097152;

    const CLIENT_CAPABILITIES = (
        self::CLIENT_LONG_PASSWORD | self::CLIENT_FOUND_ROWS | self::CLIENT_ODBC | self::CLIENT_LONG_FLAG |
        self::CLIENT_IGNORE_SPACE | self::CLIENT_PROTOCOL_41 | self::CLIENT_TRANSACTIONS |
        self::CLIENT_INTERACTIVE | self::CLIENT_SECURE_CONNECTION | self::CLIENT_MULTI_RESULTS |
        self::CLIENT_PLUGIN_AUTH | self::CLIENT_PLUGIN_AUTH_LENENC_CLIENT_DATA
    );
    # Not done yet
    const CLIENT_HANDLE_EXPIRED_PASSWORDS = 4194304;

    const CLIENT_SESSION_TRACK = 8388608;

    const CLIENT_DEPRECATE_EOF = 16777216;
}
