<?php
/**
 * Author: Louis Livi <574747417@qq.com>
 * Date: 2018/11/9
 * Time: 下午12:10.
 */

namespace SMProxy\MysqlPacket\Util;

/**
 * MySql 错误码
 */
interface ErrorCode
{
    // cobar errorMessage code
    const ERR_OPEN_SOCKET = 3001;
    const ERR_CONNECT_SOCKET = 3002;
    const ERR_FINISH_CONNECT = 3003;
    const ERR_REGISTER = 3004;
    const ERR_READ = 3005;
    const ERR_PUT_WRITE_QUEUE = 3006;
    const ERR_WRITE_BY_EVENT = 3007;
    const ERR_WRITE_BY_QUEUE = 3008;
    const ERR_HANDLE_DATA = 3009;
    const ERR_EXCEPTION_CAUGHT = 3010;
    const ERR_SINGLE_EXECUTE_NODES = 3011;
    const NO_TRANSACTION_IN_MULTI_NODES = 3012;

    // mysql errorMessage code
    const ER_HASHCHK = 1000;
    const ER_NISAMCHK = 1001;
    const ER_NO = 1002;
    const ER_YES = 1003;
    const ER_CANT_CREATE_FILE = 1004;
    const ER_CANT_CREATE_TABLE = 1005;
    const ER_CANT_CREATE_DB = 1006;
    const ER_DB_CREATE_EXISTS = 1007;
    const ER_DB_DROP_EXISTS = 1008;
    const ER_DB_DROP_DELETE = 1009;
    const ER_DB_DROP_RMDIR = 1010;
    const ER_CANT_DELETE_FILE = 1011;
    const ER_CANT_FIND_SYSTEM_REC = 1012;
    const ER_CANT_GET_STAT = 1013;
    const ER_CANT_GET_WD = 1014;
    const ER_CANT_LOCK = 1015;
    const ER_CANT_OPEN_FILE = 1016;
    const ER_FILE_NOT_FOUND = 1017;
    const ER_CANT_READ_DIR = 1018;
    const ER_CANT_SET_WD = 1019;
    const ER_CHECKREAD = 1020;
    const ER_DISK_FULL = 1021;
    const ER_DUP_KEY = 1022;
    const ER_ERROR_ON_CLOSE = 1023;
    const ER_ERROR_ON_READ = 1024;
    const ER_ERROR_ON_RENAME = 1025;
    const ER_ERROR_ON_WRITE = 1026;
    const ER_FILE_USED = 1027;
    const ER_FILSORT_ABORT = 1028;
    const ER_FORM_NOT_FOUND = 1029;
    const ER_GET_ERRNO = 1030;
    const ER_ILLEGAL_HA = 1031;
    const ER_KEY_NOT_FOUND = 1032;
    const ER_NOT_FORM_FILE = 1033;
    const ER_NOT_KEYFILE = 1034;
    const ER_OLD_KEYFILE = 1035;
    const ER_OPEN_AS_READONLY = 1036;
    const ER_OUTOFMEMORY = 1037;
    const ER_OUT_OF_SORTMEMORY = 1038;
    const ER_UNEXPECTED_EOF = 1039;
    const ER_CON_COUNT_ERROR = 1040;
    const ER_OUT_OF_RESOURCES = 1041;
    const ER_BAD_HOST_ERROR = 1042;
    const ER_HANDSHAKE_ERROR = 1043;
    const ER_DBACCESS_DENIED_ERROR = 1044;
    const ER_ACCESS_DENIED_ERROR = 1045;
    const ER_NO_DB_ERROR = 1046;
    const ER_UNKNOWN_COM_ERROR = 1047;
    const ER_BAD_NULL_ERROR = 1048;
    const ER_BAD_DB_ERROR = 1049;
    const ER_TABLE_EXISTS_ERROR = 1050;
    const ER_BAD_TABLE_ERROR = 1051;
    const ER_NON_UNIQ_ERROR = 1052;
    const ER_SERVER_SHUTDOWN = 1053;
    const ER_BAD_FIELD_ERROR = 1054;
    const ER_WRONG_FIELD_WITH_GROUP = 1055;
    const ER_WRONG_GROUP_FIELD = 1056;
    const ER_WRONG_SUM_SELECT = 1057;
    const ER_WRONG_VALUE_COUNT = 1058;
    const ER_TOO_LONG_IDENT = 1059;
    const ER_DUP_FIELDNAME = 1060;
    const ER_DUP_KEYNAME = 1061;
    const ER_DUP_ENTRY = 1062;
    const ER_WRONG_FIELD_SPEC = 1063;
    const ER_PARSE_ERROR = 1064;
    const ER_EMPTY_QUERY = 1065;
    const ER_NONUNIQ_TABLE = 1066;
    const ER_INVALID_DEFAULT = 1067;
    const ER_MULTIPLE_PRI_KEY = 1068;
    const ER_TOO_MANY_KEYS = 1069;
    const ER_TOO_MANY_KEY_PARTS = 1070;
    const ER_TOO_LONG_KEY = 1071;
    const ER_KEY_COLUMN_DOES_NOT_EXITS = 1072;
    const ER_BLOB_USED_AS_KEY = 1073;
    const ER_TOO_BIG_FIELDLENGTH = 1074;
    const ER_WRONG_AUTO_KEY = 1075;
    const ER_READY = 1076;
    const ER_NORMAL_SHUTDOWN = 1077;
    const ER_GOT_SIGNAL = 1078;
    const ER_SHUTDOWN_COMPLETE = 1079;
    const ER_FORCING_CLOSE = 1080;
    const ER_IPSOCK_ERROR = 1081;
    const ER_NO_SUCH_INDEX = 1082;
    const ER_WRONG_FIELD_TERMINATORS = 1083;
    const ER_BLOBS_AND_NO_TERMINATED = 1084;
    const ER_TEXTFILE_NOT_READABLE = 1085;
    const ER_FILE_EXISTS_ERROR = 1086;
    const ER_LOAD_INFO = 1087;
    const ER_ALTER_INFO = 1088;
    const ER_WRONG_SUB_KEY = 1089;
    const ER_CANT_REMOVE_ALL_FIELDS = 1090;
    const ER_CANT_DROP_FIELD_OR_KEY = 1091;
    const ER_INSERT_INFO = 1092;
    const ER_UPDATE_TABLE_USED = 1093;
    const ER_NO_SUCH_THREAD = 1094;
    const ER_KILL_DENIED_ERROR = 1095;
    const ER_NO_TABLES_USED = 1096;
    const ER_TOO_BIG_SET = 1097;
    const ER_NO_UNIQUE_LOGFILE = 1098;
    const ER_TABLE_NOT_LOCKED_FOR_WRITE = 1099;
    const ER_TABLE_NOT_LOCKED = 1100;
    const ER_BLOB_CANT_HAVE_DEFAULT = 1101;
    const ER_WRONG_DB_NAME = 1102;
    const ER_WRONG_TABLE_NAME = 1103;
    const ER_TOO_BIG_SELECT = 1104;
    const ER_UNKNOWN_ERROR = 1105;
    const ER_UNKNOWN_PROCEDURE = 1106;
    const ER_WRONG_PARAMCOUNT_TO_PROCEDURE = 1107;
    const ER_WRONG_PARAMETERS_TO_PROCEDURE = 1108;
    const ER_UNKNOWN_TABLE = 1109;
    const ER_FIELD_SPECIFIED_TWICE = 1110;
    const ER_INVALID_GROUP_FUNC_USE = 1111;
    const ER_UNSUPPORTED_EXTENSION = 1112;
    const ER_TABLE_MUST_HAVE_COLUMNS = 1113;
    const ER_RECORD_FILE_FULL = 1114;
    const ER_UNKNOWN_CHARACTER_SET = 1115;
    const ER_TOO_MANY_TABLES = 1116;
    const ER_TOO_MANY_FIELDS = 1117;
    const ER_TOO_BIG_ROWSIZE = 1118;
    const ER_STACK_OVERRUN = 1119;
    const ER_WRONG_OUTER_JOIN = 1120;
    const ER_NULL_COLUMN_IN_INDEX = 1121;
    const ER_CANT_FIND_UDF = 1122;
    const ER_CANT_INITIALIZE_UDF = 1123;
    const ER_UDF_NO_PATHS = 1124;
    const ER_UDF_EXISTS = 1125;
    const ER_CANT_OPEN_LIBRARY = 1126;
    const ER_CANT_FIND_DL_ENTRY = 1127;
    const ER_FUNCTION_NOT_DEFINED = 1128;
    const ER_HOST_IS_BLOCKED = 1129;
    const ER_HOST_NOT_PRIVILEGED = 1130;
    const ER_PASSWORD_ANONYMOUS_USER = 1131;
    const ER_PASSWORD_NOT_ALLOWED = 1132;
    const ER_PASSWORD_NO_MATCH = 1133;
    const ER_UPDATE_INFO = 1134;
    const ER_CANT_CREATE_THREAD = 1135;
    const ER_WRONG_VALUE_COUNT_ON_ROW = 1136;
    const ER_CANT_REOPEN_TABLE = 1137;
    const ER_INVALID_USE_OF_NULL = 1138;
    const ER_REGEXP_ERROR = 1139;
    const ER_MIX_OF_GROUP_FUNC_AND_FIELDS = 1140;
    const ER_NONEXISTING_GRANT = 1141;
    const ER_TABLEACCESS_DENIED_ERROR = 1142;
    const ER_COLUMNACCESS_DENIED_ERROR = 1143;
    const ER_ILLEGAL_GRANT_FOR_TABLE = 1144;
    const ER_GRANT_WRONG_HOST_OR_USER = 1145;
    const ER_NO_SUCH_TABLE = 1146;
    const ER_NONEXISTING_TABLE_GRANT = 1147;
    const ER_NOT_ALLOWED_COMMAND = 1148;
    const ER_SYNTAX_ERROR = 1149;
    const ER_DELAYED_CANT_CHANGE_LOCK = 1150;
    const ER_TOO_MANY_DELAYED_THREADS = 1151;
    const ER_ABORTING_CONNECTION = 1152;
    const ER_NET_PACKET_TOO_LARGE = 1153;
    const ER_NET_READ_ERROR_FROM_PIPE = 1154;
    const ER_NET_FCNTL_ERROR = 1155;
    const ER_NET_PACKETS_OUT_OF_ORDER = 1156;
    const ER_NET_UNCOMPRESS_ERROR = 1157;
    const ER_NET_READ_ERROR = 1158;
    const ER_NET_READ_INTERRUPTED = 1159;
    const ER_NET_ERROR_ON_WRITE = 1160;
    const ER_NET_WRITE_INTERRUPTED = 1161;
    const ER_TOO_LONG_STRING = 1162;
    const ER_TABLE_CANT_HANDLE_BLOB = 1163;
    const ER_TABLE_CANT_HANDLE_AUTO_INCREMENT = 1164;
    const ER_DELAYED_INSERT_TABLE_LOCKED = 1165;
    const ER_WRONG_COLUMN_NAME = 1166;
    const ER_WRONG_KEY_COLUMN = 1167;
    const ER_WRONG_MRG_TABLE = 1168;
    const ER_DUP_UNIQUE = 1169;
    const ER_BLOB_KEY_WITHOUT_LENGTH = 1170;
    const ER_PRIMARY_CANT_HAVE_NULL = 1171;
    const ER_TOO_MANY_ROWS = 1172;
    const ER_REQUIRES_PRIMARY_KEY = 1173;
    const ER_NO_RAID_COMPILED = 1174;
    const ER_UPDATE_WITHOUT_KEY_IN_SAFE_MODE = 1175;
    const ER_KEY_DOES_NOT_EXITS = 1176;
    const ER_CHECK_NO_SUCH_TABLE = 1177;
    const ER_CHECK_NOT_IMPLEMENTED = 1178;
    const ER_CANT_DO_THIS_DURING_AN_TRANSACTION = 1179;
    const ER_ERROR_DURING_COMMIT = 1180;
    const ER_ERROR_DURING_ROLLBACK = 1181;
    const ER_ERROR_DURING_FLUSH_LOGS = 1182;
    const ER_ERROR_DURING_CHECKPO = 1183;
    const ER_NEW_ABORTING_CONNECTION = 1184;
    const ER_DUMP_NOT_IMPLEMENTED = 1185;
    const ER_FLUSH_MASTER_BINLOG_CLOSED = 1186;
    const ER_INDEX_REBUILD = 1187;
    const ER_MASTER = 1188;
    const ER_MASTER_NET_READ = 1189;
    const ER_MASTER_NET_WRITE = 1190;
    const ER_FT_MATCHING_KEY_NOT_FOUND = 1191;
    const ER_LOCK_OR_ACTIVE_TRANSACTION = 1192;
    const ER_UNKNOWN_SYSTEM_VARIABLE = 1193;
    const ER_CRASHED_ON_USAGE = 1194;
    const ER_CRASHED_ON_REPAIR = 1195;
    const ER_WARNING_NOT_COMPLETE_ROLLBACK = 1196;
    const ER_TRANS_CACHE_FULL = 1197;
    const ER_SLAVE_MUST_STOP = 1198;
    const ER_SLAVE_NOT_RUNNING = 1199;
    const ER_BAD_SLAVE = 1200;
    const ER_MASTER_INFO = 1201;
    const ER_SLAVE_THREAD = 1202;
    const ER_TOO_MANY_USER_CONNECTIONS = 1203;
    const ER_SET_CONSTANTS_ONLY = 1204;
    const ER_LOCK_WAIT_TIMEOUT = 1205;
    const ER_LOCK_TABLE_FULL = 1206;
    const ER_READ_ONLY_TRANSACTION = 1207;
    const ER_DROP_DB_WITH_READ_LOCK = 1208;
    const ER_CREATE_DB_WITH_READ_LOCK = 1209;
    const ER_WRONG_ARGUMENTS = 1210;
    const ER_NO_PERMISSION_TO_CREATE_USER = 1211;
    const ER_UNION_TABLES_IN_DIFFERENT_DIR = 1212;
    const ER_LOCK_DEADLOCK = 1213;
    const ER_TABLE_CANT_HANDLE_FT = 1214;
    const ER_CANNOT_ADD_FOREIGN = 1215;
    const ER_NO_REFERENCED_ROW = 1216;
    const ER_ROW_IS_REFERENCED = 1217;
    const ER_CONNECT_TO_MASTER = 1218;
    const ER_QUERY_ON_MASTER = 1219;
    const ER_ERROR_WHEN_EXECUTING_COMMAND = 1220;
    const ER_WRONG_USAGE = 1221;
    const ER_WRONG_NUMBER_OF_COLUMNS_IN_SELECT = 1222;
    const ER_CANT_UPDATE_WITH_READLOCK = 1223;
    const ER_MIXING_NOT_ALLOWED = 1224;
    const ER_DUP_ARGUMENT = 1225;
    const ER_USER_LIMIT_REACHED = 1226;
    const ER_SPECIFIC_ACCESS_DENIED_ERROR = 1227;
    const ER_LOCAL_VARIABLE = 1228;
    const ER_GLOBAL_VARIABLE = 1229;
    const ER_NO_DEFAULT = 1230;
    const ER_WRONG_VALUE_FOR_VAR = 1231;
    const ER_WRONG_TYPE_FOR_VAR = 1232;
    const ER_VAR_CANT_BE_READ = 1233;
    const ER_CANT_USE_OPTION_HERE = 1234;
    const ER_NOT_SUPPORTED_YET = 1235;
    const ER_MASTER_FATAL_ERROR_READING_BINLOG = 1236;
    const ER_SLAVE_IGNORED_TABLE = 1237;
    const ER_INCORRECT_GLOBAL_LOCAL_VAR = 1238;
    const ER_WRONG_FK_DEF = 1239;
    const ER_KEY_REF_DO_NOT_MATCH_TABLE_REF = 1240;
    const ER_OPERAND_COLUMNS = 1241;
    const ER_SUBQUERY_NO_1_ROW = 1242;
    const ER_UNKNOWN_STMT_HANDLER = 1243;
    const ER_CORRUPT_HELP_DB = 1244;
    const ER_CYCLIC_REFERENCE = 1245;
    const ER_AUTO_CONVERT = 1246;
    const ER_ILLEGAL_REFERENCE = 1247;
    const ER_DERIVED_MUST_HAVE_ALIAS = 1248;
    const ER_SELECT_REDUCED = 1249;
    const ER_TABLENAME_NOT_ALLOWED_HERE = 1250;
    const ER_NOT_SUPPORTED_AUTH_MODE = 1251;
    const ER_SPATIAL_CANT_HAVE_NULL = 1252;
    const ER_COLLATION_CHARSET_MISMATCH = 1253;
    const ER_SLAVE_WAS_RUNNING = 1254;
    const ER_SLAVE_WAS_NOT_RUNNING = 1255;
    const ER_TOO_BIG_FOR_UNCOMPRESS = 1256;
    const ER_ZLIB_Z_MEM_ERROR = 1257;
    const ER_ZLIB_Z_BUF_ERROR = 1258;
    const ER_ZLIB_Z_DATA_ERROR = 1259;
    const ER_CUT_VALUE_GROUP_CONCAT = 1260;
    const ER_WARN_TOO_FEW_RECORDS = 1261;
    const ER_WARN_TOO_MANY_RECORDS = 1262;
    const ER_WARN_NULL_TO_NOTNULL = 1263;
    const ER_WARN_DATA_OUT_OF_RANGE = 1264;
    const WARN_DATA_TRUNCATED = 1265;
    const ER_WARN_USING_OTHER_HANDLER = 1266;
    const ER_CANT_AGGREGATE_2COLLATIONS = 1267;
    const ER_DROP_USER = 1268;
    const ER_REVOKE_GRANTS = 1269;
    const ER_CANT_AGGREGATE_3COLLATIONS = 1270;
    const ER_CANT_AGGREGATE_NCOLLATIONS = 1271;
    const ER_VARIABLE_IS_NOT_STRUCT = 1272;
    const ER_UNKNOWN_COLLATION = 1273;
    const ER_SLAVE_IGNORED_SSL_PARAMS = 1274;
    const ER_SERVER_IS_IN_SECURE_AUTH_MODE = 1275;
    const ER_WARN_FIELD_RESOLVED = 1276;
    const ER_BAD_SLAVE_UNTIL_COND = 1277;
    const ER_MISSING_SKIP_SLAVE = 1278;
    const ER_UNTIL_COND_IGNORED = 1279;
    const ER_WRONG_NAME_FOR_INDEX = 1280;
    const ER_WRONG_NAME_FOR_CATALOG = 1281;
    const ER_WARN_QC_RESIZE = 1282;
    const ER_BAD_FT_COLUMN = 1283;
    const ER_UNKNOWN_KEY_CACHE = 1284;
    const ER_WARN_HOSTNAME_WONT_WORK = 1285;
    const ER_UNKNOWN_STORAGE_ENGINE = 1286;
    const ER_WARN_DEPRECATED_SYNTAX = 1287;
    const ER_NON_UPDATABLE_TABLE = 1288;
    const ER_FEATURE_DISABLED = 1289;
    const ER_OPTION_PREVENTS_STATEMENT = 1290;
    const ER_DUPLICATED_VALUE_IN_TYPE = 1291;
    const ER_TRUNCATED_WRONG_VALUE = 1292;
    const ER_TOO_MUCH_AUTO_TIMESTAMP_COLS = 1293;
    const ER_INVALID_ON_UPDATE = 1294;
    const ER_UNSUPPORTED_PS = 1295;
    const ER_GET_ERRMSG = 1296;
    const ER_GET_TEMPORARY_ERRMSG = 1297;
    const ER_UNKNOWN_TIME_ZONE = 1298;
    const ER_WARN_INVALID_TIMESTAMP = 1299;
    const ER_INVALID_CHARACTER_STRING = 1300;
    const ER_WARN_ALLOWED_PACKET_OVERFLOWED = 1301;
    const ER_CONFLICTING_DECLARATIONS = 1302;
    const ER_SP_NO_RECURSIVE_CREATE = 1303;
    const ER_SP_ALREADY_EXISTS = 1304;
    const ER_SP_DOES_NOT_EXIST = 1305;
    const ER_SP_DROP_FAILED = 1306;
    const ER_SP_STORE_FAILED = 1307;
    const ER_SP_LILABEL_MISMATCH = 1308;
    const ER_SP_LABEL_REDEFINE = 1309;
    const ER_SP_LABEL_MISMATCH = 1310;
    const ER_SP_UNINIT_VAR = 1311;
    const ER_SP_BADSELECT = 1312;
    const ER_SP_BADRETURN = 1313;
    const ER_SP_BADSTATEMENT = 1314;
    const ER_UPDATE_LOG_DEPRECATED_IGNORED = 1315;
    const ER_UPDATE_LOG_DEPRECATED_TRANSLATED = 1316;
    const ER_QUERY_INTERRUPTED = 1317;
    const ER_SP_WRONG_NO_OF_ARGS = 1318;
    const ER_SP_COND_MISMATCH = 1319;
    const ER_SP_NORETURN = 1320;
    const ER_SP_NORETURNEND = 1321;
    const ER_SP_BAD_CURSOR_QUERY = 1322;
    const ER_SP_BAD_CURSOR_SELECT = 1323;
    const ER_SP_CURSOR_MISMATCH = 1324;
    const ER_SP_CURSOR_ALREADY_OPEN = 1325;
    const ER_SP_CURSOR_NOT_OPEN = 1326;
    const ER_SP_UNDECLARED_VAR = 1327;
    const ER_SP_WRONG_NO_OF_FETCH_ARGS = 1328;
    const ER_SP_FETCH_NO_DATA = 1329;
    const ER_SP_DUP_PARAM = 1330;
    const ER_SP_DUP_VAR = 1331;
    const ER_SP_DUP_COND = 1332;
    const ER_SP_DUP_CURS = 1333;
    const ER_SP_CANT_ALTER = 1334;
    const ER_SP_SUBSELECT_NYI = 1335;
    const ER_STMT_NOT_ALLOWED_IN_SF_OR_TRG = 1336;
    const ER_SP_VARCOND_AFTER_CURSHNDLR = 1337;
    const ER_SP_CURSOR_AFTER_HANDLER = 1338;
    const ER_SP_CASE_NOT_FOUND = 1339;
    const ER_FPARSER_TOO_BIG_FILE = 1340;
    const ER_FPARSER_BAD_HEADER = 1341;
    const ER_FPARSER_EOF_IN_COMMENT = 1342;
    const ER_FPARSER_ERROR_IN_PARAMETER = 1343;
    const ER_FPARSER_EOF_IN_UNKNOWN_PARAMETER = 1344;
    const ER_VIEW_NO_EXPLAIN = 1345;
    const ER_FRM_UNKNOWN_TYPE = 1346;
    const ER_WRONG_OBJECT = 1347;
    const ER_NONUPDATEABLE_COLUMN = 1348;
    const ER_VIEW_SELECT_DERIVED = 1349;
    const ER_VIEW_SELECT_CLAUSE = 1350;
    const ER_VIEW_SELECT_VARIABLE = 1351;
    const ER_VIEW_SELECT_TMPTABLE = 1352;
    const ER_VIEW_WRONG_LIST = 1353;
    const ER_WARN_VIEW_MERGE = 1354;
    const ER_WARN_VIEW_WITHOUT_KEY = 1355;
    const ER_VIEW_INVALID = 1356;
    const ER_SP_NO_DROP_SP = 1357;
    const ER_SP_GOTO_IN_HNDLR = 1358;
    const ER_TRG_ALREADY_EXISTS = 1359;
    const ER_TRG_DOES_NOT_EXIST = 1360;
    const ER_TRG_ON_VIEW_OR_TEMP_TABLE = 1361;
    const ER_TRG_CANT_CHANGE_ROW = 1362;
    const ER_TRG_NO_SUCH_ROW_IN_TRG = 1363;
    const ER_NO_DEFAULT_FOR_FIELD = 1364;
    const ER_DIVISION_BY_ZERO = 1365;
    const ER_TRUNCATED_WRONG_VALUE_FOR_FIELD = 1366;
    const ER_ILLEGAL_VALUE_FOR_TYPE = 1367;
    const ER_VIEW_NONUPD_CHECK = 1368;
    const ER_VIEW_CHECK_FAILED = 1369;
    const ER_PROCACCESS_DENIED_ERROR = 1370;
    const ER_RELAY_LOG_FAIL = 1371;
    const ER_PASSWD_LENGTH = 1372;
    const ER_UNKNOWN_TARGET_BINLOG = 1373;
    const ER_IO_ERR_LOG_INDEX_READ = 1374;
    const ER_BINLOG_PURGE_PROHIBITED = 1375;
    const ER_FSEEK_FAIL = 1376;
    const ER_BINLOG_PURGE_FATAL_ERR = 1377;
    const ER_LOG_IN_USE = 1378;
    const ER_LOG_PURGE_UNKNOWN_ERR = 1379;
    const ER_RELAY_LOG_INIT = 1380;
    const ER_NO_BINARY_LOGGING = 1381;
    const ER_RESERVED_SYNTAX = 1382;
    const ER_WSAS_FAILED = 1383;
    const ER_DIFF_GROUPS_PROC = 1384;
    const ER_NO_GROUP_FOR_PROC = 1385;
    const ER_ORDER_WITH_PROC = 1386;
    const ER_LOGGING_PROHIBIT_CHANGING_OF = 1387;
    const ER_NO_FILE_MAPPING = 1388;
    const ER_WRONG_MAGIC = 1389;
    const ER_PS_MANY_PARAM = 1390;
    const ER_KEY_PART_0 = 1391;
    const ER_VIEW_CHECKSUM = 1392;
    const ER_VIEW_MULTIUPDATE = 1393;
    const ER_VIEW_NO_INSERT_FIELD_LIST = 1394;
    const ER_VIEW_DELETE_MERGE_VIEW = 1395;
    const ER_CANNOT_USER = 1396;
    const ER_XAER_NOTA = 1397;
    const ER_XAER_INVAL = 1398;
    const ER_XAER_RMFAIL = 1399;
    const ER_XAER_OUTSIDE = 1400;
    const ER_XAER_RMERR = 1401;
    const ER_XA_RBROLLBACK = 1402;
    const ER_NONEXISTING_PROC_GRANT = 1403;
    const ER_PROC_AUTO_GRANT_FAIL = 1404;
    const ER_PROC_AUTO_REVOKE_FAIL = 1405;
    const ER_DATA_TOO_LONG = 1406;
    const ER_SP_BAD_SQLSTATE = 1407;
    const ER_STARTUP = 1408;
    const ER_LOAD_FROM_FIXED_SIZE_ROWS_TO_VAR = 1409;
    const ER_CANT_CREATE_USER_WITH_GRANT = 1410;
    const ER_WRONG_VALUE_FOR_TYPE = 1411;
    const ER_TABLE_DEF_CHANGED = 1412;
    const ER_SP_DUP_HANDLER = 1413;
    const ER_SP_NOT_VAR_ARG = 1414;
    const ER_SP_NO_RETSET = 1415;
    const ER_CANT_CREATE_GEOMETRY_OBJECT = 1416;
    const ER_FAILED_ROUTINE_BREAK_BINLOG = 1417;
    const ER_BINLOG_UNSAFE_ROUTINE = 1418;
    const ER_BINLOG_CREATE_ROUTINE_NEED_SUPER = 1419;
    const ER_EXEC_STMT_WITH_OPEN_CURSOR = 1420;
    const ER_STMT_HAS_NO_OPEN_CURSOR = 1421;
    const ER_COMMIT_NOT_ALLOWED_IN_SF_OR_TRG = 1422;
    const ER_NO_DEFAULT_FOR_VIEW_FIELD = 1423;
    const ER_SP_NO_RECURSION = 1424;
    const ER_TOO_BIG_SCALE = 1425;
    const ER_TOO_BIG_PRECISION = 1426;
    const ER_M_BIGGER_THAN_D = 1427;
    const ER_WRONG_LOCK_OF_SYSTEM_TABLE = 1428;
    const ER_CONNECT_TO_FOREIGN_DATA_SOURCE = 1429;
    const ER_QUERY_ON_FOREIGN_DATA_SOURCE = 1430;
    const ER_FOREIGN_DATA_SOURCE_DOESNT_EXIST = 1431;
    const ER_FOREIGN_DATA_STRING_INVALID_CANT_CREATE = 1432;
    const ER_FOREIGN_DATA_STRING_INVALID = 1433;
    const ER_CANT_CREATE_FEDERATED_TABLE = 1434;
    const ER_TRG_IN_WRONG_SCHEMA = 1435;
    const ER_STACK_OVERRUN_NEED_MORE = 1436;
    const ER_TOO_LONG_BODY = 1437;
    const ER_WARN_CANT_DROP_DEFAULT_KEYCACHE = 1438;
    const ER_TOO_BIG_DISPLAYWIDTH = 1439;
    const ER_XAER_DUPID = 1440;
    const ER_DATETIME_FUNCTION_OVERFLOW = 1441;
    const ER_CANT_UPDATE_USED_TABLE_IN_SF_OR_TRG = 1442;
    const ER_VIEW_PREVENT_UPDATE = 1443;
    const ER_PS_NO_RECURSION = 1444;
    const ER_SP_CANT_SET_AUTOCOMMIT = 1445;
    const ER_NO_VIEW_USER = 1446;
    const ER_VIEW_FRM_NO_USER = 1447;
    const ER_VIEW_OTHER_USER = 1448;
    const ER_NO_SUCH_USER = 1449;
    const ER_FORBID_SCHEMA_CHANGE = 1450;
    const ER_ROW_IS_REFERENCED_2 = 1451;
    const ER_NO_REFERENCED_ROW_2 = 1452;
    const ER_SP_BAD_VAR_SHADOW = 1453;
    const ER_PARTITION_REQUIRES_VALUES_ERROR = 1454;
    const ER_PARTITION_WRONG_VALUES_ERROR = 1455;
    const ER_PARTITION_MAXVALUE_ERROR = 1456;
    const ER_PARTITION_SUBPARTITION_ERROR = 1457;
    const ER_PARTITION_WRONG_NO_PART_ERROR = 1458;
    const ER_PARTITION_WRONG_NO_SUBPART_ERROR = 1459;
    const ER_CONST_EXPR_IN_PARTITION_FUNC_ERROR = 1460;
    const ER_NO_CONST_EXPR_IN_RANGE_OR_LIST_ERROR = 1461;
    const ER_FIELD_NOT_FOUND_PART_ERROR = 1462;
    const ER_LIST_OF_FIELDS_ONLY_IN_HASH_ERROR = 1463;
    const ER_INCONSISTENT_PARTITION_INFO_ERROR = 1464;
    const ER_PARTITION_FUNC_NOT_ALLOWED_ERROR = 1465;
    const ER_PARTITIONS_MUST_BE_DEFINED_ERROR = 1466;
    const ER_RANGE_NOT_INCREASING_ERROR = 1467;
    const ER_INCONSISTENT_TYPE_OF_FUNCTIONS_ERROR = 1468;
    const ER_MULTIPLE_DEF_CONST_IN_LIST_PART_ERROR = 1469;
    const ER_PARTITION_ENTRY_ERROR = 1470;
    const ER_MIX_HANDLER_ERROR = 1471;
    const ER_PARTITION_NOT_DEFINED_ERROR = 1472;
    const ER_TOO_MANY_PARTITIONS_ERROR = 1473;
    const ER_SUBPARTITION_ERROR = 1474;
    const ER_CANT_CREATE_HANDLER_FILE = 1475;
    const ER_BLOB_FIELD_IN_PART_FUNC_ERROR = 1476;
    const ER_CHAR_SET_IN_PART_FIELD_ERROR = 1477;
    const ER_UNIQUE_KEY_NEED_ALL_FIELDS_IN_PF = 1478;
    const ER_NO_PARTS_ERROR = 1479;
    const ER_PARTITION_MGMT_ON_NONPARTITIONED = 1480;
    const ER_DROP_PARTITION_NON_EXISTENT = 1481;
    const ER_DROP_LAST_PARTITION = 1482;
    const ER_COALESCE_ONLY_ON_HASH_PARTITION = 1483;
    const ER_ONLY_ON_RANGE_LIST_PARTITION = 1484;
    const ER_ADD_PARTITION_SUBPART_ERROR = 1485;
    const ER_ADD_PARTITION_NO_NEW_PARTITION = 1486;
    const ER_COALESCE_PARTITION_NO_PARTITION = 1487;
    const ER_REORG_PARTITION_NOT_EXIST = 1488;
    const ER_SAME_NAME_PARTITION = 1489;
    const ER_CONSECUTIVE_REORG_PARTITIONS = 1490;
    const ER_REORG_OUTSIDE_RANGE = 1491;
    const ER_DROP_PARTITION_FAILURE = 1492;
    const ER_DROP_PARTITION_WHEN_FK_DEFINED = 1493;
    const ER_PLUGIN_IS_NOT_LOADED = 1494;
    const ER_MULTI_QUERY_TIMEOUT = 1495;
    const ER_MULTI_EXEC_ERROR = 1496;
    const ER_HAS_GONE_AWAY = 2006;
}
