<?php
/*
Author  : poetbi (poetbi@163.com)
Document: http://boasoft.top/doc/#api/boa.fileinfo.html
Licenses: Apache-2.0 (http://apache.org/licenses/LICENSE-2.0)
*/
namespace boa;

class fileinfo{
	private $file = null;
	private $obj = null;

	public function __construct($file){
		$this->file = $file;
	}

	public function __destruct(){
		$this->close();
	}

    public function md5(){
        return hash_file('md5', $this->file);
    }

    public function sha1(){
        return hash_file('sha1', $this->file);
    }

	public function mime_type(){
		return $this->file_read(FILEINFO_MIME_TYPE);
	}
	
	public function charset(){
		return $this->file_read(FILEINFO_MIME_ENCODING);
	}

	public function mime(){
		return $this->file_read(FILEINFO_MIME);
	}

	public function devices(){
		return $this->file_read(FILEINFO_DEVICES);
	}

	public function raw(){
		return $this->file_read(FILEINFO_RAW);
	}

	public function ext(){
		if(defined('FILEINFO_EXTENSION')){
			$res = $this->file_read(FILEINFO_EXTENSION);
		}else{
			$res = substr(strrchr($this->file, '.'), 1);
		}
		return strtolower($res);
	}

	public function close(){
		if($this->obj){
			$this->obj->close();
			$this->obj = null;
		}
	}
	
	private function file_open(){
		if(!$this->obj){
			if(class_exists('finfo', false)){
				$this->obj = new \finfo();
			}else{
				msg::set('boa.error.6', 'finfo');
			}
		}
		return $this->obj;
	}
	
	private function file_read($type = FILEINFO_NONE){
		$obj = $this->file_open();
		$obj->set_flags($type);
		$res = $obj->file($this->file);
		return $res;
	}
}
?>