var touch = new vueTouch();
touch.inMove = true;
var App=new Vue({
	el: "#App",
	data: function() {
		return {
			page: "product",
			pageLoad: false,
			list: {},
			shopid: shopid,
			shop: {},
			shopFavClass: "",
			tabClass: "",
			tabRowClass:"",
			sideClass:"",
			catList: {},
			catid: 0,
			per_page: 0,
			isFirst: true,
			cart: {},
			ksShow: false,
			ksproduct: [],
			ksList: [],
			ksList2: [],
			ksid: 0,
			ksid1: 0,
			ksid2: 0,
			orderby: ""
		}
	},
	created: function() {
		this.getPage();
		this.getList();
		this.statCart();
	},
	methods: {

		backTop: function() {
			$(window).scrollTop(0);
		},
		gourl: function(url) {
			uni.navigateTo({
				url: url
			})
		},

		headerMoreShow: function() {
			this.headerMoreClass = 'flex-col';
		},
		headerMoreHide: function() {
			this.headerMoreClass = '';
		},

		goOrder: function() {
			window.location = "/module.php?m=b2b_order&a=confirm&shopid=" + shopid;
		},
		goGuest: function() {
			window.location = "/module.php?m=b2b_guest&a=user&shopid=" + shopid;

		},
		goProduct: function(id) {
			window.location = "/module.php?m=b2b_product&a=show&id=" + id + "&shopid=" + shopid

		},

		getPage: function() {
			var that = this;
			$.ajax({
				url: "/module.php?m=b2b_shop&ajax=1&shopid=" + shopid,
				dataType: "json",
				success: function(res) {


					that.shop = res.data.shop;
					if (res.data.isfav == 1) {
						that.shopFavClass = "btn-fav-active";
					}
					that.pageLoad = true;

				}
			});
		},
		setCat: function(catid) {
			this.catid = catid;
			this.per_page = 0;
			this.isFirst = true;
			this.getList();
		},
		setOrder: function(o) {
			this.orderby = o;
			this.isFirst = true;
			this.per_page = 0;
			this.getList();
		},
		getList: function() {
			var that = this;
			if (this.per_page == 0 && !this.isFirst) {
				return false;
			}
			$.ajax({
				url: "/module.php?m=b2b_product&ajax=1&shopid=" + this.shopid,
				data: {
					catid: that.catid,
					type: that.type,
					per_page: that.per_page,
					orderby: this.orderby,
				},
				dataType: "json",
				success: function(res) {
					if (res.error) {
						return false;
					}

					if (that.isFirst) {
						that.catList = res.data.catList;
						that.list = res.data.list;
					} else {
						for (var i in res.data.list) {
							that.list.push(res.data.list[i]);
						}
					}
					that.per_page = res.data.per_page;

				}
			})
		},


		favShopToggle: function(shopid) {
			var that = this;
			$.ajax({
				url: "/index.php?m=fav&a=toggle&ajax=1",
				data: {
					tablename: "mod_b2b_shop",
					objectid: shopid
				},
				dataType: "json",
				success: function(res) {
					if (res.error) {
						skyToast(res.message)
					}

					if (res.data == "add") {
						that.shopFavClass = 'btn-fav-active';
					} else {
						that.shopFavClass = '';
					}
				}
			})
		},

		addCart: function(id, ksid) {
			var that = this;
			var id = id;
			var ksid = ksid == undefined ? 0 : ksid;
			var amount = 1;
			$.ajax({
				url: '/module.php?m=b2b_cart&a=add&ajax=1',
				data: {
					productid: id,
					amount: amount,
					ksid: ksid
				},
				method: 'GET',
				dataType: "json",
				success: function(res) {
					if (res.error == 1000) {
						window.location = "/index.php?m=login"
						return false;
					}
					if (res.error) {
						skyToast(res.message);
						return false;
					}
					that.statCart();
					for (var i = 0; i < that.list.length; i++) {
						if (that.list[i].id == id) {
							if (res.data.amount > 0) {
								that.list[i].incart = 1;
							}
							that.list[i].cart_amount = res.data.amount;
							break;
						}
					}

				}
			})
		},
		plusCart: function(id, amount, ksid) {
			var that = this;
			var id = id;
			var amount = amount;
			var ksid = ksid == undefined ? 0 : ksid;
			amount++;
			$.ajax({
				url: '/module.php?m=b2b_cart&a=add&ajax=1',
				data: {
					productid: id,
					amount: amount,
					ksid: ksid
				},
				method: 'GET',
				dataType: "json",

				success: function(res) {
					if (res.error) {
						skyToast(res.message);
						return false;
					}
					that.statCart();
					for (var i = 0; i < that.list.length; i++) {
						if (that.list[i].id == id) {

							that.list[i].cart_amount = res.data.amount;
							break;
						}
					}


				}
			})
		},
		minusCart: function(id, amount, ksid) {
			var that = this;
			var id = id;
			var amount = amount;
			var ksid = ksid == undefined ? 0 : ksid;
			amount--;
			var isdelete = 0;
			if (amount == 0) {
				isdelete = 1
			}
			$.ajax({
				url: '/module.php?m=b2b_cart&a=add&ajax=1',
				data: {
					productid: id,
					amount: amount,
					ksid: ksid,
					isdelete: isdelete
				},
				method: 'GET',
				dataType: "json",

				success: function(res) {
					if (res.error) {
						skyToast(res.message);
						return false;
					}
					that.statCart();
					for (var i = 0; i < that.list.length; i++) {
						if (that.list[i].id == id) {
							if (res.data.amount == 0) {
								that.list[i].incart = 0;
							}
							that.list[i].cart_amount = res.data.amount;
							break;
						}
					}


				}
			})
		},

		//规格操作
		ksBox: function(id) {
			var that = this;
			$.ajax({
				url: "/module.php?m=b2b_product_ks&ajax=1&productid=" + id,
				dataType: "json",
				success: function(res) {
					that.ksShow = true;
					that.ksproduct = res.data.product;
					that.ksList = res.data.ksList;
					that.ksList2 = res.data.ksList2;
					that.ksid1 = res.data.ksid;
					that.ksid = res.data.ksid;
				}
			})
		},
		ksHide: function() {
			this.ksid = 0;
			this.ksShow = false;
		},
		ks1: function(id) {
			var that = this;
			$.ajax({
				url: "/module.php?m=b2b_product_ks&a=sizeList&ajax=1&id=" + id,
				dataType: "json",
				success: function(res) {
					that.ksid1 = res.data.ksid;
					that.ksid = res.data.ksid;
					that.ksproduct = res.data.product;
					that.ksList2 = res.data.ksList2;
				}
			})
		},
		ks2: function(id) {
			var that = this;
			that.ksid = id;
			$.ajax({
				url: "/module.php?m=b2b_product_ks&a=get&ajax=1&id=" + id,
				dataType: "json",
				success: function(res) {

					that.ksproduct = res.data.product;

				}
			})
		},
		ksAddCart: function(id) {
			var that = this;
			var id = id;
			var ksid = that.ksid;
			var amount = 1;
			$.ajax({
				url: '/module.php?m=b2b_cart&a=add&ajax=1',
				data: {
					productid: id,
					amount: amount,
					ksid: ksid
				},
				method: 'GET',
				dataType: "json",
				success: function(res) {
					if (res.error == 1000) {
						window.location = "/index.php?m=login"
						return false;
					}
					if (res.error) {
						skyToast(res.message);
						return false;
					}
					that.statCart();
					that.ksproduct.incart = 1;
					that.ksproduct.cart_amount = res.data.amount;
				}
			})
		},
		ksPlusCart: function(id, amount) {
			var that = this;
			var id = id;
			var amount = amount;
			var ksid = that.ksid;
			amount++;
			$.ajax({
				url: '/module.php?m=b2b_cart&a=add&ajax=1',
				data: {
					productid: id,
					amount: amount,
					ksid: ksid
				},
				method: 'GET',
				dataType: "json",

				success: function(res) {
					if (res.error) {
						skyToast(res.message);
						return false;
					}
					that.statCart();
					that.ksproduct.cart_amount = res.data.amount;
				}
			})
		},
		ksMinusCart: function(id, amount) {
			var that = this;
			var id = id;
			var amount = amount;
			var ksid = that.ksid;
			amount--;
			var isdelete = 0;
			if (amount == 0) {
				isdelete = 1
			}
			$.ajax({
				url: '/module.php?m=b2b_cart&a=add&ajax=1',
				data: {
					productid: id,
					amount: amount,
					ksid: ksid,
					isdelete: isdelete
				},
				method: 'GET',
				dataType: "json",

				success: function(res) {
					if (res.error) {
						skyToast(res.message);
						return false;
					}
					that.statCart();
					if (res.data.amount == 0) {
						that.ksproduct.cart_amount = 0;
						that.ksproduct.incart = 0;
					} else {
						that.ksproduct.cart_amount = res.data.amount;
					}

				}
			})
		},
		statCart: function() {
			var that = this;
			$.ajax({
				dataType: "json",
				url: "/module.php?m=b2b_cart&a=statshop&ajax=1",
				data: {
					shopid: this.shopid
				},
				success: function(res) {
					if(res.error){
						that.cart = {
							cart_amount: 0,
							cart_total_money: 0,
							cart_total_num: 0,
							express_money: 0
						};
					}else{
						that.cart = {
							cart_amount: res.data.cart_amount,
							cart_total_money: res.data.cart_total_money,
							cart_total_num: res.data.cart_total_num,
							express_money: res.data.express_money
						};
					}
				}
			})
		}

	}
})

$(window).on("scroll",function(e){
	var a=$(window).scrollTop();
	var b=$("#esDot").offset().top;
	if(a>b){
		App.$data.sideClass="sideClass"
		App.$data.tabClass="tabClass";
		App.$data.tabRowClass="tabRowClass";
	}else{
		App.$data.sideClass=""
		App.$data.tabClass="";
		App.$data.tabRowClass="";
	}
})