Vue.component('shop-list', {
	props:{
		a:""
	},
	data:function(){
		return {
			pageLoad:false,
			list:[]
		}
	},
	created:function(){
		this.getPage();
	},
	methods:{
		getPage:function(){
			var that=this;
			$.ajax({
				dataType:"json",	
				url:"/module.php?m=b2b_ymdian&a=shoplist&ajax=1",
				success:function(res){
					that.list=res.data.list;
					that.pageLoad=true;
				}
			})
		},
		goShop:function(shopid){
			var that=this;
			$.ajax({
				dataType:"json",	
				url:"/module.php?m=b2b_ymdian&a=setshop&ajax=1",
				data:{
					shopid:shopid
				},
				success:function(res){
					if(res.error){
						skyToast(res.message)
						return false;
					}else{
						window.location.reload();
					}
					
				}
			})
		}
	},
	template:`
		<div class="bg-white">
			<div v-if="Object.keys(list).length==0" class="emptyData">暂无夜猫店</div>
			<div @click="goShop(item.shopid)" v-for="(item,index) in list" :key="index" class="row-item">
				<div class="row-item-title">{{item.shopname}}</div> 
			</div>
		</div>
	`
});	