var App=new Vue({
	el:"#App",
	data:function(){
		return {
			list:[],
			pageLoad:false,
			type:"",
			per_page:0,
			isFirst:true
		}
	},
	created:function(){
		this.getPage();
	},
	methods:{
		setType:function(type){
			this.type=type;
			this.getPage();
		},
		goBlog:function(id){
			window.location="/module.php?m=sblog_blog&a=show&id="+id;
		},
		getPage:function(){
			var that=this;
			$.ajax({
				url:"/module.php?m=sblog_people&a=list&ajax=1",
				data:{
					type:that.type
				},
				dataType:"json",
				success:function(res){
					that.pageLoad=true;
					that.per_page=res.data.per_page;
					that.list=res.data.list;
				}
			})
		},
		getList:function(){
			var that=this;
			if(this.per_page==0){
				return false;
			}
			$.ajax({
				url:"/module.php?m=sblog_people&a=list&ajax=1",
				data:{
					type:that.type,
					per_page:that.per_page
				},
				dataType:"json",
				success:function(res){
					that.pageLoad=true;
					that.per_page=res.data.per_page;
					for(var i in res.data.list){
						that.list.push(res.data.list[i]);
					}
				}
			})
		},
		goUser:function(userid){
			window.location="/module.php?m=sblog_home&userid="+userid;
		},
		followToggle:function(item){
			var that=this;
			$.ajax({
				url: "/index.php?m=follow&a=Toggle&ajax=1",
				dataType: "json",
				data: {
					t_userid: item.userid
				},
				success: function(res) {
					if(res.error){
						skyToast(res.message)
						return false;
					}
					item.isfollow = res.follow;
			
				}
			});
		}
	}
})