Vue.component("friend-apply",{
	props:{
		touserid:0
	},
	data:function(){
		return {
			isFriend:1,
			friendBoxClass:"",
			applyContent:""
		}
	},
	created:function(){
		this.getPage();
	},
	methods:{
		getPage:function(){
			var that=this;
			$.ajax({
				dataType:"json",
				url:"/index.php?m=friend&a=isfriend&ajax=1",
				data:{
					touserid:this.touserid
				},
				success:function(res){
					if(res.error){
						return false;
					}
					if(res.data==0){
						that.isFriend=0;
					}
				}
			})
		},
		addFriend: function() {
			var that=this;
			$.ajax({
				dataType:"json",
				url:"/index.php?m=friend_apply&a=apply&ajax=1",
				data:{
					touserid:that.touserid,
					description:that.applyContent
				},
				success: function(res) {
					skyToast(res.message)
					that.friendBoxClass="";
				}
			})
		},
	},
	template:`
		<div>
			 
			<div v-if="isFriend==0" @click="friendBoxClass='flex-col'" class="add-friend-btn iconfont icon-friend_add_light"></div> 
			<div class="modal-group" :class="friendBoxClass">
				<div class="modal-mask" @click="friendBoxClass=''"></div>
				<div class="modal" style="margin-top: -50px;">
					<div class="modal-header">
						<div class="modal-title">申请成为好友</div>
						<div class="modal-close icon-close" @click="friendBoxClass=''"></div>
					</div>
					<div class="input-flex">
						 
						<input class="input-flex-text" type="text" v-model="applyContent" placeholder="申请好友说明" />
					</div>
					<div class="btn-row-submit" @click="addFriend()">申请好友</div>
				</div>
			</div>
		</div>
	`
	 
})
document.write(`
<style>
.add-friend-btn {
	position: fixed;
	z-index:20;
	top: 100px;
	right: 3px;
	background-color: #15ABA5;
	color: #fff;
	width: 30px;
	height: 30px;
	line-height: 30px;
	border-radius: 20px;
	text-align: center;
	display: block;
	cursor: pointer;
	}
</style>
		`)