<!DOCTYPE html>
<html>
	<?php echo $this->fetch('head.html'); ?>
	<body>
		<div class="header">
			<div class="header-back"></div>
			<div class="header-title">确认订单</div>
		</div>
		<div class="header-row"></div>
		<div class="main-body" id="app" v-if="pageLoad" style="display:none">
			<form id="orderForm">
			<div class="row-box mgb-5">
				<div class="row-box-hd">
					<div class="flex-1 f16">收货地址</div>
					<a class="row-box-more" href="/index.php?m=user_address&a=add">新增地址</a>
				</div>
			 
				<div @click="changeAddr(item.id)" v-for="(item,index) in pageData.addrList" class="row-item-text">
					<input :checked="item.id==pageData.user_address_id?'checked':''" name="user_address_id" class="user_address_id" :value="item.id" type="radio" />
					{{item.truename}} {{item.telephone}} <br /> {{item.pct_address}}
				</div>
				 
			</div>
			<div class="row-box mgb-5">
				<input type="hidden" name="shopid" :value="pageData.shop.shopid" />
				<div :gourl="'/module.php?m=b2b_guest&a=user&shopid='+pageData.shop.shopid" class="flex">
					<img :src="pageData.shop.imgurl+'.100x100.jpg'" class="wh-40 mgr-5" />
					<div class="flex-1 f16">{{pageData.shop.shopname}}</div>
					<div>
					<div class="btn-round bg-success wh-40  btn-icon icon-service"></div>
					</div>
				</div>
			</div>
			<div class="row-box mgb-5">
				<div class="row-box-hd">
					产品列表
				</div>
				 
				<div v-for="(item,index) in pageData.cartList" :key="index" class="flexlist-item">
					<input type="hidden" name="cartid[]" :value="item.id" />
					<img :src="item.imgurl+'.100x100.jpg'" class="flexlist-img" />
					<div class="flex-1">
						<div class="flexlist-title">{{item.title}}</div>
						<div class="mgb-5 cl2">{{item.ks_title}}</div>
						<div class="flex">
							<div class="flex-1 cl-money">￥{{item.price}}</div>
							<div class="">* {{item.amount}}</div>
						</div>
					</div>
				</div>
				 
			</div>
			<div class="row-box mgb-5">
				<div class="flex flex-wrap flex-ai-center">
					<div>共{{pageData.total_num}}件商品，货价：￥ {{pageData.goods_money}}元 
					邮费：￥ {{pageData.express_money}} 元 </div>
					<div>总价：￥{{pageData.total_money}}</div>
				</div>
			</div>
			<div  v-if="Object.keys(pageData.couponList).length>0"  class="row-box mgb-5">
				<div class="row-box-hd mgb-5">优惠券</div>
				<div class="radioList-group">
					<input type="hidden" class="radioList-value" name="coupon_id" :value="coupon_id" />
					<block v-for="(item,index) in pageData.couponList" :key="index">
					<div :class="{'radioList-item-active':coupon_id==item.id}" class="radioList-item" @click="setCoupon(item.id)" >{{item.title}}</div>
					</block>	
					 
				</div>
				
			</div>
			
			<div class="row-box mgb-5">
				<div class="row-box-hd mgb-10">支付方式</div>

				<div class="paylist">
					<input type="hidden" name="paytype" id="paytype" :value="pageData.paytype">
					 
					<div @click="changePaytype(index)" v-for="(item,index) in pageData.paytypeList" :key="index" class="paylist-item" :v="index" v-bind:class="{'paylist-item-active':index==pageData.paytype}">{{item}}</div>
					 

				</div>
			</div>
			<div class="row-box">
				<textarea name="comment" class="textarea-flex-text h60" placeholder="请输入订单备注"></textarea>
				<div class="btn-row-submit" id="order-confirm-submit">确认购买</div>
			</div>
			</form>
		</div>
		<?php echo $this->fetch('footer.html'); ?>
		<script>
			var shopid="<?php echo $this->_var['shop']['shopid']; ?>";
		</script>
		<script src="<?php echo $this->_var['skins']; ?>b2b_order/confirm.js"></script>
		<script>
			$(function(){
				 
				$(document).on("click","#order-confirm-submit",function(){
					$.post("/module.php?m=b2b_order&a=order&ajax=1",$("#orderForm").serialize(),function(res){
						skyToast(res.message);
						if(!res.error){
							if(res.data.action=='pay'){
								window.location=res.data.payurl;
							}
						}
					},"json");
				})
			})
		</script>
	</body>
</html>
