<!DOCTYPE html>
<html>
	<?php echo $this->fetch('head.html'); ?>
	<body>
		<div class="header">
			<div class="header-back"></div>
			<div class="header-title">订单详情</div>
		</div>
		<div class="header-row"></div>
		 
		<div class="main-body none" :class="'flex-col'" id="App">
			<div class="flex flex-ai-center bg-fff pd-10 mgb-5">
				<div class="cl-status mgr-10">{{order.status_name}}</div>
				<div class="cl2 f12">{{order.ptype_name}}</div>
				<div class="flex-1 "></div>
				
				<div class="cl-money">￥{{order.shop_money}}/￥{{order.money}}</div>
			</div>
			<div class="row-box mgb-5">
				<div class="flex mgb-5">
					<div class="cl2 f12 mgr-5">类型：</div>
					<div class="cl-num f12 mgr-10">{{order.ptype_name}}</div>
					<div class="cl2 f12 mgr-5">页数：</div>
					<div class="cl-num f12 mgr-10">{{order.page_num}}</div>
					 
					<div class="cl2 f12 mgr-5">份数：</div>
					<div class="cl-num f12">{{order.print_num}}</div>
				</div>
				<div class="flex mgb-5">
					<div class="cl2 f12 mgr-5">下单时间：</div>
					<div class="cl3 f12">{{order.createtime}}</div>
				</div> 
				<div v-if="order.bookid>0" class="flex mgb-10">
					<div class="cl3">{{book.title}}</div>
					<div class="flex-1"></div>
					
				</div> 
			</div>
			<div class="row-box mgb-5 flex-center flex">
				<a href="<?php echo $this->_var['order']['fileurl']; ?>" download="<?php echo $this->_var['order']['filename']; ?>" class="btn-small">下载打印资料</a>
			</div>	
			<div class="row-box mgb-5">
				 
				<div class="f14 mgb-5">备注</div>
				<div class="bg-light pd-10 cl3 bd-radius-10">
					{{order.content}}
				</div>
			</div>
		
			<div v-if="order.sendtype==1" class="row-box pdt-0 mgb-5">
				 
				<div class="flex-table">
					<div class="flex-table-label">联系人：</div>
					<div class="flex-table-box text-right">
						{{order.nickname}}
					</div>
				</div>
				<div class="flex-table">
					<div class="flex-table-label">手机：</div>
					<div class="flex-table-box text-right">
						{{order.telephone}}
					</div>
				</div>
				<div class="flex-table">
					<div class="flex-table-label">收货地址：</div>
					<div class="flex-table-box text-right">
						{{order.address}}
					</div>
				</div>
			</div>
			
				
				<div  class="row-box pdt-0">
					<div class="row-box flex flex-center">
						<div :gourl="'moduleshop.php?m=olprint_guest&a=user&userid='+order.userid" class="btn btn-outline-primary ">联系用户</div>
						<div class="flex-1"></div>
						<template v-if="order.status==0">
							<div @click="confirm(order.orderid)" v-if="order.ispay==1" class="btn btn-outline-success mgl-5">确认接单</div>
							<div v-if="order.status==0" class="btn btn-outline-dark mgl-5" @click="cancel(order.orderid)">取消订单</div>
						</template>
						<template v-if="order.status==1">
							<div @click="send(order.orderid)" v-if="order.ispay==1" class="btn btn-outline-success mgl-5">确认发货</div>
						</template>
						
						 
					</div>
				</div>
				 
			 
		</div>
			
			
		 
		<?php echo $this->fetch('footer.html'); ?>
		<script>
			var orderid="<?php echo $this->_var['order']['orderid']; ?>"
		</script>
		<script src="<?php echo $this->_var['skins']; ?>olprint_order/show.js"></script>
	</body>
</html>
