 
var isFirst=true;
var App=new Vue({
	el:"#app",
	data:function(){
		return {
			pageData:{},
			pageLoad:false,
			page:"blog",
			type:"",
			per_page:0
		}
	},
	created:function(){
		var stype=sessionStorage.getItem("sblog-index-type");
		if(stype){
			this.type=stype;
		}
		var spage=sessionStorage.getItem("sblog-index-page");
		if(spage){
			this.page=spage;
		}
		this.getPage();
	},
	methods:{
		setType:function(type){
			this.type=type;
			
			sessionStorage.setItem("sblog-index-type",type);
			if(type=='topic'){
				this.page="topic";
				sessionStorage.setItem("sblog-index-page","topic");
			}else{
				this.page="blog";
				sessionStorage.setItem("sblog-index-page","blog");
				this.getPage();
			}
			
		},
		goBlog:function(id){
			window.location="/module.php?m=sblog_blog&a=show&id="+id;
		},
		goTopic:function(title){
			window.location="/module.php?m=sblog_blog&a=topic&title="+encodeURI(title);
		},
		getPage:function(){
			var that=this;
			$.ajax({
				url:"/module.php?m=sblog_blog&a=list&ajax=1",
				data:{
					type:that.type
				},
				dataType:"json",
				success:function(res){
					that.pageLoad=true;
					that.pageData=res.data;
					that.per_page=res.data.per_page;
					isFirst=false;
				}
			})
		},
		getList:function(){
			var that=this;
			if(!isFirst && that.per_page==0) return false;
			$.ajax({
				url:"/module.php?m=sblog_blog&a=list&ajax=1",
				data:{
					type:that.type,
					per_page:that.per_page
				},
				dataType:"json",
				success:function(res){
					
					that.per_page=res.data.per_page;
					
					if(isFirst){
						isFirst=false;
						that.pageData.list=res.data.list;
					}else{
						var pageData=that.pageData;
						var list=pageData.list;
						for(var i in res.data.list){
							list.push(res.data.list[i]);
						}
						that.pageData.list=list;
					}
					
				}
			})
		}
	}
})