-- MySQL dump 10.13  Distrib 5.6.44, for Win64 (x86_64)
--
-- Host: localhost    Database: test1
-- ------------------------------------------------------
-- Server version	5.6.44-log

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `tb_administrator`
--

DROP TABLE IF EXISTS `tb_administrator`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_administrator` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(60) NOT NULL DEFAULT '' COMMENT '用户名',
  `password` varchar(64) NOT NULL DEFAULT '' COMMENT '密码',
  `salt` varchar(20) DEFAULT NULL COMMENT '盐',
  `gender` tinyint(2) NOT NULL DEFAULT '0' COMMENT '0保密，1男，2女',
  `level` int(11) DEFAULT '0' COMMENT '等级',
  `birthday` int(11) NOT NULL DEFAULT '0' COMMENT '生日',
  `nickname` varchar(50) NOT NULL DEFAULT '' COMMENT '昵称',
  `mobile` varchar(20) NOT NULL DEFAULT '' COMMENT '手机号',
  `email` varchar(100) NOT NULL DEFAULT '' COMMENT '邮箱',
  `avatar` varchar(255) NOT NULL DEFAULT '' COMMENT '头像',
  `is_check` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '0禁用',
  `last_login_ip` varchar(15) NOT NULL DEFAULT '' COMMENT '最后登录ip',
  `last_login_time` int(11) NOT NULL DEFAULT '0' COMMENT '最后登录时间',
  `update_time` int(11) DEFAULT '0',
  `create_time` int(11) NOT NULL DEFAULT '0' COMMENT '注册时间',
  PRIMARY KEY (`id`),
  KEY `user_login` (`username`) USING BTREE,
  KEY `user_nickname` (`nickname`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='用户表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_administrator`
--

LOCK TABLES `tb_administrator` WRITE;
/*!40000 ALTER TABLE `tb_administrator` DISABLE KEYS */;
INSERT INTO `tb_administrator` VALUES (1,'admin','cc7866161bcd916228e424f7bf7c6931','ecWmmMak',0,0,0,'','','','20210421/5bfb3409bb5cc5eb1aff73d095c581b4.png',1,'',0,1618998580,0);
/*!40000 ALTER TABLE `tb_administrator` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_auth_group`
--

DROP TABLE IF EXISTS `tb_auth_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_auth_group` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `module` varchar(10) NOT NULL DEFAULT 'admin' COMMENT '所属模块',
  `level` int(11) NOT NULL COMMENT '角色等级',
  `title` varchar(200) NOT NULL COMMENT '用户组中文名称',
  `status` tinyint(1) NOT NULL COMMENT '状态：为1正常，为0禁用',
  `rules` text COMMENT '用户组拥有的规则id， 多个规则","隔开',
  `notation` varchar(100) DEFAULT NULL COMMENT '组别描述',
  `pic` varchar(200) DEFAULT NULL COMMENT '角色图标',
  `recom` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否推荐首页显示',
  `create_time` int(10) NOT NULL COMMENT '创建时间',
  `update_time` int(10) NOT NULL COMMENT '编辑时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_auth_group`
--

LOCK TABLES `tb_auth_group` WRITE;
/*!40000 ALTER TABLE `tb_auth_group` DISABLE KEYS */;
INSERT INTO `tb_auth_group` VALUES (1,'admin',1090,'超级管理员',1,'1,2,3,4,5,6,7,8,9,10,23,24,25,26,11,12,15,14,16,17,18,19,20,21,22','我能干任何事','#dd4b39',0,1502780231,1543839266),(2,'admin',1,'后台浏览',1,'1,2,3,4,5,10,23,24,15,14,16,19','只能查看列表','#f39c12',0,1502784113,1534808239),(3,'admin',0,'雇主',1,NULL,'',NULL,0,1536592696,0);
/*!40000 ALTER TABLE `tb_auth_group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_auth_group_access`
--

DROP TABLE IF EXISTS `tb_auth_group_access`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_auth_group_access` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `uid` int(11) unsigned NOT NULL COMMENT '用户id',
  `group_id` int(11) unsigned NOT NULL COMMENT '用户组id',
  `create_time` int(10) NOT NULL COMMENT '创建时间',
  `update_time` int(10) NOT NULL COMMENT '编辑时间',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`) USING BTREE,
  KEY `group_id` (`group_id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_auth_group_access`
--

LOCK TABLES `tb_auth_group_access` WRITE;
/*!40000 ALTER TABLE `tb_auth_group_access` DISABLE KEYS */;
INSERT INTO `tb_auth_group_access` VALUES (1,1,1,0,0),(2,5,1,0,0),(3,5,2,0,0),(4,5,3,0,0);
/*!40000 ALTER TABLE `tb_auth_group_access` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_auth_rule`
--

DROP TABLE IF EXISTS `tb_auth_rule`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_auth_rule` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `pid` int(11) unsigned NOT NULL COMMENT '父id',
  `module` varchar(10) NOT NULL DEFAULT 'admin' COMMENT '权限节点所属模块',
  `level` tinyint(1) NOT NULL COMMENT '1-项目;2-模块;3-操作',
  `name` varchar(80) NOT NULL COMMENT '规则唯一标识',
  `title` varchar(20) NOT NULL COMMENT '规则中文名称',
  `type` tinyint(1) NOT NULL DEFAULT '1',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态：为1正常，为0禁用',
  `ismenu` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否导航',
  `condition` varchar(200) DEFAULT NULL COMMENT '规则表达式，为空表示存在就验证，不为空表示按照条件验证',
  `icon` varchar(50) DEFAULT NULL COMMENT '节点图标',
  `sorts` mediumint(8) DEFAULT '50' COMMENT '排序',
  `create_time` int(10) NOT NULL COMMENT '创建时间',
  `update_time` int(10) NOT NULL COMMENT '编辑时间',
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`) USING BTREE,
  KEY `module` (`module`) USING BTREE,
  KEY `level` (`level`) USING BTREE,
  KEY `name` (`name`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_auth_rule`
--

LOCK TABLES `tb_auth_rule` WRITE;
/*!40000 ALTER TABLE `tb_auth_rule` DISABLE KEYS */;
INSERT INTO `tb_auth_rule` VALUES (1,0,'admin',1,'Index/index','后台首页',1,1,1,NULL,'fa fa-home',1000,1532168003,1532169104),(2,0,'admin',1,'index','系统设置',1,1,1,NULL,'fa fa-dashboard',1200,1532168495,1532169112),(3,2,'admin',2,'index/index','网站设置',1,1,1,NULL,'fa fa-circle-o',1,1532168566,1532169121),(4,2,'admin',2,'index/profile','修改密码',1,1,1,NULL,'fa fa-circle-o',2,1532169226,1618998681),(5,2,'admin',2,'index/uploads','文件管理',1,1,1,NULL,'fa fa-circle-o',3,1532169267,0),(6,0,'admin',1,'auth','权限管理',1,1,1,NULL,'fa fa-users',1300,1532177458,0),(7,6,'admin',2,'auth_admin/index','管理员列表',1,1,1,NULL,'fa fa-user-o',1,1532177508,1532189126),(8,6,'admin',2,'auth_group/index','角色列表',1,1,1,NULL,'fa fa-vcard',2,1532177534,1532188696),(9,6,'admin',2,'auth_rule/index','菜单规则列表',1,1,1,NULL,'fa fa-user-circle',3,1532177559,1532188705),(10,0,'admin',1,'member','会员管理',1,1,1,NULL,'fa fa-users',1400,1532177701,1532241958),(11,0,'admin',1,'invitation/index','邀请管理',1,1,1,NULL,'fa fa-users',1500,1532177768,0),(12,0,'admin',1,'task','任务管理',1,1,1,NULL,'fa fa-dashboard',1600,1532177915,0),(14,12,'admin',2,'taskjoin/index','任务数据',1,1,1,NULL,'fa fa-circle-o',3,1532177961,0),(15,12,'admin',2,'task/index','任务列表',1,1,1,NULL,'fa fa-circle-o',2,1532178005,0),(16,12,'admin',2,'taskcategory/index','分类列表',1,1,1,NULL,'fa fa-circle-o',4,1532178030,0),(17,0,'admin',1,'channel/index','渠道管理',1,1,1,NULL,'fa fa-dashboard',1700,1532178159,0),(18,0,'admin',1,'recharge/index','充值管理',1,1,1,NULL,'fa fa-dashboard',1800,1532178193,0),(19,0,'admin',1,'withdraw/index','提现管理',1,1,1,NULL,'fa fa-dashboard',1900,1532178216,0),(20,0,'admin',1,'notice/index','公告管理',1,1,1,NULL,'fa fa-home',2000,1532178266,0),(21,0,'admin',1,'banner/index','轮播图管理',0,1,0,NULL,'fa fa-dashboard',2100,1532178294,0),(22,0,'admin',1,'feedback/index','反馈管理',1,1,1,NULL,'fa fa-dashboard',2200,1532178317,0),(23,10,'admin',2,'member/index','会员列表',1,1,1,NULL,'fa fa-circle-o',1,1532241379,0),(24,10,'admin',2,'member/charge','充值记录',1,1,1,NULL,'fa fa-circle-o',2,1532241433,0),(25,10,'admin',2,'credit_record/index','资金流水',1,1,1,NULL,'fa fa-circle-o',50,1536659743,0),(26,10,'admin',2,'member/fenzu','会员级别',1,1,1,NULL,'fa fa-circle-o',51,1536659743,0);
/*!40000 ALTER TABLE `tb_auth_rule` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_banner`
--

DROP TABLE IF EXISTS `tb_banner`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_banner` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` varchar(80) NOT NULL DEFAULT '',
  `thumb` varchar(255) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `order_by` int(10) unsigned NOT NULL DEFAULT '0',
  `is_display` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `order_by` (`is_display`,`order_by`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='轮播图';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_banner`
--

LOCK TABLES `tb_banner` WRITE;
/*!40000 ALTER TABLE `tb_banner` DISABLE KEYS */;
INSERT INTO `tb_banner` VALUES (1,'1','20210421/520faf2a77e4350d0030a6e83e31573c.png','http://cps.iun.ink',3,1,1541966534,1524738575);
/*!40000 ALTER TABLE `tb_banner` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_channel`
--

DROP TABLE IF EXISTS `tb_channel`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_channel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT NULL COMMENT '渠道名',
  `order_by` int(11) DEFAULT '0',
  `is_display` tinyint(3) DEFAULT '0' COMMENT '1显示',
  `update_time` int(11) DEFAULT '0',
  `create_time` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_channel`
--

LOCK TABLES `tb_channel` WRITE;
/*!40000 ALTER TABLE `tb_channel` DISABLE KEYS */;
INSERT INTO `tb_channel` VALUES (1,'QQ',0,1,0,1520213049);
/*!40000 ALTER TABLE `tb_channel` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_charge`
--

DROP TABLE IF EXISTS `tb_charge`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_charge` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '操作管理员ID，0代表系统',
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `type` varchar(10) CHARACTER SET utf8 NOT NULL DEFAULT '' COMMENT 'credit1积分，credit2余额',
  `num` decimal(10,2) DEFAULT '0.00' COMMENT '充值数量，负数代表减少',
  `remark` varchar(200) CHARACTER SET utf8 NOT NULL,
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_charge`
--

LOCK TABLES `tb_charge` WRITE;
/*!40000 ALTER TABLE `tb_charge` DISABLE KEYS */;
/*!40000 ALTER TABLE `tb_charge` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_code`
--

DROP TABLE IF EXISTS `tb_code`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_code` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mobile` varchar(11) CHARACTER SET utf8 NOT NULL,
  `email` varchar(20) DEFAULT NULL COMMENT '邮箱',
  `code` varchar(20) CHARACTER SET utf8 DEFAULT NULL COMMENT '验证码',
  `status` tinyint(3) DEFAULT '0' COMMENT '1已使用',
  `ip` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT 'IP地址',
  `create_time` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_code`
--

LOCK TABLES `tb_code` WRITE;
/*!40000 ALTER TABLE `tb_code` DISABLE KEYS */;
/*!40000 ALTER TABLE `tb_code` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_config`
--

DROP TABLE IF EXISTS `tb_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `setting` text COMMENT '设置选项，序列化存储',
  `update_time` int(11) DEFAULT '0' COMMENT '修改时间',
  `create_time` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='任务配置';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_config`
--

LOCK TABLES `tb_config` WRITE;
/*!40000 ALTER TABLE `tb_config` DISABLE KEYS */;
INSERT INTO `tb_config` VALUES (1,'a:34:{s:5:\"title\";s:15:\"艾丽微电商\";s:4:\"logo\";s:45:\"20210421/f2b04d2f64abddfe24a81203cd86fd25.gif\";s:2:\"qq\";s:0:\"\";s:6:\"wechat\";s:10:\"1225251313\";s:9:\"copyright\";s:20:\"京ICP备-2020005866\";s:10:\"baidu_stat\";s:0:\"\";s:10:\"baidu_chat\";s:0:\"\";s:9:\"seo_title\";s:54:\"玩赚部落，一个发朋友圈都能赚钱的APP！\";s:12:\"seo_keywords\";s:12:\"玩赚部落\";s:15:\"seo_description\";s:90:\"玩赚部落是一个多内容任务分发平台，每天都会更新大量高额任务！\";s:9:\"SMTP_HOST\";s:0:\"\";s:9:\"SMTP_PORT\";s:0:\"\";s:9:\"SMTP_USER\";s:0:\"\";s:9:\"SMTP_PASS\";s:0:\"\";s:10:\"FROM_EMAIL\";s:0:\"\";s:9:\"FROM_NAME\";s:6:\"系统\";s:10:\"TEST_EMAIL\";s:0:\"\";s:27:\"invitation_first_task_award\";s:1:\"0\";s:26:\"invitation_withdraw_rebate\";s:1:\"0\";s:17:\"invitation_rebate\";s:2:\"20\";s:17:\"sign_give_credit1\";s:3:\"100\";s:18:\"sign_continue_give\";s:1:\"2\";s:12:\"withdraw_min\";s:2:\"10\";s:12:\"withdraw_fee\";s:2:\"10\";s:3:\"fee\";s:2:\"10\";s:6:\"period\";s:9:\"0#6#12#24\";s:5:\"speed\";s:1:\"6\";s:10:\"push_check\";s:1:\"0\";s:7:\"top_fee\";s:1:\"5\";s:12:\"top_max_hour\";s:1:\"5\";s:24:\"receive_order_limit_time\";s:2:\"30\";s:22:\"check_order_limit_time\";s:1:\"2\";s:16:\"join_task_detail\";s:1475:\"<h5>1、点击下方任务中心</h5><p><img src=\"/uploads/20210421/1619000881126414.png\" title=\"1619000881126414.png\" alt=\"QQ截图20210421182754.png\"/></p><p><br/></p><h5>2.根据自己服务级别选择任务种类</h5><p><img src=\"/uploads/20210421/1619000845107519.png\" title=\"1619000845107519.png\" alt=\"QQ截图20210421182535.png\"/></p><h5>2、浏览完任务需求后点击 “抢单” 按键，若跳转到做任务界面则抢单成功，如果失败则是目前单数已满。请在抢单后的两小时内完成任务，逾期则自动解锁。<br/></h5><p><br/></p><h5>3、跳转到做任务页面，在文本框写上任务需要的文字内容，如果任务有要求的话，还需要上传相应的图片，一切都弄好之后点击右上角的发布，静待文件上传成功后自动跳转。</h5><p><img title=\"1517191394899149.png\" alt=\"help3.png\" src=\"/ueditor/php/upload/image/20180129/1517191394899149.png\"/></p><h5>4、如果抢单后发现自己不符合任务需求，则退回任务详情页，点击解锁即可，如果不点击而又不在两小时内上传任务相关内容的话，系统将会自动解锁。</h5><p><img title=\"1517191401639366.png\" alt=\"help4.png\" src=\"/ueditor/php/upload/image/20180129/1517191401639366.png\"/></p><h5>5、做过的、正在做的任务可以在个人中心的参与中查看。</h5><p><img title=\"1517191411866530.png\" alt=\"help5.png\" src=\"/ueditor/php/upload/image/20180129/1517191411866530.png\"/></p>\";s:16:\"push_task_detail\";s:1599:\"<h5>1、点击页面下方发布按键。</h5><p><img title=\"1517191633304320.png\" alt=\"help6.png\" src=\"/ueditor/php/upload/image/20180129/1517191633304320.png\"/></p><h5>2、根据发布任务的要求填写相关内容。</h5><p><img title=\"1517191637329752.png\" alt=\"help7.png\" src=\"/ueditor/php/upload/image/20180129/1517191637329752.png\"/></p><h5>3、点击右上角的发布。如果页面跳转则发布成功，若发布失败，则需根据弹出的错误信息进行相应的修改。</h5><p><img title=\"1517191642115923.png\" alt=\"help8.png\" src=\"/ueditor/php/upload/image/20180129/1517191642115923.png\"/></p><h5>4、发布过的任务可以在“发布”中查看。</h5><p><img title=\"1517191647505020.png\" alt=\"help9.png\" src=\"/ueditor/php/upload/image/20180129/1517191647505020.png\"/></p><h5>5、点击在进行中的任务。</h5><p><img title=\"1517191652117756.png\" alt=\"help10.png\" src=\"/ueditor/php/upload/image/20180129/1517191652117756.png\"/></p><h5>6、在发布任务的任务详情里顶部的审核按键或者直接在底部皆可审核任务。</h5><p><img title=\"1517191660163219.png\" alt=\"help11.png\" src=\"/ueditor/php/upload/image/20180129/1517191660163219.png\"/></p><h5>7、如果审核不通过的话要写明不通过的理由，方便推手进行修改。</h5><p><img title=\"1517191670623745.png\" alt=\"help12.png\" src=\"/ueditor/php/upload/image/20180129/1517191670623745.png\"/></p><h5>8、在任务详情里还可以进行额外的操作。</h5><p><img title=\"1517191675786750.png\" alt=\"help13.png\" src=\"/ueditor/php/upload/image/20180129/1517191675786750.png\"/></p>\";}',1619002177,1516952068);
/*!40000 ALTER TABLE `tb_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_credit_record`
--

DROP TABLE IF EXISTS `tb_credit_record`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_credit_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `type` enum('credit1','credit2') NOT NULL COMMENT 'credit1积分，credit2余额',
  `num` decimal(10,2) DEFAULT '0.00' COMMENT '充值数量，负数代表减少',
  `title` varchar(30) NOT NULL DEFAULT '' COMMENT '标题',
  `remark` varchar(200) NOT NULL,
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`) USING BTREE,
  KEY `uid_2` (`uid`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_credit_record`
--

LOCK TABLES `tb_credit_record` WRITE;
/*!40000 ALTER TABLE `tb_credit_record` DISABLE KEYS */;
INSERT INTO `tb_credit_record` VALUES (1,1,'credit1',300.00,'签到','签到成功，获得300积分。',1618995545),(2,1,'credit1',2.00,'签到','您已连续1天签到，额外获得2积分。',1618995545),(3,1,'credit1',-100.00,'活动抽奖','使用积分抽奖，扣除100积分。',1618996498),(4,1,'credit1',-100.00,'活动抽奖','使用积分抽奖，扣除100积分。',1618996506),(5,1,'credit1',-100.00,'活动抽奖','使用积分抽奖，扣除100积分。',1618996511);
/*!40000 ALTER TABLE `tb_credit_record` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_feedback`
--

DROP TABLE IF EXISTS `tb_feedback`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_feedback` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '反馈id',
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT '用户id',
  `username` varchar(50) NOT NULL DEFAULT '' COMMENT '昵称',
  `content` varchar(500) NOT NULL DEFAULT '' COMMENT '反馈内容',
  `ip` varchar(20) NOT NULL DEFAULT '0' COMMENT 'ip地址',
  `ip_addr` varchar(200) NOT NULL DEFAULT '' COMMENT '地理位置',
  `parent_id` int(11) NOT NULL DEFAULT '0' COMMENT '上级id',
  `is_reply` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否回复',
  `son` int(11) NOT NULL DEFAULT '0' COMMENT '子反馈数',
  `create_time` int(11) unsigned NOT NULL DEFAULT '0',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`,`parent_id`),
  KEY `update_time` (`update_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='反馈表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_feedback`
--

LOCK TABLES `tb_feedback` WRITE;
/*!40000 ALTER TABLE `tb_feedback` DISABLE KEYS */;
/*!40000 ALTER TABLE `tb_feedback` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_follows`
--

DROP TABLE IF EXISTS `tb_follows`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_follows` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) DEFAULT '0',
  `follow_uid` int(11) DEFAULT '0',
  `update_time` int(11) DEFAULT '0',
  `create_time` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_follows`
--

LOCK TABLES `tb_follows` WRITE;
/*!40000 ALTER TABLE `tb_follows` DISABLE KEYS */;
/*!40000 ALTER TABLE `tb_follows` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_invitation_code`
--

DROP TABLE IF EXISTS `tb_invitation_code`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_invitation_code` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='邀请码表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_invitation_code`
--

LOCK TABLES `tb_invitation_code` WRITE;
/*!40000 ALTER TABLE `tb_invitation_code` DISABLE KEYS */;
/*!40000 ALTER TABLE `tb_invitation_code` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_invitation_log`
--

DROP TABLE IF EXISTS `tb_invitation_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_invitation_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `username` varchar(50) NOT NULL DEFAULT '' COMMENT '用户名',
  `invite_uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '邀请用户id',
  `invite_username` varchar(50) NOT NULL DEFAULT '' COMMENT '邀请用户名',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`),
  KEY `invite_uid` (`invite_uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='邀请记录表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_invitation_log`
--

LOCK TABLES `tb_invitation_log` WRITE;
/*!40000 ALTER TABLE `tb_invitation_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `tb_invitation_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_invitation_rebate_record`
--

DROP TABLE IF EXISTS `tb_invitation_rebate_record`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_invitation_rebate_record` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `num` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '充值数量，负数代表减少',
  `task_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '任务id',
  `remark` varchar(200) NOT NULL DEFAULT '',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_invitation_rebate_record`
--

LOCK TABLES `tb_invitation_rebate_record` WRITE;
/*!40000 ALTER TABLE `tb_invitation_rebate_record` DISABLE KEYS */;
/*!40000 ALTER TABLE `tb_invitation_rebate_record` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_lock`
--

DROP TABLE IF EXISTS `tb_lock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_lock` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(20) DEFAULT NULL COMMENT '网站名称',
  `domain` varchar(255) DEFAULT NULL COMMENT '授权域名',
  `is_forever` tinyint(3) DEFAULT '0' COMMENT '1代表永久授权',
  `to_date` int(11) DEFAULT NULL COMMENT '到期时间戳',
  `update_time` int(11) DEFAULT NULL,
  `create_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_lock`
--

LOCK TABLES `tb_lock` WRITE;
/*!40000 ALTER TABLE `tb_lock` DISABLE KEYS */;
INSERT INTO `tb_lock` VALUES (2,'测试域名','cps.iun.ink',1,1525151700,1522850473,1522646138),(4,'萌手赚网','cps.iun.ink',1,1522981620,NULL,1522981699),(5,'测试域名','cps.iun.ink',1,1525151700,1522850473,1522646138);
/*!40000 ALTER TABLE `tb_lock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_member`
--

DROP TABLE IF EXISTS `tb_member`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_member` (
  `uid` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(20) DEFAULT NULL COMMENT '用户名',
  `gender` tinyint(3) DEFAULT '0',
  `parent_uid` int(11) DEFAULT '0' COMMENT '上级ID',
  `experience_value` decimal(10,2) DEFAULT '0.00' COMMENT '经验值',
  `level` int(11) DEFAULT '1' COMMENT '等级',
  `invitation_code` varchar(20) DEFAULT NULL COMMENT '邀请码/手机号',
  `oath_type` tinyint(3) DEFAULT '0' COMMENT '0默认，1微信，2QQ，3微博，4支付宝等',
  `openid` varchar(255) DEFAULT NULL COMMENT '第三方openid',
  `credit1` decimal(10,2) DEFAULT '0.00' COMMENT '积分',
  `credit2` decimal(10,2) DEFAULT '0.00' COMMENT '余额',
  `password` varchar(50) DEFAULT NULL COMMENT '密码',
  `salt` varchar(8) DEFAULT NULL COMMENT '盐',
  `avatar` varchar(255) DEFAULT NULL COMMENT '头像',
  `email` varchar(50) DEFAULT NULL COMMENT '邮箱',
  `is_bind_email` tinyint(3) DEFAULT '0' COMMENT '1已绑定',
  `alipay_account` varchar(50) DEFAULT NULL COMMENT '支付宝账号',
  `alipay_realname` varchar(50) DEFAULT NULL COMMENT '支付宝真实姓名',
  `is_bind_alipay` tinyint(1) DEFAULT '0' COMMENT '1已绑定支付宝',
  `mobile` varchar(20) DEFAULT NULL COMMENT '手机',
  `is_bind_mobile` tinyint(3) DEFAULT '0' COMMENT '1绑定手机',
  `channel_id` int(11) DEFAULT '0' COMMENT '渠道登记',
  `channel_name` varchar(50) DEFAULT NULL COMMENT '渠道名称',
  `channel_desc` varchar(500) DEFAULT NULL COMMENT '渠道描述',
  `is_bind_channel` tinyint(3) DEFAULT '0' COMMENT '1已登记渠道',
  `is_check` tinyint(3) DEFAULT '1' COMMENT '0禁用',
  `is_del` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '删除标识',
  `invite_total` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '邀请总人数',
  `invite_rebate` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '邀请总返利收益',
  `sign` varchar(30) NOT NULL DEFAULT '' COMMENT '随机签名',
  `sign_continue` int(10) unsigned DEFAULT '0' COMMENT '连续签到天数',
  `update_time` int(11) DEFAULT '0',
  `create_time` int(11) DEFAULT '0',
  `img` varchar(100) CHARACTER SET utf8 DEFAULT NULL,
  PRIMARY KEY (`uid`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='会员表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_member`
--

LOCK TABLES `tb_member` WRITE;
/*!40000 ALTER TABLE `tb_member` DISABLE KEYS */;
INSERT INTO `tb_member` VALUES (1,'13252066626',0,0,0.00,1,NULL,0,NULL,2.00,0.00,'3a4bb2ea374c7816b95b364957f64b0c','O2pzbkQN',NULL,'',0,NULL,NULL,0,NULL,0,0,NULL,NULL,0,1,0,0,0.00,'',1,1618996511,1618995029,'tp161899571026.png');
/*!40000 ALTER TABLE `tb_member` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_member_level`
--

DROP TABLE IF EXISTS `tb_member_level`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_member_level` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `level` int(11) NOT NULL,
  `title` varchar(100) NOT NULL,
  `have_money` decimal(20,2) NOT NULL,
  `is_effect` int(11) NOT NULL,
  `repay_1` decimal(20,2) NOT NULL,
  `repay_2` decimal(20,2) NOT NULL,
  `repay_3` decimal(20,2) NOT NULL,
  `butie` decimal(20,2) NOT NULL,
  `add_time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_member_level`
--

LOCK TABLES `tb_member_level` WRITE;
/*!40000 ALTER TABLE `tb_member_level` DISABLE KEYS */;
INSERT INTO `tb_member_level` VALUES (1,2,'VIP会员',99.00,1,10.00,20.00,30.00,2.00,0),(2,3,'高级VIP会员',199.00,1,20.00,30.00,40.00,3.00,0),(3,4,'特级VIP会员',299.00,1,30.00,40.00,50.00,4.00,0);
/*!40000 ALTER TABLE `tb_member_level` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_notice`
--

DROP TABLE IF EXISTS `tb_notice`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_notice` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `detail` text,
  `order_by` int(11) DEFAULT '0',
  `is_display` tinyint(3) DEFAULT '1',
  `update_time` int(11) DEFAULT '0',
  `create_time` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='公告';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_notice`
--

LOCK TABLES `tb_notice` WRITE;
/*!40000 ALTER TABLE `tb_notice` DISABLE KEYS */;
INSERT INTO `tb_notice` VALUES (1,'如何赚佣01','<p>1、只要要押金99元。每天发圈得8元，把你的WX朋友圈打造成自动提款机。</p><p>2、分享好友成为会员可得奖励，一级8元，二级还有8元。</p><p>3、一级会员发圈你可以得4元/每天，分享10个就40元/每天，100个就400元/每天，分享越多，收益越多！</p><p>4、二级会员发圈你还可以得2元/每天，分享10个就20元/天，100个就200元/每天</p><p>5、会员可以投放广告，投放成功可得30%的广告奖励！收入日结，提现秒到！</p><p>6、七天内完成一级五十人，二级三百人，公司直接给予奖励现金一万元！现金一万元！等你来拿！</p><p>7、提现十分钟到账，目前没有手续费，满100可提！</p><p>例如</p><p>例如：一代10人，二代10人+自己每天8元，一个月收益2040元</p><p>例如：一代20人，二代20人+自己每天8元，一个月收益3840元</p><p>二代发圈按三三复制</p><p>50*3=150人150*2=300</p><p>收益日结保底200+300=500元</p><p>一个月保底收15000元</p><p>另外满50名更新会员平台额外奖励团队每添加一人2</p><p>二、非VIP会员会有哪些收益吗？</p><p>VIP会员收益：假如您是非VIP会员，你的下级成为VIP会员，你账上有收益，但是不能提现。只有成为VIP会员后，才能提现。</p><p>发圈收益：假如您是非VIP会员，你的下级成为VIP会员，他们做任务，你账单上没有收益。只有成为VIP会员后，做任务才有收益。</p><p>三、VIP会员有哪些收益？</p><p>发圈收益：VIP会员可以发任务到朋友圈取得收益，每天完成任务可以取得8元/天，同时可以取得下级发圈收益的提成：一级4元，二级2元</p><p>VIP会员收益：VIP会员可以取得下级成为VIP会员的收益，一级8元，二级8元</p><p>四、非VIP会员发任务到朋友圈有收益吗？</p><p>非VIP会员，可以发任务到朋友圈，但是无法提交任务，所以没有收益</p><p>五、如何发朋友圈任务？</p><p>1）进入平台任务中心，里面领取任务，每天领取两条任务</p><p>2）复制文案内容，保存推广图片到自己相册，而后按要求，发朋友圈保留两个小时。</p><p>3）提交任务：而后截图朋友圈的任务，在任务中心提交任务就可。</p><p><br/></p>',0,1,1580741151,1550912337);
/*!40000 ALTER TABLE `tb_notice` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_recharge`
--

DROP TABLE IF EXISTS `tb_recharge`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_recharge` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) DEFAULT '0',
  `username` varchar(20) NOT NULL DEFAULT '' COMMENT '用户名',
  `credit2` decimal(10,2) DEFAULT '0.00' COMMENT '充值金额',
  `pay_method` tinyint(3) DEFAULT '0' COMMENT '0银行卡，1支付宝，2微信',
  `account` varchar(50) DEFAULT NULL COMMENT '账号',
  `realname` varchar(20) DEFAULT NULL COMMENT '真实姓名',
  `mobile` varchar(20) DEFAULT NULL COMMENT '手机号',
  `pay_time` varchar(50) DEFAULT NULL COMMENT '充值时间',
  `thumbs` varchar(255) NOT NULL DEFAULT '' COMMENT '充值截图',
  `status` tinyint(3) DEFAULT '0' COMMENT '0待审核，1已发放，-1审核未通过',
  `note` varchar(255) DEFAULT NULL COMMENT '备注信息',
  `create_time` int(11) DEFAULT '0',
  `update_time` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_recharge`
--

LOCK TABLES `tb_recharge` WRITE;
/*!40000 ALTER TABLE `tb_recharge` DISABLE KEYS */;
/*!40000 ALTER TABLE `tb_recharge` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_sign`
--

DROP TABLE IF EXISTS `tb_sign`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_sign` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) DEFAULT '0',
  `credit1` decimal(10,2) DEFAULT '0.00' COMMENT '赠送的积分',
  `create_time` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `uid_create_time` (`uid`,`create_time`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='签到表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_sign`
--

LOCK TABLES `tb_sign` WRITE;
/*!40000 ALTER TABLE `tb_sign` DISABLE KEYS */;
INSERT INTO `tb_sign` VALUES (1,1,300.00,1618995545);
/*!40000 ALTER TABLE `tb_sign` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_task`
--

DROP TABLE IF EXISTS `tb_task`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) DEFAULT '0' COMMENT '会员ID',
  `title` varchar(255) DEFAULT NULL COMMENT '标题',
  `detail` text,
  `category_id` int(11) DEFAULT '0' COMMENT '类别ID',
  `start_time` int(11) DEFAULT '0' COMMENT '开始时间',
  `end_time` int(11) DEFAULT '0' COMMENT '结束时间',
  `ticket_num` int(11) DEFAULT '0' COMMENT '票数',
  `join_num` int(11) DEFAULT '0' COMMENT '已加入的票数',
  `unit_price` decimal(10,2) unsigned DEFAULT '0.00' COMMENT '任务单价',
  `give_credit1` int(10) unsigned DEFAULT '0' COMMENT '奖励积分',
  `give_credit2` decimal(10,2) DEFAULT '0.00' COMMENT '奖励金额',
  `fee` decimal(10,2) DEFAULT '0.00' COMMENT '手续费',
  `amount` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '任务总金额',
  `top_hour` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '置顶小时',
  `top_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '置顶时间',
  `top_fee` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '置顶费用',
  `top_end_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '置顶结束时间',
  `check_period` int(11) DEFAULT '0' COMMENT '审核周期，小时',
  `check_period_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '审核周期时间',
  `about_url` varchar(255) DEFAULT NULL COMMENT '相关地址',
  `check_text_content` varchar(255) NOT NULL DEFAULT '' COMMENT '文字验证',
  `remarks` varchar(255) NOT NULL DEFAULT '' COMMENT '备注',
  `is_screenshot` tinyint(3) DEFAULT '0' COMMENT '1需要截图',
  `is_ip_restriction` tinyint(3) DEFAULT '0' COMMENT '1限制IP',
  `province` varchar(20) DEFAULT NULL COMMENT '限制省份',
  `rate` tinyint(3) DEFAULT '0' COMMENT '0默认，1仅限一次，2每天一次，3定时任务',
  `interval_hour` int(11) DEFAULT '0' COMMENT '间隔时间',
  `is_limit_speed` tinyint(3) DEFAULT '0' COMMENT '1限速',
  `limit_ticket_num` int(11) DEFAULT '0' COMMENT '每5分钟限制票数',
  `thumbs` text COMMENT '任务多图',
  `order_by` int(11) DEFAULT '0',
  `is_display` tinyint(3) DEFAULT '1' COMMENT '1显示',
  `out_stock_flag` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '下架,0,未下架,1,下架 ',
  `out_stock_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '下架时间',
  `is_complete` tinyint(3) DEFAULT '0' COMMENT '1已完成',
  `complete_time` int(11) DEFAULT '0' COMMENT '完成时间',
  `admin_id` int(10) unsigned NOT NULL DEFAULT '0',
  `audit_remarks` varchar(255) NOT NULL DEFAULT '' COMMENT '审核备注',
  `update_time` int(11) DEFAULT '0',
  `create_time` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='任务表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_task`
--

LOCK TABLES `tb_task` WRITE;
/*!40000 ALTER TABLE `tb_task` DISABLE KEYS */;
/*!40000 ALTER TABLE `tb_task` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_task_category`
--

DROP TABLE IF EXISTS `tb_task_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_task_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(20) DEFAULT NULL COMMENT '分类名称',
  `only_level` int(11) NOT NULL DEFAULT '1',
  `thumb` varchar(255) DEFAULT NULL COMMENT '分类图片',
  `min_give_credit1` decimal(10,2) DEFAULT '0.00' COMMENT '最小奖励积分',
  `min_give_credit2` decimal(10,2) DEFAULT '0.00' COMMENT '最小奖励金额',
  `order_by` int(11) DEFAULT '0' COMMENT '数字越大越靠前',
  `is_display` tinyint(3) DEFAULT '1' COMMENT '1显示',
  `update_time` int(11) DEFAULT '0',
  `create_time` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='分类';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_task_category`
--

LOCK TABLES `tb_task_category` WRITE;
/*!40000 ALTER TABLE `tb_task_category` DISABLE KEYS */;
INSERT INTO `tb_task_category` VALUES (1,'普通任务',1,'20210421/db276457265271d2a50963b92c2bbe5d.png',0.00,1.00,3,1,1619000806,1516799416),(2,'VIP任务区',2,'20210421/4b9b4f752ef0579dc077e819ddb46069.png',0.00,2.00,2,1,1619000791,1516799441),(3,'高级VIP任务',3,'20210421/5bd597094a3a379ca88ea5d064b04343.png',0.00,4.00,1,1,1619000770,1516799454),(4,'特级VIP任务',4,'20210421/d0c0a97fcdc15de18b9a1eb42f72005a.png',0.00,20.00,0,1,1619000764,1516799487);
/*!40000 ALTER TABLE `tb_task_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_task_join`
--

DROP TABLE IF EXISTS `tb_task_join`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_task_join` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '接单id',
  `task_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '任务id',
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '用户ID',
  `thumbs` text COMMENT '审核图样',
  `check_text_content` varchar(255) NOT NULL DEFAULT '' COMMENT '文字确认',
  `communication` varchar(255) NOT NULL DEFAULT '' COMMENT '信息交流',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '接单状态',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '接单时间',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0',
  `audit_time` int(10) unsigned NOT NULL DEFAULT '0',
  `delflag` int(10) unsigned NOT NULL DEFAULT '1' COMMENT '删除标识  1.未删除 2.假删除',
  PRIMARY KEY (`id`),
  KEY `task_id` (`task_id`),
  KEY `uid` (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='任务接单表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_task_join`
--

LOCK TABLES `tb_task_join` WRITE;
/*!40000 ALTER TABLE `tb_task_join` DISABLE KEYS */;
/*!40000 ALTER TABLE `tb_task_join` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_task_operate_steps`
--

DROP TABLE IF EXISTS `tb_task_operate_steps`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_task_operate_steps` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '操作id',
  `task_id` int(11) NOT NULL DEFAULT '0' COMMENT '任务id',
  `uid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '用户id',
  `content` text COMMENT '操作说明文字',
  `image` varchar(255) NOT NULL DEFAULT '' COMMENT '操作说明配图',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '操作步骤顺序',
  `update_time` int(11) NOT NULL DEFAULT '0',
  `create_time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `task_id` (`task_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='操作说明表  与发布任务表关联';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_task_operate_steps`
--

LOCK TABLES `tb_task_operate_steps` WRITE;
/*!40000 ALTER TABLE `tb_task_operate_steps` DISABLE KEYS */;
/*!40000 ALTER TABLE `tb_task_operate_steps` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_uploads`
--

DROP TABLE IF EXISTS `tb_uploads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_uploads` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_id` int(11) DEFAULT '0' COMMENT '管理员ID',
  `uid` int(11) DEFAULT '0' COMMENT '会员ID',
  `extension` varchar(20) DEFAULT NULL COMMENT '扩展名',
  `original_name` varchar(255) DEFAULT NULL COMMENT '原文件名',
  `save_name` varchar(255) DEFAULT NULL COMMENT '保存名称',
  `filename` varchar(255) DEFAULT NULL COMMENT '文件名',
  `md5` varchar(255) DEFAULT NULL COMMENT '文件md5',
  `sha1` varchar(255) DEFAULT NULL COMMENT '文件sha1值',
  `size` varchar(255) DEFAULT NULL COMMENT '文件大小',
  `create_time` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC COMMENT='上传信息表';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_uploads`
--

LOCK TABLES `tb_uploads` WRITE;
/*!40000 ALTER TABLE `tb_uploads` DISABLE KEYS */;
INSERT INTO `tb_uploads` VALUES (1,1,0,'jpg',NULL,'20210421/8c2728115d8507f9d99fa404b47a7e59.jpg','8c2728115d8507f9d99fa404b47a7e59.jpg','599836faac4954cf18c98cc06a52693a','a7991d6882d64c0f19098c03e57e00fd4f1645f0','77877',1618993772),(2,1,0,'gif',NULL,'20210421/f2b04d2f64abddfe24a81203cd86fd25.gif','f2b04d2f64abddfe24a81203cd86fd25.gif','e2017b29fea6e850f19b0bb88a271473','d9bd933d66e0edeb0d347daebc242b1eb987737f','327421',1618994975),(3,1,0,'png',NULL,'20210421/2a10559c72ffc9df2756d7e19574c84c.png','2a10559c72ffc9df2756d7e19574c84c.png','4618d69a8d7725d2a7ebe911012be4a2','15bd4900a2baf1004156055b40f0ca9b8996baec','79376',1618996684),(4,1,0,'png',NULL,'20210421/58590414b67178fa6c10203d500dc41b.png','58590414b67178fa6c10203d500dc41b.png','251d012ce10635bcd20f6f6100483632','f773b14172183f068d1423ccf9a9f859bec937a4','76093',1618996698),(5,1,0,'png',NULL,'20210421/18028ea3409ff8a37f4bbfc49ff1c82e.png','18028ea3409ff8a37f4bbfc49ff1c82e.png','a03a2a9d2f2eff8c89ea0ab1fff1852b','46b9cf291cb177588b0cc4b757a65a64f7caeb7e','44441',1618996706),(6,1,0,'png',NULL,'20210421/db276457265271d2a50963b92c2bbe5d.png','db276457265271d2a50963b92c2bbe5d.png','a03a2a9d2f2eff8c89ea0ab1fff1852b','46b9cf291cb177588b0cc4b757a65a64f7caeb7e','44441',1618996732),(7,1,0,'png',NULL,'20210421/d0c0a97fcdc15de18b9a1eb42f72005a.png','d0c0a97fcdc15de18b9a1eb42f72005a.png','c92e189c30ca9c7642b2c4a5b7dad88d','d4dd75994999e162c091e266f7471425904c4723','7189',1618996742),(8,1,0,'png',NULL,'20210421/5bd597094a3a379ca88ea5d064b04343.png','5bd597094a3a379ca88ea5d064b04343.png','4618d69a8d7725d2a7ebe911012be4a2','15bd4900a2baf1004156055b40f0ca9b8996baec','79376',1618996750),(9,1,0,'png',NULL,'20210421/4b9b4f752ef0579dc077e819ddb46069.png','4b9b4f752ef0579dc077e819ddb46069.png','251d012ce10635bcd20f6f6100483632','f773b14172183f068d1423ccf9a9f859bec937a4','76093',1618996756),(10,1,0,'gif',NULL,'20210421/f65e0e30cd8bebd9efe67e81638a8b88.gif','f65e0e30cd8bebd9efe67e81638a8b88.gif','e2017b29fea6e850f19b0bb88a271473','d9bd933d66e0edeb0d347daebc242b1eb987737f','327421',1618997370),(11,1,0,'gif',NULL,'20210421/33c4384a8568a6f5359c96289de2f38d.gif','33c4384a8568a6f5359c96289de2f38d.gif','e2017b29fea6e850f19b0bb88a271473','d9bd933d66e0edeb0d347daebc242b1eb987737f','327421',1618997391),(12,1,0,'png',NULL,'20210421/aa338e07d59c5045b4275a8ef4df43aa.png','aa338e07d59c5045b4275a8ef4df43aa.png','c92e189c30ca9c7642b2c4a5b7dad88d','d4dd75994999e162c091e266f7471425904c4723','7189',1618997397),(13,1,0,'gif',NULL,'20210421/88af0ebe88301b75883c6f9ec096ae58.gif','88af0ebe88301b75883c6f9ec096ae58.gif','e2017b29fea6e850f19b0bb88a271473','d9bd933d66e0edeb0d347daebc242b1eb987737f','327421',1618997464),(14,1,0,'gif',NULL,'20210421/28a5ececcbe772d8202cacf748438663.gif','28a5ececcbe772d8202cacf748438663.gif','e2017b29fea6e850f19b0bb88a271473','d9bd933d66e0edeb0d347daebc242b1eb987737f','327421',1618998266),(15,1,0,'png',NULL,'20210421/5bfb3409bb5cc5eb1aff73d095c581b4.png','5bfb3409bb5cc5eb1aff73d095c581b4.png','a6587f25aca05683b7deb3b9ac0b5bc1','73bd630c4b604826d52dc856795c078e08be2566','28351',1618998580),(16,1,0,'png',NULL,'20210421/1619000742730077.png','1619000742730077.png',NULL,NULL,'7960',1619000742),(17,1,0,'png',NULL,'20210421/1619000845107519.png','1619000845107519.png',NULL,NULL,'45098',1619000845),(18,1,0,'png',NULL,'20210421/1619000881126414.png','1619000881126414.png',NULL,NULL,'6694',1619000881);
/*!40000 ALTER TABLE `tb_uploads` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tb_withdraw`
--

DROP TABLE IF EXISTS `tb_withdraw`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tb_withdraw` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) DEFAULT '0',
  `username` varchar(20) NOT NULL DEFAULT '' COMMENT '用户名',
  `credit2` decimal(10,2) DEFAULT '0.00' COMMENT '提现金额',
  `fee` decimal(10,2) DEFAULT '0.00' COMMENT '手续费',
  `pay_method` tinyint(3) DEFAULT '0' COMMENT '0银行卡，1支付宝，2微信',
  `account` varchar(50) DEFAULT NULL COMMENT '账号',
  `realname` varchar(20) DEFAULT NULL COMMENT '真实姓名',
  `mobile` varchar(20) DEFAULT NULL COMMENT '手机号',
  `status` tinyint(3) DEFAULT '0' COMMENT '0待审核，1已发放，-1审核未通过',
  `note` varchar(255) DEFAULT NULL COMMENT '备注信息',
  `update_time` int(11) DEFAULT '0',
  `create_time` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=50 DEFAULT CHARSET=utf8mb4 ROW_FORMAT=DYNAMIC;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tb_withdraw`
--

LOCK TABLES `tb_withdraw` WRITE;
/*!40000 ALTER TABLE `tb_withdraw` DISABLE KEYS */;
/*!40000 ALTER TABLE `tb_withdraw` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping routines for database 'test1'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2021-04-21 18:49:55
