<?php
/**
 * Created by PhpStorm.
 * User: dell
 * Date: 2018/3/31
 * Time: 下午11:24
 */

namespace app\admin\controller;


class Lock extends Base
{
    public function _initialize()
    {
        parent::_initialize(); // TODO: Change the autogenerated stub
       
    }

    public function index(){
        if(request()->isAjax()){
            $ids = params_array('ids');
            if(!check_array($ids)){
                message('请选择要删除的公告','','error');
            }
            $status = \app\admin\model\Lock::deleteByIds($ids);
            if(!$status){
                message('删除失败','','error');
            }
            message("删除成功",'reload','success');
        }
        $where = [];
        $params = request()->param();
        if(!empty($params['keyword'])){
            $where['title'] = ['like',"%{$params['keyword']}%"];
        }
        if(!empty($params['is_forever'])){
            $where['is_forever'] = ['in',$params['is_forever']];
        }
        $list = \app\admin\model\Lock::getList(15,$where);
        $pager = $list->render();
        return $this->fetch(__FUNCTION__, [
            'list' => $list,
            'pager' => $pager
        ]);
    }


    public function post(){
        $id = params('id');
        $item = [];
        if(check_id($id)){
            $item = \app\admin\model\Lock::getInfoById($id);
        }
        if(request()->isAjax()){
            $params = array_trim(request()->post());
            $validate = $this->validate($params,'Lock');
            if($validate !== true){
                message($validate,'','error');
            }
            $params['to_date'] = strtotime($params['to_date']);
            if(empty($item)){
                $params['create_time'] = TIMESTAMP;
                $op = "添加";
                $status = \app\admin\model\Lock::addInfo($params);
            }else{
                $params['update_time'] = TIMESTAMP;
                $op = "修改";
                $status = \app\admin\model\Lock::updateInfoById($id,$params);
            }
            if(!$status){
                message("{$op}失败",'','error');
            }
            message("{$op}成功",'reload','success');
        }
        return $this->fetch(__FUNCTION__,[
            'item' => $item
        ]);
    }
}