<?php 
  include './head.php';
?>
<div class="layui-row layui-col-space15">
        <div class="layui-col-md8 layui-col-md-offset2">
        <div class="layui-card" style="border-radius: 20px;">
            <div class="layui-card-header">
                <h3 style="padding-top: 3px;"><b>单页列表</b></h3>
            </div>
            <div class="layui-card-body">
              <div class="layui-form layui-form-pane">
                <div class="layui-form-item">
                  <label class="layui-form-label"><i class="layui-icon layui-icon-search"></i></label> 
                  <div class="layui-input-inline">
                    <input type="text" name="search" autocomplete="off" placeholder="请输入序号" class="layui-input">
                  </div>
                  <button onclick="search()" class="layui layui-btn">搜索</button>
                </div>
                </form>
                <hr>
                <table id="viewList" lay-filter="viewList"></table>
                <script type="text/html" id="viewAct">
                    <a class="layui-btn layui-btn-normal layui-btn-xs" lay-event="view">查看</a>
                    <a class="layui-btn layui-btn-warm layui-btn-xs" lay-event="tuisong">推送</a>
                    <a class="layui-btn layui-btn-success layui-btn-xs" lay-event="edit">编辑</a>
                    <a class="layui-btn layui-btn-danger layui-btn-xs" lay-event="del">删除</a>
                </script>
            </div>
</div>
</div>

<script src="../public/static/layuiadmin/layui/layui.all.js"></script>
  <script>
  layui.config({
      base: '../public/static/layuiadmin/' //静态资源所在路径
    }).extend({
      index: 'lib/index' //主入口模块
    }).use(['index','form','table'], function(){
      var $ = layui.$
      ,table = layui.table
      ,layedit = layui.layedit
      ,laydate = layui.laydate
      ,form = layui.form
      ,admin = layui.admin
      ,element = layui.element
      ,layer = layui.layer;
      element.render();

    search = function(){
      var load = layer.load({time:false});
        var search = $("input[name='search']").val();
        table.reload('viewList', {
          where: {
            id: search
          }
          ,page: {
            curr: 1
          }
        });
        layer.close(load);
      }


    table.render({
      elem: '#viewList',
      url: './ajax.php?act=viewList',
      page: true,
      toolbar: '<div><i lay-event="viewAdd" class="layui-icon layui-icon-add-circle" style="font-size: 30px; color:#009688;"></i> </div>',
      cols: [[
        // {type: 'checkbox', fixed: 'left'},
        {field: 'id', title: '序号', width:80, sort: true},
        {field: 'class', title: '目录分类', width:100},
        {field: 'title', title: '页面标题', width:188},
        {field: 'addtime', title: '创建时间', width:166},
        {field: 'pvAll', title: '总PV', width:88,templet:'#pvAll',sort: true},
        {title: '操作', width: 288, toolbar: '#viewAct'}
      ]]
    })

    table.on('toolbar(viewList)', function(obj){
    var checkStatus = table.checkStatus(obj.config.id)
    ,data = checkStatus.data; //获取选中的数据
    switch(obj.event){
      case 'viewAdd':
       area = [$(window).width() > 600 ? '600px' : '90%', $(window).height() > 550 ? '550px' : '90%'];
        layer.open({
          type: 2,
          title: '添加页面',
          skin: 'layui-layer-molv', //加上边框
          area: area, //宽高
          content: './viewAdd.php?act=add'
        });
      break;
    };
  });

    table.on('tool(viewList)', function(obj){
      var data = obj.data;
      var layEvent = obj.event;
      var tr = obj.tr;  
      if(layEvent=='del'){
        layer.confirm('序号: '+data.id+'<br>分类：'+data.class+'<br>名称：'+data.title+'<br>您确定要<font color="red"><b> 删除 </b></font>吗？', function(index){
              var load = layer.load({time:false});
              $.ajax({
                  url: "./ajax.php?act=viewDel",
                  data: {id:data.id},
                  type: "GET",
                  dataType: "json",
                  success: function(data){
                      layer.close(load);
                      if(data.code==1){
                        layer.msg(data.msg,{icon:6});
                      }else{
                        layer.msg(data.msg,{icon:5});
                      }
                      if(data.code == 1){
                          obj.del(); 
                      }
                  },
                  error: function(data){
                      layer.close(load);
                      layer.msg("未知错误");
                  }
              });
          });
      }else if(layEvent=='edit'){
        area = [$(window).width() > 600 ? '600px' : '90%', $(window).height() > 550 ? '550px' : '90%'];
          layer.open({
            type: 2,
            title: '修改页面',
            skin: 'layui-layer-molv', //加上边框
            area: area, //宽高
            content: './viewAdd.php?act=edit&id='+data.id
          });
      }else if(layEvent=='view'){
          area = [$(window).width() > 600 ? '600px' : '90%', $(window).height() > 550 ? '550px' : '90%'];
          var load = layer.load({time:false});
          $.ajax({
              url: "./ajax.php?act=viewSee",
              data: {id:data.id},
              type: "GET",
              dataType: "json",
              success: function(data){
                  layer.close(load);
                  layer.open({
                      type: 2,
                      title:'页面预览',
                      skin: 'layui-layer-rim', //加上边框
                      area: area, //宽高
                      content: data.url
                    });
              },
              error: function(data){
                  layer.close(load);
                  layer.msg("未知错误");
              }
          });
    }else if(layEvent=='tuisong'){
      var load = layer.load({time:false});
          $.ajax({
              url: "./ajax.php?act=viewTuisong",
              data: {mod:'view',id:data.id},
              type: "GET",
              dataType: "json",
              success: function(data){
                  layer.close(load);
                  if(data.code==1){
                    layer.msg(data.msg,{icon:6});
                  }else{
                    layer.msg(data.msg,{icon:5});
                  }
              },
              error: function(data){
                  layer.close(load);
                  layer.msg("未知错误");
              }
          });
      }
  });
})
  </script>
<?php 
  include 'foot.php';
?>