<?php
/*
	[Office 515158] (C) 2009-2012 天生创想 Inc.
	$Id: function_global.php 1209087 2012-01-08 08:58:28Z baiwei.jiang $
*/

!defined('IN_TOA') && exit('Access Denied!');

if (!function_exists('file_put_contents')) {
	function file_put_contents($file, $data, $append = false) {
		$mode = $append ? 'ab' : 'wb';
		$fp = @fopen($file,$mode) or die("can not open file $file !");
		flock($fp, LOCK_EX);
		$len = fwrite($fp, $data);
		flock($fp, LOCK_UN);
		@fclose($fp);
		return $len;
	}
}

if ( !function_exists('file_get_contents') ) {
	function file_get_contents($file) {
		$fp = @fopen($file,'rb') or die("can not open file $file!");
		flock($fp, LOCK_SH);
		$content = fread($fp, filesize($file));
		flock($fp, LOCK_UN);
		@fclose($fp);
		return $content;
	}
}

if (!function_exists('json_encode')) {
	function json_encode ($a=false) {
		if (is_null($a)) return 'null';
		if ($a === false) return 'false';
		if ($a === true) return 'true';
		if (is_scalar($a)) {
			if (is_float($a)) {
				return floatval(str_replace(",", ".", strval($a)));
			}
			if (is_string($a)) {
				static $jsonReplaces = array(array("\\", "/", "\n", "\t", "\r", "\b", "\f", '"'), array('\\\\', '\\/', '\\n', '\\t', '\\r', '\\b', '\\f', '\"'));
				return '"' . str_replace($jsonReplaces[0], $jsonReplaces[1], $a) . '"';
			} else {
				return $a;
			}
		}
		$isList = true;
		for ($i = 0, reset($a); $i < count($a); $i++, next($a)) {
			if (key($a) !== $i) {
				$isList = false;
				break;
			}
		}
		$result = array();
		if ($isList) {
			foreach ($a as $v) $result[] = json_encode($v);
			return '[' . join(',', $result) . ']';
		} else {
			foreach ($a as $k => $v) $result[] = json_encode($k).':'.json_encode($v);
			return '{' . join(',', $result) . '}';
		}
	}
}
//设置系统时间
function get_date($format, $timestamp = '') {
	$timezone = 8;
	empty($timestamp) && $timestamp = PHP_TIME;
	return gmdate($format, $timestamp + intval($timezone) * 3600);
}

function str_to_time($timestr) {
	$timezone = get_config('TOA','timezone');
	return function_exists('date_default_timezone_set') ? (strtotime($timestr) - 3600 * $timezone) : strtotime($timestr);
}

//页面跳转,不提示
function goto_page($url) {
	echo '<html><head></head><body><script type="text/javascript">window.location=\''.$url.'\'</script></body></html>';
	//echo $url;
	exit;
}

//获取配置信息
function get_config($group, $key) {
	return $GLOBALS['_CACHE']['config'][$group][$key];
}

//获取客户端IP
function get_onlineip() {
	if ($_SERVER['HTTP_X_FORWARDED_FOR']) {
		$onlineip = $_SERVER['HTTP_X_FORWARDED_FOR'];
	} elseif ($_SERVER['HTTP_CLIENT_IP']) {
		$onlineip = $_SERVER['HTTP_CLIENT_IP'];
	} else {
		$onlineip = $_SERVER['REMOTE_ADDR'];
	}
	return preg_match("/^([0-9]{1,3}\.){3}[0-9]{1,3}$/",$onlineip) ? $onlineip : 'unknown';	
}
//addslashes
function add_slashes($string) {
	if (!is_array($string)) return addslashes($string);
	foreach ($string as $key => $val) {
		$string[$key] = add_slashes($val);
	}
	return $string;
}

function del_slashes($string) {
	if (!is_array($string)) return stripslashes($string);
	foreach ($string as $key => $val) {
		$string[$key] = del_slashes($val);
	}
	return $string;
}

//ob_start
function obstart() {
	if ( get_config('TOA','obstart') && function_exists('ob_gzhandler') ) {
		ob_start('ob_gzhandler');
	} else {
		ob_start();
	}
}
//ob_end_clean
function obclean() {
	ob_end_clean();
	obstart();
}

//检查提交
function check_submit($action) {
	if (isset($_POST[$action]) && $_SERVER['REQUEST_METHOD'] == 'POST') {
		return true;
	}
	return false;
}

//字符串过滤
function check_str($string, $isurl = false) {
	$string = preg_replace('/[\\x00-\\x08\\x0B\\x0C\\x0E-\\x1F]/','',$string);
	$string = str_replace(array("\0","%00","\r"),'',$string);
	empty($isurl) && $string = preg_replace("/&(?!(#[0-9]+|[a-z]+);)/si",'&amp;',$string);
	$string = str_replace(array("%3C",'<'),'&lt;',$string);
	$string = str_replace(array("%3E",'>'),'&gt;',$string);
	$string = str_replace(array('"',"'","\t",'  '),array('&quot;','&#39;','    ','&nbsp;&nbsp;'),$string);
	return trim($string);
}

//是否超级管理员
function is_superadmin($uid = '') {
	global $_USER,$superadmin;
	global $db;
	global $_USER;
	$sql = "SELECT id FROM ".DB_TABLEPRE."user where flag='1' and id='".$_USER->id."' and jituanid='".$_USER->jituanid."' ";
	$result = $db->fetch_one_array($sql);
	return $result['id'];
	//empty($uid) && $uid = $_USER->id;
	//return in_array($uid, explode(',',$superadmin));

}

//检查权限
function check_purview($pv) {
	global $_USER;
	return $_USER->get_pv($pv);
}

//设置COOKIE
function set_cookie($var, $val = '', $expire = 0) {
	$expire = $expire > 0 ? PHP_TIME + $expire : (empty($val) ? (PHP_TIME - 3600) : 0);
	$s = $_SERVER['SERVER_PORT'] == 443 ? 1 : 0;
	return setcookie(COOKIE_PRE.$var, $val, $expire, COOKIE_PATH, COOKIE_DOMAIN, $s);
}

//获取COOKIE
function get_cookie($var) {
	$var = COOKIE_PRE.$var;
	return isset($_COOKIE[$var]) ? $_COOKIE[$var] : False;
}

//插入记录
function insert_db($table, $data, $replace = false) {
	global $db;
	$keysql = $valsql = '';
	foreach ($data as $key => $val) {
		$keysql .= empty($keysql) ? "`$key`" : ", `$key`";
		$valsql .= empty($valsql) ? "'$val'" : ", '$val'";
	}
	$method = $replace ? 'REPLACE' : 'INSERT';
	$sql = "$method INTO `".DB_TABLEPRE."$table` ($keysql) VALUES ($valsql)";
	$db->query($sql);
	return $db->insert_id();
}
//插入记录
function insert_smsdb($table, $data, $replace = false) {
	global $db;
	$keysql = $valsql = '';
	foreach ($data as $key => $val) {
		$keysql .= empty($keysql) ? "`$key`" : ", `$key`";
		$valsql .= empty($valsql) ? "'$val'" : ", '$val'";
	}
	$method = $replace ? 'REPLACE' : 'INSERT';
	$sql = "$method INTO `$table` ($keysql) VALUES ($valsql)";
	$db->query($sql);
	return $db->insert_id();
}
//更新记录
function update_db($table, $value, $where) {
	global $db;
	$updatesql = $wheresql = '';
	foreach ($value as $key => $val) {
		$updatesql .= empty($updatesql) ? " `$key` = '$val'" : ", `$key` = '$val'";
	}
	foreach ($where as $key => $val) {
		$wheresql .= empty($wheresql) ? " `$key` = '$val' " : " AND `$key` = '$val'";
	}
	$sql = "UPDATE `".DB_TABLEPRE."$table` SET $updatesql WHERE $wheresql";
	$db->query($sql);
	return $db->affected_rows();
}
function prompt($str){
	echo $str;
	exit;
}
//字符串截取
function cut_str($str, $len = 0, $dot = '...',$encoding = 'utf-8') {
	if (!$len || strlen($str) <= $len) return $str;
	$tempstr = '';
	$str = str_replace(array('&amp;', '&quot;', '&lt;', '&gt;'), array('&', '"', '<', '>'), $str);
	if ($encoding == 'utf-8') {
		$n = $tn = $noc = 0;
		while($n < strlen($str)) {
			$t = ord($str[$n]);
			if($t == 9 || $t == 10 || (32 <= $t && $t <= 126)) {
				$tn = 1; $n++; $noc++;
			} elseif (194 <= $t && $t <= 223) {
				$tn = 2; $n += 2; $noc += 2;
			} elseif (224 <= $t && $t < 239) {
				$tn = 3; $n += 3; $noc += 2;
			} elseif (240 <= $t && $t <= 247) {
				$tn = 4; $n += 4; $noc += 2;
			} elseif (248 <= $t && $t <= 251) {
				$tn = 5; $n += 5; $noc += 2;
			} elseif ($t == 252 || $t == 253) {
				$tn = 6; $n += 6; $noc += 2;
			} else {
				$n++;
			}
			if($noc >= $len) {
				break;
			}
		}
		if($noc > $len) {
			$n -= $tn;
		}
		$tempstr = substr($str, 0, $n);
	} elseif ($encoding == 'gbk') {
		for ($i=0; $i<$len; $i++) {
			$tempstr .= ord($str{$i}) > 127 ? $str{$i}.$str{++$i} : $str{$i};
		}
	}
	$tempstr = str_replace(array('&', '"', '<', '>'), array('&amp;', '&quot;', '&lt;', '&gt;'), $tempstr);
	return $tempstr.$dot;
}

//数据大小单位转换
function sizecount($byte) {
	if ($byte < 1024) {
		return $byte.'byte';
	} elseif (($size = round($byte/1024,2)) < 1024) {
		return $size.'KB';
	} elseif (($size = round($byte / (1024*1024),2)) < 1024) {
		return $size.'MB';
	} else {
		return round($byte / (1024*1024*1024),2).'GB';
	}
}
function getsql($content){
	$str='select,union,where,insert,drop,create,script,alert,concat,iframe';
	$strvalue=explode(',',$str);
	$m=0;
	for($i=0;$i<sizeof($strvalue);$i++){
		if(substr_count(strtolower($content),$strvalue[$i])>0){
			$m++;
		}
	}
	if($m>0){
		return '系统安全检测到'.$m.'个系统关键词，请更改内容！';
	}else{
		return $content;
	}
}

//获取$_GET或$_POST值
function getGP($var, $method = 'GP', $type = 'string') {
	if ($method == 'G' || $method != 'P' && isset($_GET[$var])) {
		$gp = &$_GET;
	} else {
		$gp = &$_POST;
	}
	if ($type == 'int') {
		return isset($gp[$var]) ? intval($gp[$var]) : 0;
	} elseif ($type == 'array') {
		return isset($gp[$var]) ? (array)getsql($gp[$var]) : array();
	} else {
		return isset($gp[$var]) ? (string)trim(getsql($gp[$var])) : '';
	}
}

//初始化GP值为变量
function initGP($keys, $method = 'GP', $type = 'string') {
	!is_array($keys) && $keys = array($keys);
	foreach ($keys as $key) {
		$GLOBALS[$key] = getGP($key, $method, $type);
	}
}
//提示信息
function show_msg_type ($content = '', $url = '') {
		$_ENV['message'] = array();
		$_ENV['message']['content'] = "$content";
		$_ENV['message']['nav'] = "<a href='$url'>是的，我要执行此操作</a>";
		echo '
		<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="X-UA-Compatible" content="IE=7" />
<title>提示信息</title>
<style type="text/css"> 
<!--
*{ padding:0; margin:0; font-size:12px}
a:link,a:visited{text-decoration:none;color:#0068a6}
a:hover,a:active{color:#ff6600;text-decoration: underline}
.showMsg{border: 8px solid #069DD5; zoom:1; width:450px; height:172px;position:absolute;top:44%;left:50%;margin:-87px 0 0 -225px}
.showMsg h5{background-image: url(template/default/images/admin_img/msg.png);background-repeat: no-repeat; color:#fff; padding-left:35px; height:25px; line-height:26px;*line-height:28px; overflow:hidden; font-size:14px; text-align:left}
.showMsg .content{ padding:46px 12px 10px 45px; font-size:14px; height:64px; text-align:left}
.showMsg .bottom{ background:#F5F6F7; margin: 0 1px 1px 1px;line-height:26px; *line-height:30px; height:26px; text-align:center}
.showMsg .ok,.showMsg .guery{background: url(template/default/images/admin_img/msg_bg.png) no-repeat 0px -560px;}
.showMsg .guery{background-position: left -460px;}
-->
</style>
</head>
<body>
<div class="showMsg" style="text-align:center">
	<h5>提示信息</h5>
    <div class="content guery" style="display:inline-block;display:-moz-inline-stack;zoom:1;*display:inline;max-width:330px">'.$_ENV['message']['content'].'</div>
    <div class="bottom">
    	['.$_ENV['message']['nav'].']
			        </div>
</div>
</body>
</html>';
exit();
}
//提示信息
function show_msg ($content = '', $url = '', $litime = 3000, $ajump = true) {
	$_ENV['message'] = array();
	if (is_array($content)) {
		foreach ($content as $value) $_ENV['message']['content'] .= "$value\n"; 
	} else {
		$_ENV['message']['content'] = "$content\n";
	}
	if ( $ajump ) {
		if ($url == "") {
			$_ENV['message']['nav'] = "<a href='javascript:history.back();'>如果您的浏览器没自动跳转，请点击这里</a>";
			$_ENV['message']['goto'] = "<script>setTimeout(\"history.back();\",{$litime});</script>";
		} else {
			$_ENV['message']['nav'] = "<a href='$url'>如果您的浏览器没自动跳转，请点击这里</a>";
			$_ENV['message']['goto'] = "<script>setTimeout(\"window.location.href='{$url}';\",{$litime});</script>";
		}
	} else {
		$_ENV['message']['nav'] = "<a href='{$url}'>点击这里返回</a>";
	}
	if ( file_exists(THEME_ROOT.'message.php') ) {
		template('message');
	} else {
		echo '
		<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="X-UA-Compatible" content="IE=7" />
<title>提示信息</title>
<style type="text/css"> 
<!--
*{ padding:0; margin:0; font-size:12px}
a:link,a:visited{text-decoration:none;color:#0068a6}
a:hover,a:active{color:#ff6600;text-decoration: underline}
.showMsg{border: 8px solid #069DD5; zoom:1; width:450px; height:172px;position:absolute;top:44%;left:50%;margin:-87px 0 0 -225px}
.showMsg h5{background-image: url(template/default/images/admin_img/msg.png);background-repeat: no-repeat; color:#fff; padding-left:35px; height:25px; line-height:26px;*line-height:28px; overflow:hidden; font-size:14px; text-align:left}
.showMsg .content{ padding:46px 12px 10px 45px; font-size:14px; height:64px; text-align:left}
.showMsg .bottom{ background:#F5F6F7; margin: 0 1px 1px 1px;line-height:26px; *line-height:30px; height:26px; text-align:center}
.showMsg .ok,.showMsg .guery{background: url(template/default/images/admin_img/msg_bg.png) no-repeat 0px -560px;}
.showMsg .guery{background-position: left -460px;}
-->
</style>
</head>
<body>
<div class="showMsg" style="text-align:center">
	<h5>提示信息</h5>
    <div class="content guery" style="display:inline-block;display:-moz-inline-stack;zoom:1;*display:inline;max-width:330px">'.$_ENV['message']['content'].'</div>
    <div class="bottom">
    	<a href="javascript:history.back();" >['.$_ENV['message']['nav'].']</a>
			        </div>
</div>
'.$_ENV['message']['goto'].' 
</body>
</html>';
	}
	exit();
}

//产生随机数
function random($length,$string = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz') {
	$rstr = '';
	$strlen = strlen($string);
	for ($i=0; $i<$length; $i++) {
		$rstr .= $string{mt_rand(0,$strlen-1)};	
	}
	return $rstr;
}

//引入缓存
function get_cache($cachename) {
	global $_CACHE;
	!is_array($cachename) && $cachename = array($cachename);
	foreach ($cachename as $cache) {
		if (isset($_CACHE[$cache])) continue ;
		$cachefile = CACHE_ROOT.'cache_'.$cache.'.php';
		if (!file_exists($cachefile)) {
			require_once(TOA_ROOT.'./include/function_cache.php');
			recache($cache);
		}
		include_once($cachefile);
	}
}
//ubb解码
function ubb_decode($conver_str) {
	global $_CACHE;
	$conver_str = eregi_replace('\[upload=([0-9]+)]',$_CACHE['config']['blog']['url'].'/attachment.php?id=\\1',$conver_str);
	$conver_str = str_replace(array('[b]','[/b]'),array('<b>','</b>'),$conver_str);
	$conver_str = eregi_replace('\[img]([^\[]*)\[/img]','<img src="\\1" onload="resize_img(this)" />',$conver_str);
	$conver_str = eregi_replace('\[url=([^\[]*)]([^\[]*)\[/url]','<a href="\\1" title="\\2" target="_blank">\\2</a>',$conver_str);
	$conver_str = eregi_replace('\[file]([^\[]+)\[/file]','<a href="\\1">点击下载附件</a>',$conver_str);
	return $conver_str;
}

//输出404
function page_not_found() {
	if ( file_exists(THEME_ROOT.'404.php') ) {
		template('404');
	} else {
		header("HTTP/1.1 404 Not Found\n");
		//header("Content-Type: text/html\n");
		header("Date: ".get_date('D, d M Y H:i:s',PHP_TIME)." GMT\n");
		echo '<!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
<html><head>
<title>404 Not Found</title>
</head><body>
<h1>Not Found</h1>
<p>The requested URL '.$_SERVER['SCRIPT_NAME'].' was not found on this server.</p>
<p>Additionally, a 404 Not Found
error was encountered while trying to use an ErrorDocument to handle the request.</p>
</body>
</html>
';
	}
	exit;
}

//分页
function showpage ($num = 0,$prepage = 10,$curpage = 1,$url = '', $rewritemode = false, $pagenum = 10) {
	$pagestr = '';
	$url .= strspn('?',$url) ? '&' : '?';
	$realpages = 1;

	if ($num > $prepage) {
		$realpages = @ceil($num/$prepage);		
		if ($realpages < $pagenum) {
			$from = 1;
			$to = $realpages;
		} else {
			$offset = 5;
			$from = $curpage - $offset;
			$to = $from + $pagenum;
			if ($from < 1) {
				$from = 1;
				$to = $from + $pagenum - 1;
			} elseif ($to > $realpages) {
				$to = $realpages;
				$from = $realpages - $pagenum + 1;
			}
		}
		$pagestr .= '共'.$num.'条';
		if ($curpage > $pagenum) $pagestr .= '<a href="'.$url.'page=1">1...</a>';
		if ($curpage > 1) $pagestr .= '<a href="'.$url.'page=1" class="page-next form-element"><<  首页</a><a href="'.$url.'page='.($curpage-1).'" class="page-next form-element"><上一页</a>';
		for ($i = $from; $i <= $to; $i++) {
			if ($i == $curpage) {
				$pagestr .= '<a href="#" class="page-next form-element" style="color:#F37800;font-weight:bold;">'.$i.'</a>';
			} else {
				$pagestr .= '<a href="'.$url.'page='.$i.'" class="page-next form-element">'.$i.'</a>';
			}
		}
		if ($curpage < $realpages) $pagestr .= '<a href="'.$url.'page='.($curpage+1).'" class="page-next form-element">下一页&gt;</a><a class="page-end form-element" href="'.$url.'page='.$realpages.'">尾页&gt;&gt;</a>';
		if ($realpages > $to) $pagestr .= '<a href="'.$url.'page='.$realpages.'" class="page-next form-element">'.$realpages.'...</a>';
		//if ($realpages > 1 && !$rewritemode) $pagestr .= '<input type="text" size="3" class="go" onkeydown="if (event.keyCode==13) {window.location=\''.$url.'page=\'+this.value;return false;}" />';
		$pagestr = '<span class="page-link">'.$pagestr.'</span>';
	}
	return $pagestr;
}

function newshowpage ($num = 0,$prepage = 10,$curpage = 1,$url = '', $rewritemode = false, $pagenum = 8) {
	$pagestr = '';
	$url .= strspn('?',$url) ? '&' : '?';
	$realpages = 1;

	if ($num > $prepage) {
		$realpages = @ceil($num/$prepage);		
		if ($realpages < $pagenum) {
			$from = 1;
			$to = $realpages;
		} else {
			$offset = 5;
			$from = $curpage - $offset;
			$to = $from + $pagenum;
			if ($from < 1) {
				$from = 1;
				$to = $from + $pagenum - 1;
			} elseif ($to > $realpages) {
				$to = $realpages;
				$from = $realpages - $pagenum + 1;
			}
		}
		$pagestr .= '<div class="page-info-block">共<span id="total_records">'.$num.'</span>条  <span id="total_page">'.$prepage.'</span>条/页 共<span id="current_page">'.$realpages.'</span>页</div> ';
		$pagestr .= '<div class="pagination" id="work-pager-block"><ul>';
		//if ($curpage > $pagenum) $pagestr .= '<a href="'.$url.'page=1">1...</a>';
		if ($curpage > 1) $pagestr .= '<li><span><a href="'.$url.'page=1" style="color:#000;">首页</a></span></li><li><span><a href="'.$url.'page='.($curpage-1).'" style="color:#000;">上一页</a></span></li>';
		for ($i = $from; $i <= $to; $i++) {
			if ($i == $curpage) {
				$pagestr .= '<li class="active"><span>'.$i.'</span></li>';
			} else {
				$pagestr .= '<li><span><a href="'.$url.'page='.$i.'" style="color:#000;">'.$i.'</a></span></li>';
			}
		}
		//if ($realpages > $to) $pagestr .= '<li><span><a href="'.$url.'page='.$realpages.'" style="color:#000;">'.$realpages.'...</a></span></li>';
		if ($curpage < $realpages) $pagestr .= '<li><span><a href="'.$url.'page='.($curpage+1).'" style="color:#000;">下一页</a></span></li><li><span><a style="color:#000;" href="'.$url.'page='.$realpages.'">尾页</a></span></li>';
		
		//if ($realpages > 1 && !$rewritemode) $pagestr .= '<input type="text" size="3" class="go" onkeydown="if (event.keyCode==13) {window.location=\''.$url.'page=\'+this.value;return false;}" />';
		$pagestr = $pagestr.'</ul></div>';
	}
	return $pagestr;
}
function TOA_closed() {
	$reason = get_config('TOA','close_reason');
	$logurl = get_config('TOA','url').'/login.php';
	echo '
	<html>
	<head>
		<title>TOA 提示信息</title>
		<meta http-equiv="content-type" content="text/html; charset=utf-8" />
		<style type="text/css">
		body {background:#F8F8F8;margin-top:150px;font-family:\'Verdana\',\'宋体\';}
		a {color:#175796;text-decoration:none;}
		a:hover {color:red;text-decoration:none;}
		table {background:#fff;border:3px solid #f0f0f0;width:450px;}
		td,th {font-size:14px;color:#000;}
		th {background:#1A5A8D;height:50px;color:#fff;}
		td {padding:5px;}
		</style>
	</head>
	<body>
		<table cellspacing="0" align="center">
			<tr><th>TOA 提示信息</th></tr>
			<tr>
				<td align="left" height="100">'.$reason.'</td>
			</tr>
			<tr>
				<td align="center" style="border-top:1px solid #ccc;color:#666;background:#fbfbfb;padding:10px;"><a href="'.$logurl.'">如果你是管理员，请点击这里进行登录！</a></td>
			</tr>
		</table>
	</body>
	</html>';
exit;
}
function is_email($email) {
	if (preg_match('/^[0-9a-z]+[0-9a-z_\.\-]*@[0-9a-z\-]+(\.[a-z]{2,4}){1,2}$/i',$email)) {
		return true;
	}
	return false;
}

function is_username($username) {
	$badchars = array("\\",'&',' ',"'",'"','/','*',',','<','>',"\r","\t","\n",'#','$','(',')','%','@','+','?',';','^');
	foreach ($badchars as $char) {
		if (strpos($username,$char) !== false) {
			return false;
		}
	}
	return true;
}

function authcode($str, $method = 'ENCODE') {
	return ($method == 'ENCODE' ? base64_encode($str) : base64_decode($str));
}

function my_serialize($data) {
	return add_slashes(serialize(del_slashes($data)));
}
function getWordDocument( $content , $absolutePath = "" , $isEraseLink = true )
{
    $mht = new MhtFileMaker();
    if ($isEraseLink)
        $content = preg_replace('/<a\s*.*?\s*>(\s*.*?\s*)<\/a>/i' , '$1' , $content);   //去掉链接

    $images = array();
    $files = array();
    $matches = array();
    //这个算法要求src后的属性值必须使用引号括起来
    if ( preg_match_all('/<img[.\n]*?src\s*?=\s*?[\"\'](.*?)[\"\'](.*?)\/>/i',$content ,$matches ) )
    {
        $arrPath = $matches[1];
        for ( $i=0;$i<count($arrPath);$i++)
        {
            $path = $arrPath[$i];
            $imgPath = trim( $path );
            if ( $imgPath != "" )
            {
                $files[] = $imgPath;
                if( substr($imgPath,0,7) == 'http://')
                {
                    //绝对链接，不加前缀
                }
                else
                {
                    $imgPath = $absolutePath.$imgPath;
                }
                $images[] = $imgPath;
            }
        }
    }
    $mht->AddContents("tmp.html",$mht->GetMimeType("tmp.html"),$content);

    for ( $i=0;$i<count($images);$i++)
    {
        $image = $images[$i];
        if ( @fopen($image , 'r') )
        {
            $imgcontent = @file_get_contents( $image );
            if ( $content )
                $mht->AddContents($files[$i],$mht->GetMimeType($image),$imgcontent);
        }
        else
        {
            echo "file:".$image." not exist!<br />";
        }
    }

    return $mht->GetFile();
}
function Sms_Date($sTime,$type = 'normal',$alt = 'false') {
    if (!$sTime)
        return '';
    //sTime=源时间，cTime=当前时间，dTime=时间差
    $cTime      =   time();
    $dTime      =   strtotime(get_date('Y-m-d H:i:s',PHP_TIME)) - $sTime;
    $dDay       =   intval(date("z",$cTime)) - intval(date("z",$sTime));
    //$dDay     =   intval($dTime/3600/24);
    $dYear      =   intval(date("Y",$cTime)) - intval(date("Y",$sTime));
    //normal：n秒前，n分钟前，n小时前，日期
    if($type=='normal'){
		
        if( $dTime < 60 ){
            if($dTime < 10){
                return '刚刚';    //by yangjs
            }else{
                return intval(floor($dTime / 10) * 10)."秒前";
            }
        }elseif( $dTime < 3600 ){
            return intval($dTime/60)."分钟前";
        //今天的数据.年份相同.日期相同.
        }elseif( $dYear==0 && $dDay == 0  ){
            //return intval($dTime/3600)."小时前";
            return '今天:'.date('H:i',$sTime);
        }elseif($dYear==0){
            return date("m月d日 H:i",$sTime);
        }else{
            return date("Y年m月d日 H:i",$sTime);
        }
    }elseif($type=='times'){
        return $cTime-$sTime;
    //full: Y-m-d , H:i:s
    }elseif($type=='mohu'){
        if( $dTime < 60 ){
            return $dTime."秒前";
        }elseif( $dTime < 3600 ){
            return intval($dTime/60)."分钟前";
        }elseif( $dTime >= 3600 && $dDay == 0  ){
            return intval($dTime/3600)."小时前";
        }elseif( $dDay > 0 && $dDay<=7 ){
            return intval($dDay)."天前";
        }elseif( $dDay > 7 &&  $dDay <= 30 ){
            return intval($dDay/7) . '周前';
        }elseif( $dDay > 30 ){
            return intval($dDay/30) . '个月前';
        }
    //full: Y-m-d , H:i:s
    }elseif($type=='full'){
        return date("Y-m-d , H:i:s",$sTime);
    }elseif($type=='ymd'){
        return date("Y-m-d",$sTime);
    }else{
        if( $dTime < 60 ){
            return $dTime."秒前";
        }elseif( $dTime < 3600 ){
            return intval($dTime/60)."分钟前";
        }elseif( $dTime >= 3600 && $dDay == 0  ){
            return intval($dTime/3600)."小时前";
        }elseif($dYear==0){
            return date("Y-m-d H:i:s",$sTime);
        }else{
            return date("Y-m-d H:i:s",$sTime);
        }
    }
}
//拼音转换
function Pinyin($_String, $_Code='UTF8'){ //GBK页面可改为gb2312，其他随意填写为UTF8
        $_DataKey = "a|ai|an|ang|ao|ba|bai|ban|bang|bao|bei|ben|beng|bi|bian|biao|bie|bin|bing|bo|bu|ca|cai|can|cang|cao|ce|ceng|cha". 
                        "|chai|chan|chang|chao|che|chen|cheng|chi|chong|chou|chu|chuai|chuan|chuang|chui|chun|chuo|ci|cong|cou|cu|". 
                        "cuan|cui|cun|cuo|da|dai|dan|dang|dao|de|deng|di|dian|diao|die|ding|diu|dong|dou|du|duan|dui|dun|duo|e|en|er". 
                        "|fa|fan|fang|fei|fen|feng|fo|fou|fu|ga|gai|gan|gang|gao|ge|gei|gen|geng|gong|gou|gu|gua|guai|guan|guang|gui". 
                        "|gun|guo|ha|hai|han|hang|hao|he|hei|hen|heng|hong|hou|hu|hua|huai|huan|huang|hui|hun|huo|ji|jia|jian|jiang". 
                        "|jiao|jie|jin|jing|jiong|jiu|ju|juan|jue|jun|ka|kai|kan|kang|kao|ke|ken|keng|kong|kou|ku|kua|kuai|kuan|kuang". 
                        "|kui|kun|kuo|la|lai|lan|lang|lao|le|lei|leng|li|lia|lian|liang|liao|lie|lin|ling|liu|long|lou|lu|lv|luan|lue". 
                        "|lun|luo|ma|mai|man|mang|mao|me|mei|men|meng|mi|mian|miao|mie|min|ming|miu|mo|mou|mu|na|nai|nan|nang|nao|ne". 
                        "|nei|nen|neng|ni|nian|niang|niao|nie|nin|ning|niu|nong|nu|nv|nuan|nue|nuo|o|ou|pa|pai|pan|pang|pao|pei|pen". 
                        "|peng|pi|pian|piao|pie|pin|ping|po|pu|qi|qia|qian|qiang|qiao|qie|qin|qing|qiong|qiu|qu|quan|que|qun|ran|rang". 
                        "|rao|re|ren|reng|ri|rong|rou|ru|ruan|rui|run|ruo|sa|sai|san|sang|sao|se|sen|seng|sha|shai|shan|shang|shao|". 
                        "she|shen|sheng|shi|shou|shu|shua|shuai|shuan|shuang|shui|shun|shuo|si|song|sou|su|suan|sui|sun|suo|ta|tai|". 
                        "tan|tang|tao|te|teng|ti|tian|tiao|tie|ting|tong|tou|tu|tuan|tui|tun|tuo|wa|wai|wan|wang|wei|wen|weng|wo|wu". 
                        "|xi|xia|xian|xiang|xiao|xie|xin|xing|xiong|xiu|xu|xuan|xue|xun|ya|yan|yang|yao|ye|yi|yin|ying|yo|yong|you". 
                        "|yu|yuan|yue|yun|za|zai|zan|zang|zao|ze|zei|zen|zeng|zha|zhai|zhan|zhang|zhao|zhe|zhen|zheng|zhi|zhong|". 
                        "zhou|zhu|zhua|zhuai|zhuan|zhuang|zhui|zhun|zhuo|zi|zong|zou|zu|zuan|zui|zun|zuo"; 
        $_DataValue = "-20319|-20317|-20304|-20295|-20292|-20283|-20265|-20257|-20242|-20230|-20051|-20036|-20032|-20026|-20002|-19990". 
                        "|-19986|-19982|-19976|-19805|-19784|-19775|-19774|-19763|-19756|-19751|-19746|-19741|-19739|-19728|-19725". 
                        "|-19715|-19540|-19531|-19525|-19515|-19500|-19484|-19479|-19467|-19289|-19288|-19281|-19275|-19270|-19263". 
                        "|-19261|-19249|-19243|-19242|-19238|-19235|-19227|-19224|-19218|-19212|-19038|-19023|-19018|-19006|-19003". 
                        "|-18996|-18977|-18961|-18952|-18783|-18774|-18773|-18763|-18756|-18741|-18735|-18731|-18722|-18710|-18697". 
                        "|-18696|-18526|-18518|-18501|-18490|-18478|-18463|-18448|-18447|-18446|-18239|-18237|-18231|-18220|-18211". 
                        "|-18201|-18184|-18183|-18181|-18012|-17997|-17988|-17970|-17964|-17961|-17950|-17947|-17931|-17928|-17922". 
                        "|-17759|-17752|-17733|-17730|-17721|-17703|-17701|-17697|-17692|-17683|-17676|-17496|-17487|-17482|-17468". 
                        "|-17454|-17433|-17427|-17417|-17202|-17185|-16983|-16970|-16942|-16915|-16733|-16708|-16706|-16689|-16664". 
                        "|-16657|-16647|-16474|-16470|-16465|-16459|-16452|-16448|-16433|-16429|-16427|-16423|-16419|-16412|-16407". 
                        "|-16403|-16401|-16393|-16220|-16216|-16212|-16205|-16202|-16187|-16180|-16171|-16169|-16158|-16155|-15959". 
                        "|-15958|-15944|-15933|-15920|-15915|-15903|-15889|-15878|-15707|-15701|-15681|-15667|-15661|-15659|-15652". 
                        "|-15640|-15631|-15625|-15454|-15448|-15436|-15435|-15419|-15416|-15408|-15394|-15385|-15377|-15375|-15369". 
                        "|-15363|-15362|-15183|-15180|-15165|-15158|-15153|-15150|-15149|-15144|-15143|-15141|-15140|-15139|-15128". 
                        "|-15121|-15119|-15117|-15110|-15109|-14941|-14937|-14933|-14930|-14929|-14928|-14926|-14922|-14921|-14914". 
                        "|-14908|-14902|-14894|-14889|-14882|-14873|-14871|-14857|-14678|-14674|-14670|-14668|-14663|-14654|-14645". 
                        "|-14630|-14594|-14429|-14407|-14399|-14384|-14379|-14368|-14355|-14353|-14345|-14170|-14159|-14151|-14149". 
                        "|-14145|-14140|-14137|-14135|-14125|-14123|-14122|-14112|-14109|-14099|-14097|-14094|-14092|-14090|-14087". 
                        "|-14083|-13917|-13914|-13910|-13907|-13906|-13905|-13896|-13894|-13878|-13870|-13859|-13847|-13831|-13658". 
                        "|-13611|-13601|-13406|-13404|-13400|-13398|-13395|-13391|-13387|-13383|-13367|-13359|-13356|-13343|-13340". 
                        "|-13329|-13326|-13318|-13147|-13138|-13120|-13107|-13096|-13095|-13091|-13076|-13068|-13063|-13060|-12888". 
                        "|-12875|-12871|-12860|-12858|-12852|-12849|-12838|-12831|-12829|-12812|-12802|-12607|-12597|-12594|-12585". 
                        "|-12556|-12359|-12346|-12320|-12300|-12120|-12099|-12089|-12074|-12067|-12058|-12039|-11867|-11861|-11847". 
                        "|-11831|-11798|-11781|-11604|-11589|-11536|-11358|-11340|-11339|-11324|-11303|-11097|-11077|-11067|-11055". 
                        "|-11052|-11045|-11041|-11038|-11024|-11020|-11019|-11018|-11014|-10838|-10832|-10815|-10800|-10790|-10780". 
                        "|-10764|-10587|-10544|-10533|-10519|-10331|-10329|-10328|-10322|-10315|-10309|-10307|-10296|-10281|-10274". 
                        "|-10270|-10262|-10260|-10256|-10254"; 
        $_TDataKey   = explode('|', $_DataKey); 
        $_TDataValue = explode('|', $_DataValue);
        $_Data = array_combine($_TDataKey, $_TDataValue);
        arsort($_Data); 
        reset($_Data);
        if($_Code!= 'gb2312') $_String = _U2_Utf8_Gb($_String); 
        $_Res = ''; 
        for($i=0; $i<strlen($_String); $i++) { 
                $_P = ord(substr($_String, $i, 1)); 
                if($_P>160) { 
                        $_Q = ord(substr($_String, ++$i, 1)); $_P = $_P*256 + $_Q - 65536;
                } 
                $_Res .= _Pinyin($_P, $_Data); 
        } 
        return preg_replace("/[^a-z0-9]*/", '', $_Res); 
} 
function _Pinyin($_Num, $_Data){ 
        if($_Num>0 && $_Num<160 ){
                return chr($_Num);

        }elseif($_Num<-20319 || $_Num>-10247){
                return '';
        }else{ 
                foreach($_Data as $k=>$v){ if($v<=$_Num) break; } 
                return $k; 
        } 
}
function _U2_Utf8_Gb($_C){ 
        $_String = ''; 
        if($_C < 0x80){
                $_String .= $_C;
        }elseif($_C < 0x800) { 
                $_String .= chr(0xC0 | $_C>>6); 
                $_String .= chr(0x80 | $_C & 0x3F); 
        }elseif($_C < 0x10000){ 
                $_String .= chr(0xE0 | $_C>>12); 
                $_String .= chr(0x80 | $_C>>6 & 0x3F); 
                $_String .= chr(0x80 | $_C & 0x3F); 
        }elseif($_C < 0x200000) { 
                $_String .= chr(0xF0 | $_C>>18); 
                $_String .= chr(0x80 | $_C>>12 & 0x3F); 
                $_String .= chr(0x80 | $_C>>6 & 0x3F); 
                $_String .= chr(0x80 | $_C & 0x3F); 
        } 
        return iconv('UTF-8', 'GB2312', $_String); 
}
//获取上一月或下一个月
function GetMonth($date,$sign="1"){
			//得到系统的年月
			$tmp_date=date($date);
			//切割出年份
			$tmp_year=substr($tmp_date,0,4);
			//切割出月份
			$tmp_mon =substr($tmp_date,4,2);
			$tmp_nextmonth=mktime(0,0,0,$tmp_mon+1,1,$tmp_year);
			$tmp_forwardmonth=mktime(0,0,0,$tmp_mon-1,1,$tmp_year);
			if($sign==0){
				//得到当前月的下一个月 
				return $fm_next_month=date("Y/m",$tmp_nextmonth);        
			}else{
				//得到当前月的上一个月 
				return $fm_forward_month=date("Y/m",$tmp_forwardmonth);         
			}
}
function unescape($str){ 
	$ret = ''; 
	$len = strlen($str); 
	for ($i = 0; $i < $len; $i++){ 
	if ($str[$i] == '%' && $str[$i+1] == 'u'){ 
	$val = hexdec(substr($str, $i+2, 4)); 
	if ($val < 0x7f) $ret .= chr($val); 
	else if($val < 0x800) $ret .= chr(0xc0|($val>>6)).chr(0x80|($val&0x3f)); 
	else $ret .= chr(0xe0|($val>>12)).chr(0x80|(($val>>6)&0x3f)).chr(0x80|($val&0x3f)); 
	$i += 5; 
	} 
	else if ($str[$i] == '%'){ 
	$ret .= urldecode(substr($str, $i, 3)); 
	$i += 2; 
	} 
	else $ret .= $str[$i]; 
	} 
return $ret; 
}

?>