/*Sets Themed Colors Based on Themes*/

var themeprimary = getThemeColorFromCss('themeprimary');
var themesecondary = getThemeColorFromCss('themesecondary');
var themethirdcolor = getThemeColorFromCss('themethirdcolor');
var themefourthcolor = getThemeColorFromCss('themefourthcolor');
var themefifthcolor = getThemeColorFromCss('themefifthcolor');

//Gets Theme Colors From Selected Skin To Use For Drawing Charts
function getThemeColorFromCss(style) {
    var $span = $("<span></span>").hide().appendTo("body");
    $span.addClass(style);
    var color = $span.css("color");
    $span.remove();
    return color;
}

//手柄开关RTL支持复选框
$("#skin-changer li a").click(function () {
    createCookie("current-skin", $(this).attr('rel'), 10);
    window.location.reload();
});

//检查不做为阿拉伯语和波斯语的演示页面RTL支持


var rtlchanger = document.getElementById('rtl-changer');

if (location.pathname != "/index-rtl-fa.html" && location.pathname != "index-rtl-ar.html") {
    if (readCookie("rtl-support")) {
        switchClasses("pull-right", "pull-left");
        switchClasses("databox-right", "databox-left");
        switchClasses("item-right", "item-left");
        $('.navbar-brand small img').attr('src', 'assets/img/logo-rtl.png');
        if (rtlchanger != null)
            document.getElementById('rtl-changer').checked = true;
    }
    else {
        if (rtlchanger != null)
            rtlchanger.checked = false;
    }

    if (rtlchanger != null) {
        rtlchanger.onchange = function () {
            if (this.checked) {
                createCookie("rtl-support", "true", 10);
            }
            else {
                eraseCookie("rtl-support");
            }
            setTimeout(function () {
                window.location.reload();
            }, 600);

        };
    }
}
/*Loading*/
$(window)
    .load(function () {
        setTimeout(function () {
            $('.loading-container')
                .addClass('loading-inactive');
        }, 1000);
    });

/*帐户区域-设置按钮*/
$('#btn-setting')
    .on('click', function (e) {
        $('.navbar-account')
            .toggleClass('setting-open');
    });

/*切换全屏*/
$('#fullscreen-toggler')
    .on('click', function (e) {
        var element = document.documentElement;
        if (!$('body')
            .hasClass("full-screen")) {

            $('body')
                .addClass("full-screen");
            $('#fullscreen-toggler')
                .addClass("active");
            if (element.requestFullscreen) {
                element.requestFullscreen();
            } else if (element.mozRequestFullScreen) {
                element.mozRequestFullScreen();
            } else if (element.webkitRequestFullscreen) {
                element.webkitRequestFullscreen();
            } else if (element.msRequestFullscreen) {
                element.msRequestFullscreen();
            }

        } else {

            $('body')
                .removeClass("full-screen");
            $('#fullscreen-toggler')
                .removeClass("active");

            if (document.exitFullscreen) {
                document.exitFullscreen();
            } else if (document.mozCancelFullScreen) {
                document.mozCancelFullScreen();
            } else if (document.webkitExitFullscreen) {
                document.webkitExitFullscreen();
            }

        }
    });



InitiateSideMenu();
//InitiateSettings();
//InitiateWidgets();

function InitiateSideMenu() {
    //侧边栏显示开关
    $(".sidebar-toggler").on('click', function () {
        $("#sidebar").toggleClass("hide");
        $(".sidebar-toggler").toggleClass("active");
        return false;
    });
    //End 侧边栏显示开关
	
    //侧边栏崩溃
    var b = $("#sidebar").hasClass("menu-compact");
    $("#sidebar-collapse").on('click', function () {
        new_menu();

    });
    //End 侧边栏菜单句柄
	
}
function new_menu(){
	    if (!$('#sidebar').is(':visible'))
            $("#sidebar").toggleClass("hide");
			$(".menu-text").toggleClass("hide");
			$(".menu-expand").toggleClass("hide");
        $("#sidebar").toggleClass("menu-compact"); 
        $(".sidebar-collapse").toggleClass("active");
        b = $("#sidebar").hasClass("menu-compact");

        if ($(".sidebar-menu").closest("div").hasClass("slimScrollDiv")) {
            $(".sidebar-menu").slimScroll({ destroy: true });
            $(".sidebar-menu").attr('style', '');
        }
        $(".sidebar-menu li .menu-dropdown").hover(function(){
			if($(this).attr("id")){
				$(".page-chatbar-s").show();
				MenuForm($(this).attr("id"));
			}
		});
		$(".page-sidebar").mouseleave(function(){
			$(".page-chatbar-s").hide();
			$("#munuviews").html('');
			//$("#second-panel"+$(this).attr("id")).hide();
		});
}
function MenuTopForm(id) {
	jQuery.ajax({
		type: 'GET',
		url: 'newstart.php?do=topmenu&menuid='+id,
		success: function(data){
			if(data!=''){
				//alert(data);
				$("#munutopviews").html(data);
			}
		}
	});
}
function MenuForm(id) {
	jQuery.ajax({
		type: 'GET',
		url: 'newstart.php?do=menu&id='+id,
		success: function(data){
			if(data!=''){
				//alert(data);
				$("#munuviews").html(data);
			}
		}
	});
}
function _SMS() {
	jQuery.ajax({
		type: 'GET',
		url: 'newstart.php?do=sms&date='+new Date(),
		success: function(data){
			if(data!=''){
				//alert(data);
				$("#_SMS").html(data);
			}
		}
	});
}
function _Mail() {
	jQuery.ajax({
		type: 'GET',
		url: 'newstart.php?do=Mail&date='+new Date(),
		success: function(data){
			if(data!=''){
				//alert(data);
				$("#_Mail").html(data);
			}
		}
	});
}
function _SmsStart() {
	jQuery.ajax({
		type: 'GET',
		url: 'newstart.php?do=SmsStart&date='+new Date(),
		success: function(data){
			if(data!=''){
				$("#_SmsShow").html('');
				_SmsShow();
			}
		}
	});
}
_SmsShow();
function _SmsShow(name) {
	if(name){
		var name=name;
	}else{
		var name='';
	}
	jQuery.ajax({
		type: 'GET',
		url: 'newstart.php?do=SmsShow&name='+name+'&date='+new Date(),
		success: function(data){
			if(data!=''){
				$("#_SmsShow").html(data);
			}
		}
	});
	window.setTimeout(_SmsShow,120*5*1000);
}
function _SmsMsg(sid) {
	var _sid=$('input[name="sid"]').val();
	if(sid!=0){
		jQuery.ajax({
			type: 'GET',
			url: 'newstart.php?do=SmsMsg&sid='+_sid+'&date='+new Date(),
			success: function(data){
				if(data!=''){
					$("#_SmsMsg").html(data);
					var div = document.getElementById('_SmsMsg');
					div.scrollTop = div.scrollHeight;
				}
			}
		});
		window.setTimeout('_SmsMsg('+sid+');',10*2*1000);
	}
}
function search_user(){
	var user=$('input[name="user"]').val();
	_SmsShow(escape(user));
	//alert(user);escape
}
function _SmsAdd() {
	var sid=$('input[name="sid"]').val();
	var Sms_User=$('input[name="Sms_User"]').val();
	var SMS_CONTENT=$('textarea[name="SMS_CONTENT"]').val();
	if(Sms_User!=''){
		jQuery.ajax({
			type: 'GET',
			url: 'newstart.php?do=SmsAdd&sid='+sid+'&Sms_User='+Sms_User+'&SMS_CONTENT='+escape(SMS_CONTENT)+'&date='+new Date(),
			success: function(data){
				if(data!=''){
					_SmsMsg(sid);
					$('textarea[name="SMS_CONTENT"]').val('');
				}
			}
		});
	}
}
// 全屏窗口
function maximize(widgetbox) {
    if (widgetbox) {
        var windowHeight = $(window).height();
        var headerHeight = widgetbox.find(".widget-header").height();
        widgetbox.find(".widget-body").height(windowHeight - headerHeight);
    }
}

/* 滚动到 */
//function scrollTo(el, offeset) {
 //   var pos = (el && el.size() > 0) ? el.offset().top : 0;
 //   jQuery('html,body').animate({ scrollTop: pos + (offeset ? offeset : 0) }, 'slow');
//}

/*显示通知*/
function Notify(message, position, timeout, theme, icon, closable) {
    toastr.options.positionClass = 'toast-' + position;
    toastr.options.extendedTimeOut = 0; //1000;
    toastr.options.timeOut = timeout;
    toastr.options.closeButton = closable;
    toastr.options.iconClass = icon + ' toast-' + theme;
    toastr['custom'](message);
}



//聊天
$("#chat-link").click(function () {
    $('.page-chatbar').toggleClass('open');
    $("#chat-link").toggleClass('open');
});
//$('.page-chatbar .chatbar-contacts .contact').on('click', function(e) {
function _SmsContact(sid) {
    $('.page-chatbar .chatbar-contacts').hide();
    $('.page-chatbar .chatbar-messages').show();
	jQuery.ajax({
		type: 'GET',
		url: 'newstart.php?do=SmsBack&sid='+sid+'&date='+new Date(),
		success: function(data){
			if(data!=''){
				$("#_SmsBack").html(data);
				_SmsMsg(sid);
			}
		}
	});
}
//});

//$('.page-chatbar .chatbar-messages .back').on('click', function (e) {
function _back(){
    $('.page-chatbar .chatbar-contacts').show();
    $('.page-chatbar .chatbar-messages').hide();
	_SmsMsg(0);
	_SmsShow();
}
//});
var position = (readCookie("rtl-support") || location.pathname == "/index-rtl-fa.html" || location.pathname == "index-rtl-ar.html") ? 'right' : 'left';
$('.chatbar-messages .messages-list').slimscroll({
    position: position,
    size: '4px',
    color: themeprimary,
    height: $(window).height() - 260,
	start:'bottom'
});
$('.chatbar-contacts .contacts-list').slimscroll({
    position: position,
    size: '4px',
    color: themeprimary,
    height: $(window).height() - 86,
});
//End 聊天

/*#区域得到颜色*/
//从主题颜色的字符串中获取颜色
function getcolor(colorString) {
    switch (colorString) {
        case ("themeprimary"):
            return themeprimary;
        case ("themesecondary"):
            return themesecondary;
        case ("themethirdcolor"):
            return themethirdcolor;
        case ("themefourthcolor"):
            return themefourthcolor;
        case ("themefifthcolor"):
            return themefifthcolor;
        default:
            return colorString;
    }
}
/*#endregion Get Colors*/


//开关类功能
function switchClasses(firstClass, secondClass) {

    var firstclasses = document.getElementsByClassName(firstClass);

    for (i = firstclasses.length - 1; i >= 0; i--) {
        if (!hasClass(firstclasses[i], 'dropdown-menu')) {
            addClass(firstclasses[i], firstClass + '-temp');
            removeClass(firstclasses[i], firstClass);
        }
    }

    var secondclasses = document.getElementsByClassName(secondClass);

    for (i = secondclasses.length - 1; i >= 0; i--) {
        if (!hasClass(secondclasses[i], 'dropdown-menu')) {
            addClass(secondclasses[i], firstClass);
            removeClass(secondclasses[i], secondClass);
        }
    }

    tempClasses = document.getElementsByClassName(firstClass + '-temp');

    for (i = tempClasses.length - 1; i >= 0; i--) {
        if (!hasClass(tempClasses[i], 'dropdown-menu')) {
            addClass(tempClasses[i], secondClass);
            removeClass(tempClasses[i], firstClass + '-temp');
        }
    }
}


//Add Classes Function
function addClass(elem, cls) {
    var oldCls = elem.className;
    if (oldCls) {
        oldCls += " ";
    }
    elem.className = oldCls + cls;
}

//Remove Classes Function
function removeClass(elem, cls) {
    var str = " " + elem.className + " ";
    elem.className = str.replace(" " + cls, "").replace(/^\s+/g, "").replace(/\s+$/g, "");
}

//Has Classes Function
function hasClass(elem, cls) {
    var str = " " + elem.className + " ";
    var testCls = " " + cls + " ";
    return (str.indexOf(testCls) != -1);
}