<?php

namespace Home\Model;
use Think\Model\RelationModel;
class AdminModel extends RelationModel {

	protected $_validate = array(
		// 验证用户昵称是否唯一,且格式是否正确（2-4个汉字）
		array('nickname','nickname','昵称格式不正确或被占用',0,'function',1), 
		array('truename','truename','真实姓名格式不正确2-4个汉字',0,'function',3), 
		array('password','/^[\@A-Za-z0-9\!\#\$\%\^\&\*\.\~]{6,22}$/','密码范围6-22个任意字符',0,'',2),
		array('anquan','/^[\@A-Za-z0-9\!\#\$\%\^\&\*\.\~]{6,22}$/','安全码范围6-22个任意字符',0,'',2),
		array('shenfenzheng','/^[\@A-Za-z0-9\!\#\$\%\^\&\*\.\~]{15,18}$/','身份证格式不正确',0,'',2),
		array('bumen','bumen','此部不存在',0,'function',2),
		array('tuandui','tuandui','此团不存在',0,'function',2),
		array('xiaozu','xiaozu','此组不存在',0,'function',2),
		array('xiaodui','xiaodui','此队不存在',0,'function',2),
		array('job', array(1,9), '职务不存在', 0,'between',2), 
		array('sex', array(0,1), '性别范围错误！', 0,'in',3), 
		array('year','/(19[6-9][0-9]|200[0-9])/', '年龄范围错误！', 0,'',3),
		array('edu', array(0,1,2,3), '学历范围错误', 0,'in',3),
		array('phone', '/^1[3|4|5|7|8]\d{9}$/', '手机号格式错误！',0,'',3),
		array('qq', '/^\d{5,11}$/', 'QQ号格式错误',0,'',3),
		array('alipay', 'require', '支付宝账号必填',0,'',3),
		array('qt', '/^[a-z_\d]+$/', '微信格式错误',0,'',3),
		array('tuijian','xuanchuan','入职负责人不存在',0,'function',1), 
		);
	/**
	 * [$_auto 自动完成]
	 * @var array
	 */
	protected $_auto = array(
		//password字段不存在，用phone字段代替
		//array('password','phone',1,'field'),
		array('password','md5',3,'function'),
		array('anquan','md5',2,'function'),
		array('zctime','time',1,'function'),
		array('jhtime','time',1,'function'),
		array('sjtime','time',2,'function','ignore'),
		);

}