<?php
/*
 * 此文件用于验证语音服务API接口，供开发时参考
 * 执行验证前请确保文件为utf-8编码，并替换相应参数为您自己的信息，并取消相关调用的注释
 * 建议验证前先执行Test.php验证PHP环境
 *
 * 2017/11/30
 */

namespace Aliyun\DySDKLite\Vms\Demo;

require_once ROOT_D ."/addons/jy_alisms/aliyun-dyvms-php-sdk-lite/SignatureHelper.php";

use Aliyun\DySDKLite\SignatureHelper;

// todo 接口定义，请先替换相应参数为您自己的信息

/**
 * 取消呼叫
 */
function cancelCall($accessKeyId,$accessKeySecret,$params) {

    $params = array();

    // *** 需用户填写部分 ***

    // fixme 必填: 请参阅 https://ak-console.aliyun.com/ 取得您的AK信息
    //$accessKeyId = "your access key id";
    //$accessKeySecret = "your access key secret";

    // fixme 必填: 从上次呼叫调用的返回值中获取的CallId
   // $params["CallId"] = "113853585007^100675005007";

    // *** 需用户填写部分结束, 以下代码若无必要无需更改 ***

    // 初始化SignatureHelper实例用于设置参数，签名以及发送请求
    $helper = new SignatureHelper();

    // 此处可能会抛出异常，注意catch
    $content = $helper->request(
        $accessKeyId,
        $accessKeySecret,
        "dyvmsapi.aliyuncs.com",
        array_merge($params, array(
            "RegionId" => "cn-hangzhou",
            "Action" => "CancelCall",
            "Version" => "2017-05-25",
        ))
        // fixme 选填: 启用https
        // ,true
    );

    return $content;
}
/**
 * 点击拨号
 */
function clickToDial($accessKeyId,$accessKeySecret,$params) {

    $params = array();

    // *** 需用户填写部分 ***

    // fixme 必填: 请参阅 https://ak-console.aliyun.com/ 取得您的AK信息
    //$accessKeyId = "your access key id";
   // $accessKeySecret = "your access key secret";

    // fixme 必填: 主叫显号, 可在语音控制台中找到所购买的显号
   // $params["CallerShowNumber"] = "05344757036";

    // fixme 必填: 主叫号码
   // $params["CallerNumber"] = "1800000000";

    // fixme 必填: 被叫显号, 可在语音控制台中找到所购买的显号
   //$params["CalledShowNumber"] = "4001112222";

    // fixme 必填: 被叫号码
    //$params["CalledNumber"] = "13700000000";


    // fixme 可选: 是否录音
   // $params["RecordFlag"] = true;

    // fixme 可选: 是否开启实时ASR功能
   // $params["AsrFlag"] = true;

    // fixme 可选: ASR模型ID
    //$params["AsrModelId"] = '2070aca1eff146f9a7bc826f1c3d4d33';

    // fixme 可选: 预留给调用方使用的ID, 最终会通过在回执消息中将此ID带回给调用方（15个字符及以内）
   // $params["OutId"] = "yourOutId";

    // *** 需用户填写部分结束, 以下代码若无必要无需更改 ***

    // 初始化SignatureHelper实例用于设置参数，签名以及发送请求
    $helper = new SignatureHelper();

    // 此处可能会抛出异常，注意catch
    $content = $helper->request(
        $accessKeyId,
        $accessKeySecret,
        "dyvmsapi.aliyuncs.com",
        array_merge($params, array(
            "RegionId" => "cn-hangzhou",
            "Action" => "ClickToDial",
            "Version" => "2017-05-25",
        ))
        // fixme 选填: 启用https
        // ,true
    );

    return $content;
}
//交互问答
function ivrCall() {

    $params = array();

    // *** 需用户填写部分 ***

    // fixme 必填: 请参阅 https://ak-console.aliyun.com/ 取得您的AK信息
    $accessKeyId = "your access key id";
    $accessKeySecret = "your access key secret";

    // fixme 必填: 被叫显号
    $params["CalledShowNumber"] = "4001112222";

    // fixme 必填: 被叫显号
    $params["CalledNumber"] = "13700000000";

    // fixme 必填: 呼叫开始时播放的提示音-语音文件Code名称或者Tts模板Code
    $params["StartCode"] = "TTS_10001";

    // fixme 可选: Tts模板中的变量替换JSON,假如Tts模板中存在变量，则此处必填
    $params["StartTtsParams"] = array("AckNum" => "123456");

    // fixme 必填: 按键与语音文件ID或tts模板的映射关系
    $menuKeyMaps = array (
        array ( // 按下1键, 播放语音
            "Key" => "1",
            "Code" => "9a9d7222-670f-40b0-a3af.wav"
        ),
        array ( // 按下2键, 播放语音
            "Key" => "2",
            "Code" => "44e3e577-3d3a-418f-932c.wav"
        ),
        array ( // 按下3键, 播放TTS语音
            "Key" => "3",
            "Code" => "TTS_71390000",
            "TtsParams" => array("product"=>"aliyun", "code"=>"123")
        ),
    );

    // fixme 可选: 重复播放次数
    $params["PlayTimes"] = 3;

    // fixme 可选: 等待用户按键超时时间，单位毫秒
    $params["Timeout"] = 3000;

    // fixme 可选: 播放结束时播放的结束提示音,支持语音文件和Tts模板2种方式,但是类型需要与StartCode一致，即前者为Tts类型的，后者也需要是Tts类型的
    $params["ByeCode"] = "TTS_71400007";

    // fixme 可选: Tts模板变量替换JSON,当ByeCode为Tts时且Tts模板中带变量的情况下此参数必填
    $params["ByeTtsParams"] = array("product" => "aliyun", "code" => "123");

    // fixme 可选: 预留给调用方使用的ID, 最终会通过在回执消息中将此ID带回给调用方
    $params["OutId"] = "yourOutId";

    // *** 需用户填写部分结束, 以下代码若无必要无需更改 ***

    if(!empty($params["StartTtsParams"]) && is_array($params["StartTtsParams"])) {
        $params["StartTtsParams"] = json_encode($params["StartTtsParams"], JSON_UNESCAPED_UNICODE);
    }

    if(!empty($params["ByeTtsParams"]) && is_array($params["ByeTtsParams"])) {
        $params["ByeTtsParams"] = json_encode($params["ByeTtsParams"], JSON_UNESCAPED_UNICODE);
    }

    $i = 0;
    foreach($menuKeyMaps as $menuKeyMap) {
        ++$i;
        $params["MenuKeyMap." . $i . ".Key"] = $menuKeyMap["Key"];
        $params["MenuKeyMap." . $i . ".Code"] = $menuKeyMap["Code"];
        if(!empty($menuKeyMap["TtsParams"]) && is_array($menuKeyMap["TtsParams"])) {
            $params["MenuKeyMap." . $i . ".TtsParams"] = json_encode($menuKeyMap["TtsParams"], JSON_UNESCAPED_UNICODE);
        }
    }

    // 初始化SignatureHelper实例用于设置参数，签名以及发送请求
    $helper = new SignatureHelper();
    // 此处可能会抛出异常，注意catch
    $content = $helper->request(
        $accessKeyId,
        $accessKeySecret,
        "dyvmsapi.aliyuncs.com",
        array_merge($params, array(
            "RegionId" => "cn-hangzhou",
            "Action" => "IvrCall",
            "Version" => "2017-05-25",
        ))
        // fixme 选填: 启用https
        // ,true
    );

    return $content;
}

/**
 * 通过呼叫ID获取呼叫记录
 */
function queryCallDetailByCallId() {

    $params = array();

    // *** 需用户填写部分 ***

    // fixme 必填: 请参阅 https://ak-console.aliyun.com/ 取得您的AK信息
    $accessKeyId = "your access key id";
    $accessKeySecret = "your access key secret";

    // fixme 必填: 从上次呼叫调用的返回值中获取的CallId
    $params["CallId"] = "113853585007^100675005007";

    // fixme 必填: Unix时间戳（毫秒），会查询这个时间点对应那一天的记录
    $params["QueryDate"] = "1234567890123";

    // fixme 必填: 语音通知为:11000000300006, 语音验证码为:11010000138001, IVR为:11000000300005, 点击拨号为:11000000300004, SIP为:11000000300009
    $params["ProdId"] = "11010000138001";

    // *** 需用户填写部分结束, 以下代码若无必要无需更改 ***

    // 初始化SignatureHelper实例用于设置参数，签名以及发送请求
    $helper = new SignatureHelper();

    // 此处可能会抛出异常，注意catch
    $content = $helper->request(
        $accessKeyId,
        $accessKeySecret,
        "dyvmsapi.aliyuncs.com",
        array_merge($params, array(
            "RegionId" => "cn-hangzhou",
            "Action" => "QueryCallDetailByCallId",
            "Version" => "2017-05-25",
        ))
        // fixme 选填: 启用https
        // ,true
    );

    return $content;
}
/**
 * 文本转语音外呼
 */
function singleCallByTts($accessKeyId,$accessKeySecret,$params) {

    //$params = array ();

    // *** 需用户填写部分 ***

    // fixme 必填: 请参阅 https://ak-console.aliyun.com/ 取得您的AK信息
  //  $accessKeyId = "your access key id";
   // $accessKeySecret = "your access key secret";

    // fixme 必填: 被叫显号
   // $params["CalledShowNumber"] = "4001112222";

    // fixme 必填: 被叫显号
    //$params["CalledNumber"] = "13700000000";

    // fixme 必填: Tts模板Code
    //$params["TtsCode"] = "TTS_10001";

    // fixme 选填: Tts模板中的变量替换JSON,假如Tts模板中存在变量，则此处必填
    //$params["TtsParam"] = array("AckNum" => "123456");

    // fixme 选填: 音量
    $params["Volume"] = 100;

    // fixme 选填: 播放次数
    $params["PlayTimes"] = 3;

    // fixme 选填: 音量, 取值范围 0~200
    $params["Volume"] = 100;

    // fixme 选填: 预留给调用方使用的ID, 最终会通过在回执消息中将此ID带回给调用方
    $params["OutId"] = "123456";

    // *** 需用户填写部分结束, 以下代码若无必要无需更改 ***

    if(!empty($params["TtsParam"]) && is_array($params["TtsParam"])) {
        $params["TtsParam"] = json_encode($params["TtsParam"], JSON_UNESCAPED_UNICODE);
    }

    // 初始化SignatureHelper实例用于设置参数，签名以及发送请求
    $helper = new SignatureHelper();

    // 此处可能会抛出异常，注意catch
    $content = $helper->request(
        $accessKeyId,
        $accessKeySecret,
        "dyvmsapi.aliyuncs.com",
        array_merge($params, array(
            "RegionId" => "cn-hangzhou",
            "Action" => "SingleCallByTts",
            "Version" => "2017-05-25",
        ))
        // fixme 选填: 启用https
        // ,true
    );

    return $content;
}
/**
 * 语音文件外呼
 */
function singleCallByVoice() {

    $params = array ();

    // *** 需用户填写部分 ***

    // fixme 必填: 请参阅 https://ak-console.aliyun.com/ 取得您的AK信息
    $accessKeyId = "your access key id";
    $accessKeySecret = "your access key secret";

    // fixme 必填: 被叫显号
    $params["CalledShowNumber"] = "4001112222";

    // fixme 必填: 被叫显号
    $params["CalledNumber"] = "13700000000";

    // fixme 必填: 语音文件Code
    $params["VoiceCode"] = "c2e99ebc-2d4c-4e78-8d2a-afbb06cf6216.wav";

    // fixme 选填: 音量
    $params["Volume"] = 100;

    // fixme 选填: 播放次数
    $params["PlayTimes"] = 3;

    // fixme 选填: 外呼流水号
    // $params["OutId"] = "yourOutId";

    // *** 需用户填写部分结束, 以下代码若无必要无需更改 ***

    // 初始化SignatureHelper实例用于设置参数，签名以及发送请求
    $helper = new SignatureHelper();

    // 此处可能会抛出异常，注意catch
    $content = $helper->request(
        $accessKeyId,
        $accessKeySecret,
        "dyvmsapi.aliyuncs.com",
        array_merge($params, array(
            "RegionId" => "cn-hangzhou",
            "Action" => "SingleCallByVoice",
            "Version" => "2017-05-25",
        ))
        // fixme 选填: 启用https
        // ,true
    );

    return $content;
}
