<?php
namespace jy_weishop;
defined('BY_JYA') or exit('error');
/*
	门店
*/
class store extends \plugin{
	public function create($params){
		$postdata=$params;
		$wxdata=array(
			'business_name'=>trim($postdata['title']),
			'introduction'=>trim($postdata['desc']),
			'telephone'=>trim($postdata['tel']),
			'address'=>trim($postdata['address']),
			'branch_name'=>trim($postdata['branch_name']),
			'province'=>$postdata['pcd']['province'],
			'city'=>$postdata['pcd']['city'],
			'district'=>$postdata['pcd']['district'],
			'offset_type'=>3,
			'longitude'=>$postdata['lat_lng']['lng'],
			'latitude'=>$postdata['lat_lng']['lat'],
			'photo_list'=>ijson_encode($postdata['hdps']),
			'recommend'=>trim($postdata['recommend']),
			'special'=>trim($postdata['special']),
			'open_time'=>trim($postdata['onlinetime']),
			'avg_price'=>trim($postdata['avg_price']),
			'out_pay'=>$postdata['out_pay'],
			'out_juli'=>$postdata['out_juli'],
			'businessimg'=>trim($postdata['businessimg']),
			'licenseimg'=>trim($postdata['licenseimg']),
			'api_sid'=>trim($postdata['api_sid']),
		);
		$postdata['pcd']=ijson_encode($postdata['pcd']);
		$postdata['onlinetime']=ijson_encode($postdata['onlinetime']);
		$postdata['hdps']=ijson_encode($postdata['hdps']);
		$postdata['lat_lng']=ijson_encode($postdata['lat_lng']);
		$data=array_fields(array('api_sid','businessimg','licenseimg','recommend','special','avg_price','title','logo','pcd','lat_lng','address','tel','type','realname','mobile','onlinetime','hdps','desc','paixu','status','out_pay','out_juli'),$postdata);
		$id=intval($postdata['id']);
		if($id){
			pdo_update('jy_weishop_store',$data,array('id'=>$id,'uniacid'=>$_SESSION['uniacid']));
			$wxdata['sid']=$id;
			model('core/wechat_store')->updatestore($wxdata);
		}else{
			$data['uniacid']=$_SESSION['uniacid'];
			pdo_insert('jy_weishop_store',$data);
			$id=pdo_insertid();
			$wxdata['sid']=$id;
			model('core/wechat_store')->addstore($wxdata);
		}
		return $id;
	}
	public function create_upwechat($params){
		$postdata=$params;
		$postdata['pcd']=array(
			'province'=>$postdata['province'],
			'city'=>$postdata['city'],
			'district'=>$postdata['district'],
		);
		$postdata['pcd']=ijson_encode($postdata['pcd']);
		$postdata['lat_lng']=array('lng'=>$postdata['longitude'],'lat'=>$postdata['latitude']);
		$postdata['lat_lng']=ijson_encode($postdata['lat_lng']);
		$data=array(
			'title'=>trim($postdata['business_name']),
			'desc'=>trim($postdata['introduction']),
			'tel'=>trim($postdata['telephone']),
			'address'=>trim($postdata['address']),
			'pcd'=>$postdata['pcd'],
			'lat_lng'=>$postdata['lat_lng'],
			'hdps'=>ijson_encode($postdata['photo_list']),
			'recommend'=>trim($postdata['recommend']),
			'special'=>trim($postdata['special']),
			'onlinetime'=>trim($postdata['open_time']),
			'avg_price'=>trim($postdata['avg_price']),
			'status'=>1,
		);
		$data['uniacid']=$_SESSION['uniacid'];
		pdo_insert('jy_weishop_store',$data);
		$id=pdo_insertid();
		return $id;
	}
	public function create_towechat($params){
		$postdata=$params;
		$wxdata=array(
			'business_name'=>trim($postdata['title']),
			'introduction'=>trim($postdata['desc']),
			'telephone'=>trim($postdata['tel']),
			'address'=>trim($postdata['address']),
			'branch_name'=>trim($postdata['branch_name']),
			'province'=>$postdata['pcd']['province'],
			'city'=>$postdata['pcd']['city'],
			'district'=>$postdata['pcd']['district'],
			'offset_type'=>3,
			'longitude'=>$postdata['lat_lng']['lng'],
			'latitude'=>$postdata['lat_lng']['lat'],
			'photo_list'=>ijson_encode($postdata['hdps']),
			'recommend'=>trim($postdata['recommend']),
			'special'=>trim($postdata['special']),
			'open_time'=>trim($postdata['onlinetime']),
			'avg_price'=>trim($postdata['avg_price']),
		);
		$wxdata['sid']=$postdata['id'];
		model('core/wechat_store')->addstore($wxdata);
		return true;
	}
	public function out_times($store_id,$post=array()) {
		$store=pdo_get('jy_weishop_store',array('uniacid'=>$_SESSION['uniacid'],'id'=>$store_id));
		$store['onlinetime']=json_decode($store['onlinetime'],true);
		$store['out_pay']=$post['out_pay']?:$store['out_pay'];
		$store['out_pay']=price($store['out_pay']);
		//配送时间
		$days = array(
				0=>date("m-d",time("day")),
				1=>date("m-d",strtotime("+1 day")),
				2=>date("m-d",strtotime("+2 day")), 
				3=>date("m-d",strtotime("+3 day")), 
				4=>date("m-d",strtotime("+4 day")),
				5=>date("m-d",strtotime("+5 day")),
				6=>date("m-d",strtotime("+6 day")),
		);
		$totaytime = strtotime(date('Y-m-d'));
		//配送时间段
		$lasttimebox=0;
		if($post['set_timebox']==1){
			foreach($post['peisong_timebox'] as &$item){
				$start=$daytime.' '.$item['times']['start'];
				$start=strtotime($start);
				$end=$daytime.' '.$item['times']['end'];
				$end=strtotime($end);
				$times[]=array(
					'start' => $item['times']['start'],
					'end' => $item['times']['end'],
					'timestamp' => $end,
					'fee' => 0,
					'timev' =>$item['times']['start'].'~'.$item['times']['end'],
					'out_pay' => $store['out_pay']."元配送费",
				);
				$timestamp[] = $end;
				if($end>$item['yuyue']*60+time()){
					$lasttimebox +=1;
				}
			}
		}else{
			$timestamp = array();
			$daytime=date('Y-m-d');
			if($store['onlinetime']['start']){
				$start=$daytime.' '.$store['onlinetime']['start'];
				$start=strtotime($start);
			}else{
				$start = mktime(8, 0);
			}
			if($store['onlinetime']['end']){
				$end=$daytime.' '.$store['onlinetime']['end'];
				$end=strtotime($end);
			}else{
				$end = mktime(22, 0);
			}
			for($i = $start; $i < $end;) {
					$times[] = array(
						'start' => date('H:i', $i),
						'end' => date('H:i', $i + 1800),
						'timestamp' => $i + 1800,
						'fee' => 0,
						'timev' =>date('H:i', $i).'~'.date('H:i', $i + 1800),
						'out_pay' => $store['out_pay']."元配送费",
					);
					$timestamp[] = $i + 1800;
					$i += 1800;
					if($i + 1800>30*60+time()){
						$lasttimebox +=1;
					}
			}
		}
		$data = array(
			'days' => $days,
			'times' => $times,
			'timestamp' => $timestamp,
			'updatetime' => strtotime(date('Y-m-d')) + 86400,
			'reserve' => 0,
			'lasttimebox' => $lasttimebox,
		);
		return $data;
	}
	/*
		整理获取结束时间下标值
	*/
	public function array_order($value, $array)
	{
		$array[] = $value;
		asort($array);
		$array = array_values($array);
		$index = array_search($value, $array);
		return $array[$index + 1];
	}
	/*
		一键同步更新商品数据
	*/
	public function upgoods($up=false){
		$goods=pdo_getall('jy_weishop_goods',array('uniacid'=>$_SESSION['uniacid'],'merchid'=>0),array('id','price','total'));
		foreach($goods as $item){
			$stores=pdo_getall('jy_weishop_store',array('uniacid'=>$_SESSION['uniacid']),array('id'));			
			foreach($stores as $s){
				$storegoods=pdo_getall('jy_weishop_store_goods',array('uniacid'=>$_SESSION['uniacid'],'storeid'=>$s['id']),array('id','storeid','goodsid'));
				$isadd=false;
				foreach($storegoods as $g){
					if($item['id']==$g['goodsid']){
						$isadd=true;
						break;
					}
					$isgoods=pdo_getcolumn('jy_weishop_goods',array('uniacid'=>$_SESSION['uniacid'],'id'=>$g['goodsid']),'id');
					if(!$isgoods){
						pdo_delete('jy_weishop_store_goods',array('uniacid'=>$_SESSION['uniacid'],'id'=>$g['id']));
					}
					$iscount=pdo_count('jy_weishop_store_goods',array('uniacid'=>$_SESSION['uniacid'],'storeid'=>$s['id'],'goodsid'=>$g['goodsid']),'id');
					if($iscount>1){
						pdo_delete('jy_weishop_store_goods',array('uniacid'=>$_SESSION['uniacid'],'id'=>$g['id']));
					}
				}
				//还没有了该商品
				if($up){
						$data=array(
							'goodsid'=>intval($item['id']),
							'storeid'=>intval($s['id']),
							'total'=>intval($item['total']),
							'price'=>$item['price'],
						);
						pdo_update('jy_weishop_store_goods',$data,array('uniacid'=>$_SESSION['uniacid'],'id'=>$g['id']));
				}elseif(!$isadd){
					$data=array(
						'goodsid'=>intval($item['id']),
						'storeid'=>intval($s['id']),
						'total'=>intval($item['total']),
						'price'=>$item['price'],
					);
					$data['uniacid']=$_SESSION['uniacid'];
					pdo_insert('jy_weishop_store_goods',$data);
				}
			}
		}
		return true;
	}
	/*
		单门店一键同步更新商品数据
	*/
	public function uponestoregoods($storeid,$up=false){
		$goods=pdo_getall('jy_weishop_goods',array('uniacid'=>$_SESSION['uniacid'],'merchid'=>0),array('id','price','total'));
		foreach($goods as $item){
			$storegoods=pdo_getall('jy_weishop_store_goods',array('uniacid'=>$_SESSION['uniacid'],'storeid'=>$storeid),array('id','storeid','goodsid'));
			$isadd=false;
			foreach($storegoods as $g){
					if($item['id']==$g['goodsid']){
						$isadd=true;
						break;
					}
					$isgoods=pdo_getcolumn('jy_weishop_goods',array('uniacid'=>$_SESSION['uniacid'],'id'=>$g['goodsid']),'id');
					if(!$isgoods){
						pdo_delete('jy_weishop_store_goods',array('uniacid'=>$_SESSION['uniacid'],'id'=>$g['id']));
					}
					$iscount=pdo_count('jy_weishop_store_goods',array('uniacid'=>$_SESSION['uniacid'],'storeid'=>$storeid,'goodsid'=>$g['goodsid']),'id');
					if($iscount>1){
						pdo_delete('jy_weishop_store_goods',array('uniacid'=>$_SESSION['uniacid'],'id'=>$g['id']));
					}
			}
			//还没有了该商品
			if(!$isadd){
					$data=array(
						'goodsid'=>intval($item['id']),
						'storeid'=>intval($storeid),
						'total'=>intval($item['total']),
						'price'=>$item['price'],
					);
					$data['uniacid']=$_SESSION['uniacid'];
					pdo_insert('jy_weishop_store_goods',$data);
			}elseif($up){
						$data=array(
							'goodsid'=>intval($item['id']),
							'storeid'=>intval($storeid),
							'total'=>intval($item['total']),
							'price'=>$item['price'],
						);
						pdo_update('jy_weishop_store_goods',$data,array('uniacid'=>$_SESSION['uniacid'],'id'=>$g['id']));
			}
		}
		return true;
	}
	/*
		添加修改商品
	*/
	public function editgoods($params){
		$data=array(
			'goodsid'=>intval($params['id']),
			'storeid'=>intval($params['storeid']),
			'total'=>intval($params['total']),
		);
		if($params['id']){
			$id=intval($params['id']);
			pdo_update('jy_weishop_store_goods',$data,array('id'=>$id,'uniacid'=>$_SESSION['uniacid']));
		}else{
			$data['uniacid']=$_SESSION['uniacid'];
			pdo_insert('jy_weishop_store_goods',$data);
			$id=pdo_insertid();
		}
		return $id;
	}
	/*
		门店库存
	*/
	public function getinfo($goodsid,$storeid){
		$info=pdo_get('jy_weishop_store_goods',array('goodsid'=>$goodsid,'storeid'=>$storeid,'uniacid'=>$_SESSION['uniacid']),array('id','total','price'));
		$info['title']=pdo_getcolumn('jy_weishop_store',array('id'=>$storeid,'uniacid'=>$_SESSION['uniacid']),'title');
		return $info;
	}
	/*
		门店商品规格
	*/
	public function getoption($goodsid,$storeid,$specid='',$optionid=''){
		$params=array('goodsid'=>$goodsid,'storeid'=>$storeid,'uniacid'=>$_SESSION['uniacid']);
		if($specid && !$optionid){
			$optionid=pdo_getcolumn('jy_weishop_goods_option',array('goodsid'=>$goodsid,'specs'=>$specid,'uniacid'=>$_SESSION['uniacid']),'id');
		}
		if($optionid){
			$params['optionid']=$optionid;
		}
		$option=pdo_get('jy_weishop_store_goods_option',$params);
		if($option['optionid']){
			$option['id']=$option['optionid'];
			$sysdata=pdo_get('jy_weishop_goods_option',array('goodsid'=>$goodsid,'id'=>$option['optionid'],'uniacid'=>$_SESSION['uniacid']),array('price','thumb'));
			$option['price']=$option['price']>0?$option['price']:$sysdata['price'];
			$option['thumb']=$sysdata['thumb'];
		}
		return $option;
	}
	//导入门店
	public function excel_stores($rows)
	{
			$num = count($rows);
			$i = 0;
			$colsIndex = array();
			foreach ($rows[1] as $cols => $col) {
				if ($col == 'title') {
					$colsIndex['title'] = $i;
				}

				if ($col == 'sku_barcode') {
					$colsIndex['sku_barcode'] = $i;
				}

				if ($col == 'price') {
					$colsIndex['price'] = $i;
				}

				if ($col == 'num') {
					$colsIndex['num'] = $i;
				}

				if ($col == 'description') {
					$colsIndex['description'] = $i;
				}

				if ($col == 'skuProps') {
					$colsIndex['skuProps'] = $i;
				}

				if ($col == 'picture') {
					$colsIndex['picture'] = $i;
				}

				if ($col == 'propAlias') {
					$colsIndex['propAlias'] = $i;
				}

				++$i;
			}
			$rows = array_slice($rows, 2, count($rows) - 2);
			$items = array();
			$num = 0;
			foreach ($rows as $rownu => $col) {
				$item = array();
				$item['title'] = $col[$colsIndex[title]];
				$item['marketprice'] = $col[$colsIndex[price]];
				$item['total'] = $col[$colsIndex[num]];
				$item['content'] = $col[$colsIndex[description]];
				$item['goodssn'] = $col[$colsIndex[sku_barcode]];
				$item['total'] = $col[$colsIndex[num]];
				$item['image'] = $col[$colsIndex[picture]];
				$item['video'] = $col[$colsIndex[video]];
				$this->create($params);
				$items[] = $item;
				++$num;
			}
			if(!$items[0]['title']){
				exi('上传文件失败：文件格式错误或文件内容为空！','error');
			}
		return true;
	}
}