<?php

defined('BY_JYA') or exit('error');
/*
	促销
*/
$tabs=array(
	array('op'=>'list','title'=>'活动列表'),
	array('op'=>'edit','title'=>'添加/编辑活动'),
	array('op'=>'log','title'=>'活动记录'),
);
set_html('tabs',$tabs);
$_RQ['op']=$_RQ['op']?:'list';
if($_RQ['op']=='list'){
	$params=array('uniacid'=>$_SESSION['uniacid']);
	$return['params']=array('status'=>0);
	if($_RQ['status']){
		$return['params']['status']=$_RQ['status'];
		if($_RQ['status']==1){
			$params['stop']=0;
			$params['start_time >']=TIMESTAMP;
		}elseif($_RQ['status']==2){
			$params['stop']=0;
			$params['start_time <']=TIMESTAMP;
			$params['end_time >']=TIMESTAMP;
		}elseif($_RQ['status']==3){
			$params['stop']=0;
			$params['end_time <']=TIMESTAMP;
		}elseif($_RQ['status']==4){
			$params['stop']=1;
		}
	}
	if($_RQ['goods_id']){
		$params['goods_id']=intval($_RQ['goods_id']);
		$return['params']['goods_id']=$_RQ['goods_id'];
	}
	if($_RQ['title']){
		$params['title like']=trim($_RQ['title']);
		$return['params']['title']=$_RQ['title'];
	}
	$parameter=array(
		'params'=>$params,
		'limit'=>array(intval($_RQ['page'])?:1,10),
	);
	$list=$this->get_list('activity_limit',$parameter,$total);
	if($list){
		foreach($list as &$item){
			$item['goods']=$this->model('goods')->goods_detail($item['goods_id'],array('title','image'));
			if($item['stop']){
				$item['status']='4';
			}elseif($item['start_time']>TIMESTAMP){
				$item['status']='1';
			}elseif($item['end_time']<TIMESTAMP){
				$item['status']='3';
			}else{
				$item['status']='2';
			}
		}
	}
	$return['list']=$list;
	$totalpage=ceil($total/$psize);
	$totalpage=intval($totalpage);
	$return['totalpage'] =$totalpage;
	$return['params']['page'] =$pindex;
	$htmls=array(
		'type'=>'list',
		'list'=>array('data'=>'list','list'=>array(
			array('name'=>'goods.title','title'=>'活动商品','type'=>'string'),
			array('name'=>'goods.image','title'=>'商品图片','type'=>'image'),
			array('name'=>'start_time','title'=>'开始时间','type'=>'time'),
			array('name'=>'end_time','title'=>'结束时间','type'=>'time'),
			array('name'=>'price','title'=>'限时卖价','type'=>'string'),
			array('name'=>'num','title'=>'每人可参与次数','type'=>'string'),
			array('name'=>'status','title'=>'活动状态','type'=>'radio','options'=>'statuss'),
			array('name'=>'createtime','title'=>'活动创建时间','type'=>'time'),
		),'action'=>array(
			array('type'=>'post','op'=>'stop','title'=>'关闭','show'=>array('stop'=>0)),
			array('type'=>'href','op'=>'log','title'=>'活动记录'),
		)),
		'search'=>array(
			array('type'=>'string','width'=>15,'name'=>'title','title'=>'活动商品'),
			array('type'=>'select','width'=>15,'name'=>'status','title'=>'活动状态','options'=>'statuss2'),
			array('type'=>'choose','width'=>18,'action'=>'jy_weishop/goods.get_goods/','name'=>'goods_id','title'=>'选择商品'),
		),
	);
	$return['htmls']=$htmls;
	$return['statuss']=array(
		'0'=>'全部',
		'1'=>'未开始',
		'2'=>'进行中',
		'3'=>'已结束',
		'4'=>'已关闭',
	);
	$return['statuss2']=array(
		array('id'=>0,'title'=>'全部',),
		array('id'=>1,'title'=>'未开始',),
		array('id'=>2,'title'=>'进行中',),
		array('id'=>3,'title'=>'已结束',),
		array('id'=>4,'title'=>'已关闭',),
	);
	exi($return);
	
}
if($_RQ['op']=='edit'){
	if($_RQ['postdata']){
		$post=get_postdata();
		$data=array(
			'title'=>trim($post['title']),
			'goods_id'=>intval($post['goods_id']),
			'start_time'=>strtotime($post['start_time']),
			'end_time'=>strtotime($post['end_time']),
			'price'=>price($post['price']),
			'num'=>intval($post['num']),
			'total'=>intval($post['total']),
		);
		$id=intval($post['id']);
		if($id){
			$this->update('activity_limit',$data,array('id'=>$id,'uniacid'=>$_SESSION['uniacid']));
			$this->model('activity')->create_active($data['goods_id'],$id,'limit');
		}else{
			if($this->model('activity')->check_active($data['goods_id'])){
				exi('商品已存在活动，请勿重复添加！','error');
			}
			$optionsid=pdo_count('jy_weishop_goods_option',array('goodsid'=>$data['goods_id']),'id');
			if($optionsid){
				exi('多规格商品不支持定价活动，只能参与折扣活动！','error');
			}
			$data['uniacid']=$_SESSION['uniacid'];
			$data['createtime']=TIMESTAMP;
			$this->insert('activity_limit',$data);
			$id=$this->insertid();
			$this->model('activity')->create_active($data['goods_id'],$id,'limit');
		}
		exi('设置成功！','','list');
	}
	$id = intval($_RQ['id']);
	if($id){
		$item=pdo_get('jy_weishop_activity_limit',array('id'=>$id,'uniacid'=>$_SESSION['uniacid']));
		$item['nowprice']=pdo_getcolumn('jy_weishop_goods',array('id'=>$item['goods_id'],'uniacid'=>$_SESSION['uniacid']),'price');
		$item['choose'] = 0;
		$item['start_time'] =$item['start_time']?date('Y/m/d H:i',$item['start_time']):'';
		$item['end_time'] =$item['end_time']?date('Y/m/d H:i',$item['end_time']):'';
	}else{
		$item=array();
		$item['choose'] = 1;
	}
	$return['item']=$item;
	$htmls=array(
		'type'=>'edit',
		'post'=>false,
		'desc'=>'设置活动详情',
		'edit'=>array(
			array('name'=>'title','title'=>'活动名称','type'=>'string'),
			array('type'=>'choose','action'=>'jy_weishop/goods.get_goods/','name'=>'goods_id','title'=>'活动商品ID','show'=>array('choose'=>1)),
			array('name'=>'goods_id','title'=>'活动商品ID','type'=>'string','read'=>true,'show'=>array('choose'=>0),'help'=>'只有新添加活动,才能选择商品ID'),
			array('name'=>'start_time','title'=>'开始时间','type'=>'time'),
			array('name'=>'end_time','title'=>'结束时间','type'=>'time'),
			array('name'=>'price','title'=>'活动价','type'=>'string','help'=>''),
			array('name'=>'total','title'=>'库存','type'=>'string'),
			array('name'=>'num','title'=>'每人可参与次数','type'=>'string'),
		),
	);
	$return['htmls']=$htmls;
	exi($return);
}
if($_RQ['op']=='del'){
	model('core/php_ctrl')->del(array(
		'tablename'=>$this->tablename('activity_limit'),
	));
}
if($_RQ['op']=='stop'){
	$id=intval($_RQ['id']);
	if(!$id){
		exi('请先选择活动！','error');
	}
	$item=$this->get('activity_limit',array('id'=>$id,'uniacid'=>$_SESSION['uniacid']));
	if(!$item){
		exi('指定活动不存在~','error');
	}
	$this->model('activity')->del_active($item['goods_id'],$id,'limit');
	$this->update('activity_limit',array('stop'=>1),array('id'=>$id,'uniacid'=>$_SESSION['uniacid']));
	exi('活动关闭成功！','','list');
}
if($_RQ['op']=='log'){
	$params=array('uniacid'=>$_SESSION['uniacid']);
	if($_RQ['active_id']){
		$params['active_id']=intval($_RQ['active_id']);
	}
	$return['params']=array();
	if($_RQ['goods_id']){
		$params['goods_id']=intval($_RQ['goods_id']);
		$return['params']['goods_id']=$_RQ['goods_id'];
	}
	if($_RQ['mid']){
		$params['mid']=intval($_RQ['mid']);
		$return['params']['mid']=$_RQ['mid'];
	}
	$parameter=array(
		'params'=>$params,
		'limit'=>array(intval($_RQ['page'])?:1,10),
	);
	$list=$this->get_list('activity_limit_log',$parameter,$total);
	if($list){
		foreach($list as &$item){
			$item['goods']=$this->model('goods')->goods_detail($item['goods_id'],array('title','image'));
			$item['member']=cfc('core')->member_show($item['mid']);
		}
	}
	$return['list']=$list;
	$totalpage=ceil($total/$psize);
	$totalpage=intval($totalpage);
	$return['totalpage'] =$totalpage;
	$return['params']['page'] =$pindex;
	$htmls=array(
		'type'=>'list',
		'list'=>array('data'=>'list','edit'=>false,'del_one'=>false,'delall'=>false,'list'=>array(
			array('name'=>'member','title'=>'会员','type'=>'member'),
			array('name'=>'goods.title','title'=>'商品标题','type'=>'string'),
			array('name'=>'goods.image','title'=>'商品图片','type'=>'image'),
			array('name'=>'ordersn','title'=>'订单号','type'=>'string'),
			array('name'=>'num','title'=>'购买数量','type'=>'string'),
			array('name'=>'price','title'=>'购买单价','type'=>'string'),
			array('name'=>'createtime','title'=>'下单时间','type'=>'time'),
		)),
		'search'=>array(
			array('type'=>'choose','width'=>18,'action'=>'core/member.get_member/','name'=>'mid','title'=>'选择会员'),
			array('type'=>'choose','width'=>18,'action'=>'jy_weishop/goods.get_goods/','name'=>'goods_id','title'=>'选择商品'),
		),
	);
	$return['htmls']=$htmls;
	exi($return);
}