<?php
/*
	文件下载接口
	下载任务数据表
CREATE TABLE IF NOT EXISTS `ims_core_cloud_download` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `type` tinyint(1) unsigned NOT NULL,2表示下载插件，4表示更新插件，9表示下载其他
  `parts` tinyint(3) unsigned NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `complete` tinyint(1) unsigned NOT NULL,
  `complete_time` int(10) unsigned NOT NULL,
  `zipfile` char(30) NOT NULL,
  `remark` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;
*/
defined('BY_JYA') or exit('Access Denied');
$id=intval($_RQ['id']);
if(!$id){
	eci('请先选择下载任务！','error');
}
$download=pdo_get('core_cloud_download',array('id'=>$id));
if(!$download){
	eci('下载任务不存在！','error');
}
if($download['complete']){
	eci('下载任务已完成！','error');
}
$zipname=ROOT_AT.$download['zipfile'];
if(!is_file($zipname)){
	eci('下载对象不存在！','error');
}
$part=intval($_RQ['part']);
if(!$part){
	eci('请选择要下载的part！','error');
}
if($part>$download['parts']){
	eci('part参数错误！','error');
}
$size=$download['size'];
if(!$size){
	$size=1*1024*1024;
}
$update=array('num +='=>1);
$num=pdo_getcolumn('core_cloud_download',array('id'=>$id),'num');
if($num>=($download['parts']-1)){
	$update['complete']=1;
	$update['complete_time']=TIMESTAMP;
}
pdo_update('core_cloud_download',$update,array('id'=>$id));
$data=file_get_contents($zipname,'',null,($part-1)*$size,$size);
$del_types=array(3,4);
if($update['complete'] && in_array($download['type'],$del_types)){
	//下载完需要删除的，此处删除临时文件
	@unlink($zipname);
}
exit($data);
