<?php
namespace core;
defined('BY_JYA') or exit('error');
class bbs_release{
	private $_db = null;
	private $fid = null;
	private $title = null;
	private $content = null;
	private $author = null;
	private $author_id = null;
	private $current_time = null;
	private $displayorder = null; //0:正常，-2:待审核
	public function __construct($config){
		$this->_db = new \DB($config);
	}
	public function post($fid, $title, $content, $author, $author_id, $displayorder = -2){
		$this->fid		  = $fid;
		$this->title		= $title;
		$this->content	  = $content;
		$this->author	   = $author;
		$this->author_id	= $author_id;
		$this->current_time = time();
		$this->displayorder = $displayorder;
		$tid = $this->do_pre_forum_thread();
		if(!$tid){
			return error('更新表 pre_forum_thread 失败');
		}
		$pid = $this->do_pre_forum_post_tableid();
		if(!$this->do_pre_forum_post($pid, $tid)){
			return error('更新表 pre_forum_post 失败');
		}
		if(!$this->do_pre_forum_forum()){
			return error('更新表 pre_forum_forum 失败');
		}
		if($this->displayorder == -2){
			if(!($this->do_pre_forum_thread_moderate($tid))){
				return error('更新表 pre_forum_thread_moderate 失败');
			}
		}
		return ($this->do_pre_common_member_count()) ? '发帖成功' : error('更新表 pre_pre_common_member_count');
	}
	private function do_pre_forum_thread(){
		$data				 = array();
		$data['fid']		  = $this->fid;
		$data['author']	   = $this->author;
		$data['authorid']	 = $this->author_id;
		$data['subject']	  = $this->title;
		$data['dateline']	 = $this->current_time;
		$data['lastpost']	 = $this->current_time;
		$data['lastposter']   = $this->author;
		$data['displayorder'] = $this->displayorder;
		$result = $this->_db->insert('forum_thread', $data);
		if($result == 1){
			$tid = $this->_db->insertid();
		}
		return $tid;
	}
	private function do_pre_forum_post_tableid(){
		$result = $this->_db->query('INSERT INTO `pre_forum_post_tableid`(`pid`) VALUES(NULL)');
		if($result == 1){
			$pid = $this->_db->insertid();
		}
		return $pid;
	}
	private function do_pre_forum_post($pid, $tid){
		$data			 = array();
		$data['pid']	  = $pid;
		$data['fid']	  = $this->fid;
		$data['tid']	  = $tid;
		$data['first']	= 1;
		$data['author']   = $this->author;
		$data['authorid'] = $this->author_id;
		$data['subject']  = $this->title;
		$data['dateline'] = $this->current_time;
		$data['message']  = $this->content;
		$result = $this->_db->insert('forum_post', $data);
		return ($result == 1) ? true : false;
	}
	private function do_pre_forum_forum(){
		$result = $this->_db->update('forum_forum',array('threads +='=>1,'posts +='=>1,'todayposts +='=>1),array('fid'=>$this->fid));
		return ($result == 1) ? true : false;
	}
	private function do_pre_forum_thread_moderate($tid){
		$data			 = array();
		$data['tid']	  = $tid;
		$data['status']   = 0;
		$data['dateline'] = $this->current_time;
		$result = $this->_db->insert('forum_thread_moderate', $data);
		return ($result == 1) ? true : false;
	}
	private function do_pre_common_member_count(){
		$result = $this->_db->update('common_member_count',array('threads +='=>1),array('uid'=>$this->author_id));
		return ($result == 1) ? true : false;
	}
}