<?php
/*
 * [JINYUN!] (C)2001-2099 Jinyunweb.com
 * This is NOT a freeware, use is subject to license terms
 * $Id: 2017-12-13 03:39:35 apple $
*/
namespace core;
defined('BY_JYA') or exit('error');
class develop{
	public function appreplace($path,$type=''){
		$files=cfc('files')->file_tree($path);
		foreach($files as $file){
			if(is_file($path.$file)){
				$data=file_get_contents($path.$file);
				if(strpos($file,'_wxauth.wxml')!== false){
					if($type=='aliapp'){
						$data=str_replace('bindgetuserinfo=','onGetAuthorize=',$data);
						$data=str_replace('open-type="getUserInfo"','open-type="getAuthorize" onError="closeAuthM" scope="userInfo"',$data);
					}else{
						$data=str_replace('bindgetuserinfo=','bindtap=',$data);
					}
				}
				$pathinfo=pathinfo($path.$file);
				if($pathinfo['extension']=='wxml'){
					$data=$this->apphtml($data,$type);
					$newfile=str_replace('wxml','',$path.$file);
					if($type=='ttapp'){
						//抖音又不支持wxml
						unlink($path.$file);
						file_put_contents($newfile.'ttml',$data);
					}elseif($type=='aliapp'){
						unlink($path.$file);
						if(strpos($file,'_navigation-bar.wxml')!== false){
							file_put_contents($newfile.'axml','<!--no-->');
						}elseif(strpos($file,'/pages/_menu.wxml')!== false){
							file_put_contents($newfile.'axml','<include src="/pages/_menu_ali.axml"/>');
						}else{
							file_put_contents($newfile.'axml',$data);
						}
					}elseif($type=='baiduapp'){
						unlink($path.$file);
						file_put_contents($newfile.'swan',$data);
					}
					
				}elseif($pathinfo['extension']=='wxss'){
					if((strpos($file,'/app.wxss')!== false) && $type=='aliapp'){
						$data=str_replace("image{width:100%;height:100%;}"," ",$data);
						$data=str_replace("--topbarheight:150rpx","--topbarheight:0",$data);
					}
					$data=$this->appcss($data,$type);
					
					$newfile=str_replace('wxss','',$path.$file);
					if($type=='ttapp'){
						//抖音又不支持wxss
						unlink($path.$file);
						file_put_contents($newfile.'ttss',$data);
					}elseif($type=='aliapp'){
						unlink($path.$file);
						file_put_contents($newfile.'acss',$data);
					}elseif($type=='baiduapp'){
						unlink($path.$file);
						file_put_contents($newfile.'css',$data);
					}
				}elseif($pathinfo['extension']=='js'){
					if((strpos($file,'/app.js')!== false) && $type=='aliapp'){
						$data=str_replace("('resource/js","('/resource/js",$data);
					}
					if((strpos($file,'/util.js')!== false) && $type=='aliapp'){
						$data=str_replace('res.code','res.authCode',$data);
						$data=str_replace("('base64.js","('/resource/js/base64.js",$data);
						$data=str_replace("('jinyun_socket.js","('/resource/js/jinyun_socket.js",$data);
						$data=str_replace("('md5.js","('/resource/js/md5.js",$data);
					}
					if((strpos($file,'/tabbar/tabbar.js')!== false) && $type=='aliapp'){
						$data=str_replace("attached: function attached()","didMount ()",$data);
						$data=str_replace("this.triggerEvent","//this.triggerEvent",$data);
					}
					$data=$this->appjs($data,$type);
					file_put_contents($path.$file,$data);
				}elseif($type!='wxapp' && (strpos($file,'components/')=== false) && $pathinfo['extension']=='json' && $file!='/app.json' && $file!='/project.config.json' && $file!='/sitemap.json'){
					$data='
{
		"usingComponents": {
				"mp-badge": "/components/badge/badge",
				"base-modal" : "/components/base-modal/index",
				"jy-modal": "/components/jy-modal/index",
				"mp-navigation-bar": "/components/navigation-bar/navigation-bar",
				"mp-tabbar": "/components/tabbar/tabbar"
		}
}';
					file_put_contents($path.$file,$data);
				}
			}
		}
				
		return true;
	}
	public function apphtml($html,$type=''){
		if($type=='ttapp'){
			//抖音已支持wx
			$html=str_replace('wx:if','tt:if',$html);
			$html=str_replace('wx:elif','tt:elif',$html);
			$html=str_replace('wx:else','tt:else',$html);
			$html=str_replace('wx:for','tt:for',$html);
			$html=str_replace('wx:for-index','tt:for-index',$html);
			$html=str_replace('wx:for-item','tt:for-item',$html);
			$html=str_replace('wx:key','tt:key',$html);
			$html=str_replace('.wxml','.ttml',$html);
		}elseif($type=='aliapp'){
			$html=str_replace('wx:if','a:if',$html);
			$html=str_replace('wx:elif','a:elif',$html);
			$html=str_replace('wx:else','a:else',$html);
			$html=str_replace('wx:for','a:for',$html);
			$html=str_replace('wx:for-index','a:for-index',$html);
			$html=str_replace('wx:for-item','a:for-item',$html);
			$html=str_replace('wx:key','a:key',$html);
			$html=str_replace('bindtap=','onTap=',$html);
			$html=str_replace('.wxml','.axml',$html);
			$html=str_replace('<i ','<text ',$html);
			$html=str_replace('<i>','<text>',$html);
			$html=str_replace('</i>','</text>',$html);
			$html=str_replace('<span>','<text>',$html);
			$html=str_replace('<span ','<text ',$html);
			$html=str_replace('</span>','</text>',$html);
			$html=str_replace('<a ','<text ',$html);
			$html=str_replace('<a>','<text>',$html);
			$html=str_replace('</a>','</text>',$html);
			$html=str_replace('<p ','<text ',$html);
			$html=str_replace('<p>','<text>',$html);
			$html=str_replace('</p>','</text>',$html);
			$html=str_replace('<include src="/pages/_menu.wxml"/>','<mp-tabbar iconimg="{{false}}" list="{{pluginnav}}"></mp-tabbar>',$html);
		}elseif($type=='baiduapp'){
			$html=str_replace('wx:if','s-if',$html);
			$html=str_replace('wx:elif','s-elif',$html);
			$html=str_replace('wx:else','s-else',$html);
			$html=str_replace('wx:for','s-for',$html);
			$html=str_replace('wx:for-index','s-for-index',$html);
			$html=str_replace('wx:for-item','s-for-item',$html);
			$html=str_replace('wx:key','s-key',$html);
			$html=str_replace('.wxml','.swan',$html);
		}		
		return $html;
	}
	public function appjs($jsdata,$type=''){
		$key_str='ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
		if($type=='ttapp'){
			$jsdata=str_replace('wx.showNavigationBarLoading','//wx.showNavigationBarLoading',$jsdata);
			$jsdata=str_replace('wx.hideNavigationBarLoading','//wx.hideNavigationBarLoading',$jsdata);
			$jsdata=str_replace('wx.getMenuButtonBoundingClientRect','wx.getMenuButtonLayout',$jsdata);
			$jsdata=str_replace('wx.','tt.',$jsdata);
			//一些误替换，恢复
			for($i=0;$i<strlen($key_str);$i++){//遍历字符串恢复
				$jsdata=str_replace($key_str[$i].'tt.',$key_str[$i].'wx.',$jsdata);
			}
		}elseif($type=='aliapp'){
			$jsdata=str_replace('wx.','my.',$jsdata);
			$jsdata=str_replace('my.showNavigationBarTitle','my.showNavigationBarLoading',$jsdata);
			$jsdata=str_replace('my.setNavigationBarTitle','my.setNavigationBar',$jsdata);
			$jsdata=str_replace('app.fansinfo','//app.fansinfo',$jsdata);
			$jsdata=str_replace('my.login','my.getAuthCode',$jsdata);
			$jsdata=str_replace('my.showModal','my.confirm',$jsdata);
			//一些误替换，恢复
			for($i=0;$i<strlen($key_str);$i++){//遍历字符串恢复
				$jsdata=str_replace($key_str[$i].'my.',$key_str[$i].'wx.',$jsdata);
			}
		}elseif($type=='baiduapp'){
			$jsdata=str_replace('wx.','swan.',$jsdata);
			//一些误替换，恢复
			for($i=0;$i<strlen($key_str);$i++){//遍历字符串恢复
				$jsdata=str_replace($key_str[$i].'swan.',$key_str[$i].'wx.',$jsdata);
			}
		}
		
		return $jsdata;
	}
	public function appcss($css,$type=''){
		if($type=='ttapp'){
			//抖音已支持wxss
			$css=str_replace('.wxss','.ttss',$css);
		}elseif($type=='aliapp'){
			$css=str_replace('.wxss','.acss',$css);
		}elseif($type=='baiduapp'){
			$css=str_replace('.wxss','.css',$css);
		}		
		return $css;
	}
	//H5开始
	public function h5replace($path,$type=''){
		$files=cfc('files')->file_tree($path);
		foreach($files as $file){
			if(is_file($path.$file)){
				$data=file_get_contents($path.$file);
				$pathinfo=pathinfo($path.$file);
				if($pathinfo['extension']=='html'){
					$data=$this->h5html($data,$type);
					$newfile=str_replace('html','',$path.$file);
					unlink($path.$file);
					file_put_contents($newfile.'wxml',$data);	
				}elseif($pathinfo['extension']=='css'){
					$data=$this->h5css($data,$type);
					$newfile=str_replace('css','',$path.$file);
					unlink($path.$file);
					file_put_contents($newfile.'wxss',$data);
				}
			}
		}				
		return true;
	}
	public function h5html($html,$type=''){
		$html=str_replace('.html','.wxml',$html);	
		$html=str_replace('<div','<view',$html);	
		$html=str_replace('</div','</view',$html);	
		$html=str_replace('.css','.wxss',$html);
		$html=str_replace('<div ng-include="','<include src="',$html);
		$html=str_replace('ng-if','wx:if',$html);
		$html=str_replace('ng-repeat','wx:for',$html);
		return $html;
	}
	public function h5css($css,$type=''){
		$css=str_replace('.css','.wxss',$css);	
		return $css;
	}
	//插件生成小程序
	public function pluginapp($name,$wxapp_id,$index_page=''){
		$index_page=$index_page?:$name.'/index/';
		$dir=ROOT_PLUGIN.$name;
		if(!is_dir($dir)){
			exit('插件不存在！');
		}
		$temp_dir=ROOT_AT.'temp/'.random(30);mkdir($temp_dir);		
		//第一步，将小程序包拷贝入临时文件夹
		cfc('files')->file_copy(ROOT_D.'/core/resource/wxapp/wxapp_template',$temp_dir);
		
		//第二步，遍历插件目录，生成页面文件
		$actions=cfc('files')->file_tree($dir.'/custom/actions',array(),'.php');
		$pages=array();
		foreach($actions as $action_file){
			$action=substr($action_file,1,-4);
			if($action=='init'){
				continue;
			}
			$pages[]="\t\t\"{$name}/{$action}/index\",";
			$page_dir=$temp_dir.'/'.$name.'/'.$action;
			cfc('files')->mkdirs($page_dir);
			cfc('files')->file_copy(ROOT_D.'/core/resource/wxapp/page_template',$page_dir);
			$page_html_file=$dir.'/custom/templates/mobile/'.$action.'.html';
			if(is_file($page_html_file)){
				$bar='<include src="/pages/_navigation-bar.wxml"/>';
				$page_data=file_get_contents($page_html_file);
				$page_data=$bar.$page_data;
				//替换<div </div
				$page_data=str_replace('<div','<view',$page_data);
				$page_data=str_replace('</div','</view',$page_data);
				//赋值action
				$pagejs_data=file_get_contents($page_dir.'/index.js');
				$pagejs_data=str_replace('{action}',$action,$pagejs_data);
				file_put_contents($page_dir.'/index.js',$pagejs_data);
				file_put_contents($page_dir.'/index.wxml',$page_data);
			}
		}
		$pages=implode("\n",$pages);
		$window=ijson_encode(array('navigationStyle'=>'custom'));
		$app_json=file_get_contents($temp_dir.'/app.json');
		$app_json=str_replace('{pages}',$pages,$app_json);
		$app_json=str_replace('{window}',$window,$app_json);
		file_put_contents($temp_dir.'/app.json',$app_json);
		$wxapp=pdo_get('core_account_wxapp',array('id'=>$wxapp_id));
		//全局样式
		$wxapp['syscolor']=$wxapp['syscolor']?:'#18bc9c';
		$css_json=file_get_contents($temp_dir.'/app.wxss');
		$css_json=str_replace('{syscolor}',$wxapp['syscolor'],$css_json);
		file_put_contents($temp_dir.'/app.wxss',$css_json);
		$setting=array(
			'index_url'=>SITEROOT."custom/index.php?i={$_SESSION['uniacid']}&wxgid={$wxapp_id}",
			'api_url'=>SITEROOT."api.php?this=custom",
			'att_url'=>ATTACHMENT_URL,
			'siteroot'=>SITEROOT,
			'uniacid'=>$_SESSION['uniacid'],
			'wxgid'=>$wxapp_id,
			'title'=>$wxapp['title'],
			'sharetitle'=>$wxapp['title'],
			'sharedesc'=>$wxapp['title'],
		);
		$app_js=file_get_contents($temp_dir.'/app.js');
		$app_js=str_replace(array('{index_page}','{setting}','{plugin_name}'),array($index_page,ijson_encode($setting),$name),$app_js);
		file_put_contents($temp_dir.'/app.js',$app_js);
		do{
			$zip=ROOT_AT.'temp/'.random(10).'.temp';
		}while(is_file($zip));
		return $temp_dir;
	}
}