<?php
/*
 * [JINYUN!] (C)2001-2099 Jinyunweb.com
 * This is NOT a freeware, use is subject to license terms
 * $Id: 2017-12-13 03:39:35 apple $
*/
namespace core;
defined('BY_JYA') or exit('error');
/*
	统计图表生成
*/
class echart{
	/*
		饼状图
		自动统计指定数据表中的数据，以特定字段值作为分类依据，生成饼状图
		$params=array(
			'title'=>'测试饼状图',
			'tablename'=>'tablename',
			'width'=>'50%',
			'field'=>'status',
			'field_options'=>array(
				'1'=>'状态1',
				'2'=>'状态2',
			),
			'params'=>array('uniacid'=>$_SESSION['uniacid']),
		);
	*/
	public function pie($params){
		if(!$params['params']){
			$params['params']=array('uniacid'=>$_SESSION['uniacid']);
		}
		$params['width']=$params['width']?:'50%';
		$params['title']=$params['title']?:'饼状图';
		$params['field']=$params['field']?:'status';
		$data=array();
		$legend=array();
		$parameter=$params['params'];
		foreach($params['field_options'] as $key=>$value){
			$parameter[$params['field']]=$key;
			if($params['sum_field']){
				$res=pdo_getsum($params['tablename'],$parameter,$params['sum_field']);
			}else{
				$res=pdo_count($params['tablename'],$parameter);
			}
			$data[]=array('name'=>$value,'value'=>$res);
			$legend[]=$value;
		}
		$options=array(
			'title'=>array('text'=>$params['title'],'subtext'=>date('Y/m/d H:i:s')),
			'tooltip'=>array('trigger'=>'item','formatter'=>'{a} <br/>{b} : {c} ({d}%)'),
			'legend'=>array('orient'=>'vertical','x'=>'right','data'=>$legend),
			'calculable'=>!0,
			'series'=>array(
				array('name'=>$params['title'],'radius'=>'55%','type'=>'pie','data'=>$data),
			),
		);
		return array(
			'title'=>$params['title'],
			'type'=>'echarts',
			'one_num'=>2,
			'width'=>$params['width'],
			'name'=>random(10),
			'options'=>$options
		);
	}
	/*
		基于时间周期的统计趋势折线图，直接从相应数据表中读取数据并渲染
		data数组中，如果指明sum_field，表示统计字段和
		$params=array(
			'title'=>'测试图',
			'y_title'=>'数量',
			'type'=>'month',
			'data'=>array(
				'分销佣金'=>array('tablename'=>'jy_commission_commission','time_field'=>'createtime','sum_field'=>'money'),
			),
		);
	*/
	public function line($params){
		//整理数据
		if(!$params['data']){
			return array();
		}
		$params['title']=$params['title']?:'折线图';
		if($params['data']['tablename']){
			$params['data']=array($params['title']=>$params['data']);
		}
		$types=array('month','day');
		$type=$params['type']?:'month';
		$type=in_array($type,$types)?$type:'month';
		if($type=='month'){
			$time_type='days';
			$num=30;
		}else{
			$time_type='hours';
			$num=24;
		}
		
		//近三十天订单走势
		$day_times=array();
		for($i=$num;$i>0;$i--){
			$day_times[]=strtotime('-'.$i.' '.$time_type);
		}
		if($type=='month'){
			$day_times[]=strtotime(date('Ymd'));
		}else{
			$day_times[]=strtotime(date('YmdH'));
		}
		
		$order_logs=array();
		$commission_logs=array();
		$dates=array();
		$datas=array();
		for($i=0;$i<$num;$i++){
			if($type=='month'){
				$dates[]=date('Ymd',$day_times[$i]);
			}else{
				$dates[]=date('d\H',$day_times[$i]);
			}
			foreach($params['data'] as $key=>$value){
				$time_field=$value['time_field']?:'createtime';
				$value['params']=$value['params']?:array('uniacid'=>$_SESSION['uniacid']);
				$value['params'][$time_field.' between']=array($day_times[$i],$day_times[$i+1]);
				if($value['sum_field']){
					$res=pdo_getsum($value['tablename'],$value['params'],$value['sum_field']);
				}else{
					
					$res=pdo_count($value['tablename'],$value['params']);
				}
				$res=$res?:0;
				$datas[$key][]=$res;
			}
		}
		$markPoint=array('data'=>array(
			array('type'=>'min','name'=>'最小值'),
			array('type'=>'max','name'=>'最大值')
		));
		$options=array(
			'title'=>array('text'=>$params['title']),
			'tooltip'=>array('trigger'=>'axis'),
			'legend'=>array('data'=>array_keys($datas),'textStyle'=>array('color'=>'auto')),
			//'grid'=>array('x'=>40,'x2'=>40,'y2'=>24),
			//'calculable'=>true,
			'xAxis'=>array(
				array('type'=>'category','boundaryGap'=>false,'data'=>$dates),
			),
			'yAxis'=>array(
				array('name'=>$params['y_title']?:'数量','type'=>'value'),
			),
			'series'=>array(),
		);
		foreach($datas as $key=>$value){
			$options['series'][]=array('name'=>$key,'type'=>'line','data'=>$value);
		}
		return array('type'=>'echarts','name'=>random(10),'options'=>$options);
	}
	//柱状图
	public function bar($params){
		//整理数据
		
		if(!$params['field_options']){
			return array();
		}
		$params['params']=$params['params']?:array('uniacid'=>$_SESSION['uniacid']);
		$params['title']=$params['title']?:'柱状图';
		$params['field_options']['params']=$params['field_options']['params']?:array('uniacid'=>$_SESSION['uniacid']);
		$params['field_options']['option_value']=$params['field_options']['option_value']?:'id';
		$params['field_options']['option_title']=$params['field_options']['option_title']?:'title';
		$option_data=pdo_getall($params['field_options']['tablename'],$params['field_options']['params'],array($params['field_options']['option_value'],$params['field_options']['option_title']));
		if(!$option_data){
			return array();
		}
		$x_data=array();
		$data=array();
		$parameter=$params['params'];
		foreach($option_data as $item){
			$parameter[$params['field']]=$item[$params['field_options']['option_value']];
			if($params['sum_field']){
				$res=round(pdo_getsum($params['tablename'],$parameter,$params['sum_field']),2);
			}else{
				$res=intval(pdo_count($params['tablename'],$parameter));
			}
			
			$data[]=$res;
			$x_data[]=$item[$params['field_options']['option_title']];
		}
		$markPoint=array('data'=>array(
			array('type'=>'min','name'=>'最小值'),
			array('type'=>'max','name'=>'最大值')
		));
		$markLine=array('data'=>array(
			array('type'=>'average','name'=>'平均值'),
		));
		$options=array(
			'title'=>array('text'=>$params['title']),
			'tooltip'=>array('trigger'=>'axis'),
			//'legend'=>array('data'=>array(),'textStyle'=>array('color'=>'auto')),
			//'grid'=>array('x'=>40,'x2'=>40,'y2'=>24),
			'calculable'=>true,
			'toolbox'=>array(
				'show'=>true,
				'feature'=>array(
					'saveAsImage'=>array('show'=>true),
				),
			),
			'xAxis'=>array(
				array('type'=>'category','boundaryGap'=>true,'data'=>$x_data,'axisLabel'=>array('interval'=>0,'rotate'=>10)),
			),
			'yAxis'=>array(
				array('name'=>$params['y_title']?:'数量','type'=>'value'),
			),
			'series'=>array(),
		);
		$options['series'][]=array('name'=>$params['title'],'type'=>'bar','data'=>$data,'markPoint'=>$markPoint,'markLine'=>$markLine,'itemStyle'=>array('normal'=>array('label'=>array('show'=>true,'position'=>'top'))));
		return array('type'=>'echarts','name'=>random(10),'options'=>$options);
	}
}