<?php
/*
 * [JINYUN!] (C)2001-2099 Jinyunweb.com
 * This is NOT a freeware, use is subject to license terms
 * $Id: 2017-12-13 03:39:35 apple $
*/
namespace core;
defined('BY_JYA') or exit('error');
class operator{
	//添加操作员
	public $operator_types=array(1,2,4);
	public function create_operator($operator){
		if(!$operator['name']){
			exi('添加操作员失败！未设置操作员昵称！','error');
		}
		//检查账号是否重复
		$check=pdo_getcolumn('core_users',array('name'=>$operator['name']),'id');
		if($check){
			exi('添加操作员失败，账号已存在，请更换！','error');
		}
		if(!$operator['type'] || !in_array($operator['type'],$this->operator_types)){
			$type=1;
		}else{
			$type=$operator['type'];
		}
		$new_user=array(
			'uniacid'=>$_SESSION['uniacid'],
			'name'=>$operator['name'],
			'type'=>$type,
			'status'=>intval($operator['status']),
			'home'=>$operator['home']?:'',
			'createtime'=>TIMESTAMP,
		);
		if($operator['password']){
			$new_user['salt']=random(10);
			$new_user['password']=get_password($operator['password'],$new_user['salt']);
		}
		if($operator['remark']){
			$new_user['remark']=$operator['remark'];
		}
		pdo_insert('core_users',$new_user);
		$id=pdo_insertid();
		$actions=array(
			'sys_actions'=>trim($operator['sys_actions']),
			'plugin_actions'=>trim($operator['plugin_actions']),
			'uniacid'=>$_SESSION['uniacid'],
			'uid'=>$id,
		);
		pdo_insert('core_user_permissions',$actions);
		return $id;
	}
	public function update_operator($id,$update){
		if($update['name']){
			$check=pdo_getcolumn('core_users',array('name'=>$update['name']),'id');
			if($check){
				if($check != $id){
					exi('该操作员账号已存在，请更换！','error');
				}else{
					unset($update['name']);
				}
			}
		}
		if(isset($update['password'])){
			if($update['password']){
				$update['salt']=random(10);
				$update['password']=get_password($update['password'],$update['salt']);
			}else{
				unset($update['password']);
			}
		}
		if($update['type'] && !in_array($update['type'],$this->operator_types)){
			unset($update['type']);
		}
		$update_operator=array_fields(array('group_id','mobile','name','salt','password','status','type','remark','home'),$update);
		pdo_update('core_users',$update_operator,array('id'=>$id));
		if($update['sys_actions'] || $update['plugin_actions']){
			$update_permission=array_fields(array('sys_actions','plugin_actions'),$update);
			pdo_update('core_user_permissions',$update_permission,array('uid'=>$id));
		}
		return true;
	}
	public function del_operator($id){
		pdo_delete('core_users',array('id'=>$id,'uniacid'=>$_SESSION['uniacid']));
		pdo_delete('core_user_permissions',array('uid'=>$id,'uniacid'=>$_SESSION['uniacid']));
		return true;
	}
	/*
		创建插件操作员，返回操作员ID。
		插件操作员机制说明：调用本接口直接创建一个插件操作员并返回操作员ID，系统默认设置操作员的权限为，仅有当前插件权限，系统页面无权限。且默认操作员首页为插件首页
	*/
	public function create_plugin_operator($plugin_name,$params){
		if(!$params['name'] || !$params['password']){
			exi('请先设置好操作员的账号和密码！','error');
		}
		if(!$params['home']){
			$params['home']=$plugin_name.'/index/';
		}
		$plugin_permission_id=pdo_getcolumn('core_plugins',array('name'=>$plugin_name),'id');
		$params['plugin_actions']=";{$plugin_permission_id};";
		$plugin_title=pdo_getcolumn('core_plugins',array('name'=>$plugin_name),'title');
		$params['remark']="插件【{$plugin_title}】操作员";
		return $this->create_operator($params);
	}
	public function get_username($uid){
		return pdo_getcolumn('core_users',array('id'=>$uid),'name');
	}
}