<?php
/*
 * [JINYUN!] (C)2001-2099 Jinyunweb.com
 * This is NOT a freeware, use is subject to license terms
 * $Id: 2017-12-13 03:39:35 apple $
*/
namespace core;
defined('BY_JYA') or exit('error');

define('ALIPAY_GATEWAY', 'https://mapi.alipay.com/gateway.do');

class pay{
	public function create_pay_order($parameter){
		if(!$parameter['back_url']){
			exi('创建支付订单出错！没有传入支付回调地址【 back_url 】','error');
		}
		if($parameter['no_type'] && is_string($parameter['no_type'])){
			$parameter['no_type']=array($parameter['no_type']);
		}
		do{
			$tid='JYA'.TIMESTAMP.random(7,true);
			$old=pdo_getcolumn('core_paylog',array('tid'=>$tid),'id');
		}while($old);
		$data=array(
			'uniacid'=>$_SESSION['uniacid'],
			'mid'=>$_SESSION['uid'],
			'tid'=>$tid,
			'oid'=>$parameter['id'],
			'status'=>0,
			'createtime'=>TIMESTAMP,
			'title'=>$parameter['title']?$parameter['title']:'支付订单',
			'no_type'=>$parameter['no_type']?ijson_encode($parameter['no_type']):'',
			'fee'=>$parameter['fee'],
			'plugin'=>ACCESS_PLUGIN,
			'action'=>ACCESS_ACTION,
			'more'=>$parameter['more']?$parameter['more']:'',
			'back_url'=>$parameter['back_url'],
			'success_url'=>$parameter['success_url'],
			'error_url'=>$parameter['error_url'],
		);
		if($parameter['pay_type']){
			$data['pay_type']=$parameter['pay_type'];
		}
		pdo_insert('core_paylog',$data);
		$id=pdo_insertid();
		return $id;
	}
	public function change_pay_fee($parameter){
		do{
			$tid='JYA'.TIMESTAMP.random(7,true);
			$old=pdo_getcolumn('core_paylog',array('tid'=>$tid),'id');
		}while($old);
		$data=array(
			'fee'=>$parameter['fee'],
			'tid'=>$tid,
		);
		pdo_update('core_paylog',$data,array('id'=>$parameter['pay_id']));
		return true;
	}
	public function alipay_build($params, $alipay = array()) {
		global $_AR;
		$tid = $params['tid'];
		$set = array();
		$set['service'] = 'alipay.wap.create.direct.pay.by.user';
		$set['partner'] = $alipay['partner'];
		$set['_input_charset'] = 'utf-8';
		$set['sign_type'] = 'MD5';
		$set['notify_url'] = $_SESSION['siteroot'] . 'payment/alipay/notify.php';
		$set['return_url'] = $_SESSION['siteroot'] . 'payment/alipay/return.php';
		$set['out_trade_no'] = $tid;
		$set['subject'] = $params['title'];
		$set['total_fee'] = $params['fee'];
		$set['seller_id'] = $alipay['account'];
		$set['payment_type'] = 1;
		$set['body'] = $_SESSION['uniacid'];
		$prepares = array();
		foreach($set as $key => $value) {
			if($key != 'sign' && $key != 'sign_type') {
				$prepares[] = "{$key}={$value}";
			}
		}
		sort($prepares);
		$string = implode('&', $prepares);
		$string .= $alipay['secret'];
		$set['sign'] = md5($string);

		$response = cfc('http')->ihttp_request(ALIPAY_GATEWAY . '?' . http_build_query($set, '', '&'), array(), array('CURLOPT_FOLLOWLOCATION' => 0));
		return array('url' => $response['headers']['Location']);
	}

	public function wechat_build($params, $wechat) {
		global $_AR;
		if (empty($wechat['version'])) {
			$wechat['version'] = 2;
		}
		$wOpt = array();
		$timeStamp=time();
		if ($wechat['version'] == 1) {
			$wOpt['appId'] = $_SESSION['wx']['appid'];
			$wOpt['timeStamp'] ="$timeStamp";
			$wOpt['nonceStr'] = random(8);
			$package = array();
			$package['bank_type'] = 'WX';
			$package['body'] = $params['title'];
			$package['attach'] = $_SESSION['uniacid'];
			$package['partner'] = $wechat['partner'];
			$package['out_trade_no'] = $params['tid'];
			$package['total_fee'] = $params['fee'] * 100;
			$package['fee_type'] = '1';
			$package['notify_url'] = SITEROOT . 'custom/payresult/wechat.php';
			$package['spbill_create_ip'] = CLIENT_IP;
			$package['time_start'] = date('YmdHis', TIMESTAMP);
			$package['time_expire'] = date('YmdHis', TIMESTAMP + 600);
			$package['input_charset'] = 'UTF-8';
			if (!empty($wechat['sub_mch_id'])) {
				$package['sub_mch_id'] = $wechat['sub_mch_id'];
			}
			ksort($package);
			$string1 = '';
			foreach($package as $key => $v) {
				if (empty($v)) {
					continue;
				}
				$string1 .= "{$key}={$v}&";
			}
			$string1 .= "key={$wechat['key']}";
			$sign = strtoupper(md5($string1));

			$string2 = '';
			foreach($package as $key => $v) {
				$v = urlencode($v);
				$string2 .= "{$key}={$v}&";
			}
			$string2 .= "sign={$sign}";
			$wOpt['package'] = $string2;

			$string = '';
			$keys = array('appId', 'timeStamp', 'nonceStr', 'package', 'appKey');
			sort($keys);
			foreach($keys as $key) {
				$v = $wOpt[$key];
				if($key == 'appKey') {
					$v = $wechat['wechat_miyue'];
				}
				$key = strtolower($key);
				$string .= "{$key}={$v}&";
			}
			$string = rtrim($string, '&');
			$wOpt['signType'] = 'SHA1';
			$wOpt['paySign'] = sha1($string);
			return $wOpt;
		} else {
			$package = array();
			$package['appid'] = $wechat['wechat_appid'];
			$package['mch_id'] = $wechat['wechat_mchid'];
			$package['nonce_str'] = random(8);
			$package['body'] = $params['title'];
			$package['attach'] = $_SESSION['uniacid'];
			$package['out_trade_no'] = $params['tid'];
			$package['total_fee'] = $params['fee'] * 100;
			$package['spbill_create_ip'] = CLIENT_IP;
			$package['time_start'] = date('YmdHis', TIMESTAMP);
			$package['time_expire'] = date('YmdHis', TIMESTAMP + 600);
			$package['notify_url'] =$params['notify_url']?:SITEROOT .'custom/payresult/wechat.php';
			$package['trade_type'] = 'JSAPI';
			if($wechat['wechat_type']){
				$package['sub_mch_id']=$wechat['wechat_sub_mchid'];
				$package['sub_appid']=$wechat['wechat_sub_appid'];
				$package['sub_openid'] =$_SESSION['openid'];
			}else{
				$package['openid'] =$_SESSION['openid'];
			}
			
			ksort($package, SORT_STRING);
			$string1 = '';
			foreach($package as $key => $v) {
				if (empty($v)) {
					continue;
				}
				$string1 .= "{$key}={$v}&";
			}
			$string1 .= "key={$wechat['wechat_miyue']}";
			$package['sign'] = strtoupper(md5($string1));
			$dat = array2xml($package);
			$response = cfc('http')->ihttp_request('https://api.mch.weixin.qq.com/pay/unifiedorder', $dat);
			if (is_error($response)) {
				return $response;
			}
			$xml = @isimplexml_load_string($response['content'], 'SimpleXMLElement', LIBXML_NOCDATA);
			if (strval($xml->return_code) == 'FAIL') {
				return error(strval($xml->return_msg));
			}
			if (strval($xml->result_code) == 'FAIL') {
				return error(strval($xml->err_code).': '.strval($xml->err_code_des));
			}
			$prepayid = $xml->prepay_id;
			$wOpt['appId'] = $wechat['wechat_appid'];
			$wOpt['timeStamp'] = "$timeStamp";
			$wOpt['nonceStr'] = random(8);
			$wOpt['package'] = 'prepay_id='.$prepayid;
			$wOpt['signType'] = 'MD5';
			ksort($wOpt, SORT_STRING);
			foreach($wOpt as $key => $v) {
				$string .= "{$key}={$v}&";
			}
			$string .= "key={$wechat['wechat_miyue']}";
			$wOpt['paySign'] = strtoupper(md5($string));
			return $wOpt;
		}
	}
	public function vip8pay_build($params, $vip8pay) {
			global $_AR;
			if (empty($params['type'])) {
				$params['type'] = 2;
			}
			$timeStamp=time();
			$params['timestamp']=$timeStamp;
			ksort($params, SORT_STRING);
			$string1 = '';
			foreach($params as $key => $v) {
				if (empty($v)) {
					continue;
				}
				$string1 .= "{$key}={$v}&";
			}
			$string1 .= "key={$vip8pay['vip8_key']}";
			$params['sign'] = md5($string1);
			$response = cfc('http')->ihttp_request('https://vip.8173888.com/api/v2/?s=/pay/unify/main', $params);
			if (is_error($response)) {
				return $response;
			}
			return $response;
	}
}
