<?php
/*
	余额红包
*/
namespace core;
defined('BY_JYA') or exit('error');
class red_pack{
	/*
		获得红包
		$params=array(
			'mid'=>'会员ID',
			'money'=>'红包金额',
			'remark'=>'备注',
		);
	*/
	function get_money($params,$type=''){
		if($type==1 && $params['total_num']!=1){
			$rand=mt_rand(1,100);
			$max=2*($params['money']/$params['total_num']);
			$money=($max*$rand)/100;
		}else{
			$money=$params['money'];
		}
		
		$add_log=array(
			'uniacid'=>$_SESSION['uniacid'],
			'mid'=>$params['mid'],
			'pidcode'=>$params['pidcode'],
			'plugin'=>$params['plugin']?:'core',
			'money'=>$money,
			'remark'=>$params['remark'],
			'createtime'=>TIMESTAMP,
		);
		pdo_insert('core_ideal_money_inlog',$add_log);
		$pack_id=pdo_getcolumn('core_ideal_money',array('mid'=>$params['mid']),'id');
		if($pack_id){
			$update=array(
				'money +='=>$money,
				'total_money +='=>$money,
			);
			pdo_update('core_ideal_money',$update,array('id'=>$pack_id));
		}else{
			$insert=array(
				'uniacid'=>$_SESSION['uniacid'],
				'mid'=>$params['mid'],
				'money'=>$money,
				'total_money'=>$money,
			);
			pdo_insert('core_ideal_money',$insert);
		}
		return $money;
	}
	/*
		申请提现
		$params=array(
			'mid'=>'会员ID',
			'money'=>'申请提现金额',
			'to_type'=>'提现方式：1体现到余额，2提现到微信零钱',
		);
	*/
	function cash($params){
		$pack=pdo_get('core_ideal_money',array('uniacid'=>$_SESSION['uniacid'],'mid'=>$_SESSION['uid']));
		$setting=uni_setting('cash');
		if(!$pack || $pack['money']<$params['money']){
			exi('红包余额不足！','error');
		}
		if($params['money']<$setting['min']){
			exi('提现金额必须大于等于'.$setting['min'].'元！','error');
		}
		$out_log=array(
			'uniacid'=>$_SESSION['uniacid'],
			'mid'=>$params['mid'],
			'createtime'=>TIMESTAMP,
			'to_type'=>intval($params['to_type']),
			'money'=>$params['money'],
			'cash_money'=>$params['cash_money'],
			'status'=>0,
		);
		$cash_id=pdo_insert('core_ideal_money_outlog',$out_log);
		$update=array(
			'money -='=>$params['money'],
			'frozen_money +='=>$params['money'],
		);
		pdo_update('core_ideal_money',$update,array('id'=>$pack));
		return $cash_id;
	}
	/*
		审核失败
		$params=array(
			'mid'=>'会员ID',
			'money'=>'申请提现金额',
			'to_type'=>'提现方式：1体现到余额，2提现到微信零钱',
		);
	*/
	function back_cash($id,$remark=''){
		pdo_update('core_ideal_money_outlog',array('status'=>2,'remark'=>$remark),array('id'=>$id));
		$money=pdo_getcolumn('core_ideal_money_outlog',array('id'=>$id),'money');
		$mid=pdo_getcolumn('core_ideal_money_outlog',array('id'=>$id),'mid');
		$frozen_money=pdo_getcolumn('core_ideal_money',array('uniacid'=>$_SESSION['uniacid'],'mid'=>$mid),'frozen_money');
		if($frozen_money<$money){
			exi('冻结余额不足！','error');
		}
		$update=array(
			'money +='=>$money,
			'frozen_money -='=>$money,
		);
		pdo_update('core_ideal_money',$update,array('uniacid'=>$_SESSION['uniacid'],'mid'=>$mid));
		return true;
	}
	/*
		审核通过并执行提现
		$cash_id='提现申请ID';
	*/
	function pay_cash($cash_id){
		$cash=pdo_get('core_ideal_money_outlog',array('id'=>$cash_id));
		if(!$cash){
			exi('指定的提现申请不存在！','error');
		}
		if($cash['status']!=0){
			exi('该提现申请已处理！','error');
		}
		if($cash['to_type']==1){
			//提现到余额
			$log_id=model('core/member')->add_credit2($cash['mid'],$cash['money'],'红包提现');
			
		}else{
			//提现到微信零钱
			$params=array(
				'money'=>$cash['cash_money'],
				'remark'=>'红包提现',
			);
			$log_id=model('core/member')->pay_out($cash['mid'],$params);
		}
		$cash_update=array(
			'status'=>1,
			'order_id'=>$log_id,
		);
		pdo_update('core_ideal_money_outlog',$cash_update,array('id'=>$cash['id']));
		$red_pack_update=array(
			'frozen_money -='=>$cash['money'],
		);
		pdo_update('core_ideal_money',$red_pack_update,array('mid'=>$cash['mid']));
		
	}
	/*
		确认是否已获得红包
		$pidcode=标识+id
	*/
	function check_getred($pidcode,$plugin='core',$mid=''){
		$mid=$mid?:$_SESSION['uid'];
		$redid=pdo_getcolumn('core_ideal_money_inlog',array('mid'=>$mid,'uniacid'=>$_SESSION['uniacid'],'pidcode'=>$pidcode,'plugin'=>$plugin),'id');
		return $redid;
	}
	function getone_money($pidcode,$plugin='core',$mid=''){
		$mid=$mid?:$_SESSION['uid'];
		$money=pdo_getcolumn('core_ideal_money_inlog',array('mid'=>$mid,'uniacid'=>$_SESSION['uniacid'],'pidcode'=>$pidcode,'plugin'=>$plugin),'money');
		return $money;
	}
	/*
		获取红包列表
		$pidcode=标识+id
	*/
	function getlist($parameter){
		$params=$parameter['params'];
		$limit=$parameter['limit'];
		$fields=$parameter['fields'];
		$orderby=$parameter['orderby'];
		$list=pdo_getslice('core_ideal_money_inlog',$params,$limit,$total,$fields,'',$orderby);
		return $list;
	}
	function getall($parameter){
		$params=$parameter['params'];
		$fields=$parameter['fields'];
		$orderby=$parameter['orderby'];
		$list=pdo_getall('core_ideal_money_inlog',$params,$fields,'',$orderby);
		return $list;
	}
	function getsum($parameter){
		$params=$parameter['params'];
		$sum=$parameter['sum'];
		$list=pdo_getsum('core_ideal_money_inlog',$params,$sum);
		return $list;
	}
}