<?php
/*
 * [JINYUN!] (C)2001-2099 Jinyunweb.com
 * This is NOT a freeware, use is subject to license terms
 * $Id: 2018-03-02 17:14:35 apple $
 用户操作相关函数
*/
namespace core;
defined('BY_JYA') or exit('error');
class user{
	//创建用户
	public function create_user($member=array(),$uc=true){
		if(!is_array($member)){
			return error('参数错误！');
		}
		$zhuce=core_setting('zhuce');
		$member['type'] = $member['type']?$member['type']:3;
		$member['createtime'] = $member['createtime']?$member['createtime']:TIMESTAMP;
		$member['lastip'] = $member['lastip']?$member['lastip']:CLIENT_IP;
		$member['lastvisit'] = $member['lastvisit']?$member['lastvisit']:TIMESTAMP;
		if($member['password']){
			$password=$member['password'];
			$member['salt']=random(8);
			$member['password']=get_password($member['password'], $member['salt']);
		}
		$member['status']=$zhuce['newuser']?1:0;
		if($_SESSION['fans']){
			$member=array_merge($_SESSION['fans'],$member);
		}
		$insert=array_fields(array('mobile','password','salt','status','type','agentid','createtime','name','lastvisit','lastip','remark','incode','nickname','avatar','sex','province','city','country'),$member);
		pdo_insert('core_users', $insert);
		$uid= pdo_insertid();
		if(!$uid){
			return error('注册失败！');
		}
		pdo_update('core_users',array('uniacid'=>$uid),array('id'=>$uid));
		//添加公众号参数设置数据
		$account=array(
			'uniacid'=>$uid,
			'token'=>random(30),
			'aeskey'=>random(43),
			'title'=>$member['nickname']?:$member['name'],
			'groupid'=>$member['groupid'],
			'endtime'=>$member['endtime'],
			'credit1'=>$member['credit1'],
			'credit2'=>$member['credit2'],
			'agent_id'=>$_SESSION['fromuser']?$_SESSION['fromuser']:0,
		);
		if(!$account['groupid']){
			$default_group=pdo_get('core_account_group',array('isdefault'=>1),array('id','days'));
			if($default_group){
				$account['groupid']=$default_group['id'];
				$account['endtime']=TIMESTAMP+86400*$default_group['days'];
			}else{
				$account['groupid']=0;
			}
		}
		
		pdo_insert('core_accounts',$account);
		$old_account=array(
			'acid'=>$uid,
			'uniacid'=>$uid,
		);
		pdo_insert('account_wechats',$old_account);
		if($uc){
			$this->uc_register($member['name'],$password,random(20).'@byjya.com');
		}
		//注册机器人
		$robot_key=cloud_request('cloud.robot_user.register',array('uid'=>$uid));
		if($robot_key && $robot_key!='error'){
			uni_setting('robot',array('api_key'=>$robot_key));
		}
		return $uid;
	}
	public function uc_config(){
		$config=core_setting('uc');
		
		if(!$config){
			return false;
		}
		if(!is_array($config)){
			$config=unserialize(cfc('tools')->base64_decode($config));
		}
		if(!$config['status']){
			return false;
		}
		$params=array('db_host','db_user','db_passwd','db_name','db_pre','db_charset','api_appid');
		foreach($params as $row){
			if(!$config[$row]){
				return false;
			}
		}
		define('UC_CONNECT', 'mysql');
		define('UC_DBHOST', $config['db_host']);
		define('UC_DBUSER', $config['db_user']);
		define('UC_DBPW', $config['db_passwd']);
		define('UC_DBNAME', $config['db_name']);
		define('UC_DBCHARSET', $config['db_charset']);
		define('UC_DBTABLEPRE', $config['db_name'].'.'.$config['db_pre']);
		
		define('UC_KEY', $config['api_key']);
		define('UC_API', $config['api_url']);
		define('UC_CHARSET', $config['api_charset']);
		define('UC_IP', $config['api_ip']);
		define('UC_APPID', $config['api_appid']);
		require_once ROOT_D.'/core/library/uc/include/db_mysql.class.php';
		require_once ROOT_D.'/core/library/uc/uc_client/client.php';
		return true;
	}
	public function uc_login($username,$password){
		if(!$this->uc_config()){
			return false;
		}
		$result=uc_user_login($username,$password);
		if($result && $result['0']>0){
			return true;
		}
		return false;
	}
	public function uc_register($username,$password,$email){
		if(!$this->uc_config()){
			return false;
		}
		$result=uc_user_register($username,$password,$email);
		if($result && $result['0']>0){
			return true;
		}
		return false;
	}
	public function login($uid){
		global $_AR;
		$record=pdo_get('core_users',array('id'=>$uid));
		if(!$record['nickname'] && $_SESSION['fans']){
			$update=array(
				'nickname'=>$_SESSION['fans']['nickname'],
				'avatar'=>$_SESSION['fans']['avatar'],
				'sex'=>$_SESSION['fans']['sex'],
				'province'=>$_SESSION['fans']['province'],
				'city'=>$_SESSION['fans']['city'],
				'country'=>$_SESSION['fans']['country'],
				'upfanstime'=>TIMESTAMP,
			);
			pdo_update('core_users',$update,array('id'=>$uid));
		}
		//判断是不是管理员
		$isfounder = is_founder('',$uid);
		if($record['status'] == 1 && !$isfounder) {
			$_SESSION['login_error']=true;
			//exi('您的账号正在审核或是已经被系统禁止，请联系网站管理员解决！','error','core/home.welcome/');
		}
		$account=pdo_get('core_accounts',array('uniacid'=>$record['uniacid']),array('groupid','endtime','stop','title','logo'));
		if(!$account){
			$_SESSION['login_error']=true;
			exi('找不到用户关联站点！','error');
		}
		if($account['endtime'] && $account['endtime'] < TIMESTAMP+15*24*3600 && !$isfounder){
			$account['status']=2;//将过期
		}
		if($account['endtime'] && $account['endtime'] < TIMESTAMP && !$isfounder){
			$account['status']=3;//已过期
			if($_AR['system']['forbid']){
				$_SESSION['login_error']=true;
				//exi('您的账号所属站点有效期限已过，请联系网站管理员解决！','error','core/home.welcome/');
			}else{
				$default_group=pdo_getcolumn('core_account_group',array('isdefault'=>1),'id');
				$default_group=intval($default_group);
				pdo_update('core_accounts',array('groupid'=>$default_group),array('uniacid'=>$record['uniacid']));
				$account['groupid']=$default_group;
			}
			
		}
		if($account['stop'] && !$isfounder){
			//return error('您的账号所属站点被系统管理员禁止，无法登陆！请联系管理员解决！');
			$_SESSION['login_error']=true;
			exi('您的账号所属站点被系统管理员禁止，无法登陆！请联系管理员解决！','error','core/home.welcome/');
		}
		//登陆成功，记录登陆状态。执行登陆操作
		pdo_update('core_users',array('ssid'=>session_id()),array('id'=>$record['id']));
		$_SESSION['uid']=$record['id'];
		$_SESSION['isfounder'] =is_founder();
		$_SESSION['user']=array_fields(array('type','name','status'),$record);
		$_SESSION['uniacid']=$record['uniacid']?$record['uniacid']:$record['id'];
		$this->update_permission();
		$_SESSION['account']['groupid']=$account['groupid'];
		$_SESSION['account']['endtime']=$account['endtime'];
		$_SESSION['account']['status']=$account['status'];
		$_SESSION['account']['title']=$account['title'];
		$_SESSION['account']['logo']=$account['logo'];
		$status = array(
			'lastvisit' => TIMESTAMP,
			'lastip' => CLIENT_IP
		);
		pdo_update('core_users',$status,array('id'=>$record['id']));
		//清空缓存
		cache_delete('cloud_getapps');
		cache_delete('cloud_getnews');
		cache_delete('cloud_ads');
		if($_SESSION['uniacid']==$_SESSION['uid']){
			//判断机器人key是否获取
			$check=uni_setting('robot');
			$cloud=core_setting('cloud');
			if(!$check && $cloud){
				$robot_key=cloud_request('cloud.robot_user.register',array('uid'=>$_SESSION['uniacid']));
				if($robot_key && $robot_key!='error'){
					uni_setting('robot',array('api_key'=>$robot_key));
				}
			}
		}
		/*
			根据套餐指定场景体
		*/
		if($account['groupid']){
			$group_plugin=pdo_getcolumn('core_account_group',array('id'=>$account['groupid']),'plugin_name');
			if($group_plugin){
				$_SESSION['current_plugin']=$group_plugin;
			}
		}
		$event=array(
			'uid'=>$_SESSION['uid'],
			'user_type'=>$record['type'],
			'user_name'=>$record['name'],
		);
		publish('core','user.login',$event);
		return true;
	}
	public function update_permission(){
		$account=pdo_get('core_accounts',array('uniacid'=>$_SESSION['uniacid']));
		if($_SESSION['isfounder']){
			$sys_actions=$plugin_actions='all';
		}elseif($_SESSION['user']['type']==3){//普通站长的权限	
			$useractions=$this->get_useractions($account);
			$sys_actions=$useractions['sys_actions'];
			$plugin_actions=$useractions['plugin_actions'];
		}else{//操作员的权限
			$user_action=pdo_get('core_user_permissions',array('uid'=>$_SESSION['uid']),array('sys_actions','plugin_actions'));
			$sys_actions=$user_action['sys_actions'];
			$plugin_actions=$user_action['plugin_actions'];
			$plugin_actionitem=pdo_getall('core_user_permissions_plugin',array('uid'=>$_SESSION['uid'],'uniacid'=>$_SESSION['uniacid']),array('pluginname','permissions'),'pluginname');
			$_SESSION['user']['plugin_actionitem']=$plugin_actionitem;
		}
		$_SESSION['user']['sys_actions']=$sys_actions;
		$_SESSION['user']['plugin_actions']=$plugin_actions;
	}
	public function home_page(){
		$user=pdo_get('core_users',array('id'=>$_SESSION['uid']),array('group_id','home'));
		if($user['home']){
			$url=$user['home'];
		}elseif($user['group_id']){
			$welcome=pdo_getcolumn('core_user_groups',array('id'=>$user['group_id']),'welcome');
			if($welcome){
				$url=$welcome;
			}
		}
		if(!$url && $_SESSION['account']['groupid']){
			$group=pdo_get('core_account_group',array('id'=>$_SESSION['account']['groupid']),array('index_url','plugin_name'));
			if($group['index_url']){
				$url=$group['index_url'];
			}
			
		}
		if(!$url){
			$url='core/account.welcome/';
		}
		return $url;
	}
	public function get_useractions($account){
			$sys_actions=pdo_getall('core_permissions',array('type <'=>4,'price'=>0),array('id'),'id');
			$sys_actions=array_keys($sys_actions);
			$plugin_actions=pdo_getall('core_plugins',array('price'=>0),array('id'),'id');
			$plugin_actions=array_keys($plugin_actions);
			//获取单独购买的插件
			$ops=pdo_getall('core_account_permissions',array('uniacid'=>$_SESSION['uniacid'],'time >'=>TIMESTAMP),array('pid','type'));
			if($ops){
				foreach($ops as $op){
					if($op['type']==0){
						$sys_actions[]=$op['pid'];
					}elseif($op['type']==1){
						$plugin_actions[]=$op['pid'];
					}
				}
			}
			$sys_actions=implode(';',$sys_actions);
			$plugin_actions=implode(';',$plugin_actions);
			$groupid=$account['groupid'];
			if($groupid){
				$group_action=pdo_get('core_account_group',array('id'=>$groupid),array('sys_actions','plugin_actions'));
			}
			if($group_action['sys_actions']){
				$sys_actions=';'.$sys_actions.$group_action['sys_actions'];
			}else{
				$sys_actions=';'.$sys_actions.';';
			}
			if($group_action['plugin_actions']){
				$plugin_actions=';'.$plugin_actions.$group_action['plugin_actions'];
			}else{
				$plugin_actions=';'.$plugin_actions.';';
			}
			return array('sys_actions'=>$sys_actions,'plugin_actions'=>$plugin_actions);
	}
	public function logout(){
		$holds=array('token','timestamp','this','ONESNUM');
		$_SESSION=array_fields($holds,$_SESSION);
		$_SESSION['islogout']=1;
		return true;
	}
}