<?php
/*
 * [JINYUN!] (C)2001-2099 Jinyunweb.com
 * This is NOT a freeware, use is subject to license terms
 * $Id: 2017-12-13 03:39:35 apple $
*/
namespace core;
defined('BY_JYA') or exit('error');
/*
	站点相关函数
*/
class web{
	public $num_types=array(
		'wechat'=>'公众号',
		'wxapp'=>'小程序',
		'aliapp'=>'支付宝小程序',
		'baiduapp'=>'百度小程序',
		'mobile'=>'微官网',
	);
	public function __construct($uniacid=0){
		if($uniacid==0){
			$uniacid=$_SESSION['uniacid'];
		}
		$this->uniacid=$uniacid;
	}
	/*
		校验站点应用数量是否达到上限
	*/
	public function check_num($type){
		if(!$type){
			return true;
		}
		if($_SESSION['isfounder']){
			return true;
		}
		if(!$_SESSION['account']['groupid']){
			return true;
		}
		$group_num=$this->get_group_num($type);
		$buy_num=$this->get_buy_num($type);
		$used_num=$this->get_used_num($type);
		if($used_num>=$group_num+$buy_num){
			exi("您所添加的{$this->num_types[$type]}已达到最大值，如需创建更多，请联系管理员提升权限或者升级套餐！",'error','goback');
		}
		return true;
	}
	public function get_group_id(){
		return pdo_getcolumn('core_accounts',array('uniacid'=>$this->uniacid),'groupid');
	}
	public function get_buy_num($type){
		$buy_num=pdo_getcolumn('core_account_nums',array('uniacid'=>$this->uniacid),$type)?:0;
		return $buy_num;
	}
	public function get_group_num($type){
		$group_num=pdo_getcolumn('core_account_group',array('id'=>$this->get_group_id()),$type.'_num')?:0;
		return $group_num;
	}
	/*
		返回以字节为单位的附件容量
	*/
	public function get_resource_limit($uniacid=0){
		if(!$uniacid){
			$uniacid=$_SESSION['uniacid'];
		}
		$account=pdo_get('core_accounts',array('uniacid'=>$uniacid),array('groupid','attachment'));
		if(!$account['groupid']){
			//如果用户没有套餐，默认不限制
			return 1000*1024*1024*1024;
		}
		$resource_limit=0;
		if($account['attachment']){
			$resource_limit+=$account['attachment']*1024*1024*1024;
		}
		if($account['groupid']){
			$group_resource_limit=pdo_getcolumn('core_account_group',array('id'=>$account['groupid']),'resource');
			$resource_limit+=$group_resource_limit*1024*1024;
		}
		return $resource_limit;
	}
	public function get_used_num($type){
		$tables=array(
			'wechat'=>'core_account_wechat',
			'wxapp'=>'core_account_wxapp',
			'aliapp'=>'core_account_aliapp',
			'baiduapp'=>'core_account_baiduapp',
			'mobile'=>'core_mobile_web',
		);
		$used=pdo_count($tables[$type],array('uniacid'=>$this->uniacid));
		return $used;
	}
	/*
		站点积分、余额变更
		$parameter=array(
			'type'=>'积分类型，1表示积分，2表示余额',
			'is_add'=>'是否增加',
			'fee'=>'变动金额',
			'remark'=>'变更说明',
		);
	*/
	public function account_credit($parameter){
		$types=array(1,2);
		if(!in_array($parameter['type'],$types)){
			return error('积分类型错误！');
		}
		if(!$parameter['uniacid']){
			$parameter['uniacid']=$this->uniacid;
		}
		if($parameter['is_add']){
			$op='+=';
		}else{
			$op='-=';
			$nowfee=pdo_getcolumn('core_accounts',array('uniacid'=>$parameter['uniacid']),'credit'.$parameter['type']);
			if($nowfee<$parameter['fee']){
				exi('操作失败，不能大于当前剩余','error');
			}
		}
		pdo_update('core_accounts',array('credit'.$parameter['type'].' '.$op=>$parameter['fee']),array('uniacid'=>$parameter['uniacid']));
		$credit_log=array(
			'uniacid'=>$parameter['uniacid'],
			'type'=>$parameter['type'],
			'is_add'=>$parameter['is_add'],
			'fee'=>$parameter['fee'],
			'remark'=>$parameter['remark'],
			'createtime'=>TIMESTAMP,
		);
		pdo_insert('core_account_credit_log',$credit_log);
		return true;
	}
	public function get_manage_wechat(){
		$wechat=pdo_get('core_account_wechat',array('uniacid'=>1,'isdefault'=>1));
		if(!$wechat){
			$wechat=pdo_get('core_account_wechat',array('uniacid'=>1));
		}
		return $wechat;
	}
	public function get_auth_wechat($uniacid){
		$wechat=pdo_get('core_account_wechat',array('uniacid'=>$uniacid,'isdefault'=>1,'type'=>4),array('id','appid','appsecret','type','oldid'));
		if(!$wechat){
			$wechat=pdo_get('core_account_wechat',array('uniacid'=>$uniacid,'type'=>4),array('id','appid','appsecret','type','oldid'));
		}
		if(!$wechat){
			return false;
		}else{
			return $wechat;
		}
	}
}