<?php
/*
 * [JINYUN!] (C)2001-2099 Jinyunweb.com
 * This is NOT a freeware, use is subject to license terms
 * $Id: 2018-03-02 17:14:35 apple $
 * 微信门店功能接口：https://developers.weixin.qq.com/doc/offiaccount/WeChat_Stores/WeChat_Store_Interface.html#0
*/
namespace core;
defined('BY_JYA') or exit('error');
class wechat_store{
	public function __construct($wechat_id=0){
		global $_AR;
		$this->access_token = cfc('account')->getAccessToken();
	}
	public function addstore($base_info){
		global $_AR;
		$url = "http://api.weixin.qq.com/cgi-bin/poi/addpoi?access_token=".$this->access_token;
		$post['business']=array(
			'base_info'=>$base_info,
		);
		$post=ijson_encode($post);
		$data = cfc('http')->ihttp_request($url,$post);
		$content=$data['content'];
		$content=json_decode($content,true);
		if($content['errcode'] != 0){
			//exi('错误'.$content['errcode'].'：'.$this->error_code($content['errcode']),'error');
		}
		return $content;
	}
	public function getstore($poi_id){
		global $_AR;
		$url = "http://api.weixin.qq.com/cgi-bin/poi/getpoi?access_token=".$this->access_token;
		$post=array(
			'poi_id'=>$poi_id,
		);
		$post=ijson_encode($post);
		$data = cfc('http')->ihttp_request($url,$post);
		$content=$data['content'];
		$content=json_decode($content,true);
		if($content['errcode'] != 0){
			//exi('错误'.$content['errcode'].'：'.$this->error_code($content['errcode']),'error');
		}
		return $content;
	}
	public function updatestore($base_info){
		global $_AR;
		$url = "https://api.weixin.qq.com/cgi-bin/poi/updatepoi?access_token=".$this->access_token;
		$post['business']=array(
			'base_info'=>$base_info,
		);
		$post=ijson_encode($post);
		$data = cfc('http')->ihttp_request($url,$post);
		$content=$data['content'];
		$content=json_decode($content,true);
		if($content['errcode'] != 0){
			//exi('错误'.$content['errcode'].'：'.$this->error_code($content['errcode']),'');
		}
		return $content;
	}
	public function delstore($poi_id){
		global $_AR;
		$url = "https://api.weixin.qq.com/cgi-bin/poi/delpoi?access_token=".$this->access_token;
		$post=array(
			'poi_id'=>$poi_id,
		);
		$post=ijson_encode($post);
		$data = cfc('http')->ihttp_request($url,$post);
		$content=$data['content'];
		$content=json_decode($content,true);
		if($content['errcode'] != 0){
			//exi('错误'.$content['errcode'].'：'.$this->error_code($content['errcode']),'error');
		}
		return $content;
	}
	public function getstorelist(){
		global $_AR;
		$url = "https://api.weixin.qq.com/cgi-bin/poi/getpoilist?access_token=".$this->access_token;
		$data = cfc('http')->ihttp_request($url);
		$content=$data['content'];
		$content=json_decode($content,true);
		if($content['errcode'] != 0){
			//exi('错误'.$content['errcode'].'：'.$this->error_code($content['errcode']),'error');
		}
		return $content;
	}
	public function getwifishoplist($pageindex=0,$pagesize=10){
		$token = cfc('account')->getAccessToken();
		$url='https://api.weixin.qq.com/bizwifi/shop/list?access_token='.$token;
		if($pageindex){
			$post['pageindex']=$pageindex;
		}
		if($pagesize){
			$post['pagesize']=$pagesize;
		}
		$post=ijson_encode($post);
		$data = cfc('http')->ihttp_request($url,$post);
		$content=$data['content'];
		$content=json_decode($content,true);
		if($content['errcode'] != 0){
			//exi('错误'.$content['errcode'].'：'.$this->error_code($content['errcode']),'error');
		}
		return $content;
	}
	public function getwifilist($shop_id){
		$token = cfc('account')->getAccessToken();
		$url='https://api.weixin.qq.com/bizwifi/shop/get?access_token='.$token;
		$post=array(
			"shop_id"=> intval($shop_id),
		);
		$post=ijson_encode($post);
		$data = cfc('http')->ihttp_request($url,$post);
		$content=$data['content'];
		$content=json_decode($content,true);
		if($content['errcode'] != 0){
			//exi('错误'.$content['errcode'].'：'.$this->error_code($content['errcode']),'error');
		}
		return $content;
	}
	public function addwifi($params){
		$token = cfc('account')->getAccessToken();
		$url='https://api.weixin.qq.com/bizwifi/device/add?access_token='.$token;
		$post=$params;
		$post=ijson_encode($post);
		$data = cfc('http')->ihttp_request($url,$post);
		$content=$data['content'];
		$content=json_decode($content,true);
		if($content['errcode'] != 0){
			exi('错误'.$content['errcode'].'：'.$this->error_code($content['errcode']),'error');
		}
		return $content;
	}
	public function upwifi($params){
		$token = cfc('account')->getAccessToken();
		$url='https://api.weixin.qq.com/bizwifi/shop/update?access_token='.$token;
		$post=$params;
		$post=ijson_encode($post);
		$data = cfc('http')->ihttp_request($url,$post);
		$content=$data['content'];
		$content=json_decode($content,true);
		if($content['errcode'] != 0){
			//exi('错误'.$content['errcode'].'：'.$this->error_code($content['errcode']),'error');
		}
		return $content;
	}
	public function getwificode($shopid,$ssid){
		$token = cfc('account')->getAccessToken();
		$url='https://api.weixin.qq.com/bizwifi/qrcode/get?access_token='.$token;
		$post=array(
			"shop_id"=>$shopid,
			"ssid"=>$ssid,
			"img_id"=> 1
		);
		$post=ijson_encode($post);
		$data = cfc('http')->ihttp_request($url,$post);
		$content=$data['content'];
		$content=json_decode($content,true);
		if($content['errcode'] != 0){
			//exi('错误'.$content['errcode'].'：'.$this->error_code($content['errcode']),'error');
		}
		return $content;
	}
	public function setcoupon($params){
		$token = cfc('account')->getAccessToken();
		$url='https://api.weixin.qq.com/bizwifi/couponput/set?access_token='.$token;
		$post=$params;
		$post=ijson_encode($post);
		$data = cfc('http')->ihttp_request($url,$post);
		$content=$data['content'];
		$content=json_decode($content,true);
		if($content['errcode'] != 0){
			exi('错误'.$content['errcode'].'：'.$this->error_code($content['errcode']),'error');
		}
		return $content;
	}
	public function getcoupon($params){
		$token = cfc('account')->getAccessToken();
		$url='https://api.weixin.qq.com/bizwifi/couponput/get?access_token='.$token;
		$post=$params;
		$post=ijson_encode($post);
		$data = cfc('http')->ihttp_request($url,$post);
		$content=$data['content'];
		$content=json_decode($content,true);
		if($content['errcode'] != 0){
			//exi('错误'.$content['errcode'].'：'.$this->error_code($content['errcode']),'error');
		}
		return $content;
	}
	public function getwifidata($params){
		$token = cfc('account')->getAccessToken();
		$url='https://api.weixin.qq.com/bizwifi/statistics/list?access_token='.$token;
		$post=$params;
		$post=ijson_encode($post);
		$data = cfc('http')->ihttp_request($url,$post);
		$content=$data['content'];
		$content=json_decode($content,true);
		if($content['errcode'] != 0){
			//exi('错误'.$content['errcode'].'：'.$this->error_code($content['errcode']),'error');
		}
		return $content;
	}
	//错误码
	public function error_code($code, $errmsg = '未知错误') {//获取错误详情
		global $_AR;
		$allerror=model('core/account')->error_code($code);
		if($allerror){
			return $allerror;
		}
		$errors = array(
			'0'	=> '成功',
			'61005' => '缺少接入平台关键数据，等待微信开放平台推送数据，请十分钟后再试或是检查“授权事件接收URL”是否写错（index.php?c=account&amp;a=auth&amp;do=ticket地址中的&amp;符号容易被替换成&amp;amp;）',
			'61023' => '请重新授权接入该公众号',
			'85005'=>'小程序未关联公众号，无法通过自定义菜单跳转！',
			'40164'=>'服务器IP不在白名单导致接口请求失败！请前往公众平台——开发——基本配置——公众号开发信息——IP白名单处设置',
			'40097'	=> '参数不正确，请参考字段要求检查json 字段',
			'65104'	=> '门店的类型不合法，必须严格按照附表的分类填写',
			'65105'	=> '图片url 不合法，必须使用接口1 的图片上传接口所获取的url',
			'65106'	=> '门店状态必须未审核通过',
			'65107'	=> '扩展字段为不允许修改的状态',
			'65109'	=> '门店名为空',
			'65110'	=> '门店所在详细街道地址为空',
			'65111'	=> '门店的电话为空',
			'65112'	=> '门店所在的城市为空',
			'65113'	=> '门店所在的省份为空',
			'65114'	=> '图片列表为空',
			'65115'	=> 'poi_id 不正确',
		);
		$code = strval($code);
		if($errors[$code]) {
			return $errors[$code];
		} else {
			$errmsg = $errmsg.',错误代码：'.$code;
			return $errmsg;
		}
	}
	
}