<?php
/*
 * [JINYUN!] (C)2001-2099 Jinyunweb.com
 * This is NOT a freeware, use is subject to license terms
 * $Id: 2017-12-13 03:39:35 apple $
*/
namespace core;
defined('BY_JYA') or exit('error');
class wxapp_api{
	protected $wxapp = null;
	public function __construct($wxapp_id=0){
		
		if(!$wxapp_id){
			$wxapp_id=$_SESSION['wxapp_id'];
		}
		$this->uniacid=$_SESSION['uniacid'];
		if(!$wxapp_id){
			return false;
		}else{
			$this->wxapp=pdo_get('core_account_wxapp',array('uniacid'=>$this->uniacid,'id'=>$wxapp_id));
		}
		if(empty($this->wxapp)){
			return false;
		}
		if (empty($this->wxapp['appid'])){
			exi('未填写小程序appid','error');
		}
		//APPsecret为必填项
		if(!$this->wxapp['appsecret']){
			exi('未填写小程序appsecret','error');
		}
		if($this->wxapp['expire']<TIMESTAMP){
			$this->getAccessToken();
		}
	}
	public function getAccessToken($continue=false){//获取access_token
		global $_AR;
		if($this->wxapp['expire']>TIMESTAMP && !$continue){
			return $this->wxapp['access_token'];
		}
		if(!$this->wxapp['appsecret']){
			return false;
		}else{
			$url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid={$this->wxapp['appid']}&secret={$this->wxapp['appsecret']}";
		}
		$content = cfc('http')->ihttp_request($url);
		if(is_error($content)){
			$authorizer_access_token=$this->getAuthorizer_accessToken();
			if($authorizer_access_token){
				return $authorizer_access_token;
			}else{
				exi('获取微信小程序授权失败, 请稍后重试！错误详情：'.$content['message'],'error');
			}
		}
		$token = @json_decode($content['content'], true);
		if(empty($token) || empty($token['access_token'])) {
			$authorizer_access_token=$this->getAuthorizer_accessToken();
			if($authorizer_access_token){
				return $authorizer_access_token;
			}else{
				exi('获取微信小程序授权失败, 请稍后重试！ 公众平台返回原始数据为: 错误代码-' . $token['errcode'] . '，错误信息-' . $token['errmsg'].'错误详情：'.$this->error_code($token['errcode']),'error');
			}
		}
		$record = array();
		$record['access_token'] = $token['access_token'];
		$record['expire'] = TIMESTAMP + $token['expires_in'] - 200;
		pdo_update('core_account_wxapp',$record,array('id'=>$this->wxapp['id']));
		$this->wxapp['access_token']=$token['access_token'];
		return $token['access_token'];
	}
	//发起http请求
	public function request($url,$post=null,$continue=true,$direct=false,$return_error=false,$isjson=false,$isrequest=false){
		if($this->return_error_one){
			$return_error=true;
			$this->return_error_one=false;
		}
		if($this->return_error){
			$return_error=true;
		}
		$rurl=str_replace(array('{access_token}','ACCESS_TOKEN'),$this->wxapp['access_token'],$url);
		if($isjson){
			$headers = array('Content-Type' => 'application/json');
			$result=cfc('http')->ihttp_json($rurl,$post);
		}elseif($isrequest){
			$result=cfc('http')->ihttp_request($rurl,$post);
		}elseif($post){
			$result=cfc('http')->ihttp_post($rurl,$post);
		}else{
			$result=cfc('http')->ihttp_get($rurl);
		}
		if(is_error($result)){
			$message="访问公众平台接口失败, 错误: {$result['message']}";
			if($return_error){
				return error($message);
			}else{
				exi($message,'error');
			}
		}
		$data=preg_replace('/[\x00-\x1F]/','',$result['content']);
		$data=@json_decode($data,true);
		if(($data['errcode']=='40001' || $data['errcode']=='42001') && $continue){
			$this->getAccessToken();
			$data=$this->request($url,$post,false,$direct,$return_error);
			return $data;
		}
		if($data['errcode']){
			$message=$this->error_code($data['errcode']).' '.$data['errmsg'].' '.$data['errcode'];
			if($return_error || $_SESSION['this']=='custom'){
				return error($message);
			}else{
				exi($message,'error');
			}
			
		}
		if($direct){
			return $result;
		}
		if(!is_array($data) || !$data){
			$message='访问微信接口错误，以下为原始数据：'.$result['content'];
			if($return_error){
				return error($message);
			}else{
				exi($message,'error');
			}
		}
		return $data;
	}
	//给第三方插件提供的额外接口，用于获取access_token
	public function access_token(){
		return $this->getAccessToken();
	}
	public function getfans($openid) {//获取粉丝信息（已关注且存在交互的粉丝）
		$url = "https://api.weixin.qq.com/cgi-bin/user/info?access_token={access_token}&openid={$openid}&lang=zh_CN";
		return $this->request($url,array());
	}
	public function get_media($mediaid){
		$url='https://api.weixin.qq.com/cgi-bin/media/get?access_token='.$this->wxapp['access_token'].'&media_id='.$mediaid;
		return $url;
	}
	public function get_openid_by_mid($mid){
		$openid=pdo_getcolumn('core_fans',array('mid'=>$mid,'wxgid'=>$this->wxapp['id']),'openid');
		if(!$openid){
			return error('获取用户openid失败，用户未关注该小程序！');
		}
		return $openid;
	}
	//发送客服消息，结合多小程序机制，优先发送给主小程序对应粉丝。主小程序无相应粉丝，则发送给粉丝关注的小程序
	public function sendCustomNotice($data,$mid=''){
		global $_AR;
		if(empty($data)) {
			exi('发送客服消息,参数错误!','error');
		}
		if(empty($data['touser'])){
			if(!$mid){
				if($_SESSION['uid']){
					$mid=$_SESSION['uid'];
				}else{
					exi('发送客服消息时出现错误，未设置消息接收者！','error');
				}
				
			}
			$openid=$this->get_openid_by_mid($mid);
			if(is_error($openid)){
				return $openid;
			}
			$data['touser']=$openid;
		}
		if($data['msgtype']=='news'){
			if(!$data['news']['articles']){
				$data['news']=array('articles'=>$data['news']);
			}
			foreach($data['news']['articles'] as &$news){
				$news['picurl']=tomedia($news['picurl'],true);
				$news['url']=custom_url($news['url'],true);
			}
			
		}
		$url = "https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token={access_token}";
		$data=ijson_encode($data);
		$this->request($url,$data,true,false,true);
		return true;
	}
	public function send_news($news,$mid=''){
		$data=array(
			'msgtype'=>'news',
			'news'=>array('articles'=>array($news)),
		);
		if(!$mid){
			$data['touser']=$_SESSION['openid'];
		}
		return $this->sendCustomNotice($data,$mid);
	}
	public function send_text($text,$mid=''){
		$data=array(
			'msgtype'=>'text',
			'text'=>array('content'=>$text),
		);
		if(!$mid){
			$data['touser']=$_SESSION['openid'];
		}
		return $this->sendCustomNotice($data,$mid);
	}
	//发送文本消息
	function sendText($content,$mid)
    {
        $send['msgtype'] = 'text';
        $send['text'] = array('content' => $content);
        $data = $this->sendCustomNotice($send,$mid);
        return $data;
    }
	//整理推送模板消息
	public function checktplNotice($openid_mid, $template_id, $content=array(), $url='',$msg_name='',$plugin_name='core',$itemid=0){
		$tplmsg=$this->check_tpl_msg($msg_name,$plugin_name);
		if($tplmsg!=1 && $itemid && class_exists(model($plugin_name.'/notice')) && method_exists(model($plugin_name.'/notice'),'gettpl_data')){
			$datas=model($plugin_name.'/notice')->gettpl_data($itemid);
			$tplmsg['keywords']=json_decode($tplmsg['keywords'],true);
			$newcontent=array();
			foreach ($tplmsg['keywords'] as $key => $value){
				$newcontent[$key]=cfc('account')->replaceTemplate($value,$datas);
			}
		}else{
			$tplmsg=pdo_get('core_account_tpl_template',array('wxapp_id'=>$this->wxapp['id'],'name'=>$msg_name,'plugin_name'=>$plugin_name),array('keywords'));
			$keywords=json_decode($tplmsg['keywords'],true);
			$newcontent=array();
			foreach($content as $k=>&$item){
				$newcontent[$keywords[$k]['kename']]=$item;
			}
		}
		$this->sendTplNotice($openid_mid, $template_id, $newcontent, $url);
	}
	//发送模版消息
	public function sendTplNotice($openid_mid, $template_id, $postdata, $url = '') {
		//ID为空，就发送客服消息
		if(!$template_id) {
			return error( '参数错误,模板ID不能为空');
		}
		if(empty($postdata) || !is_array($postdata)){
			exi( '参数错误,请根据模板规则完善消息内容','error');
		}
		if(empty($openid_mid)) {
			exi('模版消息发送失败,会员ID不能为空','error');
		}
		$data = array();
		if(is_numeric($openid_mid)){
			$openid=$this->get_openid_by_mid($openid_mid);
			if(is_error($openid)){
				return $openid;
			}
			$data['touser'] = $openid;
		}else{
			$data['touser'] = $openid_mid;
		}
		$data['template_id'] = trim($template_id);
		$data['page'] = wxapp_links($url);
		$data['data'] = $postdata;
		$data = ijson_encode($data);
		$api_url = "https://api.weixin.qq.com/cgi-bin/message/subscribe/send?access_token={access_token}";
		$this->request($api_url,$data,true,false,true);
		return true;
	}
	//替换关键词
	protected function replaceTemplate($str, $datas = array())
	{
		foreach ($datas as $d ) {
			$str = str_replace('[' . $d['name'] . ']', $d['value'], $str);
		}

		return $str;
	}
	public function get_tpl_industry(){
		//先判断行业，如果没有需要的行业，此处设置行业
		$get_url='https://api.weixin.qq.com/wxaapi/newtmpl/getcategory?access_token=ACCESS_TOKEN';
		$res=$this->request($get_url);
		return $res;	
	}
	public function set_tpl_industry($data){
		//设置行业
		$url='https://api.weixin.qq.com/cgi-bin/template/api_set_industry?access_token=ACCESS_TOKEN';
		$data=ijson_encode($data);
		$res=$this->request($url,$data);
		return $res;	
	}
	public function get_tpl_tids($ids){
		//获取分类下面的模板ID
		$get_url='https://api.weixin.qq.com/wxaapi/newtmpl/getpubtemplatetitles?access_token=ACCESS_TOKEN&ids='.$ids.'&start=0&limit=30';
		$res=$this->request($get_url);
		$res=ijson_encode($res);
		return $res;	
	}
	public function check_tpl_msg($name,$plugin_name='core',$remark=''){
		$msgtpl_set=uni_setting('msgtpl_set');
		foreach($msgtpl_set as &$mv){
				$tplinfo=pdo_get('core_tpl_template',array('id'=>$mv['tplid']),array('name','plugin_name'));
				if($tplinfo['plugin_name']==$plugin_name && $tplinfo['name']==$name){
					//为了默认显示opentpl==1表示关闭
					if($mv['opentpl']!=1){
						if($mv['send_tplid']){
							$msg=pdo_get('core_account_tpl_template',array('id'=>$mv['send_tplid']),array('keywords'));
						}else{
							//默认模板消息推送
							$msg=1;
						}		
						return $msg;
					}
				}
		}
		return false;
	}
	public function check_tpl_template($name,$plugin_name='core',$remark=''){
		$msgtpl_set=uni_setting('msgtpl_set');
		foreach($msgtpl_set as &$mv){
				$tplinfo=pdo_get('core_tpl_template',array('id'=>$mv['tplid']),array('name','plugin_name','template_name'));
				if($tplinfo['plugin_name']==$plugin_name && $tplinfo['name']==$name){
					//为了默认显示opentpl==1表示关闭
					if($mv['opentpl']!=1){
						if($mv['send_tplid']){
							$template_name=pdo_getcolumn('core_account_tpl_template',array('id'=>$mv['send_tplid']),'template_name');
						}else{
							$template_name=$tplinfo['template_name'];
						}		
						$template_id=$this->get_tpl_template_id($template_name,$remark);
						return $template_id;
					}
				}
		}
		return false;
	}
	public function get_tpl_template($name,$plugin_name='core'){
		$msgtpl_set=uni_setting('msgtpl_set');
		foreach($msgtpl_set as &$mv){
				$tplinfo=pdo_get('core_tpl_template',array('id'=>$mv['tplid']),array('name','plugin_name','template_name'));
				if($tplinfo['plugin_name']==$plugin_name && $tplinfo['name']==$name){
					//为了默认显示opentpl==1表示关闭
					if($mv['opentpl']!=1){
						if($mv['send_tplid']){
							$tplset=pdo_get('core_account_tpl_template',array('id'=>$mv['send_tplid']));
							return $tplset;
						}else{
							return false;
						}
					}
				}
		}
		return false;
	}
	public function add_tpl_template_id($wxapptemplate_id,$name='',$plugin_name='',$sysid='',$wxapp_id='',$keywords){
		$params=array('uniacid'=>$_SESSION['uniacid'],'plugin_name'=>$plugin_name,'name'=>$name,'wxapp_id'=>$wxapp_id);
		$isid=pdo_getcolumn('core_account_tpl_template',$params,'id');
		if($isid){
			$data=array(
					'wxapptemplate_id'=>$wxapptemplate_id,
					'keywords'=>$keywords,
			);
			pdo_update('core_account_tpl_template',$data,array('id'=>$isid));
		}else{
			$item=pdo_get('core_tpl_template',array('id'=>$sysid));
			$data=array(
					'wxapptemplate_id'=>$wxapptemplate_id,
					'title'=>$item['title'],
					'wxapp_id'=>$wxapp_id,
					'template_name'=>$item['appsubtpl_name'],
					'first'=>$item['first'],
					'firstcolor'=>$item['firstcolor'],
					'keywords'=>$keywords,
					'footer'=>$item['footer'],
					'footercolor'=>$item['footercolor'],
					'remark'=>$item['remark'],
					'kefumsg'=>$item['kefumsg'],
			);
			$data['name']=$item['name'];
			$data['plugin_name']=$item['plugin_name'];
			$data['uniacid']=$_SESSION['uniacid'];
			$data['coreid']=intval($sysid);
			pdo_insert('core_account_tpl_template',$data);
		}
	}
	public function get_tpl_template_id($template_name,$kidList=array(),$name='',$remark='',$plugin_name=''){
		$this->return_error=true;
		$params=array('uniacid'=>$_SESSION['uniacid'],'wxapp_id'=>$this->wxapp['id'],'template_name'=>$template_name);
		if($name){
			$params['name']=$name;
		}
		$template_id=pdo_getcolumn('core_account_tpl_template',$params,'template_id');
		if(!$template_id && $name && $plugin_name){
			$template_id=pdo_getcolumn('core_account_tpl_template',array('uniacid'=>$_SESSION['uniacid'],'wxapp_id'=>$this->wxapp['id'],'name'=>$name,'plugin_name'=>$plugin_name),'wxapptemplate_id');
		}
		if(!$template_id){
			//获取行业ID
			/*$industrys=$this->get_tpl_industry();
			if(is_error($industrys)){
				return false;
			}
			//$industrys=$industrys['data'][0]['id'];
			//$tids=$this->get_tpl_tids($industrys);*/
			$url='https://api.weixin.qq.com/wxaapi/newtmpl/addtemplate?access_token={access_token}';
			$params=array(
				'tid'=>$template_name,
				'kidList'=>$kidList,
				'sceneDesc'=>$remark
			);
			$res=$this->request($url,ijson_encode($params),'','',true,true);
			if(is_error($res)){
				return false;
			}
			$template=array(
				'uniacid'=>$_SESSION['uniacid'],
				'wxapp_id'=>$this->wxapp['id'],
				'type'=>1,
				'name'=>$name,
				'template_name'=>$template_name,
				'template_id'=>$res['priTmplId'],
				'remark'=>$remark,
			);
			pdo_insert('core_account_tpl_template',$template);
		}
		$this->return_error=false;
		$template_id=$template['template_id']?:$template_id;
		return $template_id;
	}
	
	public function get_live_rooms($data){
		//先判断行业，如果没有需要的行业，此处设置行业
		$url='https://api.weixin.qq.com/wxa/business/getliveinfo?access_token={access_token}';
		$data=ijson_encode($data);
		$res=$this->request($url,$data);
		return $res;	
	}
	public function add_live_rooms($data){
		//创建直播间
		$url='https://api.weixin.qq.com/wxaapi/broadcast/room/create?access_token={access_token}';
		$data=ijson_encode($data);
		$res=$this->request($url,$data,true,'','',true);
		return $res;	
	}
	public function add_live_goodstorooms($goods_ids,$roomid){
		//导入商品进直播间
		$url='https://api.weixin.qq.com/wxaapi/broadcast/room/addgoods?access_token={access_token}';
		$data=array('ids'=>$goods_ids,'roomId'=>$roomid);
		$data=ijson_encode($data);
		$res=$this->request($url,$data,true,'','',true);
		return $res;	
	}
	public function add_live_goods($goods){
		//添加商品
		$url='https://api.weixin.qq.com/wxaapi/broadcast/goods/add?access_token={access_token}';
		if($goods['originalprice'] && $goods['originalprice']<$goods['price']){
			exi('原价必须大于现价','error');
		}
		$data=array(
			'goodsInfo'=>array(
				'coverImgUrl'=>$this->upload_media($goods['image'],'image'),
				'name'=>$goods['title'],
				'priceType'=>3,
				'price2'=>$goods['price'],
				'price'=>intval($goods['originalprice']?:$goods['price']*1.2),
				'url'=>'jy_weishop/goods/detail/index?id='.$goods['goods_id'],
			)
		);
		$data=ijson_encode($data);
		$res=$this->request($url,$data,true,'','',true);
		return $res;	
	}
	public function audit_live_goods($goodsId){
		//重新提交审核
		$url='https://api.weixin.qq.com/wxaapi/broadcast/goods/audit?access_token={access_token}';
		$data=array(
			'goodsId'=>$goodsId,
		);
		$data=ijson_encode($data);
		$res=$this->request($url,$data,true,'','',true);
		return $res;	
	}
	public function status_live_goods($goods_ids){
		//更新状态
		$url='https://api.weixin.qq.com/wxa/business/getgoodswarehouse?access_token={access_token}';
		$data=array('goods_ids'=>$goods_ids);
		$data=ijson_encode($data);
		$res=$this->request($url,$data,true,'',true);
		return $res;	
	}
	public function up_live_goods($goods){
		//更新商品
		$url='https://api.weixin.qq.com/wxaapi/broadcast/goods/update?access_token={access_token}';
		if($goods['originalprice'] && $goods['originalprice']<$goods['price']){
			exi('原价必须大于现价','error');
		}
		$data=array(
			'goodsInfo'=>$goods
		);
		$data=ijson_encode($data);
		$res=$this->request($url,$data,true,'','',true);
		return $res;	
	}
	public function del_live_goods($goods_id){
		//更新状态
		$url='https://api.weixin.qq.com/wxaapi/broadcast/goods/delete?access_token={access_token}';
		$data=array('goodsId'=>$goods_id);
		$data=ijson_encode($data);
		$res=$this->request($url,$data,true,'','',true);
		return $res;	
	}
	public function getJssdkConfig(){//获取jssdk参数
		global $_AR;
		if(!$this->wxapp['jsticket'] || $this->wxapp['jsexpire']<TIMESTAMP){
			$this->getJsApiTicket();
		}
		$nonceStr = random(16);
		$timestamp = TIMESTAMP;
		$url = $_AR['siteurl'];
		$string1 = "jsapi_ticket={$this->wxapp['jsticket']}&noncestr={$nonceStr}&timestamp={$timestamp}&url={$url}";
		$signature = sha1($string1);
		$config = array(
			"appId"		=> $this->wxapp['appid'],
			"nonceStr"	=> $nonceStr,
			"timestamp" => $timestamp,
			"signature" => $signature,
		);
		return $config;
	}
	public function getJsApiTicket(){
		global $_AR;
		$url = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token={access_token}&type=jsapi";
		$result=$this->request($url);
		$record = array();
		$record['jsticket'] = $result['ticket'];
		$record['jsexpire'] = TIMESTAMP + $result['expires_in'] - 200;
		pdo_update('core_account_wechat',$record,array('id'=>$this->wxapp['id']));
		$this->wxapp['jsticket']=$record['jsticket'];
		return true;
	}
	public function url_short($url){
		$api='https://api.weixin.qq.com/cgi-bin/shorturl?access_token={access_token}';
		$post=array(
			'action'=>'long2short',
			'long_url'=>$url
		);
		$result=$this->request($api,$post);
		return $result['short_url'];
	}
	//新增临时素材
	public function upload_media($source,$type) {
		//参数说明：附件相对地址，素材类型
		$url='https://api.weixin.qq.com/cgi-bin/media/upload?access_token={access_token}&type='.$type;
		if(ATTACHMENT_TYPE){
			//远程附件
			$ext=strrchr($source,'.');
			$source=tomedia($source);
			$temp=ROOT_AT.random(30).$ext;
			copy($source,$temp);
		}else{
			$temp=ROOT_AT.$source;
		}
		$post=array('media'=>'@'.$temp);
		$res=$this->request($url,$post,'','',true,'',true);
		if(ATTACHMENT_TYPE){
			@unlink($temp);
		}
		return $res['media_id'];
	}
	//错误码
	public function error_code($code, $errmsg = '未知错误') {//获取错误详情
		global $_AR;
		$errors = array(
			'-1' => '系统繁忙',
			'0' => '请求成功',
			'300002' => '商品标题太长了！最长14个汉字',
			'300003' => '价格输入不合规（如：现价比原价大、传入价格非数字等）',
			'300018' => '图片尺寸超过300px*300px',
			'300006' => '图片上传失败（如：mediaID过期）',
			'300007' => '线上小程序版本不存在该链接,请重新上传小程序代码！',
			'300022'=>'此房间号不存在',
			'300023'=>'房间状态 拦截（当前房间状态不允许此操作）',
			'300024'=>'商品不存在',
			'300025'=>'商品审核未通过',
			'300026'=>'房间商品数量已经满额',
			'300027'=>'导入商品失败',
			'300028'=>'房间名称违规',
			'300029'=>'主播昵称违规',
			'300030'=>'主播微信号不合法',
			'300031'=>'直播间封面图不合规',
			'300032'=>'直播间分享图违规',
			'300033'=>'添加商品超过直播间上限',
			'300034'=>'主播微信昵称长度不符合要求',
			'300035'=>'主播微信号不存在',
			'300036'=>'主播微信号未实名认证,登录微信搜索--《直播小程序》--实名认证一下即可！',
			'40001' => '获取access_token时AppSecret错误，或者access_token无效',
			'40002' => '不合法的凭证类型',
			'40003' => '不合法的OpenID',
			'40004' => '不合法的媒体文件类型',
			'40005' => '不合法的文件类型',
			'40006' => '不合法的文件大小',
			'40007' => '不合法的媒体文件id',
			'40008' => '不合法的消息类型',
			'40009' => '不合法的图片文件大小',
			'40010' => '不合法的语音文件大小',
			'40011' => '不合法的视频文件大小',
			'40012' => '不合法的缩略图文件大小',
			'40013' => '不合法的APPID',
			'40014' => '不合法的access_token',
			'40015' => '不合法的菜单类型',
			'40016' => '不合法的按钮个数',
			'40017' => '不合法的按钮个数',
			'40018' => '不合法的按钮名字长度',
			'40019' => '不合法的按钮KEY长度',
			'40020' => '不合法的按钮URL长度',
			'40021' => '不合法的菜单版本号',
			'40022' => '不合法的子菜单级数',
			'40023' => '不合法的子菜单按钮个数',
			'40024' => '不合法的子菜单按钮类型',
			'40025' => '不合法的子菜单按钮名字长度',
			'40026' => '不合法的子菜单按钮KEY长度',
			'40027' => '不合法的子菜单按钮URL长度',
			'40028' => '不合法的自定义菜单使用用户',
			'40029' => '不合法的oauth_code',
			'40030' => '不合法的refresh_token',
			'40031' => '不合法的openid列表',
			'40032' => '不合法的openid列表长度',
			'40033' => '不合法的请求字符，不能包含\uxxxx格式的字符',
			'40035' => '不合法的参数',
			'40038' => '不合法的请求格式',
			'40039' => '不合法的URL长度',
			'40050' => '不合法的分组id',
			'40051' => '分组名字不合法',
			'41001' => '缺少access_token参数',
			'41002' => '缺少appid参数',
			'41003' => '缺少refresh_token参数',
			'41004' => '缺少secret参数',
			'41005' => '缺少多媒体文件数据',
			'41006' => '缺少media_id参数',
			'41007' => '缺少子菜单数据',
			'41008' => '缺少oauth code',
			'41009' => '缺少openid',
			'42001' => 'access_token超时',
			'42002' => 'refresh_token超时',
			'42003' => 'oauth_code超时',
			'43001' => '需要GET请求',
			'43002' => '需要POST请求',
			'43003' => '需要HTTPS请求',
			'43004' => '需要接收者关注',
			'43005' => '需要好友关系',
			'44001' => '多媒体文件为空',
			'44002' => 'POST的数据包为空',
			'44003' => '图文消息内容为空',
			'44004' => '文本消息内容为空',
			'45001' => '多媒体文件大小超过限制',
			'45002' => '消息内容超过限制',
			'45003' => '标题字段超过限制',
			'45004' => '描述字段超过限制',
			'45005' => '链接字段超过限制',
			'45006' => '图片链接字段超过限制',
			'45007' => '语音播放时间超过限制',
			'45008' => '图文消息超过限制',
			'45009' => '接口调用超过限制',
			'45010' => '创建菜单个数超过限制',
			'45015' => '回复时间超过限制',
			'45016' => '系统分组，不允许修改',
			'45017' => '分组名字过长',
			'45018' => '分组数量超过上限',
			'45056' => '创建的标签数过多，请注意不能超过100个',
			'45057' => '该标签下粉丝数超过10w，不允许直接删除',
			'45058' => '不能修改0/1/2这三个系统默认保留的标签',
			'45059' => '有粉丝身上的标签数已经超过限制',
			'45157' => '标签名非法，请注意不能和其他标签重名',
			'45158' => '标签名长度超过30个字节',
			'45159' => '非法的标签',
			'46001' => '不存在媒体数据',
			'46002' => '不存在的菜单版本',
			'46003' => '不存在的菜单数据',
			'46004' => '不存在的用户',
			'47001' => '解析JSON/XML内容错误',
			'48001' => 'api功能未授权',
			'50001' => '用户未授权该api',
			'40070' => '基本信息baseinfo中填写的库存信息SKU不合法。',
			'41011' => '必填字段不完整或不合法，参考相应接口。',
			'40056' => '无效code，请确认code长度在20个字符以内，且处于非异常状态（转赠、删除）。',
			'43009' => '无自定义SN权限，请参考开发者必读中的流程开通权限。',
			'43010' => '无储值权限,请参考开发者必读中的流程开通权限。',
			'43011' => '无积分权限,请参考开发者必读中的流程开通权限。',
			'40078' => '无效卡券，未通过审核，已被置为失效。',
			'40079' => '基本信息base_info中填写的date_info不合法或核销卡券未到生效时间。',
			'45021' => '文本字段超过长度限制，请参考相应字段说明。',
			'40080' => '卡券扩展信息cardext不合法。',
			'40097' => '基本信息base_info中填写的参数不合法。',
			'49004' => '签名错误。',
			'43012' => '无自定义cell跳转外链权限，请参考开发者必读中的申请流程开通权限。',
			'40099' => '该code已被核销。',
			'61005' => '缺少接入平台关键数据，等待微信开放平台推送数据，请十分钟后再试或是检查“授权事件接收URL”是否写错（index.php?c=account&amp;a=auth&amp;do=ticket地址中的&amp;符号容易被替换成&amp;amp;）',
			'61023' => '请重新授权接入该小程序',
			'85005'=>'小程序未关联小程序，无法通过自定义菜单跳转！',
			'40164'=>'服务器IP不在白名单导致接口请求失败！请前往公众平台——开发——基本配置——小程序开发信息——IP白名单处设置',
		);
		$code = strval($code);
		if($errors[$code]) {
			return $errors[$code];
		} else {
			return $errmsg;
		}
	}
}