<?php
/*
 * [JINYUN!] (C)2001-2099 Jinyunweb.com
 * This is NOT a freeware, use is subject to license terms
 * $Id: 2017-12-13 03:39:35 apple $企业微信应用API
 * core_open_plugin 第三方应用接口，注意区分PID，一个是系统插件ID
 * core_account_permissions 里面的PID，是系统ID
*/
namespace core;
defined('BY_JYA') or exit('error');
class wxwork_api{
	protected $work_weixin = null;
	public function __construct($workeropen_pid=0){
		if($workeropen_pid){
			$this->workeropen_pid=$workeropen_pid;
		}
		$this->work_weixin=core_setting('work_weixin');
		if(empty($this->work_weixin)){
			return false;
		}
		if (empty($this->work_weixin['corpid'])){
			exi('未填写企业微信服务商应用corpid','error');
		}
		if(!$this->work_weixin['provider_secret']){
			exi('未填写企业微信服务商应用provider_secret','error');
		}
		if($this->work_weixin['expire']<TIMESTAMP){
			$this->getAccessToken();
		}
		if(!$this->suite_access_token && $this->workeropen_pid){
			$this->suite_access_token=$this->get_suite_token($this->workeropen_pid);
		}
	}
	public function getAccessToken($continue=false){//获取access_token
		if($this->work_weixin['expire']>TIMESTAMP && !$continue){
			return $this->work_weixin['provider_access_token'];
		}
		if(!$this->work_weixin['provider_secret']){
			return false;
		}else{
			$url = "https://qyapi.weixin.qq.com/cgi-bin/service/get_provider_token";
		}
		$post=array(
			'corpid'=>$this->work_weixin['corpid'],
			'provider_secret'=>$this->work_weixin['provider_secret'],
		);
		$content = $this->request($url,$post);
		if($content['errcode']){
			exi('获取企业微信服务商凭证, 请稍后重试！错误详情：'.$content['errmsg'],'error');
		}
		if(empty($content['provider_access_token'])) {
			exi('获取企业微信服务商凭证, 请稍后重试！错误代码-' . $content['errcode'] . '，错误信息-' . $content['errmsg'],'error');
		}
		$this->work_weixin['provider_access_token'] = $content['provider_access_token'];
		$this->work_weixin['expire'] = TIMESTAMP + $content['expires_in'] - 200;
		core_setting('work_weixin',$this->work_weixin);
		return $content['provider_access_token'];
	}
	//获取第三方应用凭证https://work.weixin.qq.com/api/doc/90001/90143/90600
	public function get_suite_token($workeropen_pid){
		$app=pdo_get('core_open_plugin',array('id'=>$workeropen_pid));
		if(!$app['suite_id'] || !$app['suite_secret']){
			exi('该应用还未绑定企业微信平台的应用ID或应用secret！','error');
		}
		if($app['expire']>TIMESTAMP && !$continue){
			return $app['suite_access_token'];
		}
		if(!$app['suite_ticket']){
			exi('该应用还未获取到企业微信的suite_ticket！','error');
		}
		$url = "https://qyapi.weixin.qq.com/cgi-bin/service/get_suite_token";
		$post=array(
			'suite_id'=>$app['suite_id'],
			'suite_secret'=>$app['suite_secret'],
			'suite_ticket'=>$app['suite_ticket'],
		);
		$content = $this->request($url,$post);
		if($content['errcode']){
			exi('获取第三方应用凭证, 请稍后重试！错误详情：'.$content['errmsg'],'error');
		}
		if(empty($content['suite_access_token'])) {
				exi('获取第三方应用凭证, 请稍后重试！错误代码-' . $content['errcode'] . '，错误信息-' . $content['errmsg'],'error');
		}
		$update=array(
			'suite_access_token'=>$content['suite_access_token'],
			'expire'=>TIMESTAMP + $content['expires_in'] - 200,
		);
		pdo_update('core_open_plugin',$update,array('id'=>$app['id']));
		return $content['suite_access_token'];
	}
	//获取预授权码https://work.weixin.qq.com/api/doc/90001/90143/90600
	public function get_pre_auth_code(){
		$app=pdo_get('core_open_plugin',array('id'=>$this->workeropen_pid));
		$userapp=pdo_get('core_account_permissions',array('pid'=>$app['pid'],'uniacid'=>$_SESSION['uniacid']));
		if($userapp['pre_expire']>TIMESTAMP && !$continue){
			return $userapp['pre_auth_code'];
		}
		if(!$app['suite_ticket']){
			exi('该应用还未在企业微信服务商平台创建！无法同步！','error');
		}
		$url = "https://qyapi.weixin.qq.com/cgi-bin/service/get_pre_auth_code?suite_access_token=".$this->suite_access_token;
		$content = cfc('http')->ihttp_request($url);
		if(is_error($content)){
			exi('获取预授权码, 请稍后重试！错误详情：'.$content['message'],'error');
		}
		$token = @json_decode($content['content'], true);
		if(empty($token) || empty($token['pre_auth_code'])) {
				exi('获取预授权码, 请稍后重试！错误代码-' . $token['errcode'] . '，错误信息-' . $token['errmsg'],'error');
		}
		$update=array(
			'pre_auth_code'=>$token['pre_auth_code'],
			'pre_expire'=>TIMESTAMP + $token['expires_in'] - 200,
		);
		pdo_update('core_account_permissions',$update,array('pid'=>$app['pid'],'uniacid'=>$_SESSION['uniacid']));
		return $token['pre_auth_code'];
	}
	//获取企业永久授权码
	public function get_permanent_code($auth_code){
		$app=pdo_get('core_open_plugin',array('id'=>$this->workeropen_pid));
		$url = "https://qyapi.weixin.qq.com/cgi-bin/service/get_permanent_code?suite_access_token=".$this->suite_access_token;
		$post=array(
			'auth_code'=>$auth_code,
		);
		$content = $this->request($url,$post);
		if($content['errcode']){
			exi('获取企业永久授权码, 请稍后重试！错误详情：'.$content['errmsg'],'error');
		}
		if(empty($content['permanent_code'])) {
				exi('获取企业永久授权码, 请稍后重试！错误代码-' . $content['errcode'] . '，错误信息-' . $content['errmsg'],'error');
		}
		$update=array(
			'qy_access_token'=>$content['permanent_code'],
			'qy_expire'=>TIMESTAMP + $content['expires_in'] - 200,
		);
		pdo_update('core_account_permissions',$update,array('pid'=>$app['pid'],'uniacid'=>$_SESSION['uniacid']));
		return $content;
	}
	//获取登录用户信息
	public function get_login_info($auth_code){
		$url = "https://qyapi.weixin.qq.com/cgi-bin/service/get_login_info?access_token=".$this->work_weixin['provider_access_token'];
		$post=array(
			'auth_code'=>$auth_code,
		);
		$content = $this->request($url,$post);
		if($content['errcode']){
			exi('获取登录用户信息, 请稍后重试！错误详情：'.$content['errmsg'],'error');
		}
		return $content;
	}
	/*
		执行接口请求
	*/
	private function request($url,$post){
		if(is_array($post)){
			$post=ijson_encode($post);
		}
		$result=cfc('http')->request($url,$post);
		$result=@json_decode($result,true);
		
		return $result;
	}
	//错误码
	public function error_code($code, $errmsg = '未知错误') {//获取错误详情
		global $_AR;
		$errors = array(
			'-1' => '系统繁忙',
			'0' => '请求成功',
			'300002' => '商品标题太长了！最长14个汉字',
			'300003' => '价格输入不合规（如：现价比原价大、传入价格非数字等）',
			'300018' => '图片尺寸超过300px*300px',
			'300006' => '图片上传失败（如：mediaID过期）',
			'300007' => '线上小程序版本不存在该链接,请重新上传小程序代码！',
			'300022'=>'此房间号不存在',
			'300023'=>'房间状态 拦截（当前房间状态不允许此操作）',
			'300024'=>'商品不存在',
			'300025'=>'商品审核未通过',
			'300026'=>'房间商品数量已经满额',
			'300027'=>'导入商品失败',
			'300028'=>'房间名称违规',
			'300029'=>'主播昵称违规',
			'300030'=>'主播微信号不合法',
			'300031'=>'直播间封面图不合规',
			'300032'=>'直播间分享图违规',
			'300033'=>'添加商品超过直播间上限',
			'300034'=>'主播微信昵称长度不符合要求',
			'300035'=>'主播微信号不存在',
			'300036'=>'主播微信号未实名认证,登录微信搜索--《直播小程序》--实名认证一下即可！',
			'40001' => '获取access_token时AppSecret错误，或者access_token无效',
			'40002' => '不合法的凭证类型',
			'40003' => '不合法的OpenID',
			'40004' => '不合法的媒体文件类型',
			'40005' => '不合法的文件类型',
			'40006' => '不合法的文件大小',
			'40007' => '不合法的媒体文件id',
			'40008' => '不合法的消息类型',
			'40009' => '不合法的图片文件大小',
			'40010' => '不合法的语音文件大小',
			'40011' => '不合法的视频文件大小',
			'40012' => '不合法的缩略图文件大小',
			'40013' => '不合法的APPID',
			'40014' => '不合法的access_token',
			'40015' => '不合法的菜单类型',
			'40016' => '不合法的按钮个数',
			'40017' => '不合法的按钮个数',
			'40018' => '不合法的按钮名字长度',
			'40019' => '不合法的按钮KEY长度',
			'40020' => '不合法的按钮URL长度',
			'40021' => '不合法的菜单版本号',
			'40022' => '不合法的子菜单级数',
			'40023' => '不合法的子菜单按钮个数',
			'40024' => '不合法的子菜单按钮类型',
			'40025' => '不合法的子菜单按钮名字长度',
			'40026' => '不合法的子菜单按钮KEY长度',
			'40027' => '不合法的子菜单按钮URL长度',
			'40028' => '不合法的自定义菜单使用用户',
			'40029' => '不合法的oauth_code',
			'40030' => '不合法的refresh_token',
			'40031' => '不合法的openid列表',
			'40032' => '不合法的openid列表长度',
			'40033' => '不合法的请求字符，不能包含\uxxxx格式的字符',
			'40035' => '不合法的参数',
			'40038' => '不合法的请求格式',
			'40039' => '不合法的URL长度',
			'40050' => '不合法的分组id',
			'40051' => '分组名字不合法',
			'41001' => '缺少access_token参数',
			'41002' => '缺少appid参数',
			'41003' => '缺少refresh_token参数',
			'41004' => '缺少secret参数',
			'41005' => '缺少多媒体文件数据',
			'41006' => '缺少media_id参数',
			'41007' => '缺少子菜单数据',
			'41008' => '缺少oauth code',
			'41009' => '缺少openid',
			'42001' => 'access_token超时',
			'42002' => 'refresh_token超时',
			'42003' => 'oauth_code超时',
			'43001' => '需要GET请求',
			'43002' => '需要POST请求',
			'43003' => '需要HTTPS请求',
			'43004' => '需要接收者关注',
			'43005' => '需要好友关系',
			'44001' => '多媒体文件为空',
			'44002' => 'POST的数据包为空',
			'44003' => '图文消息内容为空',
			'44004' => '文本消息内容为空',
			'45001' => '多媒体文件大小超过限制',
			'45002' => '消息内容超过限制',
			'45003' => '标题字段超过限制',
			'45004' => '描述字段超过限制',
			'45005' => '链接字段超过限制',
			'45006' => '图片链接字段超过限制',
			'45007' => '语音播放时间超过限制',
			'45008' => '图文消息超过限制',
			'45009' => '接口调用超过限制',
			'45010' => '创建菜单个数超过限制',
			'45015' => '回复时间超过限制',
			'45016' => '系统分组，不允许修改',
			'45017' => '分组名字过长',
			'45018' => '分组数量超过上限',
			'45056' => '创建的标签数过多，请注意不能超过100个',
			'45057' => '该标签下粉丝数超过10w，不允许直接删除',
			'45058' => '不能修改0/1/2这三个系统默认保留的标签',
			'45059' => '有粉丝身上的标签数已经超过限制',
			'45157' => '标签名非法，请注意不能和其他标签重名',
			'45158' => '标签名长度超过30个字节',
			'45159' => '非法的标签',
			'46001' => '不存在媒体数据',
			'46002' => '不存在的菜单版本',
			'46003' => '不存在的菜单数据',
			'46004' => '不存在的用户',
			'47001' => '解析JSON/XML内容错误',
			'48001' => 'api功能未授权',
			'50001' => '用户未授权该api',
			'40070' => '基本信息baseinfo中填写的库存信息SKU不合法。',
			'41011' => '必填字段不完整或不合法，参考相应接口。',
			'40056' => '无效code，请确认code长度在20个字符以内，且处于非异常状态（转赠、删除）。',
			'43009' => '无自定义SN权限，请参考开发者必读中的流程开通权限。',
			'43010' => '无储值权限,请参考开发者必读中的流程开通权限。',
			'43011' => '无积分权限,请参考开发者必读中的流程开通权限。',
			'40078' => '无效卡券，未通过审核，已被置为失效。',
			'40079' => '基本信息base_info中填写的date_info不合法或核销卡券未到生效时间。',
			'45021' => '文本字段超过长度限制，请参考相应字段说明。',
			'40080' => '卡券扩展信息cardext不合法。',
			'40097' => '基本信息base_info中填写的参数不合法。',
			'49004' => '签名错误。',
			'43012' => '无自定义cell跳转外链权限，请参考开发者必读中的申请流程开通权限。',
			'40099' => '该code已被核销。',
			'61005' => '缺少接入平台关键数据，等待微信开放平台推送数据，请十分钟后再试或是检查“授权事件接收URL”是否写错（index.php?c=account&amp;a=auth&amp;do=ticket地址中的&amp;符号容易被替换成&amp;amp;）',
			'61023' => '请重新授权接入该小程序',
			'85005'=>'小程序未关联小程序，无法通过自定义菜单跳转！',
			'40164'=>'服务器IP不在白名单导致接口请求失败！请前往公众平台——开发——基本配置——小程序开发信息——IP白名单处设置',
		);
		$code = strval($code);
		if($errors[$code]) {
			return $errors[$code];
		} else {
			return $errmsg;
		}
	}
}