<?php
/*
	数据库结构文件
*/
return array (
  'core_access_log' => 'CREATE TABLE `ims_core_access_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `this` tinyint(1) unsigned NOT NULL,
  `os` tinyint(1) unsigned NOT NULL,
  `plugin` varchar(50) NOT NULL,
  `uid` int(10) unsigned NOT NULL,
  `runtime` int(10) unsigned NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `action` varchar(50) NOT NULL,
  `op` varchar(20) NOT NULL,
  `is_ip` tinyint(1) DEFAULT \'0\',
  PRIMARY KEY (`id`),
  KEY `log` (`uniacid`,`this`,`os`,`plugin`),
  KEY `access` (`createtime`,`uniacid`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_account_aliapp' => 'CREATE TABLE `ims_core_account_aliapp` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `type` tinyint(1) unsigned NOT NULL,
  `status` tinyint(1) unsigned NOT NULL,
  `aliapp_id` int(10) unsigned NOT NULL,
  `web_id` int(10) unsigned NOT NULL,
  `version` varchar(20) NOT NULL,
  `oldid` varchar(50) NOT NULL,
  `title` varchar(50) NOT NULL,
  `appid` varchar(100) NOT NULL,
  `private_key` text NOT NULL,
  `public_key` text NOT NULL,
  `remark` text NOT NULL,
  `items` text NOT NULL,
  `setting` text NOT NULL,
  `url` varchar(200) NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `last_up` int(10) unsigned NOT NULL,
  `desc` varchar(255) NOT NULL,
  `logo` varchar(200) NOT NULL,
  `textcolor` varchar(15) NOT NULL,
  `bgcolor` varchar(15) NOT NULL,
  `shownums` varchar(255) NOT NULL,
  `appsecret` varchar(100) NOT NULL,
  `istabbar` tinyint(1) unsigned NOT NULL,
  `sharetitle` varchar(100) NOT NULL,
  `sharedesc` varchar(100) NOT NULL,
  `shareimg` varchar(200) NOT NULL,
  `menu` text NOT NULL,
  `window` text NOT NULL,
  `plugin_name` varchar(50) NOT NULL,
  `isdiyindex` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uniacid` (`uniacid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_account_aliapp_fans' => 'CREATE TABLE `ims_core_account_aliapp_fans` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `aliapp_id` int(10) unsigned NOT NULL,
  `openid` char(16) NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `mid` int(10) unsigned NOT NULL,
  `avatar` varchar(200) NOT NULL,
  `nickname` varchar(100) NOT NULL,
  `province` varchar(100) NOT NULL,
  `city` varchar(100) NOT NULL,
  `is_student_certified` varchar(100) NOT NULL,
  `user_type` varchar(100) NOT NULL,
  `gender` varchar(100) NOT NULL,
  `updatetime` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uniacid` (`uniacid`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_account_aliapp_info' => 'CREATE TABLE `ims_core_account_aliapp_info` (
  `uniacid` int(10) unsigned NOT NULL,
  `title` varchar(50) NOT NULL,
  `logo` varchar(100) NOT NULL,
  `desc` varchar(500) NOT NULL,
  `hdps` text NOT NULL,
  `anlis` mediumtext NOT NULL,
  `biaoqian` text NOT NULL,
  PRIMARY KEY (`uniacid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8',
  'core_account_app' => 'CREATE TABLE `ims_core_account_app` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `status` tinyint(1) unsigned NOT NULL,
  `title` varchar(50) NOT NULL,
  `url` varchar(100) NOT NULL,
  `logo` char(100) NOT NULL,
  `android` char(100) NOT NULL,
  `ios` char(100) NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_account_article' => 'CREATE TABLE `ims_core_account_article` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `title` varchar(100) NOT NULL,
  `fenlei` int(10) unsigned NOT NULL,
  `keyword` varchar(50) NOT NULL,
  `readnum` int(10) unsigned NOT NULL,
  `likenum` int(10) unsigned NOT NULL,
  `status` tinyint(1) unsigned NOT NULL,
  `author` varchar(50) NOT NULL,
  `adtype` tinyint(1) unsigned NOT NULL,
  `adtitle` varchar(100) NOT NULL,
  `admore` varchar(100) NOT NULL,
  `date` varchar(20) NOT NULL,
  `account` tinyint(1) unsigned NOT NULL,
  `re_readnum` int(10) unsigned NOT NULL,
  `re_likenum` int(10) unsigned NOT NULL,
  `oldurl` varchar(100) NOT NULL,
  `article_rule_daynum` tinyint(3) unsigned NOT NULL,
  `article_rule_allnum` tinyint(3) unsigned NOT NULL,
  `article_rule_credit` int(10) unsigned NOT NULL,
  `article_rule_money` int(10) unsigned NOT NULL,
  `article_rule_money_total` int(10) unsigned NOT NULL,
  `article_rule_userd_money` int(10) unsigned NOT NULL,
  `ban` varchar(50) NOT NULL,
  `shows` varchar(50) NOT NULL,
  `desc` varchar(100) NOT NULL,
  `pic_url` char(200) NOT NULL,
  `content` text NOT NULL,
  `yingxiao` tinyint(1) unsigned NOT NULL,
  `adurl` varchar(100) NOT NULL,
  `advs` text NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `plugin_name` varchar(50) NOT NULL,
  `ishot` tinyint(1) DEFAULT \'0\',
  PRIMARY KEY (`id`),
  KEY `uniacid` (`uniacid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_account_article_fenlei' => 'CREATE TABLE `ims_core_account_article_fenlei` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `parentid` int(10) unsigned NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `group_level` tinyint(2) unsigned NOT NULL,
  `keyword` varchar(50) NOT NULL,
  `title` varchar(100) NOT NULL,
  `picurl` char(100) NOT NULL,
  `description` text NOT NULL,
  `plugin_name` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uniacid` (`uniacid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_account_article_like' => 'CREATE TABLE `ims_core_account_article_like` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `article_id` int(10) unsigned NOT NULL,
  `mid` int(10) unsigned NOT NULL,
  `like` tinyint(1) unsigned NOT NULL,
  `updatetime` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `like` (`article_id`,`mid`),
  KEY `likenum` (`article_id`,`like`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_account_baiduapp' => 'CREATE TABLE `ims_core_account_baiduapp` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `type` tinyint(1) unsigned NOT NULL,
  `status` tinyint(1) unsigned NOT NULL,
  `aliapp_id` int(10) unsigned NOT NULL,
  `web_id` int(10) unsigned NOT NULL,
  `version` varchar(20) NOT NULL,
  `oldid` varchar(50) NOT NULL,
  `title` varchar(50) NOT NULL,
  `appid` varchar(100) NOT NULL,
  `appsecret` varchar(100) NOT NULL,
  `mchid` varchar(50) NOT NULL,
  `paykey` varchar(50) NOT NULL,
  `access_token` varchar(200) NOT NULL,
  `expire` int(10) unsigned NOT NULL,
  `refresh_token` varchar(100) NOT NULL,
  `remark` text NOT NULL,
  `items` text NOT NULL,
  `setting` text NOT NULL,
  `url` varchar(200) NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `last_up` int(10) unsigned NOT NULL,
  `desc` varchar(255) NOT NULL,
  `logo` varchar(200) NOT NULL,
  `textcolor` varchar(15) NOT NULL,
  `bgcolor` varchar(15) NOT NULL,
  `is_wz` tinyint(1) unsigned NOT NULL,
  `shownums` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uniacid` (`uniacid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_account_context' => 'CREATE TABLE `ims_core_account_context` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `openid` char(28) NOT NULL,
  `expire` int(11) NOT NULL,
  `plugin` varchar(50) NOT NULL,
  `back_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_account_credit_log' => 'CREATE TABLE `ims_core_account_credit_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `type` tinyint(1) unsigned NOT NULL,
  `is_add` tinyint(1) unsigned NOT NULL,
  `fee` decimal(10,2) NOT NULL,
  `remark` text NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `log` (`uniacid`,`type`,`is_add`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_account_develop' => 'CREATE TABLE `ims_core_account_develop` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `status` tinyint(1) unsigned NOT NULL,
  `display` int(10) unsigned NOT NULL,
  `title` varchar(100) NOT NULL,
  `url` varchar(200) NOT NULL,
  `token` varchar(100) NOT NULL,
  `remark` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uniacid` (`uniacid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_account_group' => 'CREATE TABLE `ims_core_account_group` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `no_renew` tinyint(1) unsigned NOT NULL,
  `price` decimal(10,2) DEFAULT \'0.00\',
  `days` int(11) unsigned NOT NULL,
  `access` int(10) unsigned NOT NULL,
  `resource` int(10) unsigned NOT NULL,
  `isdefault` tinyint(1) unsigned NOT NULL,
  `wechat_num` int(10) unsigned NOT NULL,
  `wxapp_num` int(10) unsigned NOT NULL,
  `aliapp_num` int(10) unsigned NOT NULL,
  `baiduapp_num` int(10) unsigned NOT NULL,
  `mobile_num` int(10) unsigned NOT NULL,
  `app_num` int(10) unsigned NOT NULL,
  `sys_actions` text NOT NULL,
  `plugin_actions` text NOT NULL,
  `mobile_template` text NOT NULL,
  `pc_template` text NOT NULL,
  `wxapp` text NOT NULL,
  `wxapp_template` text NOT NULL,
  `aliapp_template` text NOT NULL,
  `createtime` int(11) unsigned NOT NULL,
  `tc_product_id` int(10) unsigned NOT NULL,
  `plugin_name` varchar(50) NOT NULL,
  `index_url` varchar(100) NOT NULL,
  `time_type` tinyint(3) unsigned NOT NULL,
  `options` varchar(1000) NOT NULL,
  `logo` varchar(100) NOT NULL,
  `desc` text NOT NULL,
  `content` text NOT NULL,
  `ttapp_num` int(11) NOT NULL,
  `opendiys` varchar(1000) NOT NULL,
  `diy_legao` text NOT NULL,
  `no_upwxapp` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_account_menus' => 'CREATE TABLE `ims_core_account_menus` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `wechat_id` int(10) unsigned NOT NULL,
  `status` tinyint(3) unsigned NOT NULL,
  `type` tinyint(3) unsigned NOT NULL,
  `title` varchar(30) NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `matchrule` text NOT NULL,
  `button` text NOT NULL,
  `menuid` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uniacid` (`uniacid`,`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_account_message' => 'CREATE TABLE `ims_core_account_message` (
  `id` int(20) NOT NULL AUTO_INCREMENT COMMENT \'自增长id\',
  `uniacid` int(10) DEFAULT \'0\',
  `uid` int(10) DEFAULT \'0\',
  `aid` int(10) DEFAULT \'0\' COMMENT \'文章ID\',
  `content` text COLLATE utf8_unicode_ci COMMENT \'内容\',
  `status` tinyint(1) DEFAULT \'0\' COMMENT \'是否处理\',
  `createtime` int(11) unsigned DEFAULT NULL,
  `username` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `userphone` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `useremail` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `type` int(2) NOT NULL,
  `data` text COLLATE utf8_unicode_ci NOT NULL,
  `formid` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `plugin_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `pageaction` varchar(100) COLLATE utf8_unicode_ci DEFAULT \'\',
  `ispay` tinyint(1) NOT NULL,
  `pay_id` int(11) NOT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ROW_FORMAT=DYNAMIC COMMENT=\'留言板\'',
  'core_account_nums' => 'CREATE TABLE `ims_core_account_nums` (
  `uniacid` int(10) unsigned NOT NULL,
  `wechat` int(10) unsigned NOT NULL,
  `wxapp` int(10) unsigned NOT NULL,
  `aliapp` int(10) unsigned NOT NULL,
  `baiduapp` int(10) unsigned NOT NULL,
  `mobile` int(10) unsigned NOT NULL,
  PRIMARY KEY (`uniacid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8',
  'core_account_open' => 'CREATE TABLE `ims_core_account_open` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `type` tinyint(1) unsigned NOT NULL,
  `wxgid` int(10) unsigned NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8',
  'core_account_pay_log' => 'CREATE TABLE `ims_core_account_pay_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `order_id` int(10) unsigned NOT NULL,
  `ordersn` char(20) NOT NULL,
  `fee` decimal(10,2) NOT NULL,
  `status` tinyint(1) unsigned NOT NULL,
  `title` varchar(50) NOT NULL,
  `no_type` varchar(50) NOT NULL,
  `remark` text NOT NULL,
  `back_url` varchar(100) NOT NULL,
  `pay_type` varchar(20) NOT NULL,
  `transaction_id` varchar(100) NOT NULL,
  `success_url` varchar(100) NOT NULL,
  `error_url` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ordersn` (`ordersn`),
  KEY `uniacid` (`uniacid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_account_permissions' => 'CREATE TABLE `ims_core_account_permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `pid` int(10) unsigned NOT NULL,
  `type` tinyint(1) unsigned NOT NULL,
  `time` int(10) unsigned NOT NULL,
  `buytype` tinyint(1) DEFAULT \'0\',
  `suite_ticket` varchar(520) NOT NULL,
  `suite_access_token` varchar(520) NOT NULL,
  `expire` int(11) NOT NULL,
  `pre_auth_code` varchar(520) NOT NULL,
  `pre_expire` int(11) NOT NULL,
  `permanent_code` varchar(520) NOT NULL,
  `qy_access_token` varchar(520) NOT NULL,
  `qy_expire` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uniacid` (`uniacid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_account_plugin_setting' => 'CREATE TABLE `ims_core_account_plugin_setting` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `plugin` varchar(50) NOT NULL,
  `key` varchar(50) NOT NULL,
  `data` mediumtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `setting` (`uniacid`,`plugin`,`key`(5))
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_account_product' => 'CREATE TABLE `ims_core_account_product` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) DEFAULT \'0\',
  `group_id` int(5) DEFAULT \'0\',
  `name` varchar(40) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT \'\' COMMENT \'产品名\',
  `price` decimal(8,2) DEFAULT \'0.00\',
  `title` varchar(150) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT \'\',
  `desc` varchar(300) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `tuijian` tinyint(1) DEFAULT \'0\' COMMENT \'推荐\',
  `picurl` varchar(200) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `content` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `pingfen` tinyint(1) DEFAULT \'5\' COMMENT \'评价\',
  `biaoqian` varchar(300) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT \'\' COMMENT \'标签\',
  `status` tinyint(1) DEFAULT \'1\',
  `qrcode` varchar(200) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT \'\' COMMENT \'二维码\',
  `readnum` int(8) DEFAULT \'0\' COMMENT \'访问量\',
  `slide` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL COMMENT \'截图\',
  `createtime` int(11) unsigned NOT NULL,
  `pingfenlog` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC',
  'core_account_product_biaoqian' => 'CREATE TABLE `ims_core_account_product_biaoqian` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) DEFAULT \'0\',
  `bqs` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC',
  'core_account_product_fenlei' => 'CREATE TABLE `ims_core_account_product_fenlei` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) DEFAULT \'0\',
  `title` varchar(150) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT \'\',
  `des` varchar(300) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT \'\',
  `tuijian` tinyint(1) DEFAULT \'0\' COMMENT \'推荐\',
  `img` varchar(200) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT \'\',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC',
  'core_account_recharge' => 'CREATE TABLE `ims_core_account_recharge` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `fee` decimal(10,2) NOT NULL,
  `status` tinyint(1) unsigned NOT NULL,
  `trade_no` varchar(100) NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_account_recycle' => 'CREATE TABLE `ims_core_account_recycle` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(50) NOT NULL,
  `uniacid` int(10) unsigned NOT NULL,
  `reason` varchar(100) NOT NULL,
  `file` varchar(100) NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_account_setting' => 'CREATE TABLE `ims_core_account_setting` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `key` varchar(50) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `setting` (`uniacid`,`key`(5))
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_account_store' => 'CREATE TABLE `ims_core_account_store` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) DEFAULT \'0\',
  `storename` varchar(255) DEFAULT \'\',
  `address` varchar(255) DEFAULT \'\',
  `tel` varchar(255) DEFAULT \'\',
  `naddress` varchar(255) DEFAULT \'\',
  `status` tinyint(3) DEFAULT \'0\',
  `type` tinyint(1) DEFAULT \'0\',
  `mobile` varchar(255) DEFAULT \'\',
  `logo` varchar(255) DEFAULT \'\',
  `desc` text,
  `group_id` int(11) DEFAULT \'0\',
  `createtime` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_uniacid` (`uniacid`),
  KEY `idx_status` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_account_store_group' => 'CREATE TABLE `ims_core_account_store_group` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `paixu` int(10) unsigned NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `group_id` int(10) unsigned NOT NULL,
  `title` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uniacid` (`uniacid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_account_store_logs' => 'CREATE TABLE `ims_core_account_store_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `pid` int(10) unsigned NOT NULL,
  `type` int(10) unsigned NOT NULL,
  `num` int(10) unsigned NOT NULL,
  `price` int(10) unsigned NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `content` varchar(100) NOT NULL,
  `remark` varchar(100) NOT NULL,
  `status` tinyint(1) unsigned NOT NULL,
  `pay_id` int(10) unsigned NOT NULL,
  `days` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uniacid` (`uniacid`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_account_tpl_template' => 'CREATE TABLE `ims_core_account_tpl_template` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `wechat_id` int(10) unsigned NOT NULL,
  `template_name` varchar(50) NOT NULL,
  `template_id` varchar(50) NOT NULL,
  `remark` varchar(100) NOT NULL,
  `type` tinyint(1) NOT NULL,
  `plugin_name` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `footercolor` varchar(20) NOT NULL,
  `firstcolor` varchar(20) NOT NULL,
  `first` varchar(500) NOT NULL,
  `footer` varchar(500) NOT NULL,
  `kefumsg` text NOT NULL,
  `keywords` text NOT NULL,
  `coreid` int(11) NOT NULL,
  `title` varchar(100) NOT NULL,
  `wxapp_id` int(11) NOT NULL,
  `wxapptemplate_id` varchar(50) DEFAULT \'\',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_account_wechat' => 'CREATE TABLE `ims_core_account_wechat` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) unsigned NOT NULL,
  `type` tinyint(1) unsigned NOT NULL,
  `is_open` tinyint(1) unsigned NOT NULL,
  `isdefault` tinyint(1) unsigned NOT NULL,
  `isrenzheng` tinyint(1) unsigned NOT NULL,
  `title` varchar(50) NOT NULL,
  `appid` varchar(100) NOT NULL,
  `appsecret` varchar(100) NOT NULL,
  `oldid` varchar(20) NOT NULL,
  `access_token` varchar(600) NOT NULL,
  `expire` int(11) unsigned NOT NULL,
  `refresh_token` varchar(100) NOT NULL,
  `ishuancun` tinyint(2) NOT NULL,
  `jsticket` varchar(100) NOT NULL,
  `jsexpire` int(11) NOT NULL,
  `yindao` varchar(100) NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `api_ticket` varchar(100) NOT NULL,
  `api_ticket_expire` int(10) unsigned NOT NULL,
  `tt_appid` varchar(100) NOT NULL,
  `tt_secret` varchar(100) NOT NULL,
  `ali_appid` varchar(100) NOT NULL,
  `ali_secret` varchar(100) NOT NULL,
  `baidu_appid` varchar(100) NOT NULL,
  `baidu_secret` varchar(100) NOT NULL,
  `wxwork_appid` varchar(100) NOT NULL,
  `is_diy` tinyint(1) DEFAULT \'0\',
  PRIMARY KEY (`id`),
  KEY `uniacid` (`uniacid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_account_wxapp' => 'CREATE TABLE `ims_core_account_wxapp` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `type` tinyint(1) unsigned NOT NULL,
  `status` tinyint(1) unsigned NOT NULL,
  `wxapp_id` int(10) unsigned NOT NULL,
  `web_id` int(10) unsigned NOT NULL,
  `version` varchar(20) NOT NULL,
  `oldid` varchar(50) NOT NULL,
  `title` varchar(50) NOT NULL,
  `appid` varchar(100) NOT NULL,
  `appsecret` varchar(100) NOT NULL,
  `mchid` varchar(50) NOT NULL,
  `paykey` varchar(50) NOT NULL,
  `access_token` varchar(200) NOT NULL,
  `expire` int(10) unsigned NOT NULL,
  `refresh_token` varchar(100) NOT NULL,
  `remark` text NOT NULL,
  `items` text NOT NULL,
  `setting` text NOT NULL,
  `url` varchar(200) NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `last_up` int(10) unsigned NOT NULL,
  `desc` varchar(255) NOT NULL,
  `logo` varchar(200) NOT NULL,
  `textcolor` varchar(15) NOT NULL,
  `bgcolor` varchar(15) NOT NULL,
  `is_wz` tinyint(1) unsigned NOT NULL,
  `shownums` varchar(255) NOT NULL,
  `istabbar` tinyint(1) unsigned NOT NULL,
  `sharetitle` varchar(100) NOT NULL,
  `sharedesc` varchar(100) NOT NULL,
  `shareimg` varchar(200) NOT NULL,
  `menu` text NOT NULL,
  `window` text NOT NULL,
  `plugin_name` varchar(50) NOT NULL,
  `isdiyindex` tinyint(1) NOT NULL,
  `tt_appid` varchar(100) NOT NULL,
  `tt_secret` varchar(100) NOT NULL,
  `ali_appid` varchar(100) NOT NULL,
  `ali_secret` varchar(100) NOT NULL,
  `baidu_appid` varchar(100) NOT NULL,
  `baidu_secret` varchar(100) NOT NULL,
  `qq_appid` varchar(100) NOT NULL,
  `qq_secret` varchar(100) NOT NULL,
  `syscolor` varchar(50) NOT NULL,
  `uptime` int(11) NOT NULL,
  `alipay_private_key` text NOT NULL,
  `alipay_public_key` text NOT NULL,
  `tt_paymchid` varchar(20) NOT NULL,
  `tt_payappid` varchar(20) NOT NULL,
  `tt_paysecret` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uniacid` (`uniacid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_account_wxapp_ewm' => 'CREATE TABLE `ims_core_account_wxapp_ewm` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `wxapp_id` int(10) unsigned NOT NULL,
  `action` varchar(300) NOT NULL,
  `attachment` varchar(100) NOT NULL,
  `createtime` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_account_wxapp_info' => 'CREATE TABLE `ims_core_account_wxapp_info` (
  `uniacid` int(10) unsigned NOT NULL,
  `title` varchar(50) NOT NULL,
  `logo` varchar(100) NOT NULL,
  `desc` varchar(500) NOT NULL,
  `hdps` text NOT NULL,
  `anlis` mediumtext NOT NULL,
  `biaoqian` text NOT NULL,
  `default_wxapp` int(10) unsigned NOT NULL,
  PRIMARY KEY (`uniacid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8',
  'core_account_wxapp_jump' => 'CREATE TABLE `ims_core_account_wxapp_jump` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `title` varchar(50) NOT NULL,
  `appid` varchar(50) NOT NULL,
  `path` varchar(50) NOT NULL,
  `wxid` int(10) unsigned NOT NULL,
  `type` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uniacid` (`uniacid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_account_wxapp_pages' => 'CREATE TABLE `ims_core_account_wxapp_pages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `wxapp_id` int(10) unsigned NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `is_index` tinyint(1) unsigned NOT NULL,
  `name` varchar(50) NOT NULL,
  `title` varchar(100) NOT NULL,
  `items` text NOT NULL,
  `setting` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `page` (`uniacid`,`wxapp_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_accounts' => 'CREATE TABLE `ims_core_accounts` (
  `uniacid` int(10) unsigned NOT NULL,
  `groupid` int(10) unsigned NOT NULL,
  `stop` tinyint(1) unsigned NOT NULL,
  `endtime` int(11) unsigned NOT NULL,
  `title` varchar(50) NOT NULL,
  `followurl` varchar(100) NOT NULL,
  `logo` varchar(100) NOT NULL,
  `token` char(30) NOT NULL,
  `aeskey` char(43) NOT NULL,
  `mani` tinyint(1) unsigned NOT NULL,
  `credit1` int(11) NOT NULL,
  `credit2` decimal(10,2) NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `desc` varchar(500) NOT NULL,
  `ewm` varchar(200) NOT NULL,
  `hdps` text NOT NULL,
  `anlis` text NOT NULL,
  `about` text NOT NULL,
  `code` text NOT NULL,
  `lxr` varchar(20) NOT NULL,
  `phone` varchar(20) NOT NULL,
  `qq` varchar(20) NOT NULL,
  `mail` varchar(20) NOT NULL,
  `cname` varchar(50) NOT NULL,
  `icp` varchar(20) NOT NULL,
  `address` varchar(100) NOT NULL,
  `naddress` varchar(50) NOT NULL,
  `wxapp_ewm` varchar(255) NOT NULL,
  `xiu_ewm` varchar(255) NOT NULL,
  `domain` varchar(50) NOT NULL,
  `links` text NOT NULL,
  `culture` text NOT NULL,
  `join` text NOT NULL,
  `agent_id` int(10) unsigned NOT NULL,
  `kflink` varchar(255) NOT NULL,
  `apps` text NOT NULL,
  `plugins` text NOT NULL,
  `noapps` tinyint(1) unsigned NOT NULL,
  `noplugins` tinyint(1) unsigned NOT NULL,
  `h5game` text NOT NULL,
  `webapps` text NOT NULL,
  `newsgroupid` int(11) NOT NULL,
  `xiu_url` varchar(150) NOT NULL,
  `attachment` int(10) unsigned NOT NULL,
  `isdiy` tinyint(1) NOT NULL,
  `opendiys` varchar(1000) NOT NULL,
  `syscolor` varchar(50) NOT NULL,
  `js_support` varchar(50) NOT NULL,
  `js_supportimg` varchar(100) NOT NULL,
  `banner380` varchar(50) NOT NULL,
  `navs` text NOT NULL,
  PRIMARY KEY (`uniacid`),
  KEY `domain` (`domain`(10))
) ENGINE=MyISAM DEFAULT CHARSET=utf8',
  'core_address' => 'CREATE TABLE `ims_core_address` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `mid` int(10) unsigned NOT NULL,
  `isdefault` tinyint(1) unsigned NOT NULL,
  `area_code` char(12) NOT NULL,
  `mobile` char(12) NOT NULL,
  `name` varchar(20) NOT NULL,
  `pcd` varchar(200) NOT NULL,
  `address` varchar(200) NOT NULL,
  `lat_lng` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_agent' => 'CREATE TABLE `ims_core_agent` (
  `uniacid` int(10) unsigned NOT NULL,
  `name` varchar(30) NOT NULL,
  `incode` char(10) NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `checktime` int(10) unsigned NOT NULL,
  `status` tinyint(1) unsigned NOT NULL,
  `commission` tinyint(2) unsigned NOT NULL,
  PRIMARY KEY (`uniacid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8',
  'core_agent_clear' => 'CREATE TABLE `ims_core_agent_clear` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `ordersn` char(20) NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `money` int(10) unsigned NOT NULL,
  `status` tinyint(1) unsigned NOT NULL,
  `ispay` tinyint(1) unsigned NOT NULL,
  `pay_type` tinyint(1) unsigned NOT NULL,
  `trade_id` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_agent_commission' => 'CREATE TABLE `ims_core_agent_commission` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `order_id` int(10) unsigned NOT NULL,
  `money` int(10) unsigned NOT NULL,
  `status` tinyint(1) unsigned NOT NULL,
  `clearsn` char(20) NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_aliapp' => 'CREATE TABLE `ims_core_aliapp` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cloud_id` int(10) unsigned NOT NULL,
  `type` tinyint(1) unsigned NOT NULL,
  `version1` int(10) unsigned NOT NULL,
  `version` varchar(20) NOT NULL,
  `title` varchar(50) NOT NULL,
  `plugin` varchar(50) NOT NULL,
  `image` char(30) NOT NULL,
  `template_id` int(10) unsigned NOT NULL,
  `price` int(10) unsigned NOT NULL,
  `days` int(10) unsigned NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `pages` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8',
  'core_aliapp_template' => 'CREATE TABLE `ims_core_aliapp_template` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `cloud_id` int(10) unsigned NOT NULL,
  `group_id` int(10) unsigned NOT NULL,
  `price` int(10) unsigned NOT NULL,
  `days` int(10) unsigned NOT NULL,
  `version` varchar(20) NOT NULL,
  `image` char(50) NOT NULL,
  `title` varchar(50) NOT NULL,
  `items` text NOT NULL,
  `setting` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_area' => 'CREATE TABLE `ims_core_area` (
  `code` char(12) NOT NULL,
  `parent_code` char(12) NOT NULL,
  `type` tinyint(1) unsigned NOT NULL COMMENT \'1省2市3区4镇5村\',
  `title` varchar(100) NOT NULL,
  `address` varchar(200) NOT NULL,
  PRIMARY KEY (`code`),
  KEY `parent` (`parent_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8',
  'core_article' => 'CREATE TABLE `ims_core_article` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `group_id` int(10) unsigned NOT NULL,
  `status` tinyint(1) unsigned NOT NULL,
  `paixu` tinyint(3) unsigned NOT NULL,
  `content` text NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `type` tinyint(1) unsigned NOT NULL,
  `tag` varchar(250) NOT NULL,
  `desc` varchar(250) NOT NULL,
  `author` varchar(15) NOT NULL DEFAULT \'\',
  `readnum` int(11) NOT NULL,
  `image` varchar(200) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `show` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_article_group' => 'CREATE TABLE `ims_core_article_group` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `paixu` tinyint(3) unsigned NOT NULL,
  `title` varchar(100) NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `type` tinyint(1) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_attachment' => 'CREATE TABLE `ims_core_attachment` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) unsigned NOT NULL,
  `group_id` int(10) NOT NULL,
  `attachment` char(100) NOT NULL,
  `type` char(8) NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `title` varchar(50) NOT NULL,
  `md5` char(32) NOT NULL,
  `size` int(10) unsigned NOT NULL,
  `wx_url` varchar(200) NOT NULL,
  `mid` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uni` (`uniacid`,`type`(5),`group_id`),
  KEY `file` (`attachment`(15))
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_attachment_group' => 'CREATE TABLE `ims_core_attachment_group` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `title` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_back' => 'CREATE TABLE `ims_core_back` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `title` varchar(100) NOT NULL,
  `backtype` tinyint(1) unsigned NOT NULL,
  `content` text NOT NULL,
  `paixu` int(11) NOT NULL,
  `status` tinyint(1) unsigned NOT NULL,
  `key` varchar(100) NOT NULL,
  `plugin` varchar(50) NOT NULL,
  `createtime` int(11) NOT NULL,
  `action` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `module` (`plugin`),
  KEY `uniacid` (`uniacid`),
  KEY `api` (`uniacid`,`status`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_back_keyword' => 'CREATE TABLE `ims_core_back_keyword` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `back_id` int(10) unsigned NOT NULL,
  `type` tinyint(1) unsigned NOT NULL,
  `keyword` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uniacid` (`uniacid`),
  KEY `back` (`back_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_baiduapp' => 'CREATE TABLE `ims_core_baiduapp` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cloud_id` int(10) unsigned NOT NULL,
  `type` tinyint(1) unsigned NOT NULL,
  `version1` int(10) unsigned NOT NULL,
  `version` varchar(20) NOT NULL,
  `title` varchar(50) NOT NULL,
  `plugin` varchar(50) NOT NULL,
  `image` char(30) NOT NULL,
  `template_id` int(10) unsigned NOT NULL,
  `price` int(10) unsigned NOT NULL,
  `days` int(10) unsigned NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `pages` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8',
  'core_baiduapp_template' => 'CREATE TABLE `ims_core_baiduapp_template` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `cloud_id` int(10) unsigned NOT NULL,
  `group_id` int(10) unsigned NOT NULL,
  `price` int(10) unsigned NOT NULL,
  `days` int(10) unsigned NOT NULL,
  `version` varchar(20) NOT NULL,
  `image` char(100) NOT NULL,
  `title` varchar(50) NOT NULL,
  `items` text NOT NULL,
  `setting` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8',
  'core_cache' => 'CREATE TABLE `ims_core_cache` (
  `ckey` varchar(50) NOT NULL,
  `value` mediumtext NOT NULL,
  `plugin` varchar(50) NOT NULL,
  `title` varchar(50) NOT NULL,
  `uid` int(11) NOT NULL,
  `uniacid` int(11) NOT NULL,
  PRIMARY KEY (`ckey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8',
  'core_card' => 'CREATE TABLE `ims_core_card` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `type` tinyint(1) unsigned NOT NULL,
  `is_wechat` tinyint(1) unsigned NOT NULL,
  `num` int(10) unsigned NOT NULL,
  `logo` char(50) NOT NULL,
  `title` varchar(100) NOT NULL,
  `title1` varchar(100) NOT NULL,
  `title2` varchar(100) NOT NULL,
  `color` varchar(20) NOT NULL,
  `need` int(10) unsigned NOT NULL,
  `data` decimal(10,2) NOT NULL,
  `limit_type` tinyint(1) unsigned NOT NULL,
  `limit_data` varchar(30) NOT NULL,
  `content` text NOT NULL,
  `mobile` char(12) DEFAULT NULL,
  `createtime` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uniacid` (`uniacid`,`is_wechat`,`type`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_card_activity' => 'CREATE TABLE `ims_core_card_activity` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `card_id` int(10) unsigned NOT NULL,
  `type` tinyint(1) unsigned NOT NULL,
  `limit_num` int(10) unsigned NOT NULL,
  `groupid` int(10) unsigned NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `title` varchar(100) NOT NULL,
  `ac_time` varchar(30) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uniacid` (`uniacid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_card_log' => 'CREATE TABLE `ims_core_card_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `mid` int(10) unsigned NOT NULL,
  `card_id` int(10) unsigned NOT NULL,
  `code` char(10) NOT NULL,
  `status` tinyint(1) unsigned NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `plugin` varchar(20) NOT NULL,
  `remark` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uniacid` (`uniacid`,`card_id`,`mid`),
  KEY `code` (`code`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_credit_log' => 'CREATE TABLE `ims_core_credit_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `mid` int(10) unsigned NOT NULL,
  `type` tinyint(1) unsigned NOT NULL,
  `is_add` tinyint(1) unsigned NOT NULL,
  `plugin` varchar(50) NOT NULL,
  `fee` decimal(10,2) NOT NULL,
  `remark` varchar(100) NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `tag` varchar(22) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uniacid` (`uniacid`,`mid`,`type`,`is_add`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_diy_menu' => 'CREATE TABLE `ims_core_diy_menu` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `status` tinyint(1) unsigned NOT NULL,
  `plugin` varchar(50) NOT NULL,
  `title` varchar(50) NOT NULL,
  `data` text NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_domain' => 'CREATE TABLE `ims_core_domain` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `domain` varchar(50) NOT NULL,
  `url` varchar(200) NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uniacid` (`uniacid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_error_log' => 'CREATE TABLE `ims_core_error_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) unsigned NOT NULL,
  `function` varchar(50) NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `message` text NOT NULL,
  `session` text NOT NULL,
  `debug` text NOT NULL,
  `query` text NOT NULL,
  `postdata` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_fans' => 'CREATE TABLE `ims_core_fans` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) unsigned NOT NULL,
  `wxgid` int(11) NOT NULL,
  `type` tinyint(1) unsigned NOT NULL,
  `openid` char(28) NOT NULL,
  `unionid` char(30) NOT NULL,
  `mid` int(11) unsigned NOT NULL,
  `follow` tinyint(1) unsigned NOT NULL,
  `tagid_list` varchar(100) NOT NULL,
  `nickname` varchar(100) NOT NULL,
  `sex` tinyint(1) unsigned NOT NULL,
  `pcd` varchar(100) NOT NULL,
  `avatar` varchar(200) NOT NULL,
  `createtime` int(11) unsigned NOT NULL,
  `updatetime` int(10) unsigned NOT NULL,
  `openid_qq` varchar(50) NOT NULL DEFAULT \'\',
  `openid_wa` varchar(50) NOT NULL DEFAULT \'\',
  `openid_ali` varchar(50) NOT NULL DEFAULT \'\',
  `plugin` varchar(100) NOT NULL,
  `wxcard_code` varchar(100) NOT NULL,
  `ttgid` int(11) NOT NULL,
  `baidugid` int(11) NOT NULL,
  `aligid` int(11) NOT NULL,
  `auth_wxid` int(11) NOT NULL,
  `wxcard_id` varchar(50) NOT NULL,
  `expires_time` int(11) NOT NULL,
  `refresh_time` int(11) NOT NULL,
  `access_token` varchar(100) NOT NULL,
  `refresh_token` varchar(100) NOT NULL,
  `credit1` decimal(10,2) NOT NULL,
  `credit1time` int(11) NOT NULL,
  `isworkman` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mid` (`mid`),
  KEY `idx` (`uniacid`),
  KEY `openid` (`openid`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC',
  'core_fansgroup' => 'CREATE TABLE `ims_core_fansgroup` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) unsigned NOT NULL,
  `wxgid` int(10) unsigned NOT NULL,
  `tag_id` int(10) unsigned NOT NULL,
  `title` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx` (`uniacid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_h5game' => 'CREATE TABLE `ims_core_h5game` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `is_my` tinyint(1) unsigned NOT NULL,
  `cloud_id` int(10) unsigned NOT NULL,
  `release` int(10) unsigned NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `type` tinyint(1) unsigned NOT NULL,
  `image` char(100) NOT NULL,
  `name` varchar(50) NOT NULL,
  `title` varchar(50) NOT NULL,
  `version` varchar(20) NOT NULL,
  `desc` text NOT NULL,
  `ishongbao` int(2) NOT NULL,
  `jrid` tinyint(3) unsigned NOT NULL,
  `diy_form` text NOT NULL,
  `new` int(3) NOT NULL DEFAULT \'0\',
  `up_my` tinyint(1) DEFAULT \'0\',
  `cloud_price` decimal(10,2) NOT NULL COMMENT \'价格\',
  `paixu` int(11) DEFAULT \'0\',
  `tuijie` int(11) DEFAULT \'0\',
  PRIMARY KEY (`id`),
  KEY `is_my` (`is_my`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_ignores' => 'CREATE TABLE `ims_core_ignores` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `plugin_id` int(10) unsigned NOT NULL,
  `type` tinyint(1) unsigned NOT NULL,
  `name` varchar(100) NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `plugin` (`plugin_id`,`type`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_jdk_access' => 'CREATE TABLE `ims_core_jdk_access` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `token` varchar(200) DEFAULT NULL,
  `refresh_token` varchar(500) DEFAULT NULL,
  `time` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_kefu_chat' => 'CREATE TABLE `ims_core_kefu_chat` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) NOT NULL,
  `userid` varchar(50) NOT NULL,
  `kefuid` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_kefu_chatlog' => 'CREATE TABLE `ims_core_kefu_chatlog` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) NOT NULL,
  `userid` varchar(50) NOT NULL,
  `msg` varchar(255) NOT NULL,
  `createtime` int(11) NOT NULL,
  `nickname` varchar(50) NOT NULL,
  `logo` varchar(200) NOT NULL,
  `type` tinyint(1) NOT NULL,
  `isread` tinyint(1) NOT NULL,
  `kefuid` int(11) NOT NULL,
  `isdeluser` tinyint(1) NOT NULL,
  `isdelkefu` tinyint(1) NOT NULL,
  `chatid` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_manage_template' => 'CREATE TABLE `ims_core_manage_template` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `is_my` tinyint(1) unsigned NOT NULL,
  `name` varchar(50) NOT NULL,
  `title` varchar(100) NOT NULL,
  `release` int(10) unsigned NOT NULL,
  `version` varchar(50) NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `updatetime` int(10) unsigned NOT NULL,
  `diy_form` text NOT NULL,
  `cloud_id` int(11) NOT NULL,
  `up_my` tinyint(1) DEFAULT \'0\',
  `cloud_price` decimal(10,2) NOT NULL COMMENT \'价格\',
  `paixu` int(11) DEFAULT \'0\',
  `tuijie` int(11) DEFAULT \'0\',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_mass' => 'CREATE TABLE `ims_core_mass` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `wxgid` int(10) unsigned NOT NULL,
  `content_type` tinyint(1) unsigned NOT NULL,
  `title` varchar(100) NOT NULL,
  `content` text NOT NULL,
  `send_time` int(10) unsigned NOT NULL,
  `send_type` tinyint(1) unsigned NOT NULL,
  `sendto_type` tinyint(1) unsigned NOT NULL,
  `sendto` int(10) unsigned NOT NULL,
  `status` tinyint(1) unsigned NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `plan_id` int(10) unsigned NOT NULL,
  `lookcontent` text NOT NULL,
  `choose_type` tinyint(1) unsigned NOT NULL,
  `saletask_type` tinyint(1) DEFAULT \'0\',
  `saletask_set` varchar(500) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uniacid` (`uniacid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_media' => 'CREATE TABLE `ims_core_media` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `wxgid` varchar(100) NOT NULL,
  `type` tinyint(1) unsigned NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `updatetime` int(10) unsigned NOT NULL,
  `title` varchar(50) NOT NULL,
  `attachment` char(255) NOT NULL,
  `media_id` varchar(500) NOT NULL,
  `url` varchar(500) NOT NULL,
  `lookcontent` text NOT NULL,
  `content` text NOT NULL,
  `groupid` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uniacid` (`uniacid`,`wxgid`,`type`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_media_news' => 'CREATE TABLE `ims_core_media_news` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `wxgid` int(10) unsigned NOT NULL,
  `media_id` int(10) unsigned NOT NULL,
  `index` int(10) unsigned NOT NULL,
  `title` varchar(100) NOT NULL,
  `thumb` char(255) NOT NULL,
  `show_cover_pic` tinyint(1) unsigned NOT NULL,
  `author` varchar(100) NOT NULL,
  `digest` text NOT NULL,
  `content` text NOT NULL,
  `url` varchar(200) NOT NULL,
  `content_source_url` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_member_card' => 'CREATE TABLE `ims_core_member_card` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) DEFAULT \'0\',
  `wxcard_id` varchar(255) DEFAULT NULL,
  `iswechat` tinyint(1) DEFAULT \'0\',
  `type` varchar(50) DEFAULT NULL,
  `status` tinyint(1) DEFAULT \'0\',
  `logoimg` varchar(255) DEFAULT NULL,
  `logowxurl` varchar(255) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `color` varchar(50) DEFAULT NULL,
  `notice` varchar(50) DEFAULT NULL,
  `service_phone` varchar(50) DEFAULT NULL,
  `prerogative` varchar(255) DEFAULT NULL,
  `description` text,
  `brand_name` varchar(255) DEFAULT NULL,
  `totalquantity` int(11) DEFAULT NULL,
  `quantity` int(11) DEFAULT NULL,
  `backgroundtype` tinyint(1) DEFAULT NULL,
  `backgroundimg` varchar(255) DEFAULT NULL,
  `backgroundwxurl` varchar(255) DEFAULT NULL,
  `freewifi` tinyint(1) DEFAULT NULL,
  `withpet` tinyint(1) DEFAULT NULL,
  `freepark` tinyint(1) DEFAULT NULL,
  `deliver` tinyint(1) DEFAULT NULL,
  `custom_cell1` tinyint(1) DEFAULT NULL,
  `custom_cell1_name` varchar(255) DEFAULT NULL,
  `custom_cell1_tips` varchar(255) DEFAULT NULL,
  `custom_cell1_url` varchar(255) DEFAULT NULL,
  `wxcarduptime` int(11) DEFAULT \'0\',
  `paixu` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_uniacid` (`uniacid`),
  KEY `idx_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC',
  'core_member_cash' => 'CREATE TABLE `ims_core_member_cash` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `mid` int(10) unsigned NOT NULL,
  `ordersn` char(24) NOT NULL,
  `money` decimal(10,2) NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `status` tinyint(1) unsigned NOT NULL,
  `pay_out_id` int(10) unsigned NOT NULL,
  `remark` varchar(100) NOT NULL,
  `service_money` decimal(10,2) NOT NULL,
  `cash_money` decimal(10,2) NOT NULL,
  `type` tinyint(1) NOT NULL,
  `realname` varchar(50) NOT NULL,
  `alipay` varchar(50) NOT NULL,
  `bankname` varchar(50) NOT NULL,
  `bankcard` varchar(25) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ordersn` (`ordersn`),
  KEY `uniacid` (`uniacid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_member_groups' => 'CREATE TABLE `ims_core_member_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `level` tinyint(2) unsigned NOT NULL,
  `uptype` tinyint(1) unsigned NOT NULL,
  `upneed` int(10) unsigned NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `title` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uniacid` (`uniacid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_members' => 'CREATE TABLE `ims_core_members` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) unsigned NOT NULL,
  `level_id` int(10) unsigned NOT NULL,
  `groupid` int(10) unsigned NOT NULL,
  `fromuser` int(10) unsigned NOT NULL,
  `from_os` tinyint(1) unsigned NOT NULL,
  `createtime` int(11) unsigned NOT NULL,
  `mobile` char(12) NOT NULL,
  `username` varchar(20) NOT NULL,
  `password` char(40) NOT NULL,
  `salt` char(10) NOT NULL,
  `unionid` char(30) NOT NULL,
  `credit2` decimal(10,2) DEFAULT \'0.00\',
  `credit1` int(11) unsigned NOT NULL,
  `nickname` varchar(50) NOT NULL,
  `avatar` varchar(150) NOT NULL,
  `qq` int(11) unsigned NOT NULL,
  `wechat` varchar(100) NOT NULL,
  `address` varchar(200) NOT NULL,
  `birth` varchar(100) NOT NULL,
  `pcd` varchar(100) NOT NULL,
  `sex` tinyint(1) NOT NULL,
  `sign_days` int(10) NOT NULL,
  `comefrom` varchar(20) DEFAULT NULL,
  `cardnum` varchar(30) DEFAULT \'\',
  `plugin` varchar(100) NOT NULL,
  `updatetime` int(10) unsigned NOT NULL,
  `realname` varchar(20) DEFAULT NULL COMMENT \'真实姓名\',
  `email` varchar(50) DEFAULT NULL COMMENT \'邮箱地址\',
  `is_virtual` tinyint(1) NOT NULL,
  `credit2_fz` decimal(10,2) NOT NULL DEFAULT \'0.00\',
  `merchid` int(11) NOT NULL,
  `storeid` int(11) NOT NULL,
  `luckkey` int(3) NOT NULL,
  `diyformdata` text NOT NULL,
  `onemid` int(11) NOT NULL,
  `realmobile` char(12) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `name` (`username`),
  KEY `mobile` (`mobile`),
  KEY `uniacid` (`uniacid`),
  KEY `card` (`cardnum`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_message' => 'CREATE TABLE `ims_core_message` (
  `id` int(20) NOT NULL AUTO_INCREMENT COMMENT \'自增长id\',
  `uniacid` int(10) DEFAULT \'0\',
  `uid` int(10) DEFAULT \'0\',
  `aid` int(10) DEFAULT \'0\' COMMENT \'文章ID\',
  `content` text COLLATE utf8_unicode_ci COMMENT \'内容\',
  `status` tinyint(1) DEFAULT \'0\' COMMENT \'是否处理\',
  `createtime` int(11) unsigned DEFAULT NULL,
  `username` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `userphone` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `useremail` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `type` int(2) NOT NULL,
  `data` text COLLATE utf8_unicode_ci NOT NULL,
  `formid` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ROW_FORMAT=DYNAMIC COMMENT=\'留言板\'',
  'core_mobile_blocks' => 'CREATE TABLE `ims_core_mobile_blocks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `support` tinyint(1) unsigned NOT NULL,
  `plugin_id` varchar(50) NOT NULL DEFAULT \'core\',
  `title` varchar(50) NOT NULL,
  `usenum` int(10) unsigned NOT NULL,
  `showhtml` char(100) NOT NULL,
  `edithtml` char(100) NOT NULL,
  `madehtml` char(100) NOT NULL,
  `madewxapp` char(100) NOT NULL,
  `image` char(100) NOT NULL,
  `cloud_id` int(10) unsigned NOT NULL,
  `release` int(10) unsigned NOT NULL,
  `default` text NOT NULL,
  `madealiapp` char(100) NOT NULL,
  `icon` varchar(100) NOT NULL,
  `basictype` tinyint(1) unsigned NOT NULL,
  `type` tinyint(1) unsigned NOT NULL,
  `name` varchar(50) NOT NULL,
  `madebaiduapp` char(100) NOT NULL,
  `madewxapp_new` char(100) NOT NULL,
  `api_domain` varchar(50) NOT NULL,
  `tuijie` int(11) DEFAULT \'0\',
  `up_my` tinyint(1) DEFAULT \'0\',
  `cloud_price` decimal(10,2) NOT NULL COMMENT \'价格\',
  `paixu` int(11) DEFAULT \'0\',
  PRIMARY KEY (`id`),
  KEY `plugin_id` (`plugin_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_mobile_template' => 'CREATE TABLE `ims_core_mobile_template` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `cloud_id` int(10) unsigned NOT NULL,
  `group_id` int(10) unsigned NOT NULL,
  `price` int(10) unsigned NOT NULL,
  `days` int(10) unsigned NOT NULL,
  `release` int(10) unsigned NOT NULL,
  `version` varchar(10) NOT NULL,
  `image` char(100) NOT NULL,
  `title` varchar(100) NOT NULL,
  `items` text NOT NULL,
  `setting` text NOT NULL,
  `type` tinyint(3) unsigned NOT NULL,
  `plugin_name` varchar(50) NOT NULL,
  `pages` longtext NOT NULL,
  `pageaction` varchar(50) NOT NULL,
  `paixu` int(10) NOT NULL,
  `purchases` int(10) NOT NULL,
  `tuijie` tinyint(1) unsigned DEFAULT \'1\',
  `desc` varchar(200) DEFAULT NULL,
  `hdps` text NOT NULL,
  `hide` tinyint(1) NOT NULL,
  `salenum` int(10) NOT NULL,
  `tpl_id` int(11) NOT NULL,
  `api_domain` varchar(50) NOT NULL,
  `up_my` tinyint(1) DEFAULT \'0\',
  `cloud_price` decimal(10,2) NOT NULL COMMENT \'价格\',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_mobile_web' => 'CREATE TABLE `ims_core_mobile_web` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `group_id` int(10) unsigned NOT NULL,
  `type` tinyint(1) unsigned NOT NULL,
  `status` tinyint(1) unsigned NOT NULL,
  `wxapp_id` int(10) unsigned NOT NULL,
  `head_id` int(10) unsigned NOT NULL,
  `foot_id` int(10) unsigned NOT NULL,
  `menu_id` int(10) unsigned NOT NULL,
  `template_id` int(10) unsigned NOT NULL,
  `title` varchar(100) NOT NULL,
  `foot` varchar(200) NOT NULL,
  `domain` varchar(100) NOT NULL,
  `items` text NOT NULL,
  `setting` text NOT NULL,
  `html` char(100) NOT NULL,
  `pc_items` text NOT NULL,
  `pc_pages` text NOT NULL,
  `pc_setting` text NOT NULL,
  `pc_head` text NOT NULL,
  `pc_foot` text NOT NULL,
  `pc_html` char(100) NOT NULL,
  `pc_htmls` text NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `updatetime` int(10) unsigned NOT NULL,
  `head_html` char(100) NOT NULL,
  `foot_html` char(100) NOT NULL,
  `pages_html` text NOT NULL,
  `pages_data` text NOT NULL,
  `pageaction` varchar(50) NOT NULL,
  `plugin_name` varchar(50) NOT NULL DEFAULT \'core\',
  `webid` int(11) NOT NULL,
  `nopc` tinyint(1) NOT NULL,
  `syscolor` varchar(50) NOT NULL,
  `pctype` tinyint(1) NOT NULL,
  `pctempname` varchar(100) NOT NULL,
  `openlogin` tinyint(1) DEFAULT \'0\',
  `is_narrow` int(11) NOT NULL,
  `star` tinyint(1) NOT NULL,
  `webtype` tinyint(1) DEFAULT \'0\',
  PRIMARY KEY (`id`),
  KEY `uniacid` (`uniacid`,`group_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_mobile_web_group' => 'CREATE TABLE `ims_core_mobile_web_group` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `title` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_notice_log' => 'CREATE TABLE `ims_core_notice_log` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT \'记录ID\',
  `setuid` int(11) unsigned NOT NULL COMMENT \'发送ID\',
  `uid` int(11) unsigned NOT NULL COMMENT \'用户ID\',
  `ip` varchar(20) NOT NULL COMMENT \'IP\',
  `type` smallint(2) NOT NULL DEFAULT \'0\' COMMENT \'类别（0：短信，1：微信，2：app）\',
  `isread` smallint(2) NOT NULL DEFAULT \'0\' COMMENT \'是否已经阅读！\',
  `msg` varchar(500) NOT NULL COMMENT \'短信内容\',
  `url` varchar(50) NOT NULL COMMENT \'跳转actions\',
  `createtime` int(11) unsigned NOT NULL COMMENT \'创建时间\',
  `uniacid` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT=\'短信日志\'',
  'core_old_plugins' => 'CREATE TABLE `ims_core_old_plugins` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `need_menu` tinyint(1) unsigned NOT NULL,
  `setting` tinyint(1) unsigned NOT NULL,
  `name` varchar(50) NOT NULL,
  `tables` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_open' => 'CREATE TABLE `ims_core_open` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `token` char(32) NOT NULL,
  `secret` char(40) NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `title` varchar(100) NOT NULL,
  `siteroot` varchar(120) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `token` (`token`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_open_user' => 'CREATE TABLE `ims_core_open_user` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `open_id` int(10) unsigned NOT NULL,
  `open_uid` varchar(50) NOT NULL,
  `expires_time` int(11) NOT NULL,
  `refresh_time` int(11) NOT NULL,
  `access_token` varchar(100) NOT NULL,
  `refresh_token` varchar(100) NOT NULL,
  `wxgid` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `open_id` (`open_id`,`open_uid`(10))
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_pay_log' => 'CREATE TABLE `ims_core_pay_log` (
  `plid` bigint(11) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `uniacid` int(11) NOT NULL,
  `acid` int(10) NOT NULL,
  `openid` varchar(40) NOT NULL,
  `uniontid` varchar(64) NOT NULL,
  `tid` varchar(128) NOT NULL,
  `fee` decimal(10,2) NOT NULL,
  `status` tinyint(4) NOT NULL,
  `module` varchar(50) NOT NULL,
  `tag` varchar(2000) NOT NULL,
  `is_usecard` tinyint(3) unsigned NOT NULL,
  `card_type` tinyint(3) unsigned NOT NULL,
  `card_id` varchar(50) NOT NULL,
  `card_fee` decimal(10,2) unsigned NOT NULL,
  `encrypt_code` varchar(100) NOT NULL,
  `uid` int(10) NOT NULL,
  `back_url` varchar(250) NOT NULL,
  `r_url` varchar(250) NOT NULL,
  `p_url` varchar(250) NOT NULL,
  PRIMARY KEY (`plid`),
  KEY `idx_openid` (`openid`),
  KEY `idx_tid` (`tid`),
  KEY `idx_uniacid` (`uniacid`),
  KEY `uniontid` (`uniontid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_paylog' => 'CREATE TABLE `ims_core_paylog` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `mid` int(10) unsigned NOT NULL,
  `tid` char(20) NOT NULL,
  `oid` varchar(100) NOT NULL,
  `status` tinyint(1) unsigned NOT NULL,
  `pay_type` varchar(10) NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `fee` decimal(10,2) NOT NULL,
  `plugin` varchar(50) NOT NULL,
  `action` varchar(30) NOT NULL,
  `title` varchar(100) NOT NULL,
  `no_type` varchar(100) NOT NULL,
  `more` varchar(50) NOT NULL,
  `transaction_id` char(32) NOT NULL,
  `back_url` varchar(100) NOT NULL,
  `success_url` varchar(100) NOT NULL,
  `error_url` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `tid` (`tid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_payout_log' => 'CREATE TABLE `ims_core_payout_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `trade_no` char(23) NOT NULL,
  `uniacid` int(10) unsigned NOT NULL,
  `mid` int(10) unsigned NOT NULL,
  `money` decimal(10,2) NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `remark` varchar(100) NOT NULL,
  `status` tinyint(1) unsigned NOT NULL,
  `pay_type` tinyint(1) unsigned NOT NULL,
  `out_trade_no` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_pc_blocks' => 'CREATE TABLE `ims_core_pc_blocks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cloud_id` int(10) unsigned NOT NULL,
  `type` tinyint(1) unsigned NOT NULL,
  `name` char(10) NOT NULL,
  `title` varchar(50) NOT NULL,
  `showhtml` char(100) NOT NULL,
  `edithtml` char(100) NOT NULL,
  `madehtml` char(100) NOT NULL,
  `image` char(255) NOT NULL,
  `default` text NOT NULL,
  `usenum` int(10) unsigned NOT NULL,
  `release` int(10) unsigned NOT NULL,
  `icon` varchar(50) NOT NULL,
  `basictype` tinyint(1) unsigned NOT NULL,
  `api_domain` varchar(50) NOT NULL,
  `up_my` tinyint(1) DEFAULT \'0\',
  `cloud_price` decimal(10,2) NOT NULL COMMENT \'价格\',
  `paixu` int(11) DEFAULT \'0\',
  `tuijie` int(11) DEFAULT \'0\',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_pc_template' => 'CREATE TABLE `ims_core_pc_template` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `cloud_id` int(10) unsigned NOT NULL,
  `group_id` int(10) unsigned NOT NULL,
  `price` int(10) unsigned NOT NULL,
  `days` int(10) unsigned NOT NULL,
  `release` int(10) unsigned NOT NULL,
  `image` char(100) NOT NULL,
  `title` varchar(50) NOT NULL,
  `version` varchar(20) NOT NULL,
  `pc_items` text NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `type` tinyint(3) unsigned NOT NULL,
  `pageaction` varchar(50) NOT NULL,
  `paixu` int(10) NOT NULL,
  `purchases` int(10) NOT NULL,
  `tuijie` tinyint(1) unsigned DEFAULT \'1\',
  `desc` varchar(200) DEFAULT NULL,
  `hide` tinyint(1) NOT NULL,
  `salenum` int(10) NOT NULL,
  `hdps` text NOT NULL,
  `pctype` tinyint(3) NOT NULL,
  `api_domain` varchar(50) NOT NULL,
  `up_my` tinyint(1) DEFAULT \'0\',
  `cloud_price` decimal(10,2) NOT NULL COMMENT \'价格\',
  PRIMARY KEY (`id`),
  KEY `uniacid` (`uniacid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_performance' => 'CREATE TABLE `ims_core_performance` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `runtime` varchar(10) NOT NULL,
  `runurl` varchar(512) NOT NULL,
  `runsql` varchar(512) NOT NULL,
  `createtime` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8',
  'core_permissions' => 'CREATE TABLE `ims_core_permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) unsigned NOT NULL,
  `action` varchar(50) NOT NULL,
  `op` varchar(50) NOT NULL,
  `title` varchar(50) NOT NULL,
  `price` int(10) unsigned NOT NULL,
  `days` int(10) unsigned NOT NULL,
  `image` char(30) NOT NULL,
  `paixu` int(10) NOT NULL,
  `purchases` int(10) NOT NULL,
  `tuijie` tinyint(1) unsigned DEFAULT \'1\',
  `desc` varchar(200) DEFAULT NULL,
  `hdps` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `p` (`action`,`op`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_plugin_id' => 'CREATE TABLE `ims_core_plugin_id` (
  `id` int(10) unsigned NOT NULL,
  `name` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8',
  'core_plugin_ignore' => 'CREATE TABLE `ims_core_plugin_ignore` (
  `id` int(10) unsigned NOT NULL,
  `plugin_id` int(10) unsigned NOT NULL,
  `type` tinyint(1) unsigned NOT NULL,
  `name` varchar(100) NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8',
  'core_plugin_install_data' => 'CREATE TABLE `ims_core_plugin_install_data` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `plugin_id` int(10) unsigned NOT NULL,
  `type` tinyint(1) unsigned NOT NULL,
  `num` int(10) unsigned NOT NULL,
  `table` varchar(50) NOT NULL,
  `plugin_name` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_plugin_permissions' => 'CREATE TABLE `ims_core_plugin_permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) unsigned NOT NULL,
  `plugin` varchar(50) NOT NULL,
  `action` varchar(50) NOT NULL,
  `op` varchar(50) NOT NULL,
  `title` varchar(50) NOT NULL,
  `price` int(10) unsigned NOT NULL,
  `days` int(10) unsigned NOT NULL,
  `image` char(30) NOT NULL,
  `tuijie` tinyint(1) DEFAULT \'0\',
  `paixu` int(10) DEFAULT \'0\',
  `desc` varchar(500) DEFAULT NULL,
  `salenum` int(10) NOT NULL,
  `hdps` text NOT NULL,
  `nobuy` tinyint(1) unsigned DEFAULT \'0\',
  `menus` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `permission` (`plugin`,`action`(5),`op`(5))
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_plugin_subscribe' => 'CREATE TABLE `ims_core_plugin_subscribe` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `subscriber` varchar(50) NOT NULL,
  `plugin` varchar(50) NOT NULL,
  `event` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_plugin_tables' => 'CREATE TABLE `ims_core_plugin_tables` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `plugin_id` int(10) unsigned NOT NULL,
  `name` varchar(50) NOT NULL,
  `title` varchar(50) NOT NULL,
  `plugin_name` varchar(60) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `plugin` (`plugin_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_plugins' => 'CREATE TABLE `ims_core_plugins` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `is_my` tinyint(1) unsigned NOT NULL,
  `type` tinyint(1) unsigned NOT NULL,
  `style` tinyint(1) NOT NULL,
  `hide` tinyint(1) unsigned NOT NULL,
  `link` tinyint(1) unsigned NOT NULL,
  `direct` tinyint(1) unsigned NOT NULL,
  `cloud_id` int(10) unsigned NOT NULL,
  `release` int(10) unsigned NOT NULL,
  `image` varchar(100) NOT NULL,
  `version` varchar(50) NOT NULL,
  `name` varchar(50) NOT NULL,
  `title` varchar(50) NOT NULL,
  `author` varchar(100) NOT NULL,
  `description` varchar(100) NOT NULL,
  `covers` text NOT NULL,
  `menus` text NOT NULL,
  `mobile_menus` text NOT NULL,
  `basic` varchar(1000) NOT NULL,
  `istakeover` tinyint(1) NOT NULL,
  `custom_access_type` tinyint(1) unsigned NOT NULL,
  `manage_access_type` tinyint(1) unsigned NOT NULL,
  `diypage` varchar(1000) NOT NULL,
  `ish5` tinyint(1) NOT NULL,
  `actionlinks` text NOT NULL,
  `is_legao` tinyint(1) NOT NULL,
  `diy_legao` text NOT NULL,
  `discount_legao` decimal(3,2) NOT NULL,
  `paixu` int(10) NOT NULL,
  `tuijie` tinyint(1) DEFAULT \'0\',
  `hdps` text NOT NULL,
  `salenum` int(10) NOT NULL,
  `price` decimal(10,2) DEFAULT \'0.00\',
  `days` int(10) NOT NULL,
  `oneword` varchar(50) NOT NULL,
  `intype` tinyint(1) NOT NULL,
  `msgtpl` text NOT NULL,
  `endtime` int(11) NOT NULL,
  `welcomehdps` text NOT NULL,
  `star` tinyint(1) NOT NULL,
  `ability` varchar(200) NOT NULL,
  `url` varchar(200) NOT NULL,
  `settings` tinyint(1) unsigned NOT NULL,
  `handles` text NOT NULL,
  `isrulefields` tinyint(1) unsigned NOT NULL,
  `iscard` tinyint(1) unsigned NOT NULL,
  `bindings` text NOT NULL,
  `shortcut` varchar(200) NOT NULL,
  `function` varchar(1000) NOT NULL,
  `issystem` tinyint(1) unsigned NOT NULL,
  `up_my` tinyint(1) DEFAULT \'0\',
  `content` text NOT NULL,
  `price1` decimal(8,2) DEFAULT \'0.00\',
  `cloud_price` decimal(8,2) DEFAULT \'0.00\',
  `package` text NOT NULL,
  `purchases` int(11) NOT NULL,
  `api_domain` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `is_my` (`is_my`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_qiandao' => 'CREATE TABLE `ims_core_qiandao` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `mid` int(10) unsigned NOT NULL,
  `date` int(8) unsigned NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uniacid` (`uniacid`,`mid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_qr' => 'CREATE TABLE `ims_core_qr` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `wechat_id` int(10) unsigned NOT NULL,
  `type` tinyint(1) unsigned NOT NULL,
  `num` int(10) unsigned NOT NULL,
  `expire` int(10) unsigned NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `file` char(100) NOT NULL,
  `plugin` varchar(50) NOT NULL,
  `title` varchar(50) NOT NULL,
  `ticket` varchar(250) NOT NULL,
  `url` varchar(100) NOT NULL,
  `data` text NOT NULL,
  `keyid` varchar(50) NOT NULL,
  `linkurl` varchar(200) NOT NULL,
  `shorturl` varchar(100) NOT NULL,
  `qrtype` tinyint(1) DEFAULT \'0\',
  `eventtype` tinyint(1) DEFAULT \'0\',
  `backid` int(11) DEFAULT \'0\',
  PRIMARY KEY (`id`),
  KEY `uniacid` (`uniacid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_qrcode' => 'CREATE TABLE `ims_core_qrcode` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `acid` int(10) unsigned NOT NULL,
  `wechat_id` int(10) unsigned NOT NULL,
  `type` varchar(10) NOT NULL,
  `extra` int(10) unsigned NOT NULL,
  `qrcid` bigint(20) NOT NULL,
  `scene_str` varchar(64) NOT NULL,
  `name` varchar(50) NOT NULL,
  `keyword` varchar(100) NOT NULL,
  `model` tinyint(1) unsigned NOT NULL,
  `ticket` varchar(250) NOT NULL,
  `url` varchar(256) NOT NULL,
  `expire` int(10) unsigned NOT NULL,
  `subnum` int(10) unsigned NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `status` tinyint(1) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_qrcid` (`qrcid`),
  KEY `uniacid` (`uniacid`),
  KEY `ticket` (`ticket`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_receive' => 'CREATE TABLE `ims_core_receive` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `plugin` varchar(50) NOT NULL,
  `type` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_recharge' => 'CREATE TABLE `ims_core_recharge` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `mid` int(10) unsigned NOT NULL,
  `fee` decimal(10,2) NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `status` tinyint(1) unsigned NOT NULL,
  `pay_type` varchar(10) NOT NULL,
  `couponid` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uniacid` (`uniacid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_replace' => 'CREATE TABLE `ims_core_replace` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `seh` text NOT NULL,
  `rep` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_reward' => 'CREATE TABLE `ims_core_reward` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `type` tinyint(1) unsigned NOT NULL,
  `days` int(10) unsigned NOT NULL,
  `credit1` int(10) unsigned NOT NULL,
  `credit2` int(10) unsigned NOT NULL,
  `title` varchar(22) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uniacid` (`uniacid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_reward_log' => 'CREATE TABLE `ims_core_reward_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `mid` int(10) unsigned NOT NULL,
  `rid` int(10) unsigned NOT NULL,
  `createtime` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_session' => 'CREATE TABLE `ims_core_session` (
  `id` char(26) NOT NULL,
  `ip` char(15) NOT NULL,
  `expire` int(10) unsigned NOT NULL,
  `manage` text NOT NULL,
  `custom` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `exp` (`expire`),
  KEY `ip` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8',
  'core_settings' => 'CREATE TABLE `ims_core_settings` (
  `key` varchar(200) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8',
  'core_template_group' => 'CREATE TABLE `ims_core_template_group` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_types' => 'CREATE TABLE `ims_core_types` (
  `name` varchar(20) NOT NULL,
  `title` varchar(50) NOT NULL,
  `data` text NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8',
  'core_url_config' => 'CREATE TABLE `ims_core_url_config` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `this` tinyint(1) unsigned NOT NULL,
  `status` tinyint(1) unsigned NOT NULL,
  `display` int(10) unsigned NOT NULL,
  `diy` varchar(100) NOT NULL,
  `common` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `this` (`this`,`status`,`display`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_user_failed_login' => 'CREATE TABLE `ims_core_user_failed_login` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL,
  `count` tinyint(1) unsigned NOT NULL,
  `lastupdate` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `username` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_user_groups' => 'CREATE TABLE `ims_core_user_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `title` varchar(100) NOT NULL,
  `sys_actions` text NOT NULL,
  `plugin_actions` text NOT NULL,
  `welcome` varchar(100) NOT NULL,
  `perm1` text NOT NULL,
  `perm2` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8',
  'core_user_permissions' => 'CREATE TABLE `ims_core_user_permissions` (
  `uid` int(10) unsigned NOT NULL,
  `uniacid` int(11) NOT NULL,
  `sys_actions` text NOT NULL,
  `plugin_actions` text NOT NULL,
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8',
  'core_user_quick' => 'CREATE TABLE `ims_core_user_quick` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL,
  `action` varchar(20) NOT NULL,
  `plugin` varchar(20) NOT NULL,
  `op` varchar(20) NOT NULL,
  `title` varchar(50) NOT NULL,
  `query` varchar(50) NOT NULL,
  `html` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `qc` (`uid`,`action`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_users' => 'CREATE TABLE `ims_core_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nickname` varchar(100) NOT NULL,
  `avatar` varchar(300) NOT NULL,
  `uniacid` int(10) unsigned NOT NULL,
  `group_id` int(10) unsigned NOT NULL,
  `mobile` char(11) NOT NULL,
  `password` char(40) NOT NULL,
  `salt` char(10) NOT NULL,
  `ssid` char(26) NOT NULL,
  `status` tinyint(1) unsigned NOT NULL,
  `type` tinyint(1) unsigned NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `name` varchar(30) NOT NULL,
  `lastvisit` int(10) unsigned NOT NULL DEFAULT \'0\',
  `lastip` varchar(15) NOT NULL DEFAULT \'\',
  `remark` varchar(500) NOT NULL DEFAULT \'\',
  `home` varchar(100) NOT NULL,
  `sex` tinyint(1) NOT NULL,
  `province` varchar(20) NOT NULL,
  `city` varchar(20) NOT NULL,
  `country` varchar(20) NOT NULL,
  `upfanstime` int(11) NOT NULL,
  `star` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_users_log' => 'CREATE TABLE `ims_core_users_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `agentid` int(11) NOT NULL,
  `createtime` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC',
  'core_wxapp' => 'CREATE TABLE `ims_core_wxapp` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cloud_id` int(10) unsigned NOT NULL,
  `type` tinyint(1) unsigned NOT NULL,
  `version1` int(10) unsigned NOT NULL,
  `version` varchar(20) NOT NULL,
  `title` varchar(50) NOT NULL,
  `plugin` varchar(50) NOT NULL,
  `image` char(50) NOT NULL,
  `template_id` int(10) unsigned NOT NULL,
  `price` int(10) unsigned NOT NULL,
  `days` int(10) unsigned NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `pages` text NOT NULL,
  `name` varchar(50) NOT NULL,
  `ish5` tinyint(1) NOT NULL,
  `isdiy` tinyint(1) NOT NULL,
  `paixu` int(10) NOT NULL,
  `purchases` int(10) NOT NULL,
  `tuijie` tinyint(1) unsigned DEFAULT \'1\',
  `desc` varchar(200) DEFAULT NULL,
  `hdps` text NOT NULL,
  `hide` tinyint(1) NOT NULL,
  `salenum` int(10) NOT NULL,
  `apptype` varchar(20) NOT NULL,
  `lasttime` int(11) NOT NULL,
  `api_domain` varchar(50) NOT NULL,
  `up_my` tinyint(1) DEFAULT \'0\',
  `cloud_price` decimal(10,2) NOT NULL COMMENT \'价格\',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_wxapp_template' => 'CREATE TABLE `ims_core_wxapp_template` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `cloud_id` int(10) unsigned NOT NULL,
  `group_id` int(10) unsigned NOT NULL,
  `price` int(10) unsigned NOT NULL,
  `days` int(10) unsigned NOT NULL,
  `version` varchar(20) NOT NULL,
  `image` char(50) NOT NULL,
  `title` varchar(50) NOT NULL,
  `items` text NOT NULL,
  `setting` text NOT NULL,
  `paixu` int(10) NOT NULL,
  `purchases` int(10) NOT NULL,
  `tuijie` tinyint(1) unsigned DEFAULT \'1\',
  `desc` varchar(200) DEFAULT NULL,
  `hdps` text NOT NULL,
  `hide` tinyint(1) NOT NULL,
  `salenum` int(10) NOT NULL,
  `api_domain` varchar(50) NOT NULL,
  `up_my` tinyint(1) DEFAULT \'0\',
  `cloud_price` decimal(10,2) NOT NULL COMMENT \'价格\',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'qrcode_stat' => 'CREATE TABLE `ims_qrcode_stat` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL DEFAULT \'0\',
  `qid` int(10) unsigned NOT NULL,
  `openid` varchar(50) NOT NULL DEFAULT \'\',
  `type` tinyint(1) unsigned NOT NULL DEFAULT \'0\',
  `qrcid` bigint(20) unsigned NOT NULL,
  `name` varchar(50) NOT NULL DEFAULT \'\',
  `createtime` int(10) unsigned NOT NULL DEFAULT \'0\',
  `scene_str` varchar(64) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'account_wechats' => 'CREATE TABLE `ims_account_wechats` (
  `acid` int(10) unsigned NOT NULL,
  `uniacid` int(10) unsigned NOT NULL,
  `token` varchar(32) NOT NULL,
  `encodingaeskey` varchar(255) NOT NULL,
  `access_token` varchar(1000) NOT NULL DEFAULT \'\',
  `level` tinyint(4) unsigned NOT NULL DEFAULT \'0\',
  `name` varchar(30) NOT NULL,
  `account` varchar(30) NOT NULL,
  `original` varchar(50) NOT NULL,
  `signature` varchar(100) NOT NULL,
  `country` varchar(10) NOT NULL,
  `province` varchar(3) NOT NULL,
  `city` varchar(15) NOT NULL,
  `username` varchar(30) NOT NULL,
  `password` varchar(32) NOT NULL,
  `lastupdate` int(10) unsigned NOT NULL DEFAULT \'0\',
  `key` varchar(50) NOT NULL,
  `secret` varchar(50) NOT NULL,
  `styleid` int(10) unsigned NOT NULL DEFAULT \'1\',
  `jsapi_ticket` varchar(1000) NOT NULL,
  `subscribeurl` varchar(120) NOT NULL,
  `card_ticket` varchar(1000) NOT NULL,
  `topad` varchar(225) NOT NULL,
  `footad` varchar(225) NOT NULL,
  `auth_refresh_token` varchar(255) NOT NULL,
  PRIMARY KEY (`acid`),
  KEY `idx_key` (`key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8',
  'mc_mapping_fans' => 'CREATE TABLE `ims_mc_mapping_fans` (
  `fanid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `acid` int(10) unsigned NOT NULL,
  `uniacid` int(10) unsigned NOT NULL DEFAULT \'0\',
  `uid` int(10) unsigned NOT NULL DEFAULT \'0\',
  `openid` varchar(50) NOT NULL,
  `salt` char(8) NOT NULL DEFAULT \'\',
  `follow` tinyint(1) unsigned NOT NULL DEFAULT \'1\',
  `followtime` int(10) unsigned NOT NULL,
  `unfollowtime` int(10) unsigned NOT NULL,
  `tag` varchar(1000) NOT NULL,
  `nickname` varchar(50) NOT NULL,
  `groupid` varchar(30) NOT NULL,
  `updatetime` int(10) unsigned DEFAULT NULL,
  `unionid` varchar(64) NOT NULL,
  PRIMARY KEY (`fanid`),
  KEY `acid` (`acid`),
  KEY `uniacid` (`uniacid`),
  KEY `openid` (`openid`),
  KEY `updatetime` (`updatetime`),
  KEY `nickname` (`nickname`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'rule' => 'CREATE TABLE `ims_rule` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL DEFAULT \'0\',
  `name` varchar(50) NOT NULL DEFAULT \'\',
  `module` varchar(50) NOT NULL,
  `displayorder` int(10) unsigned NOT NULL DEFAULT \'0\',
  `status` tinyint(1) unsigned NOT NULL DEFAULT \'1\',
  `containtype` varchar(100) NOT NULL,
  `reply_type` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'rule_keyword' => 'CREATE TABLE `ims_rule_keyword` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `rid` int(10) unsigned NOT NULL DEFAULT \'0\',
  `uniacid` int(10) unsigned NOT NULL DEFAULT \'0\',
  `module` varchar(50) NOT NULL,
  `content` varchar(255) NOT NULL,
  `type` tinyint(1) unsigned NOT NULL DEFAULT \'1\',
  `displayorder` tinyint(3) unsigned NOT NULL DEFAULT \'1\',
  `status` tinyint(1) unsigned NOT NULL DEFAULT \'1\',
  PRIMARY KEY (`id`),
  KEY `idx_content` (`content`),
  KEY `idx_rid` (`rid`),
  KEY `idx_uniacid_type_content` (`uniacid`,`type`,`content`),
  KEY `rid` (`rid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'cover_reply' => 'CREATE TABLE `ims_cover_reply` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `multiid` int(10) unsigned NOT NULL DEFAULT \'0\',
  `rid` int(10) unsigned NOT NULL,
  `module` varchar(30) NOT NULL DEFAULT \'\',
  `do` varchar(30) NOT NULL DEFAULT \'\',
  `title` varchar(255) NOT NULL DEFAULT \'\',
  `description` varchar(255) NOT NULL DEFAULT \'\',
  `thumb` varchar(255) NOT NULL DEFAULT \'\',
  `url` varchar(255) NOT NULL DEFAULT \'\',
  PRIMARY KEY (`id`),
  KEY `rid` (`rid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'mc_credits_record' => 'CREATE TABLE `ims_mc_credits_record` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL,
  `uniacid` int(11) NOT NULL,
  `credittype` varchar(10) NOT NULL DEFAULT \'\',
  `num` decimal(10,2) NOT NULL,
  `operator` int(10) unsigned NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `remark` varchar(200) NOT NULL DEFAULT \'\',
  `module` varchar(30) NOT NULL,
  `clerk_id` int(10) unsigned NOT NULL,
  `store_id` int(10) unsigned NOT NULL,
  `clerk_type` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uniacid` (`uniacid`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'uni_account_users' => 'CREATE TABLE `ims_uni_account_users` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) NOT NULL,
  `role` varchar(100) CHARACTER SET utf8 NOT NULL,
  `rank` tinyint(3) NOT NULL,
  `uid` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1',
  'core_account_ttapp' => 'CREATE TABLE `ims_core_account_ttapp` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `type` tinyint(1) unsigned NOT NULL COMMENT \'1打包2应用\',
  `status` tinyint(1) unsigned NOT NULL,
  `ttapp_id` int(10) unsigned NOT NULL,
  `url` varchar(200) NOT NULL,
  `version` varchar(100) NOT NULL,
  `title` varchar(100) NOT NULL,
  `appid` varchar(32) NOT NULL,
  `appsecret` varchar(50) NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_account_ttapp_style' => 'CREATE TABLE `ims_core_account_ttapp_style` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `logo` varchar(100) NOT NULL,
  `textcolor` varchar(15) NOT NULL,
  `bgcolor` varchar(15) NOT NULL,
  `sharetitle` varchar(100) NOT NULL,
  `sharedesc` varchar(200) NOT NULL,
  `shareimg` varchar(100) NOT NULL,
  `window` text NOT NULL,
  `menu` text NOT NULL,
  `shownums` varchar(300) NOT NULL,
  `appid` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_account_attachment_order' => 'CREATE TABLE `ims_core_account_attachment_order` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `num` int(10) unsigned NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `ordersn` char(22) NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `status` tinyint(1) unsigned NOT NULL,
  `pay_id` int(10) unsigned NOT NULL,
  `pay_type` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_account_order' => 'CREATE TABLE `ims_core_account_order` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `groupid` int(10) unsigned NOT NULL,
  `day` int(10) unsigned NOT NULL,
  `num` int(10) unsigned NOT NULL,
  `ordersn` char(22) NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `title` varchar(100) NOT NULL,
  `status` tinyint(1) unsigned NOT NULL,
  `pay_id` int(10) unsigned NOT NULL,
  `pay_type` varchar(20) NOT NULL,
  `opendiys` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_attachment_first_image' => 'CREATE TABLE `ims_core_attachment_first_image` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `video` varchar(100) NOT NULL,
  `image` varchar(100) NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_ideal_money' => 'CREATE TABLE `ims_core_ideal_money` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `mid` int(10) unsigned NOT NULL,
  `money` decimal(10,2) NOT NULL COMMENT \'当前金额\',
  `frozen_money` decimal(10,2) NOT NULL COMMENT \'冻结金额\',
  `total_money` decimal(10,2) NOT NULL COMMENT \'累计金额\',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_ideal_money_inlog' => 'CREATE TABLE `ims_core_ideal_money_inlog` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `mid` int(10) unsigned NOT NULL,
  `money` decimal(10,2) NOT NULL,
  `remark` varchar(500) NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `pidcode` varchar(250) NOT NULL,
  `plugin` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_ideal_money_outlog' => 'CREATE TABLE `ims_core_ideal_money_outlog` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `mid` int(10) unsigned NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `to_type` tinyint(1) unsigned NOT NULL,
  `money` decimal(10,2) NOT NULL,
  `remark` varchar(100) NOT NULL,
  `status` tinyint(1) unsigned NOT NULL,
  `order_id` varchar(100) NOT NULL,
  `cash_money` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_tpl_template' => 'CREATE TABLE `ims_core_tpl_template` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `tplcode` varchar(50) NOT NULL,
  `template_name` varchar(50) NOT NULL,
  `content` varchar(1000) DEFAULT NULL,
  `typegroup` varchar(255) DEFAULT \'\',
  `groupname` varchar(255) DEFAULT \'\',
  `plugin_name` varchar(100) DEFAULT \'\',
  `type` tinyint(1) NOT NULL,
  `remark` varchar(200) NOT NULL,
  `name` varchar(50) NOT NULL,
  `demo` varchar(1000) NOT NULL,
  `first` varchar(200) NOT NULL,
  `footer` varchar(200) NOT NULL,
  `keywords` text NOT NULL,
  `kefumsg` text NOT NULL,
  `footercolor` varchar(20) NOT NULL,
  `firstcolor` varchar(20) NOT NULL,
  `appsubtpl_name` varchar(50) NOT NULL,
  `demoappsub` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_account_web_tpl' => 'CREATE TABLE `ims_core_account_web_tpl` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `web_id` int(10) unsigned NOT NULL,
  `is_open` tinyint(1) unsigned NOT NULL,
  `template_id` int(10) unsigned NOT NULL,
  `items` text NOT NULL,
  `pages` text NOT NULL,
  `setting` text NOT NULL,
  `html` char(100) NOT NULL,
  `pc_items` text NOT NULL,
  `pc_pages` text NOT NULL,
  `pc_setting` text NOT NULL,
  `pc_html` char(100) NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `updatetime` int(10) unsigned NOT NULL,
  `pages_html` text NOT NULL,
  `pages_data` text NOT NULL,
  `pageaction` varchar(50) NOT NULL,
  `plugin_name` varchar(50) NOT NULL DEFAULT \'core\',
  `title` varchar(250) NOT NULL,
  `tpl_id` int(11) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `foot` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uniacid` (`uniacid`,`web_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_account_authwxapp' => 'CREATE TABLE `ims_core_account_authwxapp` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `searchstatus` tinyint(1) NOT NULL,
  `account_type` tinyint(1) NOT NULL,
  `title` varchar(50) NOT NULL,
  `title_status` tinyint(1) NOT NULL,
  `title_errmsg` varchar(500) NOT NULL,
  `appid` varchar(100) NOT NULL,
  `appsecret` varchar(100) NOT NULL,
  `principal_type` tinyint(1) NOT NULL,
  `principal_name` varchar(100) NOT NULL,
  `qualification_verify` tinyint(1) NOT NULL,
  `naming_verify` tinyint(1) NOT NULL,
  `annual_review` tinyint(1) NOT NULL,
  `annual_review_begin_time` int(11) NOT NULL,
  `annual_review_end_time` int(11) NOT NULL,
  `desc` varchar(100) NOT NULL,
  `desc_modify_used_count` int(11) NOT NULL,
  `desc_modify_quota` int(11) NOT NULL,
  `logo` varchar(100) NOT NULL,
  `logo_modify_used_count` int(11) NOT NULL,
  `logo_modify_quota` int(11) NOT NULL,
  `access_token` varchar(200) NOT NULL,
  `expire` int(10) NOT NULL,
  `refresh_token` varchar(100) NOT NULL,
  `remark` text NOT NULL,
  `merch_name` varchar(50) NOT NULL,
  `merch_code` varchar(50) NOT NULL,
  `merch_code_type` tinyint(1) NOT NULL,
  `merch_legal_persona_wechat` varchar(50) NOT NULL,
  `merch_legal_persona_name` varchar(50) NOT NULL,
  `merch_id_card` varchar(100) NOT NULL,
  `merch_license` varchar(100) NOT NULL,
  `merch_component_phone` varchar(50) NOT NULL,
  `naming_other_stuff` varchar(1000) NOT NULL,
  `requestdomain` varchar(100) NOT NULL,
  `wsrequestdomain` varchar(100) NOT NULL,
  `uploaddomain` varchar(100) NOT NULL,
  `downloaddomain` varchar(100) NOT NULL,
  `webviewdomain` text NOT NULL,
  `createtime` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uniacid` (`uniacid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_account_wxapp_live' => 'CREATE TABLE `ims_core_account_wxapp_live` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `wxapp_id` int(11) NOT NULL,
  `createtime` int(11) NOT NULL,
  `uniacid` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_account_wxapp_live_rooms' => 'CREATE TABLE `ims_core_account_wxapp_live_rooms` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) NOT NULL,
  `live_id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `roomid` int(11) NOT NULL,
  `cover_img` varchar(500) NOT NULL,
  `live_satus` varchar(100) NOT NULL,
  `start_time` int(11) NOT NULL,
  `end_time` int(11) NOT NULL,
  `anchor_name` varchar(100) NOT NULL,
  `anchor_img` varchar(500) NOT NULL,
  `total` int(11) NOT NULL,
  `goods` text NOT NULL,
  `createtime` int(11) NOT NULL,
  `goodsid` int(11) NOT NULL,
  `anchor_wechat` varchar(20) NOT NULL,
  `type` tinyint(1) NOT NULL,
  `shareimg` varchar(500) NOT NULL,
  `closelike` tinyint(1) NOT NULL,
  `closegoods` tinyint(1) NOT NULL,
  `closecomment` tinyint(1) NOT NULL,
  `mid` int(11) NOT NULL,
  `sex` tinyint(1) unsigned NOT NULL,
  `totalfee` decimal(10,2) NOT NULL,
  `fromlook` int(11) NOT NULL,
  `salenum` int(11) NOT NULL,
  `ischeck` tinyint(1) DEFAULT \'1\',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_addons_temp_pc' => 'CREATE TABLE `ims_core_addons_temp_pc` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `is_my` tinyint(1) unsigned NOT NULL,
  `name` varchar(50) NOT NULL,
  `title` varchar(100) NOT NULL,
  `plugin_name` varchar(100) NOT NULL,
  `release` int(10) unsigned NOT NULL,
  `version` varchar(50) NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `updatetime` int(10) unsigned NOT NULL,
  `diy_form` text NOT NULL,
  `cloud_id` int(11) NOT NULL,
  `up_my` tinyint(1) DEFAULT \'0\',
  `cloud_price` decimal(10,2) NOT NULL COMMENT \'价格\',
  `paixu` int(11) DEFAULT \'0\',
  `tuijie` int(11) DEFAULT \'0\',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_develop_app_getlog' => 'CREATE TABLE `ims_core_develop_app_getlog` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) NOT NULL COMMENT \'公众号ID\',
  `mid` int(11) DEFAULT \'0\' COMMENT \'用户ID\',
  `apptype` varchar(50) DEFAULT \'\' COMMENT \'类型\',
  `title` varchar(255) DEFAULT \'\' COMMENT \'标题\',
  `zipfile` varchar(255) DEFAULT \'\' COMMENT \'附件\',
  `createtime` int(11) DEFAULT \'0\' COMMENT \'时间\',
  `type` int(1) NOT NULL,
  `pluginname` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_account_wxapp_live_goods' => 'CREATE TABLE `ims_core_account_wxapp_live_goods` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) NOT NULL,
  `merchid` int(11) NOT NULL,
  `live_id` int(11) NOT NULL,
  `title` varchar(50) NOT NULL,
  `image` varchar(255) NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `originalprice` decimal(10,2) NOT NULL,
  `goods_id` int(11) NOT NULL,
  `appgoodsid` int(11) NOT NULL,
  `auditid` int(11) NOT NULL,
  `priceType` tinyint(1) NOT NULL,
  `createtime` int(11) NOT NULL,
  `status` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_open_plugin' => 'CREATE TABLE `ims_core_open_plugin` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) DEFAULT \'0\',
  `title` varchar(50) NOT NULL,
  `logo` varchar(100) NOT NULL,
  `tags` varchar(200) NOT NULL,
  `desc` varchar(500) NOT NULL,
  `type` tinyint(1) DEFAULT \'0\',
  `groupid` int(3) DEFAULT \'0\',
  `pid` int(11) NOT NULL DEFAULT \'0\',
  `images` text NOT NULL,
  `price` decimal(10,2) NOT NULL COMMENT \'价格\',
  `star` tinyint(1) DEFAULT \'0\',
  `status` tinyint(1) DEFAULT \'0\',
  `opentype` varchar(20) NOT NULL,
  `suite_id` varchar(100) NOT NULL,
  `suite_secret` varchar(100) NOT NULL,
  `createtime` int(10) DEFAULT \'0\' COMMENT \'时间\',
  `isbindopen` tinyint(1) DEFAULT \'0\',
  `tabletype` tinyint(1) DEFAULT \'0\',
  `days` int(11) DEFAULT \'0\',
  `suite_ticket` varchar(520) NOT NULL,
  `suite_access_token` varchar(520) NOT NULL,
  `expire` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_account_sms' => 'CREATE TABLE `ims_core_account_sms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) NOT NULL DEFAULT \'0\',
  `name` varchar(255) NOT NULL DEFAULT \'\',
  `type` varchar(10) NOT NULL DEFAULT \'\',
  `template` tinyint(3) NOT NULL DEFAULT \'0\',
  `smstplid` varchar(255) NOT NULL DEFAULT \'\',
  `smssign` varchar(255) NOT NULL DEFAULT \'\',
  `content` varchar(100) NOT NULL DEFAULT \'\',
  `data` text NOT NULL,
  `status` tinyint(3) NOT NULL DEFAULT \'0\',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_account_wxwork' => 'CREATE TABLE `ims_core_account_wxwork` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) unsigned NOT NULL,
  `type` tinyint(1) unsigned NOT NULL,
  `isdefault` tinyint(1) unsigned NOT NULL,
  `isrenzheng` tinyint(1) unsigned NOT NULL,
  `title` varchar(50) NOT NULL,
  `alltitle` varchar(50) NOT NULL,
  `logo` varchar(100) NOT NULL,
  `appid` varchar(100) NOT NULL,
  `appsecret` varchar(100) NOT NULL,
  `token` varchar(100) NOT NULL,
  `aeskey` varchar(100) NOT NULL,
  `access_token` varchar(600) NOT NULL,
  `expire` int(11) unsigned NOT NULL,
  `refresh_token` varchar(100) NOT NULL,
  `jsticket` varchar(100) NOT NULL,
  `jsexpire` int(11) NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `api_ticket` varchar(100) NOT NULL,
  `api_ticket_expire` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uniacid` (`uniacid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_account_wxwork_app' => 'CREATE TABLE `ims_core_account_wxwork_app` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) DEFAULT \'0\',
  `wxwork_id` int(11) NOT NULL,
  `title` varchar(50) NOT NULL,
  `logo` varchar(100) NOT NULL,
  `tags` varchar(200) NOT NULL,
  `desc` varchar(500) NOT NULL,
  `type` tinyint(1) DEFAULT \'0\',
  `groupid` int(3) DEFAULT \'0\',
  `pid` int(11) NOT NULL,
  `images` text NOT NULL,
  `star` tinyint(1) DEFAULT \'0\',
  `status` tinyint(1) DEFAULT \'0\',
  `opentype` varchar(20) NOT NULL,
  `appid` varchar(20) NOT NULL,
  `appsecret` varchar(50) NOT NULL,
  `createtime` int(10) DEFAULT \'0\' COMMENT \'时间\',
  `isbindopen` tinyint(1) DEFAULT \'0\',
  `tabletype` tinyint(1) DEFAULT \'0\',
  `access_token` varchar(600) NOT NULL,
  `expire` int(11) NOT NULL,
  `refresh_token` varchar(100) NOT NULL,
  `jsticket` varchar(100) NOT NULL,
  `jsexpire` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uniacid` (`uniacid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_media_group' => 'CREATE TABLE `ims_core_media_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) NOT NULL,
  `title` varchar(100) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `order` int(11) NOT NULL,
  `createtime` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8',
  'core_account_content' => 'CREATE TABLE `ims_core_account_content` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) NOT NULL,
  `group_id` int(11) NOT NULL,
  `type` varchar(50) NOT NULL,
  `title` varchar(100) NOT NULL,
  `image` varchar(200) NOT NULL,
  `media_id` varchar(200) NOT NULL,
  `wxappid` varchar(200) NOT NULL,
  `wxappurl` varchar(200) NOT NULL,
  `h5url` varchar(200) NOT NULL,
  `desc` varchar(200) NOT NULL,
  `file` varchar(200) NOT NULL,
  `content` text NOT NULL,
  `createtime` int(11) NOT NULL,
  `pluginname` varchar(50) NOT NULL,
  `star` tinyint(1) DEFAULT \'0\',
  `fromid` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_account_content_group' => 'CREATE TABLE `ims_core_account_content_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uniacid` int(11) NOT NULL,
  `title` varchar(100) NOT NULL,
  `type` varchar(50) NOT NULL,
  `systype` tinyint(1) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `createtime` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_user_permissions_plugin' => 'CREATE TABLE `ims_core_user_permissions_plugin` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) NOT NULL,
  `uid` int(10) NOT NULL,
  `pluginname` varchar(100) NOT NULL,
  `permissions` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_api_shop' => 'CREATE TABLE `ims_core_api_shop` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `url` varchar(100) NOT NULL,
  `cloudkey` varchar(100) NOT NULL,
  `secret` varchar(100) NOT NULL,
  `createtime` int(11) NOT NULL,
  `domain` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8',
  'core_cloud_download' => 'CREATE TABLE `ims_core_cloud_download` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `type` tinyint(1) unsigned NOT NULL,
  `parts` int(10) unsigned NOT NULL,
  `createtime` int(10) unsigned NOT NULL,
  `complete` tinyint(1) unsigned NOT NULL,
  `complete_time` int(10) unsigned NOT NULL,
  `zipfile` varchar(100) NOT NULL,
  `remark` varchar(100) NOT NULL,
  `num` int(10) unsigned NOT NULL,
  `size` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC',
  'core_plugin_version' => 'CREATE TABLE `ims_core_plugin_version` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `uniacid` int(10) unsigned NOT NULL,
  `pid` int(10) NOT NULL COMMENT \'应用id\',
  `status` tinyint(1) NOT NULL COMMENT \'状态：1:等待审核,2:审核中,3:上架,4:上架隐藏,5:下架\',
  `reason` varchar(1024) NOT NULL DEFAULT \'\' COMMENT \'审核不通过原因\',
  `version` varchar(64) NOT NULL DEFAULT \'\' COMMENT \'名称\',
  `description` varchar(1000) NOT NULL COMMENT \'版本说明\',
  `zipfile` char(30) NOT NULL COMMENT \'文件地址\',
  `config` char(30) NOT NULL,
  `release` int(10) unsigned NOT NULL,
  `updata` text NOT NULL,
  `price` decimal(8,2) DEFAULT \'0.00\',
  `upprice` decimal(8,2) DEFAULT \'0.00\',
  `sys_version` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_aid` (`pid`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC',
  'core_trade' => 'CREATE TABLE `ims_core_trade` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(10) unsigned NOT NULL,
  `uniacid` int(10) unsigned NOT NULL,
  `price` decimal(10,2) NOT NULL DEFAULT \'0.00\',
  `createtime` int(10) unsigned NOT NULL,
  `type` tinyint(2) unsigned NOT NULL,
  `code` char(40) NOT NULL,
  `paytype` tinyint(1) unsigned NOT NULL,
  `status` int(2) DEFAULT NULL,
  `tid` varchar(40) DEFAULT NULL,
  `installed` tinyint(1) NOT NULL,
  `packageindex` int(11) NOT NULL,
  `endtime` int(11) NOT NULL,
  `pay_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1',
  'core_trade_uplog' => 'CREATE TABLE `ims_core_trade_uplog` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tid` int(10) unsigned NOT NULL,
  `uniacid` int(10) unsigned NOT NULL,
  `pid` int(10) unsigned NOT NULL,
  `price` decimal(10,2) NOT NULL DEFAULT \'0.00\',
  `createtime` int(10) unsigned NOT NULL,
  `type` tinyint(2) unsigned NOT NULL,
  `paytype` tinyint(1) unsigned NOT NULL,
  `status` int(2) DEFAULT NULL,
  `uptype` int(1) NOT NULL,
  `pay_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=latin1',
);

?>