<?php
/*
 * [JINYUN!] (C)2001-2099 Jinyunweb.com
 * This is NOT a freeware, use is subject to license terms
 * $Id: 2017-12-13 03:39:35 apple $
*/
defined('BY_JYA') or exit('error');
function cache_read($key,$plugin='core',$uniacid='',$uid='') {
	$params=array('ckey'=>$key);
	if($plugin){
		$params['plugin']=$plugin;
	}
	if($uniacid){
		$params['uniacid']=$uniacid;
	}
	if($uid){
		$params['uid']=$uid;
	}
	$val=pdo_getcolumn('core_cache',$params,'value');
	if($val){
		return unserialize($val);
	}else{
		return false;
	}
}
function cache_write($key,$data,$plugin='core',$title='',$uniacid='',$uid='') {
	if (empty($key) || !isset($data)) {
		return false;
	}
	$data=serialize($data);
	$update=array(
		'ckey'=>$key,
		'value'=>$data,
		'plugin'=>$plugin,
		'title'=>$title
	);
	if($uniacid){
		$update['uniacid']=$uniacid;
	}
	if($uid){
		$update['uid']=$uid;
	}
	pdo_insert('core_cache',$update,true);
}
function cache_delete($key,$plugin='',$uniacid='',$uid='') {
	$params=array('ckey'=>$key);
	if($plugin){
		$params['plugin']=$plugin;
	}
	if($uniacid){
		$params['uniacid']=$uniacid;
	}
	if($uid){
		$params['uid']=$uid;
	}
	$result = pdo_delete('core_cache', $params);
	return $result;
}
function cache_clean($prefix = '',$plugin='',$uniacid='',$uid='') {
	$params = array();
	if($prefix){
		$params['prefix like']='%'.$prefix.'%';
	}
	if($plugin){
		$params['plugin']=$plugin;
	}
	if($uniacid){
		$params['uniacid']=$uniacid;
	}
	if($uid){
		$params['uid']=$uid;
	}
	$result = pdo_delete('core_cache', $params);
	return $result;
}
function cache_load($key, $unserialize = false) {
	return true;
}
