<?php
/*
 * [JINYUN!] (C)2001-2099 Jinyunweb.com
 * This is NOT a freeware, use is subject to license terms
 * $Id: 2017-12-13 03:39:35 apple $
*/
/*
	数据库操作函数
 */
defined('BY_JYA') or exit('error');


function pdo($config=''){
	static $db;
	if(is_array($config)){
		$db = new DB($config);
		return true;
	}else{
		return $db;
	}
}
function pdo_get_next_id($tablename){
	return pdo()->get_next_id($tablename);
}
function pdo_query($sql, $params = array()) {
	return pdo()->query($sql, $params);
}
function pdo_run($sql) {
	return pdo()->run($sql);
}
function pdo_count($tablename, $params = array(),$groupby='') {
	return pdo()->count($tablename, $params,$groupby);
}

function pdo_fetchcolumn($sql, $params = array(), $column = 0) {
	return pdo()->fetchcolumn($sql, $params, $column);
}

function pdo_fetch($sql, $params = array()) {
	return pdo()->fetch($sql, $params);
}

function pdo_fetchall($sql, $params = array(), $keyfield = '') {
	return pdo()->fetchall($sql, $params, $keyfield);
}

function pdo_getsum($tablename, $condition = array(), $fields = '') {
	return pdo()->getsum($tablename, $condition, $fields);
}

function pdo_get($tablename, $condition = array(), $fields = array()) {
	return pdo()->get($tablename, $condition, $fields);
}
function pdo_get_options($tablename, $params = array(),$field = '', $orderby = array()){
	return pdo()->get_options($tablename, $params,$field, $orderby);
}
function pdo_getall($tablename, $condition = array(), $fields = array(), $keyfield = '', $orderby = array()) {
	return pdo()->getall($tablename, $condition, $fields, $keyfield, $orderby);
}
function pdo_getlist($table,$parameter=array(),&$total=null){
	return pdo()->getslice($table,$parameter['params'],$parameter['limit'],$total,$parameter['fields'],$parameter['key'],$parameter['orderby'],$parameter['groupby']);
}
function pdo_getslice($tablename, $condition = array(), $limit = array(), &$total = null, $fields = array(), $keyfield = '', $orderby = array()) {
	return pdo()->getslice($tablename, $condition, $limit, $total, $fields, $keyfield, $orderby);
}

function pdo_getcolumn($tablename, $condition = array(), $field) {
	return pdo()->getcolumn($tablename, $condition, $field);
}


function pdo_update($table, $data = array(), $params = array(), $glue = 'AND') {
	return pdo()->update($table, $data, $params, $glue);
}


function pdo_insert($table, $data = array(), $replace = FALSE) {
	return pdo()->insert($table, $data, $replace);
}
function pdo_begin(){
	return pdo()->begin();
}
function pdo_commit(){
	return pdo()->commit();
}
function pdo_rollback(){
	return pdo()->rollback();
}

function pdo_delete($table, $params = array(), $glue = 'AND') {
	return pdo()->delete($table, $params, $glue);
}
function pdo_fieldexists($tablename, $fieldname = '') {
	return pdo()->fieldexists($tablename, $fieldname);
}
function pdo_indexexists($tablename, $fieldname = '') {
	return pdo()->indexexists($tablename, $fieldname);
}
function pdo_tableexists($tablename) {
	return pdo()->tableexists($tablename);
}
function pdo_tablename($tablename) {
	return pdo()->tablename($tablename);
}
function pdo_insertid() {
	return pdo()->insertid();
}

