<?php
/*
 * [JINYUN!] (C)2001-2099 Jinyunweb.com
 * This is NOT a freeware, use is subject to license terms
 * $Id: 2017-12-13 03:39:35 apple $
*/
/*
	系统常用选项数组初始化
*/
defined('BY_JYA') or exit('error');
//获取账号类型数组
function get_user_types(){
	return array(
		'1'=>'操作员',
		'2'=>'副管理员',
		'3'=>'管理员',
		'4'=>'副站长',
		'5'=>'站长',
	);
}
//获取os数组
function get_os(){
	$os=array('wxapp'=>1,'wechat'=>2,'mobile'=>3,'windows'=>4,'app'=>5,'aliapp'=>6,'baiduapp'=>7,'ttapp'=>8,'wxwork'=>9);
	$from=$os[$_SESSION['container']];
	if(!$from){
		$from=$os[$_SESSION['os']];
	}
	return $from;
}
//获取os数组
function get_ostitle(){
	return array(
		'1'=>'小程序',
		'2'=>'微信',
		'3'=>'手机H5',
		'4'=>'PC端',
		'5'=>'APP',
		'6'=>'支付宝',
		'7'=>'百度',
		'8'=>'头条',
		'9'=>'企业微信',
	);
}
//应用类型
function get_app_types(){
	return array(1=>'H5应用',4=>'小程序');
}
//获取权限类型数组
function get_permission_types($key='id',$value='title'){
	$data=array(
		array('id'=>0,'name'=>'sys_actions','title'=>'系统功能','table'=>'core_permissions'),
		array('id'=>1,'name'=>'plugin_actions','title'=>'插件功能','table'=>'core_plugins'),
		array('id'=>2,'name'=>'mobile_template','title'=>'微官网模版','table'=>'core_mobile_template'),
		array('id'=>3,'name'=>'pc_template','title'=>'pc站模版','table'=>'core_pc_template'),
		array('id'=>4,'name'=>'wxapp','title'=>'小程序','table'=>'core_wxapp'),
		array('id'=>5,'name'=>'wxapp_template','title'=>'diy小程序模版','table'=>'core_wxapp_template'),
	);
	$return=array();
	foreach($data as $item){
		if($value=='all'){
			$return[$item[$key]]=$item;
		}else{
			$return[$item[$key]]=$item[$value];
		}
	}
	return $return;
}
//订阅消息类型
function get_receive_types($key,$value){
	$data=array(
		array('id'=>'1','name'=>'subscribe','title'=>'关注事件'),
		array('id'=>'2','name'=>'unsubscribe','title'=>'取消关注事件'),
		//array('id'=>'3','name'=>'SCAN','title'=>'扫描带参数二维码事件'),
		array('id'=>'4','name'=>'LOCATION','title'=>'上报地理位置事件'),
		array('id'=>'5','name'=>'VIEW','title'=>'自定义菜单跳转链接事件'),
		array('id'=>'6','name'=>'scancode_push','title'=>'自定义菜单扫码推事件'),
		array('id'=>'7','name'=>'scancode_waitmsg','title'=>'自定义菜单扫码推事件且弹出“消息接收中”提示框的事件'),
		array('id'=>'8','name'=>'pic_sysphoto','title'=>'自定义菜单弹出系统拍照发图的事件推送'),
		array('id'=>'9','name'=>'pic_photo_or_album','title'=>'自定义菜单弹出拍照或者相册发图的事件'),
		array('id'=>'10','name'=>'pic_weixin','title'=>'自定义菜单弹出微信相册发图器的事件'),
		array('id'=>'11','name'=>'location_select','title'=>'自定义菜单弹出地理位置选择器的事件'),
		array('id'=>'12','name'=>'image','title'=>'图片'),
		array('id'=>'13','name'=>'voice','title'=>'语音'),
		array('id'=>'14','name'=>'video','title'=>'视频'),
		array('id'=>'15','name'=>'shortvideo','title'=>'小视频'),
		array('id'=>'16','name'=>'location','title'=>'地理位置'),
		array('id'=>'17','name'=>'link','title'=>'链接'),
	);
	$return=array();
	foreach($data as $item){
		$return[$item[$key]]=$item[$value];
	}
	return $return;
}
//回复关键词类型
function get_keyword_types(){
	return array(
		'1'=>'精确匹配',
		'2'=>'模糊匹配',
		'3'=>'正则匹配'
	);
}
//粉丝类型
function get_fans_types(){
	return array(
		'1'=>'公众号粉丝',
		'2'=>'小程序粉丝',
	);
}
//消息回复类型

function get_back_types($key='id',$value='title'){
	$data=array(
		array('id'=>'1','name'=>'text','title'=>'文本回复'),
		array('id'=>'2','name'=>'news','title'=>'图文回复'),
		array('id'=>'3','name'=>'image','title'=>'图片回复'),
		array('id'=>'4','name'=>'voice','title'=>'语音回复'),
		array('id'=>'5','name'=>'video','title'=>'视频回复'),
		array('id'=>'6','name'=>'music','title'=>'音乐回复'),
		array('id'=>'7','name'=>'wxcard','title'=>'微信卡券回复'),
		array('id'=>'8','name'=>'event','title'=>'事件回复'),

	);
	$return=array();
	foreach($data as $item){
		$return[$item[$key]]=$item[$value];
	}
	return $return;
}
//带参数二维码类型
function get_qr_types($key='id',$value='title'){
	$data=array(
		array('id'=>1,'name'=>'QR_SCENE','title'=>'临时二维码'),
		array('id'=>2,'name'=>'QR_LIMIT_SCENE','title'=>'永久二维码'),
	);
	$return=array();
	foreach($data as $item){
		$return[$item[$key]]=$item[$value];
	}
	return $return;
}
//插件类型
function get_plugin_types(){
	return array(
		'1'=>'工具插件',
		'2'=>'接口插件',
		'3'=>'应用插件',
		'4'=>'兼容插件',
	);
}
//兼容插件类型
function get_pluginopen_types(){
	return array(
		'business'=>'1',
		'activity'=>'2',
	);
}
//插件类型
function get_plugin_styles(){
	return array(
		'1'=>'行业应用',
		'2'=>'促销应用',
		'3'=>'互动营销',
		'4'=>'游戏营销',
		'5'=>'辅助应用',
		'6'=>'云接口',
	);
}
//插件行业类型
function get_plugin_intypes(){
	$system=core_setting('system');
	if(count($system['intypes'])>0){
		$inlist=array();
		foreach($system['intypes'] as $k=>&$inv){
			if($inv['noshow']==0){
				$inlist[$inv['id']]=$inv['title'];
			}
			
		}
		$intypes=$inlist;
	}else{
		$intypes=array(
			'1'=>'商城/店铺/电商类',
			'2'=>'餐饮/果饮类',
			'3'=>'美业/美发/健身类',
			'4'=>'酒店/服务/预约类',
			'5'=>'社区/社交/旅游类',
			'6'=>'教育/培训/少儿类',
			'7'=>'公司/外贸官网类',
			'0'=>'其他行业类',
		);
	}
	return $intypes;
}
//模板类型
function get_template_groups(){
	$system=core_setting('system');
	if(count($system['template_groups'])>0){
		$inlist=array();
		foreach($system['template_groups'] as $k=>&$inv){
			if($inv['noshow']==0){
				$inlist[$inv['id']]=$inv['title'];
			}
			
		}
		$template_groups=$inlist;
	}else{
		$template_groups=array(
			'0'=>'综合模板',
			'1'=>'商城/门店',
			'2'=>'餐饮/外卖',
			'3'=>'服务/预约',
			'4'=>'教育/培训',
			'5'=>'公司/官网',
			'6'=>'婚纱/摄影',
			'7'=>'美容/美发',
			'8'=>'酒店/旅游',
			'9'=>'健身/私教',
			'10'=>'医疗/门诊',
			'11'=>'服装/模特',
			'12'=>'汽车/4S',
		);
	}
	return $template_groups;
}
//H5游戏类型
function get_h5gametypes(){
	return array(
		'1'=>'节日活动',
		'2'=>'抽奖活动',
		'3'=>'游戏营销',
		'4'=>'助力活动',
		'5'=>'投票活动',
		'6'=>'签到活动',
		'7'=>'红包活动',
		'8'=>'现场活动',
	);
}
function get_pay_types(){
	return array(
		'credit'=>'余额支付',
		'wechat'=>'微信支付',
		'alipay'=>'支付宝支付',
		'yinlian'=>'银联支付',
		'hdfk'=>'货到付款',
	);
}
/*表单类型*/
function get_form_types(){
	return array('1'=>'字符串','2'=>'数字','3'=>'图片','4'=>'单选框','5'=>'多选框','6'=>'文本','7'=>'地址','8'=>'手机号','9'=>'邮箱','10'=>'多图','11'=>'视频','12'=>'获取手机号','13'=>'位置','18'=>'费用');
}
/*小程序页面*/
function get_wxapp_pages(){
	return array(
		array('title'=>'站点首页','url'=>'core/home.welcome/'),
		array('title'=>'会员中心','url'=>'core/member.home/'),
		array('title'=>'会员登录','url'=>'core/member.login/'),
		array('title'=>'会员注册','url'=>'core/member.register/'),
		array('title'=>'新闻页','url'=>'core/article.list/'),
		array('title'=>'产品页','url'=>'jy_weishop/goods.index/'),
		array('title'=>'关于我们','url'=>'core/home.abouts/'),
		array('title'=>'签到','url'=>'core/member.qiandao/'),
		array('title'=>'我的卡券','url'=>'core/member.card/'),
		array('title'=>'充值页面','url'=>'core/member.recharge/'),
		array('title'=>'会员设置','url'=>'core/member.set/'),
		array('title'=>'充值记录','url'=>'core/member.log/'),
		array('title'=>'我的留言','url'=>'core/member.message/'),
		array('title'=>'我的表单','url'=>'core/member.diyform/'),
		array('title'=>'地址管理','url'=>'core/member.address/'),
	);
}
/*系统DIY页面*/
function get_sys_diypages(){
	return array(
		array('title'=>'站点首页','url'=>'core/home.welcome/'),
		array('title'=>'会员中心','url'=>'core/member.home/'),
		array('title'=>'会员登录','url'=>'core/member.login/'),
		array('title'=>'会员注册','url'=>'core/member.register/'),
		array('title'=>'新闻页','url'=>'core/article.list/'),
		array('title'=>'产品页','url'=>'core/home.goods/'),
		array('title'=>'关于我们','url'=>'core/home.abouts/'),
		array('title'=>'我的卡券','url'=>'core/member.card/'),
		array('title'=>'充值记录','url'=>'core/member.log/'),
		array('title'=>'我的留言','url'=>'core/member.message/'),
		array('title'=>'我的表单','url'=>'core/member.diyform/'),
		array('title'=>'地址管理','url'=>'core/member.address/'),
	);
}
/*小程序CMS页面*/
function get_wxapp_otherpages(){
	return array(
		array('title'=>'相册列表','page'=>'/pagescms/album/index'),
		array('title'=>'文章列表','page'=>'/pagescms/news/index'),
	);
}
/*小程序SHOP页面*/
function get_wxapp_shoppages(){
	return array(
		array('title'=>'产品列表','page'=>'/jy_weishop/goods/index/index'),
		array('title'=>'产品详情','page'=>'/jy_weishop/goods/detail/index'),
		array('title'=>'订单列表','page'=>'/jy_weishop/order/list/index'),
	);
}
/*后台系统页面*/
function get_managehome_pages(){
	return array(
		array('title'=>'后台首页','url'=>'core/account.welcome/'),
		array('title'=>'后台站点','url'=>'core/basic.welcome/'),
		array('title'=>'后台会员','url'=>'core/member.cover/'),
		array('title'=>'后台宣传','url'=>'core/basic.xiu_data/'),
		array('title'=>'后台企业微信','url'=>'core/wxwork.welcome/'),
		array('title'=>'后台商城','url'=>'jy_weishop/basic.module_home/'),
		array('title'=>'前端首页','url'=>'core/home.welcome/'),
		array('title'=>'会员登录','url'=>'core/user.login/'),
		array('title'=>'会员注册','url'=>'core/user.register/'),
		array('title'=>'平台新闻','url'=>'core/home.news/'),
		array('title'=>'服务套餐','url'=>'core/home.group_store/'),
		array('title'=>'关于我们','url'=>'core/home.abouts/'),
		array('title'=>'公众号宣传页','url'=>'core/home.wechat/'),
		array('title'=>'应用市场','url'=>'core/home.plugin/'),
		array('title'=>'模板市场','url'=>'core/home.plugin/list/type=2'),
		array('title'=>'小程序宣传页','url'=>'core/home.wxapp/'),
		array('title'=>'PC端宣传页','url'=>'core/home.pc/'),
		array('title'=>'微官网宣传页','url'=>'core/home.mobile/'),
		array('title'=>'H5宣传页','url'=>'core/home.h5/'),
		array('title'=>'DIY官网','url'=>'core/home.diy/'),
		array('title'=>'DIY小程序','url'=>'core/home.diy_wxapp/'),
	);
}
//营销群发计划类别
function saletask_types(){
	return array(
		'0'=>'默认群发',
		'1'=>'自定义人群',
		'2'=>'未消费新增用户',
		'3'=>'兴趣人群转化',
		'4'=>'互动粉丝用户',
		'5'=>'需重点召回客户',
		'6'=>'需重点发展客户',
		'7'=>'需重点活跃客户',
		'8'=>'需刺激消费客户',
		'9'=>'指定手机客户',
		'10'=>'会员日营销',
		'11'=>'生日营销',
		'12'=>'节日营销',
		'13'=>'付费会员特价体验',
	);
}
//节日活动
function holiday_types(){
	return array(
		array('id'=>1,'title'=>'除夕'),
		array('id'=>2,'title'=>'春节'),
		array('id'=>3,'title'=>'立春'),
		array('id'=>4,'title'=>'元宵节'),
		array('id'=>5,'title'=>'情人节'),
		array('id'=>6,'title'=>'惊蛰'),
		array('id'=>7,'title'=>'妇女节'),
		array('id'=>8,'title'=>'植树节'),
		array('id'=>9,'title'=>'白色情人节'),
		array('id'=>10,'title'=>'春分'),
		array('id'=>11,'title'=>'愚人节'),
		array('id'=>12,'title'=>'清明节'),
		array('id'=>13,'title'=>'复活节'),
		array('id'=>14,'title'=>'劳动节'),
		array('id'=>15,'title'=>'母亲节'),
		array('id'=>16,'title'=>'世界地球日'),
		array('id'=>17,'title'=>'吃货节'),
		array('id'=>18,'title'=>'520情人节'),
		array('id'=>19,'title'=>'端午节'),
		array('id'=>20,'title'=>'国际儿童节'),
		array('id'=>21,'title'=>'父亲节'),
		array('id'=>22,'title'=>'618年中大促'),
		array('id'=>23,'title'=>'夏至'),
		array('id'=>24,'title'=>'建军节'),
		array('id'=>25,'title'=>'七夕'),
		array('id'=>26,'title'=>'迎新开学季'),
		array('id'=>27,'title'=>'中元节'),
		array('id'=>28,'title'=>'教师节'),
		array('id'=>29,'title'=>'秋分'),
		array('id'=>30,'title'=>'国庆节'),
		array('id'=>31,'title'=>'中秋节'),
		array('id'=>32,'title'=>'重阳节'),
		array('id'=>33,'title'=>'万圣节'),
		array('id'=>34,'title'=>'立冬'),
		array('id'=>35,'title'=>'双十一'),
		array('id'=>36,'title'=>'冬至'),
		array('id'=>37,'title'=>'平安夜'),
		array('id'=>38,'title'=>'圣诞节'),
		array('id'=>39,'title'=>'元旦节'),
		array('id'=>40,'title'=>'感恩节'),
		array('id'=>41,'title'=>'腊八节'),
		array('id'=>42,'title'=>'其他热点'),
	);
}
//内容云类别
function content_types(){
	return array(
		'text'=>'文本',
		'image'=>'图片',
		'audio'=>'语音',
		'video'=>'视频',
		'file'=>'文件',
		'miniprogram'=>'小程序',
		'news'=>'图文',
		'other'=>'其他',
	);
}
//应用表
function app_table(){
	return array(
		1=>'core_plugins',
		2=>'core_mobile_template',
		3=>'core_pc_template',
		4=>'core_wxapp',
		5=>'core_wxapp_template',
		6=>'core_pc_blocks',
		7=>'core_mobile_blocks',
		8=>'core_h5game',
		10=>'core_manage_template',
		11=>'core_addons_temp_pc',
	);
}
function app_type(){
	return array(
		1=>'功能插件',
		2=>'手机站模版',
		3=>'pc站模版',
		4=>'小程序',
		5=>'小程序首页模版',
		6=>'pc端页面组件',
		7=>'手机端页面组件',
		8=>'H5小游戏',
		10=>'系统模版',
		11=>'PC应用模版',
	);
}