define(['tool','base64'],function(tool,base64){
	var _ws;
	var _socket_url="wss://socket.jinyunweb.com";
	var _message=function(data,type){
		var message={
			type:type,
			data:data
		};
		message=JSON.stringify(message);
		//console.log('发送消息：');console.log(message);
		_ws.send(message);
	}
	var jinyun_socket={};
	jinyun_socket.send2uid=function(message,uid){
		if(!message || typeof(message)!='string'){
			console.log('发送的消息不合法！只能发送字符串格式消息！');
			return;
		}
		message=base64.encode(message);
		var data={
			'message':message,
			'to_uid':uid,
		};
		_message(data,'say');
	};
	jinyun_socket.send2room=function(message,room_id){
		if(!message || typeof(message)!='string'){
			console.log('发送的消息不合法！只能发送字符串格式消息！');
			return;
		}
		message=base64.encode(message);
		var data={
			'message':message,
			'to_room':room_id,
		};
		_message(data,'say');
	};
	jinyun_socket.join=function(room_id){
		var data={
			'room_id':room_id,
		};
		console.log('加入！'+room_id);
		_message(data,'join');
	};
	jinyun_socket.leave=function(room_id){
		
		var data={
			'room_id':room_id,
		};
		_message(data,'leave');
	};
	jinyun_socket.close=function(){
		_ws.close();
		console.log('连接已关闭！');
	}
	jinyun_socket.connect=function(callback,config,time){
		if(!config){
			tool.get('core/tools.socket/',function(res){
				//console.log('socket_res');console.log(res);
				jinyun_socket.connect(callback,res.config,time);
			});
			return;
		}
		if(!config.token || !config.nonce || !config.timestamp || !config.sign || !config.uid){
			console.log('参数错误，无法发起socket连接！');
			return;
		}
		_ws = new WebSocket(_socket_url);
		_ws.onopen=function(){
			_message(config,'login');
			if(typeof(callback)=='function'){
				callback();
			}
		}
		//接收来自api的信息
		_ws.onmessage=function(e){
			//console.log(e.data);
			var data = JSON.parse(e.data);
			switch(data['type']){
				case 'ping':
					//心跳
					console.log('心跳');
					_message('','pong');
					return;
				case 'error':
					//报错
					console.log('收到来自服务器的错误提示：');console.log(data.data);
					return;
				case 'say':
					//接收消息
					if(!jinyun_socket.onmessage || typeof(jinyun_socket.onmessage)!='function'){
						return;
					}
					var message={
						'message':base64.decode(data.data.message),
						'from_uid':data.data.from_uid,
						'from_room':data.data.from_room,
					};
					jinyun_socket.onmessage(message);
					return;
				case 'login':
					//登陆消息
					if(!jinyun_socket.onlogin || typeof(jinyun_socket.onlogin)!='function'){
						return;
					}
					var message={
						'uid':data.data.uid,
					};
					jinyun_socket.onlogin(message);
					return;
				case 'logout':
					//退出消息
					if(!jinyun_socket.onlogout || typeof(jinyun_socket.onlogout)!='function'){
						return;
					}
					var message={
						'uid':data.data.uid,
					};
					jinyun_socket.onlogout(message);
					return;
				case 'join':
					//进入房间消息
					console.log('join');console.log(data);
					if(!jinyun_socket.onjoin || typeof(jinyun_socket.onjoin)!='function'){
						return;
					}
					var message={
						'uid':data.data.uid,
						'room':data.data.room,
					};
					jinyun_socket.onjoin(message);
					return;
				case 'leave':
					//退出房间消息
					if(!jinyun_socket.onleave || typeof(jinyun_socket.onleave)!='function'){
						return;
					}
					var message={
						'uid':data.data.uid,
						'room':data.data.room,
					};
					jinyun_socket.onleave(message);
					return;
				case 'system':
					//来自系统的消息
					if(!jinyun_socket.onsystem || typeof(jinyun_socket.onsystem)!='function'){
						return;
					}
					//console.log('data.data.message');console.log(data.data.message);
					var message={
						'message':data.data.message,
						'to_uid':data.data.to_uid,
						'to_room':data.data.to_room,
					};
					jinyun_socket.onsystem(message);
					return;
			}
		}
		_ws.onclose = function() {
			console.log("连接关闭，准备重连");
			time=time || 1000;
			setTimeout(function(){
				if(time<60000){
					time=time+time;
				}
				jinyun_socket.connect(callback,false,time);
			},time)
			
		};
		_ws.onerror = function() {
			console.log("出现错误");
		};
		return true;
	}
	return jinyun_socket;
	
});