define(['bootstrap','base64'],function($,base64){
	var tool={};
	if(window.config){
		tool.config=window.config;
	}else{
		tool.config={};
	}
	tool.conf=function(config){
		tool.config=config;
	}
	tool.ajax_result=function(data,callback){
		if(data.length<=0){
			tool.message('服务器没有返回数据！','error');
		}else{
			try{
				var res=JSON.parse(data);
			}catch(err){
				tool.message('服务器返回数据不合法，原始数据为：'+data,'error');
				return;
			}
			if(res.type!='success' || res.action){
				tool.message(res.message,res.type,res.action);
				return;
			}
			if($.isFunction(callback)){
				callback(res.message);
			}
		}
	}
	tool.get=function(url,callback){
		url=tool.api_url(url);
		$.get(url,function(data,status){
			if(status!='success'){
				tool.message('请求失败：'+status,'error');
			}else{
				tool.ajax_result(data,callback);
			}
		},'text');
	}
	tool.post=function(url,post,callback,encode){
		url=tool.api_url(url);
		if(encode){
			var data=base64.encode(JSON.stringify(post),tool.config.base_key_str);
			post={postdata:data};
		}
		$.post(url,post,function(data,status){
			if(status!='success'){
				tool.message('请求失败：'+status,'error');
			}else{
				tool.ajax_result(data,callback);
			}
		},'text');
	}
	tool.api_url=function(params){
		if(!params){
			console.log('地址错误');
			return;
		}
		if(typeof(params)=='string'){
			params=tool.links(params);
		}
		if(window.scope && window.scope.page){
			if(!params.plugin){
				params.plugin=window.scope.page.plugin;
			}
			if(!params.action){
				params.action=window.scope.page.action;
			}
		}else if(window.config && window.config.access_json){
			if(!params.plugin){
				params.plugin=window.config.access_json.plugin;
			}
			if(!params.action){
				params.action=window.config.access_json.action;
			}
		}
		
		var query=params.query;
		params.query=undefined;
		params.this=tool.config.this;
		params.token=tool.config.token;
		
		var url=tool.config.siteroot+'api.php?'+tool.made_query(params);
		if(query){
			url+=query;
		}
		
		return url;
	}
	tool.custom_url=function(url,abs){
		if(url.slice(0,4)=='http' || url.slice(0,11)=='./index.php'){
			return url;
		}
		var params=tool.links(url);
		var query=params.query;
		params.query=undefined;
		if(!params.op){
			params.op=undefined;
		}
		params.i=tool.config.uniacid;
		if(abs){
			var url=tool.config.siteroot+'custom/index.php?'+tool.made_query(params);
		}else{
			var url='./index.php?'+tool.made_query(params);
		}
		
		if(query){
			url+=query;
		}
		return url;
	}
	tool.manage_url=function(url,abs){
		if(url.slice(0,4)=='http' || url.slice(0,11)=='./index.php'){
			return url;
		}
		var params=tool.links(url);
		var query=params.query;
		params.query=undefined;
		if(!params.op){
			params.op=undefined;
		}
		if(abs){
			var url=tool.config.siteroot+'manage/index.php?'+tool.made_query(params);
		}else{
			var url='./index.php?'+tool.made_query(params);
		}
		
		if(query){
			url+=query;
		}
		return url;
	}
	tool.made_query=function(params){
		var query='';
		for(var i in params){
			if(params[i]!==undefined){
				query+=i+'='+params[i]+'&';
			}
		}
		return query;
	}
	tool.tomedia=function(url,root){
		if(!url || typeof(url)!='string'){
			return false;
		}
		if(url.slice(0,4)=='http'){
			return url;
		}else if(url.slice(0,16)=='../core/resource'){
			return url;
		}else if(url.slice(0,10)=='../addons/'){
			return url;
		}else{
			var dd=url.split('.');
			if(dd['1']=='html' && !root){
				var file_url = tool.config.attachment_url+url+'?v='+tool.config.urlargs;
			}else if(dd['1']=='html' && root){
				var file_url = tool.config.attachment_rooturl+url+'?v='+tool.config.urlargs;
			}else if(root){
				var file_url = tool.config.attachment_rooturl+url;
			}else{
				var file_url = tool.config.attachment_url+url;
			}
			return file_url;
		}
	}
	tool.links=function(paop){
		if(paop.slice(0,4)=='http' || paop.slice(0,11)=='./index.php'){
			return paop;
		}
		paop=paop.split('/');
		var num=paop.length;
		switch(num){
			case 4:
				var params={'plugin':paop['0'],'action':paop['1'],'op':paop['2'],'query':paop['3']};
				break;
			case 3:
				var params={'plugin':paop['0'],'action':paop['1'],'op':paop['2']};
				break;
			case 2:
				var params={'action':paop['0'],'op':paop['1']};
				break;
			case 1:
				var params={'op':paop['0']};
				break;
			default:
				var params={};
		}
		return params;
	}
	//生成二维码
	tool.qr=function(data,id,width,wxapp,action){
		//console.log('data');console.log(data);
		if(!id){
			console.log('生成二维码失败，没有传入标签ID');
			return false;
		}
		if(!data){
			console.log('生成二维码失败，没有传入初始字符串');
			return false;
		}
		if(!width){
			width=150;
		}
		if(wxapp){
			//支持小程序，此处请求后端获取小程序二维码
			if(action){
				appdata=action
			}else{
				appdata=encodeURIComponent(data)
			}
			scope.post({'url':appdata},'core/tools.wxapp_ewm/get/','',function(res){				
				//console.log('res');console.log(res);
				if(res=='error'){
					setTimeout(function(){
						$('#'+id+'-wxapp').html('<a href="javascript:;"><img src="../core/resource/images/no-wxapp.png" style="max-width:'+width+'px"></a>');
					},200);
				}else{
					setTimeout(function(){
						//console.log('插入');console.log('#'+id+'-wxapp');console.log(res);
						$('#'+id+'-wxapp').html('<img src="'+res+'" style="max-width:'+width+'px">');
					},200);
				}
			});
			
		}
		require(['jquery.qrcode'], function(){
			setTimeout(function(){$('#'+id).html('').qrcode({
				render: 'canvas',
				width: width,
				height: width,
				text: tool.custom_url(data,true),
			});},200);
		});
	}
	tool.wxapp_qr=function(data,id,width,system){
		if(!id){
			console.log('生成二维码失败，没有传入标签ID');
			return false;
		}
		if(!data){
			console.log('生成二维码失败，没有传入初始字符串');
			return false;
		}
		if(!width){
			width=150;
		}
		var post={'url':encodeURIComponent(data)};
		if(system){
			post.system=1;
		}
		scope.post(post,'core/tools.wxapp_ewm/get/','',function(res){
		//console.log('res');console.log(res);
			if(res=='error'){
				res='../core/resource/images/no-wxapp.png';
			}
			setTimeout(function(){
				$('#'+id).html('<a href="javascript:;"><img src="'+res+'" style="max-width:'+width+'px"></a>');
			},200);
		});
	}
	tool.message=function(msg,type,action){
		if($('#page-loading').is(":visible")){
			//隐藏加载动画
			tool.page_loading('hide');
		}
		if(tool.posting){
			tool.posting=false;
		}
		if(msg){
			if($('#msg-loading').length==0){
				$.get(tool.config.siteroot+'core/resource/message.html?v='+tool.config.urlargs,function(html){
					if($('#msg-loading').length==0){
						$('body').prepend(html);
					}
					tool.message(msg,type,action);
				});
				return;
			}
			$('#msg-loading').children().children().text(msg);
			$('#msg-loading').show();
			setTimeout(function(){
				$('#msg-loading').hide();
				tool.message('',type,action);
			},2000);
		}else{
			if(action){
				if(action=='hold'){
					return true;
				}else if(action=='reload'){
					window.location.reload();
				}else if(action=='goback'){
					if(window.scope && window.scope.goback){
						scope.goback();
					}else{
						window.history.go(-1);
					}
				}else if(action=='closeWindow'){
					wx.closeWindow();
				}else{
					if(window.scope && window.scope.access_json){
						scope.access_json(action);
					}else{
						window.location.href=tool.custom_url(action);
					}
				}
			}else if(type=='error'){
				throw SyntaxError('页面返回错误！');
			}else{
				if($('body').hasClass('modal-open')){
					$('#modal_content').modal('hide');
				}
			}
		}
		return true;
	}
	tool.confirm_json=function(obj){
		if(!obj || typeof(obj)!='object' || !obj.message){
			console.log('参数错误！');
			return false;
		}
		tool.confirm(obj.message,obj.success,obj.cancel,obj.success_btn,obj.cancel_btn,obj.title);
	}
	tool.confirm=function(message,success,cancel,success_btn,cancel_btn,title){
		if($('#confirm-modal').length==0){
			$.get(tool.config.siteroot+'core/resource/confirm.html?v='+tool.config.urlargs,function(loading_html){
				if($('#confirm-modal').length==0){
					$('body').prepend(loading_html);
				}
				tool.confirm(message,success,cancel,success_btn,cancel_btn,title);
			});
			return;
		}
		success_btn=success_btn || '确定';
		cancel_btn=cancel_btn || '取消';
		title=title || '系统提示';
		var modal=$('#confirm-modal');
		if(tool.config.os=='windows'){
			modal.find('.modal-windows').show();
		}else{
			modal.find('.modal-mobile').show();
		}
		modal.find('.confirm-modal-title').text(title);
		modal.find('.confirm-modal-msg').text(message);
		modal.find('.confirm-modal-success-btn').text(success_btn);
		modal.find('.confirm-modal-cancel-btn').text(cancel_btn);
		modal.find('.confirm-modal-success-btn').unbind().click(function(){
			modal.modal('hide');
			if($.isFunction(success)){
				success();
			}else{
				window.scope.access_json(success);
			}
		});
		modal.find('.confirm-modal-cancel-btn').unbind().click(function(){
			modal.modal('hide');
			if($.isFunction(cancel)){
				cancel();
			}else{
				window.scope.access_json(cancel);
			}
		});
		modal.modal();
	}
	tool.clip=function(data){
		if($('#clip_div').length<=0){
			$(document.body).append('<div id="clip_div" style="display:none;"></div>');
			require(['clipboard'], function(Clipboard){
				var c=new Clipboard('#clip_div',{text:function(){
					return $('#clip_div').attr('copy_data');
				}});
				c.on('success',function(){
					tool.message('复制成功！');
				});
				$('#clip_div').attr('copy_data',data);
				$('#clip_div').click();
			});
		}else{
			$('#clip_div').attr('copy_data',data);
			$('#clip_div').click();
		}
	}
	tool.page_loading=function(type){
		if(!type){
			type='show';
		}
		if($('#page-loading').length==0){
			$.get(tool.config.siteroot+'core/resource/loading.html?v='+tool.config.urlargs,function(loading_html){
				if($('#page-loading').length==0){
					$('body').prepend(loading_html);
				}
				tool.page_loading(type);
			});
			return;
		}
		if(type=='show'){
			$('#page-loading').show();
		}else{
			$('#page-loading').hide();
		}
	}
	tool.location=function(callback,type){
		if(!$.isFunction(callback)){
			return false;
		}
		if(window.config.container=='wechat' && window.wx){
			if(window.config.wxready){
				tool.get_location_by_jssdk(callback);
			}else if(window.after_wxready_func){
				window.after_wxready_func.push(function(){
					tool.get_location_by_jssdk(callback);
				});
			}
			return;
		}
		
		type=type || 'baidu';
		if(type=='baidu'){
			window.HOST_TYPE = "2"; window.BMap_loadScriptTime = (new Date).getTime();
			require(['map'], function(BMap){
				var geolocation = new BMap.Geolocation();
				geolocation.getCurrentPosition(function(r){
					if(this.getStatus() == BMAP_STATUS_SUCCESS){
						
						var point = new BMap.Point(r.point.lng,r.point.lat);//用所定位的经纬度查找所在地省市街道等信息
						var gc = new BMap.Geocoder();
						gc.getLocation(point, function(rs){
							var res={'lat_lng':{'type':'BD09','lat':r.point.lat,'lng':r.point.lng},'address':rs.address,'addressComponents':rs.addressComponents};
							callback(res);
						});
					}else{
						tool.message('获取地址失败！请检查是否开启位置并授权！','error');
						var re={'iserror':1,'lat_lng':{'type':'GCJ02','lat':22.757597,'lng':118.068529},'address':'','addressComponents':{'province':'广东省','city':'深圳市','district':'福田区','street':''}};
						callback(re);
					}        
				});
			});
		}else{
				require(['qqmap'],function(qq){
					var qqlocation=new qq.maps.Geolocation("SN2BZ-MKT32-22SU7-COVX6-ZYXAQ-OEF6D", "进云");
					var params={};
					params.success=function(position){
						var res={'lat_lng':{'type':'GCJ02','lat':position.lat,'lng':position.lng},'address':position.addr,'addressComponents':{'province':position.province,'city':position.city,'district':position.district}};
						callback(res);
					}
					params.error=function(position){
						tool.message('获取地址失败！请检查是否开启位置并授权！','error');
						var re={'iserror':1,'lat_lng':{'type':'GCJ02','lat':22.757597,'lng':118.068529},'address':'','addressComponents':{'province':'广东省','city':'深圳市','district':'福田区','street':''}};
						callback(re);
					}
					qqlocation.getLocation(params.success,params.error);
				});
		}
	}
	tool.tel=function(mobile){
		window.location.href='tel:'+mobile;
	}
	tool.navigation=function(lat_lng,title,content){
		if(!lat_lng || !title){
			alert('关键参数为空，导航失败！');
			return false;
		}
		if(!content){
			content=title;
		}
		var url="http://api.map.baidu.com/marker?location="+lat_lng.lat+","+lat_lng.lng+"&title="+title+"&content="+content+"&output=html&src=webapp.baidu.openAPIdemo";
		window.location.href=url;
	}
	tool.get_location_by_jssdk=function(callback){
		wx.getLocation({
			type: 'gcj02', // 默认为wgs84的gps坐标，如果要返回直接给openLocation用的火星坐标，可传入'gcj02'
			success: function (res){
				$.ajax({
					url:'https://apis.map.qq.com/ws/geocoder/v1/?output=jsonp&key=SN2BZ-MKT32-22SU7-COVX6-ZYXAQ-OEF6D&location='+res.latitude+','+res.longitude,
					type:'get',
					dataType:'jsonp',
					success:function(result){
						//alert(JSON.stringify(result.result));
						var re={'lat_lng':{'type':'GCJ02','lat':res.latitude,'lng':res.longitude},'address':result.result.address,'addressComponents':{'province':result.result.address_component.province,'city':result.result.address_component.city,'district':result.result.address_component.district,'street':result.result.address_component.street}};
						callback(re);
					},
					fail:function(result){
						var re={'iserror':1,'lat_lng':{'type':'GCJ02','lat':22.757597,'lng':118.068529},'address':'','addressComponents':{'province':'广东省','city':'深圳市','district':'福田区','street':''}};
						callback(re);
					}
				});
			}
		});
	}
	tool.get_latlng=function(post,callback){
		var address = post.address;
		var city= post.city?post.city:'';
		if(!address){
			return false;
		}
		$.ajax({
					url:'https://apis.map.qq.com/ws/geocoder/v1/?output=jsonp&key=SN2BZ-MKT32-22SU7-COVX6-ZYXAQ-OEF6D&address='+address+'&region='+city,
					type:'get',
					dataType:'jsonp',
					success:function(res){
						callback(res.result);
					}
		});
	}
	tool.up_file=function(type,callback,multiple,accept,process){
		var html='<form action="" method="POST" enctype="multipart/form-data"><input style="display:none;" name="up_file[]" type="file" value=""></form>';
		var up_form=$(html);
		$(document.body).append(up_form);
		var input=up_form.find('input');
		if(multiple){
			input.attr('multiple','multiple');
		}
		if(type=='image'){
			input.attr('accept','image/*');
		}
		if(type=='audio'){
			input.attr('accept','audio/*');
		}
		if(type=='video'){
			input.attr('accept','video/*');
		}
		if(!type){
			type='other';
		}
		if(accept){
			input.attr('accept',accept);
		}
		input.change(function(){
			if(window.uploadsetting && window.uploadsetting[type]){
				var limit=parseInt(window.uploadsetting[type]);
				var size;
				for(var k in this.files){
					size=this.files[k].size/(1024*1024);
					if(size>limit){
						tool.message('文件太大了，上传失败！上传的文件请不要超过'+limit+'M','error');
						return;
					}
				}
			}
			var form_data=new FormData(up_form[0]);
			var params={
				url:tool.api_url('core/tools.file_upload/local_file/type='+type),
				type: 'POST', 
				data: form_data, 
				//async: false, 
				//cache: false, 
				contentType: false, 
				processData: false, 
				success:function(data){
					
					$('#up_file_process_'+process).parent().hide();
					tool.ajax_result(data,function(res){
						if(type=='video'){
							//如果是视频，自动尝试截取视频第一帧图片保存到后台
							var data={'filedata':'','filename':'/cat.png','plugin':'core','action':'tools.file_upload','op':'local','type':'image','from_video':res[0]};
								scope.ajax(data,'',function(ress){
									//console.log('success');console.log(ress);
									if(!multiple){
										res=res[0];
									}
									tool.page_loading('hide');
									callback(res,ress);
								});
							/*var new_video='<video style="display:none;" id="video_upload_for_image" src="'+scope.tomedia(res[0])+'" preload="auto" oncanplaythrough="get_video_first_image()"></video>';
							
							window.get_video_first_image=function(){
								var new_video_doc=document.getElementById("video_upload_for_image");
								var canvas = document.createElement("canvas");
								canvas.width = new_video_doc.videoWidth * 1;
								canvas.height = new_video_doc.videoHeight * 1;
								canvas.getContext('2d').drawImage(new_video_doc, 0, 0, canvas.width, canvas.height);
								var image_data=canvas.toDataURL();
								new_video_doc.remove();
								var data={'filedata':image_data,'filename':'/cat.png','plugin':'core','action':'tools.file_upload','op':'local','type':'image','from_video':res[0]};
								scope.ajax(data,'',function(ress){
									//console.log('success');console.log(ress);
									if(!multiple){
										res=res[0];
									}
									tool.page_loading('hide');
									callback(res,ress);
								});
							};
							//console.log('插入video');
							$(document.body).append(new_video);*/
							
						}else{
							if(!multiple){
								res=res[0];
							}
							tool.page_loading('hide');
							callback(res);
						}
						
					});
				}
			}
			if(process && $('#up_file_process_'+process).length>0){
				$('#up_file_process_'+process).parent().show();
				params.xhr=function(){ //获取ajaxSettings中的xhr对象，为它的upload属性绑定progress事件的处理函数  
            		myXhr = $.ajaxSettings.xhr();
					if(myXhr.upload){ //检查upload属性是否存在  
						//绑定progress事件的回调函数  
						myXhr.upload.addEventListener('progress',function(e){
							//console.log('tzjdt');
							var curr=e.loaded;
							var total=e.total;
							var per=parseInt(curr/total*100);
							$('#up_file_process_'+process).css('width',per+'%');
						}, false);   
					}
					return myXhr; //xhr对象返回给jQuery使用  
				}
			}else{
				tool.page_loading();
			}
			$.ajax(params);
		});
		input.click();
	}
	var _pay={
		pay:function(pay_type){			
			var pay_method='pay_'+pay_type;
			if(!this[pay_method]){
				this.callback({'type':'error','message':'支付方式不存在！'});
				return;
			}
			this[pay_method]();
		},
		pay_wechat:function(){
			if(window.config.fromh5wxapp==1){
				wx.miniProgram.getEnv(function(res){
					if(!res.miniprogram){
						window.config.fromh5wxapp=0;
					}
				});
			}
			if(window.config.fromh5wxapp==1){
				//H5小程序环境下
				var manage = window.config.this=='manage'?1:0;
				wx.miniProgram.navigateTo({
					url: '/pages/pay/pay?manage='+manage+'&pay_id='+this.id
				})
			}else{
				tool.post('core/member.pay/wechat/id='+this.id,{},function(data){
					if(data=='success'){
						//支付成功回调
						var pay_result={'type':'success','message':'支付成功！','payid':this.id};
						_pay.pay_result(pay_result);
						return false;
					}
					//发起微信支付
					if(window.config.container=='wechat'){
						WeixinJSBridge.invoke('getBrandWCPayRequest', data, function(res) {
							if(res.err_msg == 'get_brand_wcpay_request:ok'){
								//支付成功回调
								var pay_result={'type':'success','message':'支付成功！','payid':this.id};
							}else if(res.err_msg == 'get_brand_wcpay_request:cancel'){
								var pay_result={'type':'error','message':'取消支付！','payid':this.id};
							}else{
								var pay_result={'type':'error','message':'支付出错：'+res.err_msg,'payid':this.id};
							}
							_pay.pay_result(pay_result);
						});
					}else{
						//非微信环境，发起h5支付
						_pay.pay_complete_set();
						window.location.href=data;
					}
				});
			}
			
		},
		pay_alipay:function(){
			if(window.config.container=='wechat'){
				var pay_url=tool.custom_url('core/member.pay/copy/id='+this.id+'&pay_type=alipay',true);
				window.location.href=pay_url;
				return;
			}
			tool.get('core/member.pay/alipay/id='+this.id,function(data){
				if(data=='success'){
						//支付成功回调
						var pay_result={'type':'success','message':'支付成功！','payid':this.id};
						_pay.pay_result(pay_result);
						return false;
				}
				//发起支付宝支付
				_pay.pay_complete_set();
				var html=scope.base64.decode(data);
				$('body').append(html);
			});
		},
		pay_credit:function(){
			//tool.get('core/member.pay/wechat/id='+this.id,function(res){
				//发起余额支付
				
				tool.confirm('确认要支付吗？',function(){
					//alert('发起余额支付！');
					tool.post('core/member.pay/credit/id='+_pay.id,{},function(data){
						if(data!='success'){
							var pay_result={'type':'error','message':'支付出错：'+data,'payid':_pay.id};
						}else{
							var pay_result={'type':'success','message':'支付成功！','payid':_pay.id};
						}
						_pay.pay_result(pay_result);
					});
				});
			//});
		},
		pay_vip8pay:function(){
			tool.get('core/member.pay/vip8pay/id='+this.id,function(data){
				if(data=='success'){
						//支付成功回调
						var pay_result={'type':'success','message':'支付成功！','payid':this.id};
						_pay.pay_result(pay_result);
						return false;
				}
				//发起支付
				//console.log('data');console.log(data);
				if(res.err_msg == 'get_brand_wcpay_request:ok'){
								//支付成功回调
								var pay_result={'type':'success','message':'支付成功！','payid':this.id};
				}else if(res.err_msg == 'get_brand_wcpay_request:cancel'){
								var pay_result={'type':'error','message':'取消支付！','payid':this.id};
				}else{
								var pay_result={'type':'error','message':'支付出错：'+res.err_msg,'payid':this.id};
				}
				_pay.pay_result(pay_result);
			});
		},
		pay_hdfk:function(){
			//tool.get('core/member.pay/wechat/id='+this.id,function(res){
				//发起货到付款
				tool.post('core/member.pay/hdfk/id='+_pay.id,{},function(data){
						if(data!='success'){
							var pay_result={'type':'error','message':'提交出错：'+data,'payid':_pay.id};
						}else{
							var pay_result={'type':'success','message':'提交成功！','payid':_pay.id};
						}
						_pay.pay_result(pay_result);
				});
			//});
		},
		pay_complete_set:function(){
			$('#core-pay-modal').find('.fui-list-group').hide();
			$('#core-pay-modal').find('.complete').show();
		},
		pay_result:function(res){
			if(typeof(this.callback)=='function'){
				this.callback(res);
			}else if(window.scope && scope.access_json){
				scope.access_json(this.callback);
			}
		}
	};
	
	tool.pay=function(id,callback,pay_type,forward_url){
		if(!id || !callback){
			scope.message('调用支付接口失败，请传入有效的系统支付单号并设置好回调函数！');
			return false;
		}
		if(pay_type){
			_pay.callback=callback;
			_pay.id=id;
			_pay.pay(pay_type);
			return;
		}
		if($('#core-pay-modal').length<=0){
			if(window.config.os=='windows'){
				var pay_html=tool.config.siteroot+'core/resource/pay_pc.html?v='+tool.config.urlargs;
			}else{
				var pay_html=tool.config.siteroot+'core/resource/pay.html?v='+tool.config.urlargs
			}
			$.get(pay_html,function(pay_html){
				$(document.body).append(pay_html);
				tool.pay(id,callback,'',forward_url);
			});
			return;
		}
		tool.get('core/member.pay//id='+id,function(res){
			_pay.id=id;_pay.callback=callback;
			if(window.config.os=='windows'){
				//pc端支付，弹出二维码在手机端完成支付！
				var pay_url='core/member.pay/pay/id='+id;
				if(forward_url){
					pay_url +='&forward_url='+forward_url
				}
				if(window.config.this=='custom'){
					pay_url=tool.custom_url(pay_url,true);
				}else{
					pay_url=tool.manage_url(pay_url,true);
				}
				
				tool.qr(pay_url,'core-pay-ewm');
				var modal=$('#core-pay-modal');
				modal.find('.core-pay-fee').text('￥'+res.fee);
				modal.find('.core-pay-ordersn').text(res.tid);
				_pay.pay_complete_set();
				modal.find('.ewm').show();
				modal.find('.complete').unbind().click(function(){
					modal.modal('hide');
					_pay.pay_result({'type':'success','message':'支付成功！','payid':id});
				});
				modal.modal();
				return;
			}
			if(res.pay_type){//指定支付方式
				_pay.pay(res.pay_type);
			}else{
				var modal=$('#core-pay-modal');
				modal.find('.core-pay-credit-num').text('￥'+res.credit);
				modal.find('.core-pay-fee').text('￥'+res.fee);
				modal.find('.core-pay-ordersn').text(res.tid);
				if(res.fee==0){
					modal.find('.core-pay-0').show();
				}else{
					if(res.pay_types.length<=0){
						tool.message('没有可用的支付方式！','error');
						return;
					}
					res.pay_types.forEach(function(type){
						modal.find('.core-pay-'+type).show();
					});
				}
				modal.find('.core-pay').unbind().click(function(){
					var pay_type=$(this).attr('pay_type');
					_pay.pay(pay_type);
					modal.modal('hide');
				});
				modal.find('.complete').unbind().click(function(){
					_pay.pay_result({'type':'success','message':'支付成功！','payid':id});
				});
				modal.modal();
			}
		});
	}
	var _mobile_code_sending=false;
	tool.mobile_code=function(mobile,count_down_id,callback){
		if(_mobile_code_sending){
			tool.message('请勿频繁获取!','error');
			return false;
		}
		if(typeof(mobile)=='object'){
			var postdata=mobile;
			if(postdata.check_imgcode && !postdata.imgcode){
				tool.message('请先填写图片验证码！','error');
				return false;
			}
			if(postdata.oldmobile && postdata.oldmobile==postdata.mobile){
				tool.message('新手机号不能跟原手机号一样！');
				return false;
			}
		}else{
			var postdata={'mobile':mobile};
		}
		if(!postdata.mobile){
			tool.message('请先填写手机号！','error');
			return false;
		}
		_mobile_code_sending=true;
		count_down_id=count_down_id?count_down_id:'sms_code';
		tool.post('core/tools.sms_code/send',postdata,function(res){
			_mobile_code_sending=false;
			if($.isFunction(callback)){
				callback(res);
			}
			if(res=='success'){
				//发送成功，开始倒计时 
				if(!count_down_id){		
					return true;
				}
				if(typeof(count_down_id)=='string'){
					_mobile_code_sending=true;
					tool.count_down(60,count_down_id,'秒后重新发送',function(){
						_mobile_code_sending=false;
						$('#'+count_down_id).text('重新发送');
					});
				}else if(typeof(count_down_id)=='function'){
					count_down_id();
				}
			}else{
				tool.message('验证码发送失败!','error');
			}
		});
		
	}
	tool.count_down=function(num,id,text_count,text_end,start_time){
		if(tool.check_scope()){
			if(!start_time){
				start_time=scope.page.time;
			}
			if(start_time!=scope.page.time){
				return false;
			}
		}
		if(num>0){
			$('#'+id).text(num+text_count);
			num=num-1;
			setTimeout(function(){tool.count_down(num,id,text_count,text_end,start_time);},1000);
		}else{
			if(typeof(text_end)=='function'){
				text_end();
			}else{
				$('#'+id).text(text_end);
			}
		}
	}
	tool.check_scope=function(){
		if(window.scope && window.scope.access){
			return true;
		}
		return false;
	}
	tool.time_down=function(data){
		if(typeof(data)!='object'){
			return false;
		}
		setTimeout(function(){
			var is_continue=false;
			if(data.second>0){
				data.second--;
				is_continue=true;
			}else{
				if(tool.minute_down(data)){
					data.second=59;
					is_continue=true;
				}
			}
			if(is_continue){
				window.scope.$evalAsync();
				tool.time_down(data);
			}
		},1000);
	}
	tool.minute_down=function(data){
		if(data.minute>0){
			data.minute--;
			return true;
		}else{
			if(tool.hour_down(data)){
				data.minute=59;
				return true;
			}
		}
		return false;
	}
	tool.hour_down=function(data){
		if(data.hour>0){
			data.hour--;
			return true;
		}else{
			if(tool.day_down(data)){
				data.hour=23;
				return true;
			}
		}
		return false;
	}
	tool.day_down=function(data){
		if(data.day>0){
			data.day--;
			return true;
		}
		return false;
	}
	tool.search_near_data=function(lat_lng,callback){
		window.HOST_TYPE = "2"; window.BMap_loadScriptTime = (new Date).getTime();
			require(['map'], function(BMap){
				var point = new BMap.Point(lat_lng.lng,lat_lng.lat);
				var gc = new BMap.Geocoder();
				gc.getLocation(point,function(res){
					var result=[];
					result.push({
						'title':res.address,
						'address':res.address,
						'lat_lng':{'type':'BD09',lat:res.point.lat,lng:res.point.lng},
						'pcd':res.addressComponents,
					});
					res.surroundingPois.forEach(function(poi){
						result.push({
							'title':poi.title,
							'address':poi.address,
							'lat_lng':{'type':'BD09',lat:poi.point.lat,lng:poi.point.lng},
							'pcd':res.addressComponents,
						});
					});
					callback(result);
				});
			});
	}
	tool.choose_location=function(obj,field,type){
		window.scope.modal_func(function(res){
			if(type && res[type]){
				var ret=res[type];
			}else{
				var ret=res;
			}
			if(typeof(obj)=='function'){
				obj(ret);
			}else{
				obj[field]=ret;
			}
			scope.$evalAsync();
		},'','core/tools.choose_location/');
	}
	tool.time2number=function(str){
		timestamp = new Date(str).getTime()/1000;
		return timestamp;
	}
	tool.wechat_login=function(callback){
		require(['jinyun_socket'],function(jinyun_socket){
			jinyun_socket.connect();
			jinyun_socket.onsystem=function(res){
				console.log('rec');console.log(res);
				callback(res);
				
			}
		});
	}
	tool.get_list=function(url,isfirst,callback){
		if(isfirst){
			if(!scope.pagedata.params){
				scope.pagedata.params={};
			}
			scope.pagedata.params.page=1;
			scope.pagedata.loaded=false;
		}else if(scope.pagedata.loaded || scope.pagedata.loading){
			return;
		}
		scope.pagedata.loading=true;
		$('#loading_show').show();
		if(typeof(url)!='object'){
			url=tool.links(url);
		}
		var query=scope.made_query(scope.pagedata.params);
		if(url.query){
			url.query+='&'+query;
		}else{
			url.query=query;
		}
		//console.log('query');console.log(query);
		scope.get(url,function(res){
			//console.log(res);
			scope.pagedata.loading=false;
			$('#loading_show').hide();
			if(!scope.pagedata.list || isfirst){
				scope.pagedata.list=[];
			}
			if(res=='none'){
				scope.pagedata.loaded=true;
				return;
			}
			if(!Array.isArray(res)){
				var list=res.list?res.list:[]
			}else{
				var list=res
			}
			if(list.length==0 || (scope.pagedata.psize && list.length<scope.pagedata.psize)){
				scope.pagedata.loaded=true;
			}
			if(list && list != 'null' && list != 'undefined'){
				for(let key in list){
					scope.pagedata.list.push(list[key]);
				}
			}
			scope.pagedata.params.page++;
			if($.isFunction(callback)){
				callback(res);
			}
		});
	}
	tool.must_set=function(the){
		if(the.hasClass('must_set') && the.val()==''){
			console.log('must_set')
			the.next().show();the.css('border-color','red')
		}else{
			the.next().hide();the.css('border-color','#ddd')
		}
	}
	return tool;
});