//index.js
//获取应用实例
var app = getApp()
Page({
	data: {
		siteroot:app.setting.siteroot,
		account:app.setting.account,
		att_url:app.setting.att_url,
		root:'',
		active:1,
		page:1,
		pagedata:[],
		action: 'core/article.list/',
		isnodata:false,
		loading:true,
		list:[],
		fenleis:[],
		pagetitle:'文章列表' + '-' + app.setting.title,
	},
	onPullDownRefresh: function (){
		var the=this;
		var opt={};
		the.onLoad(opt);
		setTimeout(function(){
			wx.stopPullDownRefresh()
		},1000);
	},
	onLoad: function (opt){
		var the=this;
		wx.setNavigationBarTitle({'title':the.data.pagetitle});
		var route=the.route;
		the.setData({
			route:route,
		});
		if(opt.fromuser){
			var path=route.slice(0,-6).split('/');
			app.access.plugin=path.shift();
			app.access.action=path.join('.');
			app.access.query =app.util.made_query(opt,true);
			app.access.op=opt.op?opt.op:'';
		}
		if(opt.isgoshare){
				the.setData({
					ShowGoshare:true,
				});
		}
		app.util.get(app.access,function(pagedata){
			//console.log('list');console.log(pagedata);
			if(app.access.op=='detail'){
				pagedata.item.content=pagedata.item.content.replace(/\<img/gi, '<img style="max-width:100%"' );
			}
			the.setData({
				pagedata:pagedata,
				pluginnav:app.session.menus,
				loading:false
			});
			if(app.access.op!='detail'){
				setTimeout(()=>{the.getlist();},500);
			}
		});
	},
	//翻页
	onReachBottom: function () {
		var isnodata=this.data.isnodata
		var loading=this.data.loading
		if(!isnodata && !loading && app.access.op!='detail'){
			this.getlist()
		}
	},
	getlist: function(e){
		var the = this
		var isnodata = the.data.isnodata;
		var page = the.data.page;
		var pagedata = the.data.pagedata;
		if(e){
			var data=e.currentTarget.dataset;
		}else{
			var data={}
		}
		
		if(data.group_id){
			pagedata.list=[]
			page=1
		}
		app.util.get('core/article.list//page='+page+'&group_id='+data.group_id,function(res){
			console.log(pagedata);
			console.log(data.group_id);
			//加载分页
			if(res.list){
					pagedata.list = pagedata.list.concat(res.list);
					page++;
			}else{
					isnodata = true
			}
			pagedata.group_id=data.group_id?data.group_id:pagedata.group_id;
			the.setData({
				pagedata:pagedata,
				page:page,
				isnodata:isnodata,
				loading:false
			});
		});
	},
	like:function(e){
		var the=this;
		var data=e.currentTarget.dataset;
		var pagedata =the.data.pagedata;
		pagedata.item.likenum ++
		pagedata.like.like = data.like
		app.util.post('like',data);
		the.setData({
				pagedata:pagedata,
		});
	},
	click:function(evt){
		//用户点击事件 data.func 为方法名，data.params 为调用参数！
		var data=evt.currentTarget.dataset;
		//console.log(evt);
		app.util[data.func](data.params);
	},
	onShareAppMessage: function (res) {
		var the = this
		var pagedata = the.data.pagedata
		if (res.from === 'button') {
		}
		var path=the.data.route+'?'+app.access.query;
		if(app.access.op){
			path +='&op='+app.access.op;
		}
		if(pagedata.fromuser){
			path +='&fromuser='+pagedata.fromuser;
		}
		return {
		  title: the.data.pagetitle,
		  path: path,
		  desc: app.setting.sharedesc,
		  success: function(res) {
		  },
		  fail: function(res) {
		  }
		}
	},
	onShareTimeline: function (res) {
		var the = this
		var pagedata = the.data.pagedata
		var query=app.access.query
		if(app.access.op){
			query +='&op='+app.access.op;
		}
		if(pagedata.fromuser){
			query +='&fromuser='+pagedata.fromuser;
		}
		query +='&isgoshare=1'
		return {
		  title: the.data.pagetitle,
		  query: query,
		  desc: app.setting.sharedesc,
		  success: function(res) {
		  },
		  fail: function(res) {
		  }
		}
	},
});