//index.js
//获取应用实例
var app = getApp()
Page({
	data: {
		root:'',
		siteroot:app.setting.siteroot,
		account:app.setting.account,
		page_id:'',
		pagedata: {},
		region: ['广东省', '广州市', '海珠区'],
		pagetitle:'关于我们' + '-' + app.setting.title,
		chooseimage:[],
	},
	onPullDownRefresh: function (){
		var the=this;
		var opt={};
		the.onLoad(opt);
		setTimeout(function(){
			wx.stopPullDownRefresh()
		},1000);
	},
	onLoad: function (opt){
		var the=this;
		wx.setNavigationBarTitle({'title':the.data.pagetitle});
		var route=the.route;
		the.setData({
			route:route,
		});
		if(opt.fromuser){
			var path=route.slice(0,-6).split('/');
			app.access.plugin=path.shift();
			app.access.action=path.join('.');
			app.access.query =app.util.made_query(opt,true);
			app.access.op=opt.op?opt.op:'';
		}
		if(opt.isgoshare){
				the.setData({
					ShowGoshare:true,
				});
		}
		app.util.get(app.access,function(pagedata){
			console.log(pagedata);
			the.setData({
				pagedata:pagedata,
				pluginnav:app.session.menus,
				loading:false
			});
		});
		app.util.get(app.access,function(pagedata){
			console.log(pagedata);
			//获取action
			pagedata.action=app.access.action;
			the.setData({
				pagedata:pagedata,
				loading:false
			});
		});
	},
	// 进云常用函数
	post_diyform:function(e){
		var index = e.detail.value.index;
		var pageid = e.detail.value.pageid;
		var value = e.detail.value;
		var fileddata =[];
		for (x in value){
			var x = x
			if(x != 'index' && x != 'pageid'){
				var n=x.split("_");
				fileddata[n[1]] = fileddata[n[1]] ? fileddata[n[1]] :{};
				fileddata[n[1]][n[0]] = value[x];
			}
		}
		app.util.post_diyform(fileddata,pageid,index);
	},
	ng_input:function(e){
		var that=this
		var index = e.currentTarget.dataset.index;
		var value = e.detail.value;
		var active = [];
			active[index] = value;
			that.setData({
					ng_active: active,
			})
	},
	ng_active:function(e){
		var that=this
		var index = e.currentTarget.dataset.index;
		var value = e.currentTarget.dataset.value;
		var active = [];
			active[index] = value;
			that.setData({
					ng_active: active,
			})
	},
	// 下面是小程序常用API
	click:function(evt){
		//用户点击事件 data.func 为方法名，data.params 为调用参数！
		var data=evt.currentTarget.dataset;
		//console.log(evt);
		app.util[data.func](data.params);
	},
	wx_makePhoneCall:function(e){
		var phoneNumber = e.currentTarget.dataset.phone;
		wx.makePhoneCall({
		  phoneNumber: phoneNumber
		})
	},
	onShareAppMessage: function (res) {
		var the = this
		var pagedata = the.data.pagedata
		if (res.from === 'button') {
		}
		var path=the.data.route+'?'+app.access.query;
		if(app.access.op){
			path +='&op='+app.access.op;
		}
		if(pagedata.fromuser){
			path +='&fromuser='+pagedata.fromuser;
		}
		return {
		  title: the.data.pagetitle,
		  path: path,
		  desc: app.setting.sharedesc,
		  success: function(res) {
		  },
		  fail: function(res) {
		  }
		}
	},
	onShareTimeline: function (res) {
		var the = this
		var pagedata = the.data.pagedata
		var query=app.access.query
		if(app.access.op){
			query +='&op='+app.access.op;
		}
		if(pagedata.fromuser){
			query +='&fromuser='+pagedata.fromuser;
		}
		query +='&isgoshare=1'
		return {
		  title: the.data.pagetitle,
		  query: query,
		  desc: app.setting.sharedesc,
		  success: function(res) {
		  },
		  fail: function(res) {
		  }
		}
	},
});