/**
 * 会员中心
 */
var app = getApp()
var QQMapWX = require('../../../resource/js/qqmap-wx-jssdk.min.js');
var qqmapsdk;
Page({
	data: {
		root:app.setting.att_url,
		pagedata:[],
		pcd: ['广东省', '广州市', '海珠区'],
		pagetitle:'地址' + '-' + app.setting.title,
		bannerHeight: Math.ceil(290.0 / 750.0 * getApp().screenWidth)
	},
	onPullDownRefresh: function (){
		var the=this;
		var opt={};
		the.onLoad(opt);
		setTimeout(function(){
			wx.stopPullDownRefresh()
		},1000);
	},
	onLoad: function (options){
		var the = this;
		wx.setNavigationBarTitle({'title':the.data.pagetitle});
		//获取区域城市
		qqmapsdk = new QQMapWX({
            key: 'SN2BZ-MKT32-22SU7-COVX6-ZYXAQ-OEF6D'
        });
		app.util.location(function(res){
			qqmapsdk.reverseGeocoder({
					location:{latitude:res.latitude,longitude:res.longitude},
					success:function(res){
						var pcd =the.data.pcd
						if(res.result.address_component.province){
							 pcd[0] = res.result.address_component.province
						}
						if(res.result.address_component.city){
							pcd[1] = res.result.address_component.city
						}
						if(res.result.address_component.district){
							pcd[2] = res.result.address_component.district
						}
						the.setData({
							pcd:pcd,
						})
					}
			});
		});
		app.util.get(app.access,function(pagedata){
			console.log(pagedata);
			the.setData({
				pagedata:pagedata,
				loading:false
			});
		});
	},
	bindRegionChange: function (e) {
		//console.log('picker发送选择改变，携带值为', e.detail.value)
		this.setData({
		  pcd: e.detail.value
		})
	},
	openAddress: function () {
		var the=this
		var pagedata=the.data.pagedata
		var pcd=[];
		wx.chooseAddress({
			success (res) {
				pagedata.item={}
				pagedata.item.name = res.userName; // 收货人姓名
				pcd[0] = res.provinceName; // 国标收货地址第一级地址（省）
				pcd[1] = res.cityName; // 国标收货地址第二级地址（市）
				pcd[2] = res.countyName; // 国标收货地址第三级地址（国家）
				pagedata.item.address = res.detailInfo; // 详细收货地址信息
				pagedata.item.mobile = res.telNumber; // 收货人手机号码
				the.setData({
				  'pagedata.item': pagedata.item,
				  'pcd':pcd
				})
			},fail (res) {
				console.log('fail');console.log(res)
			}
		})
	},
	set: function (e) {
		var the=this
		var data = e.currentTarget.dataset;
		var pagedata=the.data.pagedata
		app.util.msg('设置成功')
		app.util.get('core/member.address/set/id='+data.id,function(res){
			for(var i in pagedata.list){
				pagedata.list[i].isdefault=0
			}
			pagedata.list[data.index].isdefault=1
			the.setData({
				'pagedata.list':pagedata.list
			});
		});
	},
	formSubmit:function(e){
		var the =this
		var data=e.detail.value;
		data.pcd={}
		data.pcd.province=the.data.pcd[0]
		data.pcd.city=the.data.pcd[1]
		data.pcd.district=the.data.pcd[2]
		app.util.post('post',data);
	},
	click:function(evt){
		//用户点击事件 data.func 为方法名，data.params 为调用参数！
		var data=evt.currentTarget.dataset;
		//console.log(evt);
		app.util[data.func](data.params);
	}
})